#!/usr/bin/python3
# coding: utf-8
#
#   createAndChangeCaseDialog.py
#
#       caseの作成、solver、meshの入れ替え
#
#   13/03/31    新規作成
#      04/06    空patchのboundaryFieldクリア追加
#      04/08    openFolderを追加
#      04/10    現在caseのtimeFolder内のメッシュ入れ替えを追加
#      04/15    newCaseの作成場所の指定を追加
#      04/20    ボタンの動作を変更
#      04/27    notebook方式に変更、設定を記憶させる
#               cell数が同じメッシュを入れ替えた場合、internalFieldをクリアしない。
#               timeFolder内のpolyMeshは、初めの10ヶと最後の10ヶをチェックする。
#      05/08    meshの一部入れ替えの場合エラー発生。これを修正
#      05/09    mesh入れ替え時の方向icon追加
#      06/09    tutorialsCaseのチェックをゆるめる。
#      07/14    meshDirの検索方法をglobに変更
#      07/20    mesh入れ替え:コピー先のdirも選択できるように修正
#      07/21    mesh入れ替え:dirを選択した場合、反対側のボタンを非enableに設定
#      07/27    mesh入れ替え:表示を変更
#      08/15    newCase,solver入れ替えの表示方法修正
#      08/21    clearOnlyNullBoundaryFields:fieldNamesの取得方法変更
#               バグ修正：隠しファイルが有った場合、エラー発生
#      09/6     newCase作成時、case名を入力できる様修正
#      09/25    meshCopy時:binaryMeshのコピーに対応
#      10/04    multiRegionの場合、meshを一括コピーできる様に対応
#      10/05    OpenFOAM用のcaseでない場合、pane_2, pane_3をunenableに設定
#      10/15    国際化による修正
#      12/21    stdout、stderrの設定（import logFileCreater）を追加
#   14/03/01    case作成時、currentCaseのtimeフォルダが存在しない場合エラーが発生
#               していたので、修正。addNullTimeFolder内を修正
#      09/02    clearNullBoundaryFieldsInternalFields:バグ修正
#      09/22    addNullTimeFolder:nullTimeはfirstTimeがmustに変更
#      10/23    copyMesh:cell数が異なる場合、internalFieldをクリアするか訊く様に修正
#      11/09    copyMesh:checkCurrMeshを追加
#      12/22    readMeshLocation,getMeshToCopyCase:「constant」をmeshが無くても追加
#   15/02/12    getMeshToCopyCase:バグ修正（ｺﾋﾟｰ先のdirを選択時ｴﾗｰ発生）
#      07/13    clipBoardの場所をTreeFoam/dataに変更。initialize部を修正。
#      07/17    dialog起動方法修正
#   17/02/26    initialize:solverの有無でfoamCaseかどうかを確認していたが、
#               constant, systemフォルダの有無で確認するように修正
#      04/15    getNCellPolyMesh:owner, neibourのcheckからowner側のみのcheckに変更
#      09/08    currCaseDirを引数で取得するように修正
#               referenceDir:相対参照でdirを取得する方法を変更。
#   19/05/22    selectCase,copyFieldParentToRegion:mkdirをos.mkdirに変更
#               cpをshutil.copyに変更
#      09/15    python3, GTK+3用に大幅修正
#   20/04/20    多言語化対応
#      09/12    main:entry_caseNameを非active設定をactive設定に戻す。
#      09/15    copyOtherCase:progressBar.pasteCaseLocalToLocalの引数にnewCaseName追加
#               終了時にnewCaseのpasteDirをtempFolderに保存
#   21/10/30    相対pathをセットした場合、error発生する為、修正。
#               main:window閉じた後、pasteDirが相対pathの場合、絶対pathに変更。
#               changeCopyCase,changePasteCase:相対pathの場合、絶対pathに変更。
#   22/06/09    startCopyCase,startMeshCopy:コピー後、closeを追加
#      07/22    meshCopy部分を削除。
#   24/08/01    universalDialogs:全dialogに対しfuncOk、親windowを設定
#      08/22    起動時、window位置をmouseに合わせる様修正。
#   25/07/11    startCopyCase:caseコピー時、controlDict内のapplicationを確認し、
#               未設定の場合、追記する様に修正。
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys
import shutil
import glob
import pyTreeFoam
#from createNewCaseDDialog import Show as createNewCaseDDialogShow
import createNewCaseDDialog
#from getOpenFolderDDialog import Show as getOpenFolderDDialogShow
import getOpenFolderDDialog
import progressBar
import universalDialogs as unvDlg


import logFileCreater
logFileCreater.log()

createNewCase_data = os.getenv("TreeFoamUserPath") + "/data/createNewCase_data"


#  ---------
#  windowApp
#  ---------
class windowApp:

    def __init__(self, caseDir):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path+"createAndChangeCaseDialog.glade")
        self.mainWindow = self.builder.get_object("window1")
        #window位置をmouseに合わせる
        self.mainWindow.set_position(2)
        self.mainWindow.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        #変数の設定
        self.caseDir = caseDir
        self.copyCase = ""
        self.pasteCase = ""
        self.copiedFlag = "no"          #copyButtonをclickしたかどうか
        self.OFversion = ""
        self.application = ""           #tutorialsから取得したapplication
        #GUIのobject名を設定
        self.setGtkObject()
        #dialogの初期設定（createNewCase_data読み込み）
        self.iniDialog()
        #newCaseのpasteDir名の保存先(treefoam.py側で読み込む)
        self.savePasteDir = os.getenv("TreeFoamUserPath") + "/temp/newCasePasteDir"


    def setGtkObject(self):
        """ glade内のobject名を取得"""
        #newCase作成
        self.radio_Tutorial = self.builder.get_object("radiobutton2")
        self.radio_otherCase = self.builder.get_object("radiobutton1")
        self.entry_tutoDir = self.builder.get_object("entry_tutoDir")
        self.entry_pasteDir = self.builder.get_object("entry_pasteDir")
        self.entry_caseName = self.builder.get_object("entry_caseName")

    def main(self):
        """ GUIの表示"""
        self.entry_pasteDir.set_text(self.caseDir)
        self.mainWindow.show()
        Gtk.main()
        #pasteDirを保存
        if self.copiedFlag == "yes":
            pasteDir = self.entry_pasteDir.get_text()
            if pasteDir[0] != "/":
                pasteDir = self.caseDir + "/" + pasteDir
                pasteDir = os.path.normpath(pasteDir)
        else:
            #copyButtonをクリックしていない場合
            pasteDir = ""
        f = open(self.savePasteDir, "w"); f.write(pasteDir); f.close()

    def close(self,*args):
        """ 閉じる"""
        Gtk.main_quit()

    def iniDialog(self):
        """ createNewCase_dataの内容をセット"""
        self.mainWindow.set_title(_("newCaseの作成"))
        newCase_tuto = "yes"
        if len(glob.glob(createNewCase_data)) != 0:
            f = open(createNewCase_data); lines = f.readlines(); f.close()
            for line in lines:
                words = line.split()
                if words[0] == "newCase_tutorials":
                    newCase_tuto = words[1]
        if newCase_tuto == "yes":
            self.radio_Tutorial.set_active(True)
        else:
            self.radio_otherCase.set_active(True)

        

    #  ----- event handler ---------------
    #----- 共通
    #close
    def onClose(self, event):
        self.ending()
        self.close()
    #----- caseCopy
    #getCopyCaseDir
    def onGetCopyCaseDir(self, event):      #case取得
        self.getCopyDir()
    #getCreateCaseDir
    def onGetCreateCaseDir(self, event):    #参照...
        self.getPasteDir()
    #startCopyCase
    def onStartCopyCase(self, event):       #copy開始
        self.startCopyCase()
        self.close()
    #  -----------------------------------

    #
    #  getCopyDir
    #  ----------
    def getCopyDir(self):
        """ copyDirを取得して、textBoxに保存"""
        if self.radio_Tutorial.get_active() == True:
            #tutorialsから取得
            title = _("newCaseの作成")
            mess = _("tutorialsからcaseをコピーして、newCaseを作成します。\ncaseを選択してください。")
            currDir = self.caseDir
            #[status, selCaseCopyDir] = createNewCaseDDialogShow(title, mess, currDir)
            okArgs = [self.getCopyDir_setTextBox]
            dialog = createNewCaseDDialog.createNewCase(title, mess, currDir, funcOk=okArgs, parent=self.mainWindow)
            dialog.show()
            return
        else:
            #任意のcaseから取得
            currDir = self.caseDir
            title = _("newCaseの作成")
            mess = _("手本にするcaseを選択する")
            rootDir = pyTreeFoam.readConfigTreeFoam()["rootDir"]
            #newCaseDir = getOpenFolderDDialogShow(title, mess, rootDir, currDir, currDir)
            okArgs = [self.getCopyDir_anyDir]
            dialog = getOpenFolderDDialog.getOpenFolder(title, mess, rootDir, currDir, currDir, funcOk=okArgs, parent=self.mainWindow)
            dialog.show()
            return

    #  getCopyDir_anyDir
    def getCopyDir_anyDir(self, newCaseDir):
        self.entry_tutoDir.set_text(newCaseDir)
        caseName = newCaseDir.split("/")[-1]
        self.entry_caseName.set_text(caseName)

    #  getCopyDir_setTextBox
    def getCopyDir_setTextBox(self, newCaseDir, application):
        self.application = application
        self.entry_tutoDir.set_text(newCaseDir)
        caseName = newCaseDir.split("/")[-1]
        self.entry_caseName.set_text(caseName)


    #
    #  getPasteDir
    #
    def getPasteDir(self):
        """ pasteDirを取得して、textBoxに保存"""
        title = _("newCaseの作成")
        #cont = _("tutorialsからcaseをコピーして、newCaseを作成します。\ncaseを選択してください。")
        cont = _("tutorialsからcaseをコピーして、newCaseを作成します。\n貼り付けるfolderを選択してください。")
        currDir = self.caseDir
        rootDir = pyTreeFoam.readConfigTreeFoam()["rootDir"]
        #selDir = getOpenFolderDDialogShow(title, cont, rootDir, currDir, currDir)
        okArgs = [self.getPaseteDir_setDir]
        dialog = getOpenFolderDDialog.getOpenFolder(title, cont, rootDir, currDir, currDir, funcOk=okArgs, parent=self.mainWindow)
        dialog.show()
        return

    #  getPaseteDir_setDir
    def getPaseteDir_setDir(self, selDir):
        """ 取得したdirのpathをtextBoxにセットする"""
        self.entry_pasteDir.set_text(selDir)

    #
    #  startCopyCase
    #
    def startCopyCase(self):
        """ 選択したcaseを指定した場所にコピーする"""
        self.copiedFlag = "yes"
        copyCaseDir = self.entry_tutoDir.get_text()
        pasteDir = self.entry_pasteDir.get_text()
        newCaseName = self.entry_caseName.get_text()
        if pasteDir[0] != "/":
            pasteDir = caseDir + os.sep + pasteDir
            pasteDir = os.path.normpath(pasteDir)
        if copyCaseDir[0] != "/":
            copyCaseDir = caseDir + os.sep + copyCaseDir
            copyCaseDir = os.path.normpath(copyCaseDir)
        folders = pyTreeFoam.getFolders(pasteDir)
        error = copyOtherCase(pasteDir, newCaseName, copyCaseDir)
        if error != "":
            title = _("エラー")
            self.errDialog(title, error)
            return
        else:
            #controlDict内のapplication有無をチェック
            newFolders = pyTreeFoam.getFolders(pasteDir)
            newCaseDir = list(set(newFolders) - set(folders))[0]
            if os.path.exists(newCaseDir + "/system/controlDict") == True:
                case = pyTreeFoam.case(newCaseDir)
                contDict = case.getControlDict()
                if contDict["application"] == "" and self.application != "":
                    dataDict = {"application":self.application}
                    case.setControlDict(dataDict)
            title = _("newCaseの作成")
            mess = _("caseをコピーして、newCaseを作成しました。")
            self.okDialog(title, mess)
            return

    #  -------- ending -----------------
    #
    #  ending
    #
    def ending(self):
        if self.radio_Tutorial.get_active() == True:
            newCase_tuto = "yes"
        else:
            newCase_tuto = "no"
        cont = "newCase_tutorials " + newCase_tuto + "\n"
        f = open(createNewCase_data, "w"); f.write(cont); f.close()

    #  ------- universal dialog ---------------
    def okDialog(self, title, mess, funcOk=[]):
        dialog = unvDlg.okDialog(
            title, mess, parentWin=self.mainWindow, funcOk=funcOk)
        dialog.show()

    def errDialog(self, title, mess, funcOk=[]):
        dialog = unvDlg.errDialog(
            title, mess, parentWin=self.mainWindow, funcOk=funcOk)
        dialog.show()


#
#  getAllPolyMeshDirsInCase
#
def getAllPolyMeshDirsInCase(caseDir):
    """ caseDir内の全polyMesh（region含む）を取得する"""
    meshDirs = getConstantPolyMesh(caseDir)
    meshDirs += getTimePolyMeshDirs(caseDir)
    return meshDirs

#  getConstantPolyMesh
#
def getConstantPolyMesh(caseDir):
    """ constant内のpolyMesh（region含む）を取得する"""
    dirs = glob.glob(caseDir + "/constant/polyMesh/boundary")
    dirs += glob.glob(caseDir + "/constant/*/polyMesh/boundary")
    meshDirs = []
    for name in dirs:
        #polyMesh/boundaryを削除
        nameList = name.split("/")[:-2]
        meshDirs.append("/".join(nameList))
    meshDirs.sort()
    return meshDirs

#  getTimePolyMeshDirs
#
def getTimePolyMeshDirs(caseDir):
    """ timeFolder内のpolyMesh（region含む）を取得する"""
    dirs = glob.glob(caseDir + "/*/polyMesh/boundary")
    dirs += glob.glob(caseDir + "/*/*/polyMesh/boundary")
    aMeshDirs = []
    for name in dirs:
        nameList = name[len(caseDir)+1:].split("/")[:-2]
        try:
            a = float(nameList[0])
            aMeshDirs.append([a, nameList])
        except:
            pass
    aMeshDirs.sort()
    meshDirs = []
    for aMeshDir in aMeshDirs:
        meshDir = caseDir + "/" + "/".join(aMeshDir[1])
        meshDirs.append(meshDir)
    return meshDirs
 

#
#  copyOtherCase
#
def copyOtherCase(pasteDir, newCaseName, copyCaseDir):
    """ createNewCaseの為のcaseCopy"""
    error = ""
    if len(glob.glob(pasteDir)) == 0:
        error = _("dirが選択されていません。")
        print(error)
        return error
    if len(glob.glob(copyCaseDir)) == 0:
        error =  _("選択した「") + copyCaseDir + _("」は、存在しません。")
        print(error)
        return error
    #コピー開始
    stat = progressBar.pasteCaseLocalToLocal([copyCaseDir], [pasteDir], newNames=[newCaseName]).paste()
    if stat == "OK":
        error = ""
    else:
        error = _("caseCopy時にエラーが発生しました。\n")
        error += _("  logを確認してください。")
    return error



if __name__ == "__main__":
    import gettext
    import locale
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    locale.bindtextdomain("treefoam", localeDir)
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    caseDir = sys.argv[1]      #作成場所
    #os.environ["TreeFoamPath"] = "/home/caeuser/TreeFoam-glade3"
    #caseDir = "/home/caeuser/CAE/CAE-FOAM/OF-v1906/pitzDaily"
    winApp = windowApp(caseDir)
    winApp.main()
