#!/usr/bin/python3
#  coding:  utf-8
#
#       copyPasteTextQt.py
#
#       textをclipboardを使って、copy、pasteする。
#       Qtのapp専用になる。
#
#   20/05/01    新規作成
#      05/02    PyQt4, PyQt5, PySide, PySide2に対応
#      05/24    pyQtの設定確認方法を修正（一元化）
#      07/18    copyText:pySideの場合、エラー発生する為、修正
#               sysClipboard.clear(mode=1) → sysClipboard.clear()
#

#from PyQt5 import QtCore, QtGui, QtWidgets

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()


#
#  copyText
#------------
def copyText(text):
    """ textをsystemのClipboardにコピーする"""
    sysClipboard = QApplication.clipboard()
    #sysClipboard = app.clipboard()
    #sysClipboard.clear(mode=1)
    sysClipboard.clear()
    mimeData = QMimeData()
    mimeData.setText(text)
    sysClipboard.setMimeData(mimeData)

#
#  pasteText
#------------
def pasteText():
    """ systemのclipboard内からtextを取得して返す。"""
    sysClipboard = QApplication.clipboard()
    #sysClipboard = self.app.clipboard()
    mimeData = sysClipboard.mimeData()
    cont = mimeData.text()
    return cont

