#!/usr/bin/python3
# coding: utf-8
#
#       changeDictionaryAllRegions.py
#
#           changeDictionaryAllRegionsDictの内容に従って、各regionに
#           changeDictionaryRegionsDictを作り、各regionに対し、changeDictionaryを
#           実行してdictionaryを書き換える。
#
#   13/01/18    file名を受けて実行する様に修正
#      06/01    helpを追加
#      10/15    国際化のため、修正
#      12/21    stdout、stderrの設定（import logFileCreater）を追加
#   19/10/25    GTK+3, python3用に大幅修正
#   20/04/20    多言語化対応
#

import os
import sys
import glob
import pyTreeFoam
import stringOp

import logFileCreater; logFileCreater.log()

caseDir = ""
contentsDict = ""
configDict = {}

#
#  getEachRegions
def getEachRegions(name):
    """ AllregionsDictから書き換えるregionを取得"""
    global caseDir, contentsDict
    fileName = caseDir + "/system/" + name
    f=open(fileName)
    contentsDict = f.read()
    f.close()
    contentsDictOp = stringOp.strings(contentsDict)
    p = contentsDictOp.skipFoamFile()
    regions = []
    while p < len(contentsDict):
        ((region, dummy), p) = contentsDictOp.getNextKeywordAndContents(p)
        if region != b"":
            regions.append(region.decode())
    return regions

#
#  setChangeDictionaryRegionsDict
def setChangeDictionaryRegionsDict(regions):
    """ 各reginのchangeDictionaryDictを作成し、各regionにセット"""
    global caseDir, contentsDict
    error = ""
    #errorチェック
    for name in regions:
        fileName = fileName = caseDir + "/system/" + name
        if len(glob.glob(fileName)) == 0:
            error = _(u"region「") + name + _(u"」が存在しません。")
            break
    if error != "":
        return error

    #foamFile作成
    OFversion = configDict["OFversion"]
    foamContents = pyTreeFoam.getFoamContents()
    foamFile = foamContents.makeFoamHeaderVersion(OFversion)
    foamFile += foamContents.makeFoamFile("2.0", "ascii", "dictionary", "system", "changeDictionaryDict")
    footer = foamContents.makeFoamFooter()

    #changeDictionaryDictを作成
    p=0
    contentsDictOp = stringOp.strings(contentsDict)
    for name in regions:
        (contents, p) = contentsDictOp.getKeywordContents(name, p)
        #[contents, p] = getFoamContents.getKeywordContentsMem(name, contentsDict, p)
        fileName = caseDir + "/system/" + name + "/changeDictionaryDict"
        f=open(fileName, "w")
        f.write(foamFile + contents.decode() + footer)
        f.close()
    return error

#
#  runEachChangeDictionary
#    各regionのchangeDictionaryを実行
def runEachChangeDictionary(regions):
    for name in regions:
        envOpenFoam = configDict["bashrcFOAM"]
        comm = ". " + envOpenFoam + "; "
        comm += "changeDictionary -region " + name
        print(comm)
        pyTreeFoam.run(caseDir).commandWithLog(comm)
        #os.system(comm)

#
#  printHelp
#    helpを出力
def printHelp():
    cont  = _("\n*** changeDictionaryAllRegions.pyの使い方 ***\n\n")
    cont += _("<概要>\n")
    cont += _("multiRegionモデルの境界条件を設定するコマンド。\n")
    cont += _("境界条件は、dictFileの指示に従って設定される。\n\n")
    cont += _("<使い方>\n")
    cont += _("changeDictionaryAllRegionsDict.py [dictFile] [option]\n\n")
    cont += _("[dictFile]\n")
    cont += _("    dictFileの指示に従って境界条件を設定する。\n")
    cont += _("    省略時はchangeDictionaryAllRegionsDictが使われる\n\n")
    cont += _("[option]\n")
    cont += _("    -h          helpを表示\n")
    cont += _("    -help         同上\n")
    cont += _("    --help        同上\n\n")
    cont += _("***********************************************\n")
    print(cont)



if __name__ == "__main__":
    import gettext
    import locale
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    locale.bindtextdomain("treefoam", localeDir)
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    if len(sys.argv) > 1:
        comm = sys.argv[1]
        if comm == "-h" or comm == "--help" or comm == "-help":
            printHelp()
            exit()
        else:
            fileName = comm
    else:
        fileName = "changeDictionaryAllRegionsDict"

    #  configDictを取得
    configDict = pyTreeFoam.readConfigTreeFoam()
    #  caseDirを取得
    caseDir = os.getcwd()
    #  変更するregionを取得
    regions = getEachRegions(fileName)
    #  changeDictionaryを作成し各regionにセット
    error = setChangeDictionaryRegionsDict(regions)
    #  changeDictionaryを実行
    if error == "":
        runEachChangeDictionary(regions)
    else:
        print(error)


