#!/usr/bin/python3
#
#       contRun_altnSource_fsiCht.py
#
#       OpenFOAMが出力した圧力と熱流束から、FrontISTRを実行して、
#       圧力による変位、熱流束による温度を計算し、
#       変位と温度を出力する。
#       contRun_couplingSource_fsiCht.pyを交互計算用に修正
#
#   23/10/25    saveMappingTemp,saveMappingDisp:交互計算に対応させる為、
#               tempとdispのfile名のstep数をendStepからtimeIndexに変更。
#               addTempRenameRes,setDeltaTInCnt_cht,deleteResSetRestartFileCht,
#               setDeltaTInCnt_fsi,deleteResSetRestartFileFsi:大幅修正。
#               createCommTimeArea:新規追加。（前回のcouplingTime取得の為）
#               runFistr:Fistr起動前に、Fistrが停止している事を確認後、Fistrを起動
#               runCoupling.pyから起動された場合、直ぐに戻る用に修正。
#      11/06    fsiCommonAlternateモジュールの使用に変更
#               chtCommonAlternateモジュールの使用に変更
#      11/16    allCommonConcAltnモジュールの使用に変更
#

import sys, os
import shutil
import pyCoupling
import fsiCommonAlternate as fsiComm
import chtCommonAlternate as chtComm
import allCommonConcAltn as allComm

waitCount = 5000
waitTime = 0.01


#----------------
#  coupling_fsi
#----------------
def coupling_fsi():
    """ OpenFOAMが出力した圧力から、FrontISTRが変位を計算する。
    変位を取得するところまで実行する"""
    patchName = couplingDict["mappingPatch"]
    timeName = couplingDict["timeName"]
    procNo = couplingDict["procNo"]
    solidCaseDir = couplingDict["solidCaseDir"]
    dataDir = fluidCaseDir + "/coupling_FrontISTR/data"
    endStep = 0
    #--- 圧力をmapping ------
    #ptcDataの読み込み
    pressFile = dataDir + "/" + patchName + "_facePress_" + timeName + "_" + procNo + "tm"
    #圧力の点群ファイルを作成
    fsiComm.createPressPtcFile(couplingDict, pressFile)
    if int(procNo) == 0:
        #圧力をmappingしてcntファイルに反映
        fsiComm.createMappingPressFile(couplingDict)
        #--- fistr実行 ----------
        #fsi計算前の設定
        setFsiChtCntFile("fsi")
        bfrStep, bfrTime = mmCommPressArea.getBeforeCouplingTime()
        endStep, endTime = fsiComm.setDeltaTInCnt(couplingDict, bfrStep, bfrTime)
        #Fistr起動
        runFistr("fsi", endStep, endTime)
        #--- 変位を取得 ---------
        print("(py) --- creating displacement PTC ...", flush=True)
        np = pyCoupling.getNumProcsFistrFromDat(solidCaseDir)
        dispDict = fsiComm.getDispDictFromResFile(couplingDict, endStep, np)
        dispPtc = fsiComm.createDispPtc(couplingDict, dispDict)
        #変位のmapping結果fileを作成
        print("(py) --- displacement value is mapping to patch '" + patchName + "' ...", flush=True)
        fsiComm.createMappingDispFile(couplingDict, dispPtc, endStep)
        #--- 結果file整理（file削除、restart設定）-----
        fsiComm.deleteResSetRestartFile(couplingDict, bfrStep, bfrTime, np)
    return ""

#---------------------
#  coupling_cht
#---------------------
def coupling_cht():
    """ OpenFOAMが出力した熱流束から、FrontISTRが温度を計算する。"""
    solidCaseDir = couplingDict["solidCaseDir"]
    fluidCaseDir = couplingDict["fluidCaseDir"]
    patchName = couplingDict["mappingPatch"]
    timeName = couplingDict["timeName"]
    procNo = couplingDict["procNo"]
    dataDir = fluidCaseDir + "/coupling_FrontISTR/data"
    #---- heatFluxをmapping ---------
    #heatFluxの点群ファイル作成
    htFile = dataDir + "/" + patchName + "_faceHeatFlux_" + timeName + "_" + procNo + "tm"
    chtComm.createHeatFluxPtcFile(couplingDict, htFile)
    if int(procNo) == 0:
        #heatFluxをmappingしてcntファイルに反映
        chtComm.createMappingHeatFlux(couplingDict)
        #---- fistr実行（温度計算） --------------
        #cht計算前の設定
        setFsiChtCntFile("cht")
        bfrStep, bfrTime = mmCommTempArea.getBeforeCouplingTime()
        endStep, endTime = chtComm.setDeltaTInCnt_cht(couplingDict, bfrStep, bfrTime)
        #Fistr起動
        runFistr("cht", endStep, endTime)
        #--- 温度を取得 ---------
        #温度のptcデータを作成
        print("(py) --- creating temperature PTC ...", flush=True)
        np = pyCoupling.getNumProcsFistrFromDat(solidCaseDir)
        tempDict = chtComm.getTempDictFromResFile(couplingDict, endStep, np)
        tempPtc = chtComm.createTempPtc(couplingDict, tempDict)
        #温度をmappingしたfileを作成
        print("(py) --- temperature value is mapping to patch '" + patchName + "' ...", flush=True)
        chtComm.createMappingTempFile(couplingDict, tempPtc, endStep)
        #--- 結果file整理（file削除、restart設定）----
        chtComm.deleteResSetRestartFileCht(couplingDict, bfrStep, bfrTime, np)
    return ""

#
#  setFsiChtCntFile
def setFsiChtCntFile(sect):
    """ sectに応じたdatファイルに修正"""
    solidCaseDir = couplingDict["solidCaseDir"]
    pasteDatFile = solidCaseDir + os.sep + "hecmw_ctrl.dat"
    if sect == "fsi":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_fsi.dat"
    elif sect == "cht":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_cht.dat"
    elif sect == "chtss":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_chtss.dat"
    shutil.copy(datFile, pasteDatFile)

#
#  runFistr
#----------
def runFistr(sect, endStep, endTime):
    """ FrontISTRを起動"""
    allComm.runFistr(couplingDict, mmCommArea, sect, endStep, endTime)
    return


if __name__ == "__main__":
    import gettext
    gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext

    currTime = sys.argv[1]      #currTime
    beforeTime = sys.argv[2]    #前回のtime
    procNo = sys.argv[3]        #procNo
    nProcs = sys.argv[4]        #nProcs
    timeIndex = sys.argv[5]     #timeIndex
    fluidCaseDir = os.getcwd()
    couplingData = pyCoupling.couplingData(fluidCaseDir)
    couplingDict = couplingData.read()
    couplingDict["fluidCaseDir"] = fluidCaseDir
    couplingDict["timeName"] = currTime
    couplingDict["beforeTime"] = beforeTime
    couplingDict["procNo"] = procNo
    couplingDict["nProcs"] = nProcs
    couplingDict["timeIndex"] = timeIndex
    nStepsFsi = couplingDict["nStepsOF"]
    nStepsCht = couplingDict["nSteps"]
    waitCount = int(couplingDict["maxWaitTime"])
    #共有メモリの設定（2重起動を避けるため）
    mmCommFile = allComm.createCommonArea(couplingDict)
    mmCommArea = allComm.mmCommonArea(couplingDict, mmCommFile)
    mmCommPressFile = allComm.createCommTimePressArea(couplingDict)
    mmCommPressArea = allComm.mmCommonArea(couplingDict, mmCommPressFile)
    mmCommTempFile = allComm.createCommTimeTempArea(couplingDict)
    mmCommTempArea = allComm.mmCommonArea(couplingDict, mmCommTempFile)
    #現在時間が終了時間？
    if float(couplingDict["timeName"]) > float(couplingDict["endTime"]):
        exit()
    #beforeTimeが計算開始時間よりも前 or 現時点がbeforeTime？
    if (float(beforeTime) <  float(couplingDict["startTime"]) or    #restart初回
        float(beforeTime) == float(currTime)):                      #計算初回
        #共有メモリにcouplingTimeを保存して終了
        mmCommTempArea.saveCouplingTime()
        mmCommPressArea.saveCouplingTime()
        exit() 
    #---- coupling開始---------------
    #変位のcoupling？
    if pyCoupling.isDispCoupling(couplingDict) == True:
        #couplingTimeを共有メモリに保存
        mmCommPressArea.saveCouplingTime()
        #fsiでdispDictを取得
        stat = coupling_fsi()
        if stat != "":
            raise NameError(stat)
    #温度のcoupling？
    if pyCoupling.isTempCoupling(couplingDict) == True:
        #couplingTimeを共有メモリに保存
        #saveCouplingTimeTemp()
        mmCommTempArea.saveCouplingTime()
        #温度計算
        stat = coupling_cht()
        if stat != "":
            raise NameError(stat)

    

        

