#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
#       createDexcs.py
#
#           dexcs用のtreefoam.pyとbashScriptを作成する
#           (DEXCS2024用）
#
#   17/03/19    新規作成
#      03/21    bashScriptの作成も追加
#   18/01/18    addPathの内容を修正
#               DEXCS/Swakが「~/Desktop」から「/opt」に移動された事による。
#               （DEXCS2017より移動）
#      06/30    DEXCS/Swakの場所誤記、修正。（バグ）
#   20/11/15    ver3対応で修正
#   21/10/31    pyTreeFoam.pyのrun().command()をDEXCS用に修正を追加。
#   22/02/12    pyTreeFoam.pyのrun().command()の内容を修正。
#               裏で起動するものと、そうでないものを分けて実行。
#      09/06    「blockMeshの表示」を削除
#               replaceRunCommandCont:「executable="bash"」を追加
#   23/10/27    「blockMeshの表示」を復活。「DEXCSプロットツールの起動」を追加。
#   24/10/16    treefoam,pyTreeFoam.pyをDEXCS2024用に修正
#	25/04/04    addPyFoamDir:削除。pyFoamをTreeFoam外に出した為。（ver-3.29より）
#

import os

#
#  treefoam.pyの修正用変数
#
addImport = """
#----Dexcs用追加--------------
import pyDexcsSwak
#-----------------------------
"""

addMenuItem = """
        #----Dexcs用追加--------------
        self.menuItemRunDexcsDispBlockMesh = builder.get_object("menuRunDexcsDispBlockMesh")
        self.menuItemRunDexcsBlockMesh = builder.get_object("menuRunDexcsBlockMesh")
        self.menuItemRunDexcsCfMesh = builder.get_object("menuRunDexcsCfMesh")
        self.menuItemRunDexcsCheckMesh = builder.get_object("menuRunDexcsCheckMesh")
        self.menuItemRunDexcsAllrun = builder.get_object("menuRunDexcsAllrun")
        self.menuItemRunDexcsAllclean = builder.get_object("menuRunDexcsAllclean")
        self.menuItemRunDexcsSubmitJob = builder.get_object("menuRunDexcsSubmitJob")
        self.menuItemRunDexcsSubmitStatus = builder.get_object("menuRunDexcsSubmitStatus")
        self.menuItemRunDexcsJGP = builder.get_object("menuRunDexcsJGP")
        self.menuItemRunDexcsPlotTool = builder.get_object("menuRunDexcsPlotTool")
        self.menuItemRunDexcsKdiff3 = builder.get_object("menuRunDexcsKdiff3")
        self.menuItemRunDexcsSearch = builder.get_object("menuRunDexcsSearch")
        #-----------------------------
"""

addMenuFunc = """
     #—-Dexcs用追加————–
    def menuRunDexcsDispBlockMesh(self,event):
        self.runDexcsDispBlockMesh(event)
    def menuRunDexcsBlockMesh(self,event):
        self.runDexcsBlockMesh(event)
    def menuRunDexcsCfMesh(self,event):
        self.runDexcsCfMesh(event)
    def menuRunDexcsCheckMesh(self,event):
        self.runDexcsCheckMesh(event)
    def menuRunDexcsAllrun(self,event):
        self.runDexcsAllrun(event)
    def menuRunDexcsAllclean(self,event):
        self.runDexcsAllclean(event)
    def menuRunDexcsSubmitJob(self,event):
        self.runDexcsSubmitJob(event)
    def menuRunDexcsSubmitStatus(self,event):
        self.runDexcsSubmitStatus(event)
    def menuRunDexcsJGP(self,event):
        self.runDexcsJGP(event)
    def menuRunDexcsPlotTool(self,event):
        self.runDexcsPlotTool(event)
    def menuRunDexcsKdiff3(self,event):
        self.runDexcsKdiff3(event)
    def menuRunDexcsSearch(self,event):
        self.runDexcsSearch(event)
    #—————————–
"""


addFunc = """
    #----Dexcs用追加--------------
    def dexcsReload(self):
        self.writeStatusBar(u"tree data を読み込み中...")
        #currentCaseを保存
        item = self.treeView.get_selection()
        #selCaseDir = self.getDirectory(item)
        #再読込
        self.reload()
        #caseName, solverをlabelにセット
        #caseItem = self.getItem(solveCaseDir)
        #self.changeSolveCase(caseItem)
        #currentCaseを設定
        #self.setSelectCase(self.convDirToList(selCaseDir))
        #self.clearStatus()
    def runDexcsDispBlockMesh(self,event):
        contDict = pyTreeFoam.readConfigTreeFoam()
        paraFoam = contDict["paraFoam"]
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.dispBlockMesh(solveCaseDir, paraFoam)
        self.dexcsReload()
        #event.Skip()
    def runDexcsBlockMesh(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runBlockMesh(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsCheckMesh(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runCheckMesh(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsCfMesh(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runCfMesh(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsAllrun(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runAllrun(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsAllclean(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runAllclean(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsSubmitJob(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runSubmitJob(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsSubmitStatus(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runSubmitStatus(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsJGP(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runJGP(solveCaseDir, envOpenFOAMFix)
        #event.Skip()
    def runDexcsPlotTool(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runPlotTool(solveCaseDir, envOpenFOAMFix)
        #event.Skip()
    def runDexcsKdiff3(self,event):
        os.system("kdiff3 " + solveCaseDir + " &")
        #event.Skip()
    def runDexcsSearch(self,event):
        #global envOpenFOAMFix
        pyDexcsSwak.runSearch(envOpenFOAMFix)
        #event.Skip()
    #-----------------------------
"""

#
#  treefoam修正用変数
#
pyFoamDir = """
export pyFoamDir=/opt/local_python  # for DEXCS
"""

addPath = """
export dexcsSwakPath=/opt/DEXCS/SWAK         #DEXCS
"""

#
#  treefoam.glade修正用変数
#
addIcon = """
<!-- DEXCS -->
  <object class="GtkImage" id="menuImageRunDexcsDispBlockMesh">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsBlockMesh">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsCfMesh">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsCheckMesh">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsAllrun">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsAllclean">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsSubmitJob">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsSubmitStatus">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsJGP">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsPlotTool">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsKdiff3">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
  <object class="GtkImage" id="menuImageRunDexcsSearch">
    <property name="visible">True</property>
    <property name="can_focus">False</property>
    <property name="pixbuf">icons/salome_default.png</property>
  </object>
<!--  -->
"""

addMenu = """
<!-- DEXCS -->
            <child>
              <object class="GtkMenuItem">
                <property name="visible">True</property>
                <property name="can_focus">False</property>
                <property name="label" translatable="yes">十徳ナイフ(_J)</property>
                <property name="use_underline">True</property>
                <child type="submenu">
                  <object class="GtkMenu">
                    <property name="visible">True</property>
                    <property name="can_focus">False</property>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsDispBlockMesh">
                        <property name="label" translatable="yes">blockMeshの表示</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsDispBlockMesh</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsDispBlockMesh" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsBlockMesh">
                        <property name="label" translatable="yes">blockMeshの実行</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsBlockMesh</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsBlockMesh" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsCfMesh">
                        <property name="label" translatable="yes">cfMesh(cartesianMesh)の実行</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsCfMesh</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsCfMesh" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsCheckMesh">
                        <property name="label" translatable="yes">checkMeshの実行</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsCheckMesh</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsCheckMesh" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsAllrun">
                        <property name="label" translatable="yes">Allrunの実行</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsAllrun</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsAllrun" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsAllclean">
                        <property name="label" translatable="yes">Allcleanの実行</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsAllclean</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsAllclean" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsSubmitJob">
                        <property name="label" translatable="yes">バッチジョブをサブミット</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsSubmitJob</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsSubmitJob" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsSubmitStatus">
                        <property name="label" translatable="yes">バッチジョブの確認</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsSubmitStatus</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsSubmitStatus" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsJGP">
                        <property name="label" translatable="yes">汎用gnuplot-GUI(jgp)の起動</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsJGP</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsJGP" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsPlotTool">
                        <property name="label" translatable="yes">DEXCSプロットツールの起動</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsPlotTool</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsPlotTool" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsKdiff3">
                        <property name="label" translatable="yes">ケース比較（Kdiff3）の起動</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsKdiff3</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsKdiff3" swapped="no"/>
                      </object>
                    </child>
                    <child>
                      <object class="GtkImageMenuItem" id="menuRunDexcsSerch">
                        <property name="label" translatable="yes">十徳サーチ</property>
                        <property name="visible">True</property>
                        <property name="can_focus">False</property>
                        <property name="image">menuImageRunDexcsSearch</property>
                        <property name="use_stock">False</property>
                        <property name="always_show_image">False</property>
                        <signal name="activate" handler="menuRunDexcsSearch" swapped="no"/>
                      </object>
                    </child>
                  </object>
                </child>
              </object>
            </child>
<!--  -->
"""

replaceRunCommandCont = '''        """ commandを実行する。終了するまで待ち、終了後に戻る。
        終了を待たずに戻る場合は、commandの最後に「&」を追加する。
        DEXCS用に修正。（AppImageで実行）"""
        os.chdir(self.caseDir)
        #print('comm = ',comm)
        if comm[0] == '.':
            #from PySide2 import QtCore
            from PyQt5 import QtCore
            process = QtCore.QProcess()
            working_dir = self.caseDir
            if working_dir:
                process.setWorkingDirectory(working_dir)
            if comm[-1] == "&":
                qcomm = 'bash -c ' + '"' + comm + '"'
                ret = process.startDetached(qcomm)
            else:
                qcomm = 'bash -c ' + '"' + comm + '"'
                ret = process.execute(qcomm)
        else:
            dummy_proc = subprocess.run(comm, shell=True, executable="bash") 

'''


def readFileLines(fileName):
    f = open(fileName)
    lines = f.readlines()
    f.close()
    return lines

def writeFileLines(fileName, lines):
    f = open(fileName, "w")
    for line in lines:
        f.write(line)
    f.close()

#
#  addDexcsImport
#    import行以外が10行続いた時、最後import行の次の行に追加する
def addDexcsImport(lines):
    ip = -1
    n = 0
    flag = 0
    for i in range(len(lines)):
        line = lines[i]
        if line[0] != "#" and len(line) >= len("import"):
            words = line.split()
            if len(words) > 1:
                if words[0] == "import" or words[0] == "from":
                    n = 0
                    ip = i
                else:
                    n += 1
            if n > 10:
                flag = 1
                break
    if flag == 0:
        print("error: importが追加できません")
        return lines
    ip += 1
    addLines = addImport.split("\n")[1:-1]
    addLines = list(map(lambda x: x+"\n", addLines))
    #addLines = addImport.split("\n")
    #for i in range(len(addLines)):
    #    addLines[i] += "\n"
    newLines = lines[:ip] + addLines + lines[ip:]
    return newLines

#
#  changeVersion
#    versionを修正
def changeVersion(lines):
    flag = 0
    for i in range(len(lines)):
        line = lines[i]
        if line[:len("version")] == "version":
            words = line.split('"')
            words[1] += "+dexcsSwak"
            lines[i] = '"'.join(words)
            flag = 1
            break
    if flag == 0:
        print("error: versionが変更できません")
    return lines

#
#  addMenuItems
#----------------
def addMenuItemDefine(lines):
    """ menuItem定義を追加する"""
    ip = -1
    for i in range(len(lines)):
        line = lines[i]
        if line.find('self.menuItemRunSalome = builder.get_object("menuRunSalome")') >= 0:
            ip = i + 1
            break
    if ip < 0:
        print("error: menuItem定義が追加できません")
        newLines = lines
    else:
        addLines = addMenuItem.split("\n")[1:-1]
        addLines = list(map(lambda x: x+"\n", addLines))
        newLines = lines[:ip] + addLines + lines[ip:]
    return newLines

#
#  addMenuFuncDefine
#---------------------
def addMenuFuncDefine(lines):
    """ menuFunc定義を追加"""
    ip = -1
    for i in range(len(lines)):
        line = lines[i]
        if line.find("self.helpVersion()") >= 0:
            ip = i + 1
            break
    if ip < 0:
        print("error: menuFunc定義が追加できません")
        newLines = lines
    else:
        addLines = addMenuFunc.split("\n")[1:-1]
        addLines = list(map(lambda x: x+"\n", addLines))
        newLines = lines[:ip] + addLines + lines[ip:]
    return newLines

#
#  addFuncDefine
#----------------
def addFuncDefine(lines):
    """ dexcs関数を追加"""
    ip = -1
    flag = 0
    for i in range(len(lines)):
        line = lines[i]
        if flag == 0:
            if line.find("def helpVersion(self):") >= 0:
                flag = 1
        else:
            if line.find("self.okDialog(title, mess)") >= 0:
                ip = i + 1
                break
    if ip < 0:
        print("error: dexcs関数が追加できません")
        return lines
    else:
        addLines = addFunc.split("\n")[1:-1]
        addLines = list(map(lambda x: x+"\n", addLines))
        newLines = lines[:ip] + addLines + lines[ip:]
        return newLines
        
#
#  addPyFoamDir
#---------------
def addPyFoamDir(lines):
    """ pyFoamDirを修正"""
    ip = -1
    for i in range(len(lines)):
        line = lines[i]
        if line[:len("export pyFoamDir=")] == "export pyFoamDir=":
            ip = i
            break
    if ip < 0:
        print("error: pyFoamDirが定義できません")
        return lines
    else:
        addLine = pyFoamDir.split("\n")[1] + "\n"
        lines[ip] = "#" + lines[ip]
        ip += 1
        newLines = lines[:ip] + [addLine] + lines[ip:]
        return newLines

#
#  addDexcsSwakPath
#--------------------
def addDexcsSwakPath(lines):
    """ dexcsSwakPathを追加"""
    ip = -1
    for i in range(len(lines)):
        line = lines[i]
        if line[:len("export PYTHONPATH=")] == "export PYTHONPATH=":
            words = line.split(":")
            words = words[:-1] + ["$dexcsSwakPath"] + words[-1:]
            lines[i] = ":".join(words)
            ip = i
            break
    if ip < 0:
        print("error: dexscSwakPathが追加できません")
        return lines
    else:
        addLine = addPath.split("\n")[1] + "\n"
        newLines = lines[:ip] + [addLine] + lines[ip:]
        return newLines
        
#
#  addDexcsMenuIcons
#--------------------
def addDexcsMenuIcons(lines):
    """ gladeファイルにiconを追加"""
    ip = -1
    for i in range(len(lines)):
        line = lines[i]
        if line.find('<property name="pixbuf">icons/treefoam24.png</property>') >= 0:
            ip = i + 2
            break
    if ip < 0:
        print("error: gladeファイルにiconが追加できません")
        return lines
    else:
        addLines = addIcon.split("\n")[1:-1]
        addLines = list(map(lambda x: x+"\n", addLines))
        newLines = lines[:ip] + addLines + lines[ip:]
        return newLines
        
#
#  addDexcsMenu
#--------------------
def addDexcsMenu(lines):
    """ gladeファイルにdexcsmenuを追加する"""
    ip = -1
    for i in range(len(lines)):
        line = lines[i]
        #if line.find('<signal name="activate" handler="menuParallel" swapped="no"/>') >= 0:
        if line.find('<signal name="activate" handler="menuRunCoupling" swapped="no"/>') >= 0:
            ip = i + 7
            break
    if ip < 0:
        print("error: gladeファイルにmenuが追加できません")
        return lines
    else:
        addLines = addMenu.split("\n")[1:-1]
        addLines = list(map(lambda x: x+"\n", addLines))
        newLines = lines[:ip] + addLines + lines[ip:]
        return newLines

#
#  replaceRunCommand
#--------------------
def replaceRunCommand(lines):
    """ pyTreeFoam.pyのrun().command()を修正する。"""
    ist = -1
    ied = -1
    for i in range(len(lines)):
        line = lines[i]
        if line.find("def command(self, comm)") >= 0:
            ist = i + 1
            break
    if ist > 0:
        for i in range(ist, len(lines)):
            line = lines[i]
            if line.find(" def ") >= 0:
                ied = i
                break
    if ist == -1 or ied == -1:
        return ("error", lines)
    else:
        newLines = lines[:ist] + [replaceRunCommandCont] + lines[ied:]
        return ("OK", newLines)


if __name__ == "__main__":
    #treefoam.pyの作成
    fileName = "treefoam.py"
    lines = readFileLines(fileName)
    lines = addDexcsImport(lines)
    lines = changeVersion(lines)
    lines = addMenuItemDefine(lines)
    lines = addMenuFuncDefine(lines)
    lines = addFuncDefine(lines)
    writeName = "dexcs_treefoam.py"
    writeFileLines(writeName, lines)

    #treefoamの作成
    fileName = "treefoam"
    lines = readFileLines(fileName)
    #lines = addPyFoamDir(lines)        #削除
    lines = addDexcsSwakPath(lines)
    writeName = "dexcs_treefoam"
    writeFileLines(writeName, lines)
    os.system("chmod 777 " + writeName)
    
    #treefoam.gladeの作成
    fileName = "treefoam.glade"
    lines = readFileLines(fileName)
    lines = addDexcsMenuIcons(lines)
    lines = addDexcsMenu(lines)
    writeName = "dexcs_treefoam.glade"
    writeFileLines(writeName, lines)
    
    #pyTreeFoam.pyのrun.commandの修正
    fileName = "python/pyTreeFoam.py"
    lines = readFileLines(fileName)
    stat, lines = replaceRunCommand(lines)
    if stat == "OK":
        writeName = "dexcs_pyTreeFoam.py"
        writeFileLines(writeName, lines)
        
