#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#      setBCInPatchViewerQtDDialog.py
#
#       patchViewer上でpatchの境界条件を設定する。
#
#   20/05/19    新規作成
#


#from PyQt4 import QtCore, QtGui
import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule
#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()


#-------------------
#  Ui_Dialog class
#-------------------
class Ui_Dialog(object):

    def __init__(self, patchName, selField, fields):
        self.patchName = patchName
        self.fields = fields
        self.dialog = QDialog()
        self.selField = selField
        self.boundary = ""

        self.setupUi(self.dialog)
        self.label_patchName.setText("patch: " + self.patchName)
        for field in self.fields:
            self.combo_fields.addItem(field)
        if self.selField == "":
            self.combo_fields.setCurrentIndex(-1)
        else:
            index = fields.index(self.selField)

        self.button_cancel.clicked.connect(self.cancel)
        self.button_apply.clicked.connect(self.apply)

    def Show(self):
        #self.dialog.show()
        self.dialog.exec()
        return (self.selField, self.boundary)

    def apply(self):
        self.selField = self.combo_fields.currentText()
        self.boundary = self.textEdit_boundary.toPlainText()
        self.dialog.close()

    def cancel(self):
        self.selField = ""
        self.boundary = ""
        self.dialog.close()

    def setupUi(self, Dialog):
        Dialog.setObjectName("Dialog")
        Dialog.resize(400, 300)
        #self.verticalLayout = QtGui.QVBoxLayout(Dialog)
        self.verticalLayout = QVBoxLayout(Dialog)
        self.verticalLayout.setObjectName("verticalLayout")
        #self.label_patchName = QtGui.QLabel(Dialog)
        self.label_patchName = QLabel(Dialog)
        self.label_patchName.setObjectName("label_patchName")
        self.verticalLayout.addWidget(self.label_patchName)
        #self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName("horizontalLayout")
        #self.label = QtGui.QLabel(Dialog)
        self.label = QLabel(Dialog)
        self.label.setObjectName("label")
        self.horizontalLayout.addWidget(self.label)
        #self.combo_fields = QtGui.QComboBox(Dialog)
        self.combo_fields = QComboBox(Dialog)
        #sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Minimum, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.combo_fields.sizePolicy().hasHeightForWidth())
        self.combo_fields.setSizePolicy(sizePolicy)
        #self.combo_fields.setMinimumSize(QtCore.QSize(200, 0))
        self.combo_fields.setMinimumSize(QSize(200, 0))
        self.combo_fields.setObjectName("combo_fields")
        self.horizontalLayout.addWidget(self.combo_fields)
        #spacerItem = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout.addItem(spacerItem)
        self.verticalLayout.addLayout(self.horizontalLayout)
        #self.label_2 = QtGui.QLabel(Dialog)
        self.label_2 = QLabel(Dialog)
        self.label_2.setObjectName("label_2")
        self.verticalLayout.addWidget(self.label_2)
        #self.textEdit_boundary = QtGui.QTextEdit(Dialog)
        self.textEdit_boundary = QTextEdit(Dialog)
        self.textEdit_boundary.setObjectName("textEdit_boundary")
        self.verticalLayout.addWidget(self.textEdit_boundary)
        #self.horizontalLayout_2 = QtGui.QHBoxLayout()
        self.horizontalLayout_2 = QHBoxLayout()
        self.horizontalLayout_2.setObjectName("horizontalLayout_2")
        #spacerItem1 = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem1 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout_2.addItem(spacerItem1)
        #self.button_cancel = QtGui.QPushButton(Dialog)
        self.button_cancel = QPushButton(Dialog)
        self.button_cancel.setObjectName("button_cancel")
        self.horizontalLayout_2.addWidget(self.button_cancel)
        #self.button_apply = QtGui.QPushButton(Dialog)
        self.button_apply = QPushButton(Dialog)
        self.button_apply.setObjectName("button_apply")
        self.horizontalLayout_2.addWidget(self.button_apply)
        self.verticalLayout.addLayout(self.horizontalLayout_2)

        self.retranslateUi(Dialog)
        #QtCore.QMetaObject.connectSlotsByName(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def retranslateUi(self, Dialog):
        Dialog.setWindowTitle(_("Dialog"))
        self.label_patchName.setText(_("patch: patchName"))
        self.label.setText(_("field:"))
        self.label_2.setText(_("設定内容"))
        self.button_cancel.setText(_("キャンセル"))
        self.button_apply.setText(_("設定"))


if __name__ == "__main__":
    import gettext
    gettext.install("app")
    #_ = gettext.gettext    
    import sys

    patchName = "movingWall"
    fields = ["U", "p"]
    #app = QtGui.QApplication(sys.argv)
    app = QApplication(sys.argv)
    #Dialog = QtGui.QDialog()
    #Dialog = QDialog()
    ui = Ui_Dialog(patchName, selField, fields)
    #ui.setupUi(Dialog)
    ans = ui.Show()
    #Dialog.show()
    #ans = app.exec_()
    #print("----", ans)
    #sys.exit(app.exec_())
    #print("----", ui.selField, ui.boundary)

