#!/usr/bin/python3
#  coding:  utf-8
#
#   surfaceTransformDDialog.py
#
#       stlファイルを各方向に移動する
#
#   21/07/13    新規作成
#   22/11/29    中心座標を原点に移動するcheckBoxを追加
#   24/08/09    funcOk,funcCancel,parentを追加
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

#-------------------------
#  surfaceTransform class
#-------------------------
class surfaceTransform:
    """ stlを移動する"""

    def __init__(self, funcOk=[], funcCancel=[], parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "surfaceTransformDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        #親windowを設定
        self.dialog.set_transient_for(parent)
        #modal(freeze)を設定
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        self.entry_x.set_text("0.0")
        self.entry_y.set_text("0.0")
        self.entry_z.set_text("0.0")
        self.transforms = ["0", "0", "0"]

    #
    #  show
    #--------
    def show(self):
        """ dialogの表示"""
        self.dialog.show()
        # self.dialog.run()
        # return self.transforms

    #
    #  close
    #--------
    def close(self, *args):
        """ dialogを閉じた時のevent"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        self.entry_x = self.builder.get_object("entry_x")
        self.entry_y = self.builder.get_object("entry_y")
        self.entry_z = self.builder.get_object("entry_z")
        self.check_centerX0 = self.builder.get_object("check_centerX0")
        self.check_centerY0 = self.builder.get_object("check_centerY0")
        self.check_centerZ0 = self.builder.get_object("check_centerZ0")


    #-------- event handler -----------
    #  OK
    def onOk(self, event):
        x = self.entry_x.get_text()
        y = self.entry_y.get_text()
        z = self.entry_z.get_text()
        transforms = [x, y, z]
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(transforms, *args)
            GLib.timeout_add(100, funcName, transforms, *args)
    #  cancel
    def onCancel(self, event):
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)
    #  centerX0
    def onChangeCheckX0(self, event):
        self.changeCheckX0()
    #  centerY0
    def onChangeCheckY0(self, event):
        self.changeCheckY0()
    #  centerZ0
    def onChangeCheckZ0(self, event):
        self.changeCheckZ0()


    #
    #  changeCheckX0
    #-----------------
    def changeCheckX0(self):
        """ stlの中心座標を原点に移動するのcheckBoxを変更した時"""
        if self.check_centerX0.get_active() == True:
            self.entry_x.set_sensitive(False)
            self.transforms[0] = self.entry_x.get_text()
            self.entry_x.set_text("org")
        else:
            self.entry_x.set_sensitive(True)
            self.entry_x.set_text(self.transforms[0])

    #
    #  changeCheckY0
    #-----------------
    def changeCheckY0(self):
        if self.check_centerY0.get_active() == True:
            self.entry_y.set_sensitive(False)
            self.transforms[1] = self.entry_y.get_text()
            self.entry_y.set_text("org")
        else:
            self.entry_y.set_sensitive(True)
            self.entry_y.set_text(self.transforms[1])

    #
    #  chansgeCheckZ0
    #------------------
    def changeCheckZ0(self):
        if self.check_centerZ0.get_active() == True:
            self.entry_z.set_sensitive(False)
            self.transforms[2] = self.entry_z.get_text()
            self.entry_z.set_text("org")
        else:
            self.entry_z.set_sensitive(True)
            self.entry_z.set_text(self.transforms[2])
