#!/usr/bin/python3
#  coding: utf-8
#
#           saveGoDialoig.oy
#
#       cancel, go, saveGo の3個のボタンを持つdialog
#
#   24/11/05    新規作成
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import os


import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)


#-------------------
#  saveGo class
#-------------------
class saveGo:
    """ cancel, end, saveEnd の3個のボタンを持つdialog"""

    def __init__(self, title, message, 
                 funcSaveGo=[],     #保存して終了 
                 funcGo=[],         #終了
                 funcCancel=[],     #キャンセル
                 parent=None):      #parent
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "saveGoDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.title = title
        self.message = message
        self.stat = "CANCEL"
        self.funcSaveGo = funcSaveGo
        self.funcGo = funcGo
        self.funcCancel = funcCancel
        #初期化
        self.initialize()

    #
    #  show
    #-------
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    def close(self, *args):
        """ dialogを直接閉じた時のevent"""
        self.dialog.destroy()

    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        self.label_mess = self.builder.get_object("label_mess")
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_end = self.builder.get_object("button_end")
        self.button_saveEnd = self.builder.get_object("button_saveEnd")
        
    def initialize(self):
        self.dialog.set_title(self.title)
        self.label_mess.set_text(self.message)

    #----event handler -------------
    
    def onCancel(self, event):
        self.close()
        self.runFunction(self.funcCancel)

    def onGo(self, event):
        self.close()
        self.runFunction(self.funcGo)

    def onSaveGo(self, event):
        self.close()
        self.runFunction(self.funcSaveGo)

    #  runFunction
    def runFunction(self, funcArgs):
        """ 指定した関数を実行"""
        if len(funcArgs) > 0:
            funcName = funcArgs[0]
            args = funcArgs[1:]
            funcName(*args)
