#!/usr/bin/python3
# coding: utf-8
#
#   runParaFoamOptionDialog
#
#       paraFoamをoption付きで起動するかどうかを確認して起動する。
#
#   14/07/13    新規作成
#      07/27    ラジオボタンに変更
#   15/07/17    dialogの起動方法を修正
#      07/23    radioボタンの設定を常時「option無し」に設定
#   19/09/05    GTK+3, python3用に書き換え
#   20/04/22    多言語化対応
#      06/11    if __name__ == "__main__" 以下を追加
#   24/08/09    funcOk,funcCancel,parentを追加
#      08/10    モジュール名を「runParaFoamOptionDDialog.py」に変更
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os
import sys

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)


#--------------------
#  runParaFoamOption class
#--------------------
class runParaFoamOption:

    def __init__(self, regFlag, funcOk=[], funcCancel=[], parent=None):
        #Gtk.Dialog.__init__(self, **kwds)
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "runParaFoamOptionDialog.glade")
        self.dialogApp = self.builder.get_object("dialog1")
        #親windowを設定
        self.dialogApp.set_transient_for(parent)
        #modal(freeze)の設定
        #self.dialogApp.set_modal(True)
        self.dialogApp.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.regFlag = regFlag
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        #self.status = "CANCEL"
        mess = _("paraFoamの起動方法（option）を指定してください。")
        if regFlag == True:
            #multiRegionの場合
            mess += "\n\n" 
            mess += _("このcaseは、multiRegionのcaseです。\n")
            mess += _("  「-builtin」optionを選択するか\n")
            mess += _("  paraFoamにマクロを追加してください。")
            self.radioParaFoamOption.set_active(True)
        else:
            self.radioParaFoam.set_active(True)
        self.labelCont.set_label(mess)

    def show(self):
        self.dialogApp.show()
        #Gtk.main()

    def close(self, *args):
        self.dialogApp.destroy()
        #Gtk.main_quit()

    def setGtkObject(self):
        self.labelCont = self.builder.get_object("labelCont")
        self.radioParaFoam = self.builder.get_object("radioParaFoam")
        self.radioParaFoamOption = self.builder.get_object("radioParaFoamBuiltin")

    def getOption(self):
        option = ""
        if self.radioParaFoam.get_active() == True:
            option = ""
        elif self.radioParaFoamOption.get_active() == True:
            option = "-builtin"
        else:
            option = ""
        return option

    def onOK(self, event):
        option = self.getOption()
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(option, *args)
            GLib.timeout_add(100, funcName, option, *args)

    def onCancel(self, event):
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)


if __name__ == "__main__":
    import gettext
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    paraFoamFix = sys.argv[1]
    caseDir = sys.argv[2]
    (stat, option) = Show(False)
    if stat == "OK":
        comm = "cd " + caseDir + ";" + paraFoamFix + " " + option + " &"
        os.system(comm)
