#!/usr/bin/python3
# coding: utf-8
#
#   paraSnappyPost.py
#
#       snappyHexMeshの並列実行後の後処理
#
#   19/10/20    新規作成
#   24/01/18    createCellLevel,setPolyMesh:OF-11対応。
#      11/26    setPolyMesh:OF-12用で修正。
#
""" snappyHexMeshを並列で実行した時に、各processorに散らばっているfileを
reconstructし、余分なfolderやfileを削除する。
現状は、cellLevelのみreconstructしている。"""

import os, sys 
import glob
import shutil
import pyTreeFoam
import stringOp

import logFileCreater; logFileCreater.log()

def getNumbersInFile(fileName):
    """ ファイル内の()内数値を文字で取得する"""
    cont = pyTreeFoam.foamFile().readFull(fileName)
    if pyTreeFoam.foamFile().checkBinary(cont) == "ascii":
        #asciiデータの場合
        contOp = stringOp.strings(cont)
        p = contOp.skipFoamFile()
        (data, _pp) = contOp.getSmallPair(p)
        if len(data) == 0:
            #{}dataを取得
            (nData, _pp) = contOp.getKeyword(p)
            (val, _pp) = contOp.getMiddlePair(p)
            #data作成
            data = b""
            for i in range(int(nData)):
                data += val + b"\n"
        nums = data.decode().split()
    else:
        #binaryデータの場合
        (_ascii, data) = pyTreeFoam.foamFile().separateLabelListContents(cont)
        vals = pyTreeFoam.foamFile().structBinData(data[0])
        nums = []
        for i in range(len(vals)):
            nums.append(str(vals[i]))
    return nums

#
#  createCellLevel
#  ---------------
def createCellLevel(caseDir):
    """ 各processorに散らばったcellLevelを集めreconstructする"""
    #OFversionをチェック
    configDict = pyTreeFoam.readConfigTreeFoam()
    OFversion = configDict["OFversion"]
    numVer = pyTreeFoam.getNumVersion(OFversion)
    if numVer >= 11.0:
        #OF-11 以上は、何もしない
        return
    case = pyTreeFoam.case(caseDir)
    timeFolders = case.getTimeFolders()
    timeFolders.sort()
    latestTime = timeFolders[-1]
    fileName = latestTime + "/cellDecomposition"
    nums = getNumbersInFile(fileName)
    procNums = []
    for num in nums:
        procNums.append([num, ""])
    procs = glob.glob("processor*")
    for proc in procs:
        procNo = proc[len("processor"):]
        fileName = proc + "/" + latestTime + "/polyMesh/cellLevel"
        levels = getNumbersInFile(fileName)
        j = 0
        for i in range(len(nums)):
            if procNums[i][0] == procNo:
                procNums[i][1] = levels[j]
                j += 1
    #header作成
    #  headerを取得
    cont = pyTreeFoam.foamFile().read(fileName)     #20行asciiで読み込む
    contOp = stringOp.strings(cont)
    p = contOp.skipFoamFile()
    p += 1
    while p < len(cont):
        chara = cont[p]
        if chara == "\n":
            break
        p += 1
    cont = cont[:p] + "\n\n"
    #  FoamFileを取得
    contOp = stringOp.strings(cont)
    (foamLine, _ps, _kind) = contOp.get1line(0)
    #  foamatをasciiに書き換え
    foamOp = stringOp.strings(foamLine)
    (pairCont, p) = foamOp.getMiddlePair(0)
    pairOp = stringOp.strings(pairCont)
    formatLine = "format      ascii;"
    (pairCont, p, _keyword) = pairOp.replace1lineKeyword(0, formatLine)
    #  FoamFileを入れ替え
    newFoamLine = "FoamFile\n{\n" + pairCont.decode() + "}"
    (cont, p, _keyword) = contOp.replace1lineKeyword(0, newFoamLine)
    cont = cont.decode()
    #data部を作成
    cont += str(len(procNums)) + "\n"
    cont += "(\n"
    for num in procNums:
        cont += num[1] + "\n"
    cont += ")\n"
    #footerをセット
    cont += pyTreeFoam.getFoamContents().makeFoamFooter()
    #file保存
    fileName = latestTime + "/polyMesh/cellLevel"
    pyTreeFoam.foamFile().writeFull(fileName, cont)
    print("create 'cellLevel' from each processors.")

#
#  setPolyMesh
#  -----------
def setPolyMesh(caseDir):
    """ meshをconstantにcopyし、余分なfile、folderを削除"""
    case = pyTreeFoam.case(caseDir)
    timeFolders = case.getTimeFolders()
    latestTime = timeFolders[-1]
    run = pyTreeFoam.run(caseDir)
    comm = "rm -rf ./constant/polyMesh/*"
    print(comm)
    run.command(comm)
    comm = "cp ./" + latestTime + "/polyMesh/* " + "./constant/polyMesh"
    print(comm)
    run.command(comm)
    if len(timeFolders) > 1:
        comm = "rm -rf " + latestTime
    print(comm)
    run.command(comm)
    comm = "rm -rf ./processor*"
    print(comm)
    run.command(comm)     
    configDict = pyTreeFoam.readConfigTreeFoam()
    OFversion = configDict["OFversion"]
    numVer = pyTreeFoam.getNumVersion(OFversion)
    if numVer >= 11.0:
        #OF-11の場合、最後から2番目のtimeFolderが残ったままになる為、追加。
        #OF-12の場合、余分なtimeFolderが残るので、firstTime以外を削除する。
        for i in range(1, len(timeFolders), 1):
            delTime = timeFolders[i]
            comm = "rm -rf " + delTime
            print(comm)
            run.command(comm)
    return
    

if __name__ == "__main__":
    import gettext
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    caseDir = sys.argv[1]
    #cellLevelを作成
    createCellLevel(caseDir)
    #meshをconstantにcopyし、余分なfile、folderを削除
    setPolyMesh(caseDir)
