#!/usr/bin/python3
# coding: utf-8
#
#       meetpatchNameDeleteNullPatch.py
#
#   24/11/10    changeEmptyToZerogradientを追加
#               decomposeParする時、field内にemptyがあるとエラー発生。
#               emptyをzeroGradientに修正
#

import os, sys
import pyTreeFoam

import gettext
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
gettext.install("treefoam", localeDir)
#_ = gettext.gettext


caseDir = sys.argv[1]
case = pyTreeFoam.case(caseDir)
timeFolder = case.getCurrTimeFolder()
meshDir = caseDir + os.sep + "constant"
#定義されていないpatchを削除
case.clearNullBoundaryAllFields(timeFolder, meshDir)
#boundary、各field内のemptyをzeroGradientに修正
#decomposeでエラー発生するため
case.chengeEmptyToZeroGradient(timeFolder, meshDir)
