#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   inputTextQtDialog.py
#
#       1行の文字列をQtで入力し、取得する。
#
#   20/05/24    新規作成
#   24/08/23    setCenterParentPosition:新規追加
#               (dialogの表示位置をparentの中心に表示)
#      08/28    Qt4系、Qt6系の両方に対応する様に修正
#


import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()


import sys


def _fromUtf8(s):
    return s


try:
    _encoding = QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig)


#------------------
#  Ui_Dialog class
#------------------
class Ui_Dialog(object):

    def __init__(self, title, message, inputText="", parent=None):
        self.title = title
        self.message = message
        self.inputText = inputText
        self.parent = parent
        self.Dialog = QDialog()

    def main(self):
        self.setupUi(self.Dialog)
        self.entry_text.setText(self.inputText)
        self.setEvent()
        self.label_mess.setText(self.message)
        self.Dialog.setWindowTitle(self.title)
        self.btn_ok.setDefault(True)                #enterKeyに対応
        #dialogをparentの中心に表示させる
        self.setCenterParentPosition()
        self.Dialog.exec()
        return self.inputText

    def close(self):
        self.Dialog.close()

    def setCenterParentPosition(self):
        """ dialogの位置を親の中心に設定する。
        widgetのレイアウト設定後に実行する"""
        #parentの中心位置
        geo = self.parent.geometry()
        xy = (geo.left() + geo.width()//2, geo.top() + geo.height()//2)
        pos = QPoint(xy[0], xy[1])
        #設定位置を取得
        geo = self.Dialog.geometry()
        geoP = QPoint(geo.width()//2, geo.height()//2)
        newPos = pos - geoP
        self.Dialog.move(newPos)

    def setupUi(self, Dialog):
        """ Qtのversionに応じたUiをセットする"""
        if getPyQtModule.UiCode == "Qt4":
            self.setupUi_Qt4(Dialog)
        elif getPyQtModule.UiCode == "Qt6":
            self.setupUi_Qt6(Dialog)

    def setupUi_Qt6(self, Dialog):
        """ Qt6系用のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(400, 151)
        self.verticalLayout_2 = QVBoxLayout(Dialog)
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        self.verticalLayout = QVBoxLayout()
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        self.label_mess = QLabel(Dialog)
        self.label_mess.setObjectName(_fromUtf8("label_mess"))
        self.verticalLayout.addWidget(self.label_mess)
        self.entry_text = QLineEdit(Dialog)
        self.entry_text.setObjectName(_fromUtf8("entry_text"))
        self.verticalLayout.addWidget(self.entry_text)
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## spacerItem = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        spacerItem = QSpacerItem(40, 20, QSizePolicy.Policy.Expanding, QSizePolicy.Policy.Minimum)
        self.horizontalLayout.addItem(spacerItem)
        self.btn_cancel = QPushButton(Dialog)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_cancel.sizePolicy().hasHeightForWidth())
        self.btn_cancel.setSizePolicy(sizePolicy)
        self.btn_cancel.setObjectName(_fromUtf8("btn_cancel"))
        self.horizontalLayout.addWidget(self.btn_cancel)
        self.btn_ok = QPushButton(Dialog)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_ok.sizePolicy().hasHeightForWidth())
        self.btn_ok.setSizePolicy(sizePolicy)
        self.btn_ok.setObjectName(_fromUtf8("btn_ok"))
        self.horizontalLayout.addWidget(self.btn_ok)
        self.verticalLayout.addLayout(self.horizontalLayout)
        self.verticalLayout_2.addLayout(self.verticalLayout)

        self.retranslateUi(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def setupUi_Qt4(self, Dialog):
        """ Qt4系用のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(400, 151)
        ## self.verticalLayout_2 = QtGui.QVBoxLayout(Dialog)
        self.verticalLayout_2 = QVBoxLayout(Dialog)
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        ## self.verticalLayout = QtGui.QVBoxLayout()
        self.verticalLayout = QVBoxLayout()
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        ## self.label_mess = QtGui.QLabel(Dialog)
        self.label_mess = QLabel(Dialog)
        self.label_mess.setObjectName(_fromUtf8("label_mess"))
        self.verticalLayout.addWidget(self.label_mess)
        ## self.entry_text = QtGui.QLineEdit(Dialog)
        self.entry_text = QLineEdit(Dialog)
        self.entry_text.setObjectName(_fromUtf8("entry_text"))
        self.verticalLayout.addWidget(self.entry_text)
        ## self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## spacerItem = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout.addItem(spacerItem)
        ## self.btn_cancel = QtGui.QPushButton(Dialog)
        self.btn_cancel = QPushButton(Dialog)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_cancel.sizePolicy().hasHeightForWidth())
        self.btn_cancel.setSizePolicy(sizePolicy)
        self.btn_cancel.setObjectName(_fromUtf8("btn_cancel"))
        self.horizontalLayout.addWidget(self.btn_cancel)
        ## self.btn_ok = QtGui.QPushButton(Dialog)
        self.btn_ok = QPushButton(Dialog)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_ok.sizePolicy().hasHeightForWidth())
        self.btn_ok.setSizePolicy(sizePolicy)
        self.btn_ok.setObjectName(_fromUtf8("btn_ok"))
        self.horizontalLayout.addWidget(self.btn_ok)
        self.verticalLayout.addLayout(self.horizontalLayout)
        self.verticalLayout_2.addLayout(self.verticalLayout)

        self.retranslateUi(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def retranslateUi(self, Dialog):
        Dialog.setWindowTitle(_translate("Dialog", "Dialog", None))
        self.label_mess.setText(_translate("Dialog", "TextLabel", None))
        self.btn_cancel.setText(_translate("Dialog", _("キャンセル"), None))
        self.btn_ok.setText(_translate("Dialog", _("OK"), None))

    def setEvent(self):
        self.btn_cancel.clicked.connect(self.onCancel)
        self.btn_ok.clicked.connect(self.onOk)

    def onOk(self):
        self.inputText = self.entry_text.text()
        self.close()

    def onCancel(self):
        self.inputText = ""
        self.close()


if __name__ == "__main__":
    import gettext
    gettext.install("app")
    #_ = gettext.gettext

    # import sys
    # app = QtGui.QApplication(sys.argv)
    # Dialog = QtGui.QDialog()
    # ui = Ui_Dialog()
    # ui.setupUi(Dialog)
    # Dialog.show()
    # sys.exit(app.exec_())

