#!/usr/bin/python3
# coding: utf-8
#
#       getReconstructParMethodDDialog.py
#
#       reconstructParコマンドのオプションを取得
#
#   20/12/20    新規作成
#   21/06/12    changeRadioBtn:追加
#               radioBtnを選択した時、entryをactiveにする設定を追加
#   23/05/01    並列処理を追加
#   24/08/09    funcOk,funcCancel,parentを追加
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys
import glob

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

#--------------------------------
#  getReconstructParMethod class
#--------------------------------
class getReconstructParMethod:
    """ reconstructParコマンドのoptionを取得して返す。
    
    Args:
        caseDir (str)       :caseDir
        funcOk=[] (obj)     :「OK」時、実行する関数と引数のlist
        funcCancel=[] (obj) :「cancel」時、実行する関数と引数のlist
        parent=None (obj)   :親window
    """

    def __init__(self, caseDir, funcOk=[], funcCancel=[], parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "getReconstructParMethodDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        #親windowを設定
        self.dialog.set_transient_for(parent)
        #modal(freeze)を設定
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.caseDir = caseDir
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        self.options = ""
        #self.stat = "CANCEL"
        self.entry_time.set_sensitive(False)
        self.nProcs = 0
        self.initialize()

    #
    #  show
    #-------
    def show(self):
        """ dialogを表示、optionsを返す"""
        self.dialog.show()
        # self.dialog.run()
        # if self.stat != "OK":
        #     return "CANCEL"
        # else:
        #     return self.options

    #
    #  close
    #--------
    def close(self, *args):
        """ dialogを閉じた時のevent"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #----------------
    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        self.radio_all = self.builder.get_object("radio_all")
        self.radio_latestTime = self.builder.get_object("radio_latestTime")
        self.radio_time = self.builder.get_object("radio_time")
        self.entry_time = self.builder.get_object("entry_time")
        self.check_parallel = self.builder.get_object("check_parallel")
        self.label_parallel = self.builder.get_object("label_parallel")
        self.entry_nProcs = self.builder.get_object("entry_nProcs")

    #
    #  initialize
    #-------------
    def initialize(self):
        """ 初期化"""
        #processor数を取得
        folders = glob.glob(self.caseDir + "/processor*")
        self.nProcs = len(folders)
        #GUIを初期化
        self.check_parallel.set_active(True)
        self.entry_nProcs.set_text(str(self.nProcs))

    #--------- eventの処理 -------------
    def onOk(self, event):
        options = self.getOptions()
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(options, *args) 
            GLib.timeout_add(100, funcName, options, *args)

    def onCancel(self, event):
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[1:]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)


    def onChangeRadioBtn(self, event):
        """ radioButtonを変更した時"""
        if self.radio_all.get_active() == True:
            self.entry_time.set_sensitive(False)
            self.label_parallel.set_sensitive(True)
            self.entry_nProcs.set_sensitive(True)
            self.check_parallel.set_sensitive(True)
        elif self.radio_latestTime.get_active() == True:
            self.entry_time.set_sensitive(False)
            self.label_parallel.set_sensitive(False)
            self.entry_nProcs.set_sensitive(False)
            self.check_parallel.set_sensitive(False)
        elif self.radio_time.get_active() == True:
            #entryをアクティブ
            self.entry_time.set_sensitive(True)
            self.label_parallel.set_sensitive(False)
            self.entry_nProcs.set_sensitive(False)
            self.check_parallel.set_sensitive(False)
        
    def onChangeParallel(self, event):
        """ checkを修正した時"""
        if self.check_parallel.get_active() == True:
            self.label_parallel.set_sensitive(True)
            self.entry_nProcs.set_sensitive(True)
            self.radio_all.set_active(True)
        else:
            self.label_parallel.set_sensitive(False)
            self.entry_nProcs.set_sensitive(False)


    def getOptions(self):
        """ optionを取得する"""
        if self.radio_all.get_active() == True:
            #全てのtimeが対象
            options = ""
        elif self.radio_latestTime.get_active() == True:
            #latestTimeのみ
            options = " -latestTime "
        elif self.radio_time.get_active() == True:
            #timeを指定
            times = self.entry_time.get_text()
            times = times.replace(" ", "")
            if times[0] != "'":
                times = "'" + times
            if times[-1] != "'":
                times = times + "'"
            options = " -time " + times + " "
        else:
            options = ""
        #parallelのチェック
        if options == "":
            if self.check_parallel.get_active() == True:
                n = self.entry_nProcs.get_text()
                options = "parallel_" + n
        return options
