#!/usr/bin/python3
# coding: utf-8
#
#   getOpenRunFileDDialog.py
#
#       file名の取得
#
#   13/02/09    新規作成
#      06/02    Dクリックでfileがopenするを追加
#      07/13    複数fileの選択を追加
#      09/28    getOpenFleDDialogからgetOpenRnDDalogを作成
#               編集ボタンを追加
#      10/15    国際化のため、修正
#   15/07/17    dialogの起動方法修正
#   19/12/12    GTK+3, python3用に大幅修正
#   20/04/21    多言語化対応
#   24/08/02    universalDialogs:全dialogに対しfuncOk、親windowを設定
#      08/08    GtkPartsに置き換え、funcOk,funcCancel, parentを追加。
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import os, sys
import glob

import pyTreeFoam
import GtkParts
import universalDialogs as unvDlg

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

#--------------------
#  getOpenRunFile class
#--------------------
class getOpenRunFile:

    def __init__(self, title, message, currDir, fileFilter, funcOk=[], funcCancel=[], parent=None):
        #Gtk.Dialog.__init__(self, **kwds)
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "getOpenRunFileDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        #親windowを設定
        self.dialog.set_transient_for(parent)
        #modal(freeze)設定
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        #self.dialog.set_transient_for(self)
        #titleの設定
        self.dialog.set_title(title)
        #属性の設定
        self.message = message
        self.currDir = currDir
        self.fileFilter = fileFilter
        self.files = []
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        #self.stat = "CANCEL"
        self.selFileName = ""
        #Gtk.object名の設定
        self.setGtkObject()
        #初期化
        self.initialize()

    def show(self):
        self.dialog.show()
        #self.dialog.run()

    def close(self, *args):
        #self.stat = "CANCEL"
        self.dialog.destroy()

    def setGtkObject(self):
        self.label_message = self.builder.get_object("label_message")
        self.entry_filter = self.builder.get_object("entry_filter")
        tree_listFiles = self.builder.get_object("tree_listFiles")
        self.treeList = GtkParts.treeList(tree_listFiles)

    def initialize(self):
        self.label_message.set_text(self.message)
        self.entry_filter.set_text(self.fileFilter)
        #ファイルを取得
        self.files = self.getFilteredFiles()
        #treeの初期化
        self.iniTreeList()
        #treeにfilesをセット
        self.setTreeListData()

    #表示
    def onShowFileName(self, event):
        self.showFileName()
    #キャンセル
    def onCancel(self, event):
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)
    #編集
    def onEditFileName(self, event):
        self.editFileName()
    #実行
    def onGetFileName(self, event):
        self.getFileNameReturn()
        self.close()
        selFileName = self.selFileName
        if selFileName == "":
            return
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(selFileName, *args)
            GLib.timeout_add(100, funcName, selFileName, *args)


    def getFilteredFiles(self):
        dirs = glob.glob(self.currDir + "/" + self.fileFilter)
        files = list(map(lambda x: os.path.basename(x), dirs))
        return files

    def iniTreeList(self):
        """ treeの初期化"""
        self.treeList.create(multi=False)

    def setTreeListData(self):
        """ treeListにデータをセット"""
        self.treeList.setItems(self.files)

    def getFileNameInTreeList(self):
        """ 選択しているfile名を取得する。
        選択していない場合は、「""」が戻る"""
        selNames = self.treeList.getSelectedItems()
        if len(selNames) == 0:
            fileName = ""
        else:
            fileName = selNames[0]
        return fileName

    #
    #  showFileName
    #  ------------
    def showFileName(self):
        """ filterの内容を表示する"""
        self.fileFilter = self.entry_filter.get_text()
        self.files = self.getFilteredFiles()
        self.setTreeListData()

    #
    #  editFileName
    #  ------------
    def editFileName(self):
        """ fileを編集する"""
        fileName = self.getFileNameInTreeList()
        if fileName == "":
            title = _("エラー")
            mess = _("fileを選択してください")
            self.errDialog()
            return
        else:
            pyTreeFoam.run(self.currDir).editor([fileName])

    #
    #  getFileNameReturn
    #  -------------------
    def getFileNameReturn(self):
        """ fileNameを取得し戻る"""
        fileName = self.getFileNameInTreeList()
        if fileName == "":
            title = _("エラー")
            mess = _("fileを選択してください")
            self.errDialog(title, mess)
            return
        else:
            #self.stat = "RUN"
            self.selFileName = fileName
            #self.dialog.destroy()

    #---- universalDialogs ----------------------------
    def errDialog(self, title, mess, funcOk=[]):
        dialog = unvDlg.errDialog(
            title, mess, funcOk=funcOk, parentWin=self.dialog)
        dialog.show()

if __name__ == "__main__":
    import gettext
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext


