#!/usr/bin/python3
# coding: utf-8
#
#   getOpenFilesDDialog.py
#
#       file名の取得
#
#   13/02/09    新規作成
#      06/02    Dクリックでfileがopenするを追加
#      07/13    複数fileの選択を追加
#      10/15    国際化による修正
#   15/07/17    dialogの起動方法を修正
#   19/10/16    GTK+3, python3用に大幅修正
#   20/04/21    多言語化対応
#   24/08/07    GtkPartを使用、親window,funcOk,funcCancelを追加
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys
import glob
import GtkParts

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

#-------------------
#  getOpenFiles class
#-------------------
class getOpenFiles:

    def __init__(self, title, message, currDir, fileFilter, seledFiles, 
                 funcOk=[], funcCancel=[], parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "getOpenFilesDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        #親を設定
        self.dialog.set_transient_for(parent)
        #modal(freeze)の設定
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.title = title
        self.message = message
        self.currDir = currDir
        self.fileFilter = fileFilter
        self.seledFiles = seledFiles
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        self.selFiles = []
        #初期化
        self.initialize()

    #
    #  show
    #  ----
    def show(self):
        self.dialog.show()
        # self.dialog.run()
        # return self.selFiles

    def close(self, *args):
        """ dialogを直接閉じた時のevent"""
        self.dialog.destroy()

    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        self.label_selCont = self.builder.get_object("label_selCont")
        self.entry_dir = self.builder.get_object("entry_dir")
        self.entry_filter = self.builder.get_object("entry_filter")
        treeView = self.builder.get_object("treeView")
        self.treeList = GtkParts.treeList(treeView)
        self.treeList.create()
        self.button_reference = self.builder.get_object("button_reference")

    def initialize(self):
        """ 初期化"""
        self.dialog.set_title(self.title)
        self.label_selCont.set_label(self.message)
        self.entry_dir.set_text(self.currDir)
        self.entry_filter.set_text(self.fileFilter)
        self.entry_dir.set_sensitive(False)
        self.button_reference.set_sensitive(False)
        #fileListを作成
        self.setFilesInListBox()

    def setFilesInListBox(self):
        """ 該当dir内のfileを表示する"""
        files = glob.glob(self.currDir + os.sep + self.fileFilter)
        fileNames = list(map(lambda x: x.split(os.sep)[-1], files))
        fileNames.sort()
        self.treeList.setItems(fileNames)
        #seledFilesを選択する
        selNames = []
        for name in fileNames:
            if name in self.seledFiles:
                selNames.append(name)
        self.treeList.selectItems(selNames)

    #------- event handler ------------
    def onReference(self, event):
        print("----reference")
    def onShowFiles(self, event):
        self.showFiles()
    def onOk(self, event):
        selFiles = self.getSelection()
        self.close()
        if len(self.funcOk) > 2:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(selFiles, *args)
            GLib.timeout_add(100, funcName, selFiles, *args)
    def onCancel(self, event):
        #self.selFiles = []
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)

    #
    #  showFiles
    #  ---------
    def showFiles(self):
        """ fileFilterで再度filesを取得し、表示する"""
        self.fileFilter = self.entry_filter.get_text()
        files = glob.glob(self.currDir + os.sep + self.fileFilter)
        fileNames = list(map(lambda x: x.split(os.sep)[-1], files))
        fileNames.sort()
        #listDataをセット
        self.treeList.setItems(fileNames)
        selNames = []
        for name in fileNames:
            if name in self.seledFiles:
                selNames.append(name)
        self.treeList.selectItems(selNames)

    #
    #  getSelection
    #  ------------
    def getSelection(self):
        """ 選択しているfileを取得して返す"""
        selFiles = self.treeList.getSelectedItems()
        return selFiles
