#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   getMaxLinesDataQtDDialog.py
#
#       cellの表示行数、nonuniformの読込データ数を設定
#
#   13/09/18    新規作成
#      10/12    多言語化のため、修正
#   15/07/17    dialogの起動方法を修正
#   20/02/10    Qt4, python3用に大幅修正
#      05/02    PyQt4, PyQt5, PySide, PySide2に対応
#      05/24    PyQtの確認方法を修正（一元化）    
#   24/08/23    setCenterParentPosition:新規追加
#               (dialogの表示位置をparentの中心に表示)
#      08/28    Qt4系、Qt6系の両方に対応する様に修正
#

import os

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()


def _fromUtf8(string):
    return string

#------------------
#  Ui_Dialog class
#-------------------
class Ui_Dialog(object):
    """ 最大表示行数、読み込むデータ数を設定する。
    
    Attribute:
        nInternal (int)     :internalFieldの表示行数
        nPatch (int)        :boundaryFieldの表示行数
        nBinToAscii (int)   :nununiformデータの読込データ数"""

    def __init__(self, nInternal, nPatch, nBinToAscii, parent):
        self.nInternal = nInternal
        self.nPatch = nPatch
        self.nBinToAscii = nBinToAscii
        self.parent = parent
        self.result = [nInternal, nPatch, nBinToAscii]

    def Show(self):
        """ dialogを表示する。"""
        self.Dialog = QDialog()
        self.setupUi(self.Dialog)
        self.setEvent()
        self.initialize()
        #dialogをparentの中心に表示させる
        self.setCenterParentPosition()
        self.Dialog.exec()
        return self.result

    def close(self):
        """ dialogを閉じる"""
        self.Dialog.close()

    def setCenterParentPosition(self):
        """ dialogの位置を親の中心に設定する。
        widgetのレイアウト設定後に実行する"""
        if self.parent == None:
            return
        #parentの中心位置
        geo = self.parent.geometry()
        xy = (geo.left() + geo.width()//2, geo.top() + geo.height()//2)
        pos = QPoint(xy[0], xy[1])
        #設定位置を取得
        geo = self.Dialog.geometry()
        geoP = QPoint(geo.width()//2, geo.height()//2)
        newPos = pos - geoP
        self.Dialog.move(newPos)

    def setupUi(self, Dialog):
        """ Qtのversionに応じたGUIを設定"""
        if getPyQtModule.UiCode == "Qt4":
            self.setupUi_Qt4(Dialog)
        elif getPyQtModule.UiCode == "Qt6":
            self.setupUi_Qt6(Dialog)

    def setupUi_Qt6(self, Dialog):
        """ Qt6系のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(457, 396)
        self.verticalLayout_2 = QVBoxLayout(Dialog)
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        ## spacerItem = QSpacerItem(20, 20, QSizePolicy.Minimum, QSizePolicy.Fixed)
        spacerItem = QSpacerItem(20, 20, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Fixed)
        self.verticalLayout_2.addItem(spacerItem)
        self.label = QLabel(Dialog)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label.sizePolicy().hasHeightForWidth())
        self.label.setSizePolicy(sizePolicy)
        ## self.label.setAlignment(Qt.AlignCenter)
        self.label.setAlignment(Qt.AlignmentFlag.AlignCenter)
        self.label.setObjectName(_fromUtf8("label"))
        self.verticalLayout_2.addWidget(self.label)
        ## spacerItem1 = QSpacerItem(20, 20, QSizePolicy.Minimum, QSizePolicy.Fixed)
        spacerItem1 = QSpacerItem(20, 20, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Fixed)
        self.verticalLayout_2.addItem(spacerItem1)
        self.line = QFrame(Dialog)
        ## self.line.setFrameShape(QFrame.HLine)
        self.line.setFrameShape(QFrame.Shape.HLine)
        ## self.line.setFrameShadow(QFrame.Sunken)
        self.line.setFrameShadow(QFrame.Shadow.Sunken)
        self.line.setObjectName(_fromUtf8("line"))
        self.verticalLayout_2.addWidget(self.line)
        self.groupBox = QGroupBox(Dialog)
        self.groupBox.setObjectName(_fromUtf8("groupBox"))
        self.verticalLayout = QVBoxLayout(self.groupBox)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        self.gridLayout = QGridLayout()
        self.gridLayout.setObjectName(_fromUtf8("gridLayout"))
        self.label_3 = QLabel(self.groupBox)
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_3.sizePolicy().hasHeightForWidth())
        self.label_3.setSizePolicy(sizePolicy)
        self.label_3.setObjectName(_fromUtf8("label_3"))
        self.gridLayout.addWidget(self.label_3, 1, 0, 1, 1)
        self.entry_boundary = QLineEdit(self.groupBox)
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.entry_boundary.sizePolicy().hasHeightForWidth())
        self.entry_boundary.setSizePolicy(sizePolicy)
        self.entry_boundary.setObjectName(_fromUtf8("entry_boundary"))
        self.gridLayout.addWidget(self.entry_boundary, 1, 1, 1, 1)
        self.entry_internal = QLineEdit(self.groupBox)
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.entry_internal.sizePolicy().hasHeightForWidth())
        self.entry_internal.setSizePolicy(sizePolicy)
        self.entry_internal.setObjectName(_fromUtf8("entry_internal"))
        self.gridLayout.addWidget(self.entry_internal, 0, 1, 1, 1)
        self.label_2 = QLabel(self.groupBox)
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_2.sizePolicy().hasHeightForWidth())
        self.label_2.setSizePolicy(sizePolicy)
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.gridLayout.addWidget(self.label_2, 0, 0, 1, 1)
        self.label_4 = QLabel(self.groupBox)
        self.label_4.setObjectName(_fromUtf8("label_4"))
        self.gridLayout.addWidget(self.label_4, 0, 2, 1, 1)
        self.label_5 = QLabel(self.groupBox)
        self.label_5.setObjectName(_fromUtf8("label_5"))
        self.gridLayout.addWidget(self.label_5, 1, 2, 1, 1)
        self.verticalLayout.addLayout(self.gridLayout)
        self.label_6 = QLabel(self.groupBox)
        self.label_6.setObjectName(_fromUtf8("label_6"))
        self.verticalLayout.addWidget(self.label_6)
        self.verticalLayout_2.addWidget(self.groupBox)
        self.groupBox_2 = QGroupBox(Dialog)
        self.groupBox_2.setObjectName(_fromUtf8("groupBox_2"))
        self.verticalLayout_3 = QVBoxLayout(self.groupBox_2)
        self.verticalLayout_3.setObjectName(_fromUtf8("verticalLayout_3"))
        self.gridLayout_2 = QGridLayout()
        self.gridLayout_2.setObjectName(_fromUtf8("gridLayout_2"))
        self.label_7 = QLabel(self.groupBox_2)
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_7.sizePolicy().hasHeightForWidth())
        self.label_7.setSizePolicy(sizePolicy)
        self.label_7.setObjectName(_fromUtf8("label_7"))
        self.gridLayout_2.addWidget(self.label_7, 0, 0, 1, 1)
        self.entry_nData = QLineEdit(self.groupBox_2)
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.entry_nData.sizePolicy().hasHeightForWidth())
        self.entry_nData.setSizePolicy(sizePolicy)
        self.entry_nData.setObjectName(_fromUtf8("entry_nData"))
        self.gridLayout_2.addWidget(self.entry_nData, 0, 1, 1, 1)
        self.label_8 = QLabel(self.groupBox_2)
        self.label_8.setObjectName(_fromUtf8("label_8"))
        self.gridLayout_2.addWidget(self.label_8, 0, 2, 1, 1)
        self.verticalLayout_3.addLayout(self.gridLayout_2)
        self.label_nData = QLabel(self.groupBox_2)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_nData.sizePolicy().hasHeightForWidth())
        self.label_nData.setSizePolicy(sizePolicy)
        self.label_nData.setObjectName(_fromUtf8("label_nData"))
        self.verticalLayout_3.addWidget(self.label_nData)
        self.verticalLayout_2.addWidget(self.groupBox_2)
        self.line_2 = QFrame(Dialog)
        ## self.line_2.setFrameShape(QFrame.HLine)
        self.line_2.setFrameShape(QFrame.Shape.HLine)
        ## self.line_2.setFrameShadow(QFrame.Sunken)
        self.line_2.setFrameShadow(QFrame.Shadow.Sunken)
        self.line_2.setObjectName(_fromUtf8("line_2"))
        self.verticalLayout_2.addWidget(self.line_2)
        ## spacerItem2 = QSpacerItem(20, 13, QSizePolicy.Minimum, QSizePolicy.Fixed)
        spacerItem2 = QSpacerItem(20, 13, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Fixed)
        self.verticalLayout_2.addItem(spacerItem2)
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## spacerItem3 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        spacerItem3 = QSpacerItem(40, 20, QSizePolicy.Policy.Expanding, QSizePolicy.Policy.Minimum)
        self.horizontalLayout.addItem(spacerItem3)
        self.btn_cancel = QPushButton(Dialog)
        self.btn_cancel.setObjectName(_fromUtf8("btn_cancel"))
        self.horizontalLayout.addWidget(self.btn_cancel)
        self.btn_ok = QPushButton(Dialog)
        self.btn_ok.setObjectName(_fromUtf8("btn_ok"))
        self.horizontalLayout.addWidget(self.btn_ok)
        self.verticalLayout_2.addLayout(self.horizontalLayout)

        self.retranslateUi(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def setupUi_Qt4(self, Dialog):
        """ Qt4系のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(457, 396)
        ## self.verticalLayout_2 = QtGui.QVBoxLayout(Dialog)
        self.verticalLayout_2 = QVBoxLayout(Dialog)
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        ## spacerItem = QtGui.QSpacerItem(20, 20, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Fixed)
        spacerItem = QSpacerItem(20, 20, QSizePolicy.Minimum, QSizePolicy.Fixed)
        self.verticalLayout_2.addItem(spacerItem)
        ## self.label = QtGui.QLabel(Dialog)
        self.label = QLabel(Dialog)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label.sizePolicy().hasHeightForWidth())
        self.label.setSizePolicy(sizePolicy)
        self.label.setAlignment(Qt.AlignCenter)
        self.label.setObjectName(_fromUtf8("label"))
        self.verticalLayout_2.addWidget(self.label)
        ## spacerItem1 = QtGui.QSpacerItem(20, 20, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Fixed)
        spacerItem1 = QSpacerItem(20, 20, QSizePolicy.Minimum, QSizePolicy.Fixed)
        self.verticalLayout_2.addItem(spacerItem1)
        ## self.line = QtGui.QFrame(Dialog)
        self.line = QFrame(Dialog)
        ## self.line.setFrameShape(QtGui.QFrame.HLine)
        self.line.setFrameShape(QFrame.HLine)
        ## self.line.setFrameShadow(QtGui.QFrame.Sunken)
        self.line.setFrameShadow(QFrame.Sunken)
        self.line.setObjectName(_fromUtf8("line"))
        self.verticalLayout_2.addWidget(self.line)
        ## self.groupBox = QtGui.QGroupBox(Dialog)
        self.groupBox = QGroupBox(Dialog)
        self.groupBox.setObjectName(_fromUtf8("groupBox"))
        ## self.verticalLayout = QtGui.QVBoxLayout(self.groupBox)
        self.verticalLayout = QVBoxLayout(self.groupBox)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        ## self.gridLayout = QtGui.QGridLayout()
        self.gridLayout = QGridLayout()
        self.gridLayout.setObjectName(_fromUtf8("gridLayout"))
        ## self.label_3 = QtGui.QLabel(self.groupBox)
        self.label_3 = QLabel(self.groupBox)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_3.sizePolicy().hasHeightForWidth())
        self.label_3.setSizePolicy(sizePolicy)
        self.label_3.setObjectName(_fromUtf8("label_3"))
        self.gridLayout.addWidget(self.label_3, 1, 0, 1, 1)
        ## self.entry_boundary = QtGui.QLineEdit(self.groupBox)
        self.entry_boundary = QLineEdit(self.groupBox)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.entry_boundary.sizePolicy().hasHeightForWidth())
        self.entry_boundary.setSizePolicy(sizePolicy)
        self.entry_boundary.setObjectName(_fromUtf8("entry_boundary"))
        self.gridLayout.addWidget(self.entry_boundary, 1, 1, 1, 1)
        ## self.entry_internal = QtGui.QLineEdit(self.groupBox)
        self.entry_internal = QLineEdit(self.groupBox)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.entry_internal.sizePolicy().hasHeightForWidth())
        self.entry_internal.setSizePolicy(sizePolicy)
        self.entry_internal.setObjectName(_fromUtf8("entry_internal"))
        self.gridLayout.addWidget(self.entry_internal, 0, 1, 1, 1)
        ## self.label_2 = QtGui.QLabel(self.groupBox)
        self.label_2 = QLabel(self.groupBox)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_2.sizePolicy().hasHeightForWidth())
        self.label_2.setSizePolicy(sizePolicy)
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.gridLayout.addWidget(self.label_2, 0, 0, 1, 1)
        ## self.label_4 = QtGui.QLabel(self.groupBox)
        self.label_4 = QLabel(self.groupBox)
        self.label_4.setObjectName(_fromUtf8("label_4"))
        self.gridLayout.addWidget(self.label_4, 0, 2, 1, 1)
        ## self.label_5 = QtGui.QLabel(self.groupBox)
        self.label_5 = QLabel(self.groupBox)
        self.label_5.setObjectName(_fromUtf8("label_5"))
        self.gridLayout.addWidget(self.label_5, 1, 2, 1, 1)
        self.verticalLayout.addLayout(self.gridLayout)
        ## self.label_6 = QtGui.QLabel(self.groupBox)
        self.label_6 = QLabel(self.groupBox)
        self.label_6.setObjectName(_fromUtf8("label_6"))
        self.verticalLayout.addWidget(self.label_6)
        self.verticalLayout_2.addWidget(self.groupBox)
        ## self.groupBox_2 = QtGui.QGroupBox(Dialog)
        self.groupBox_2 = QGroupBox(Dialog)
        self.groupBox_2.setObjectName(_fromUtf8("groupBox_2"))
        ## self.verticalLayout_3 = QtGui.QVBoxLayout(self.groupBox_2)
        self.verticalLayout_3 = QVBoxLayout(self.groupBox_2)
        self.verticalLayout_3.setObjectName(_fromUtf8("verticalLayout_3"))
        ## self.gridLayout_2 = QtGui.QGridLayout()
        self.gridLayout_2 = QGridLayout()
        self.gridLayout_2.setObjectName(_fromUtf8("gridLayout_2"))
        ## self.label_7 = QtGui.QLabel(self.groupBox_2)
        self.label_7 = QLabel(self.groupBox_2)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_7.sizePolicy().hasHeightForWidth())
        self.label_7.setSizePolicy(sizePolicy)
        self.label_7.setObjectName(_fromUtf8("label_7"))
        self.gridLayout_2.addWidget(self.label_7, 0, 0, 1, 1)
        ## self.entry_nData = QtGui.QLineEdit(self.groupBox_2)
        self.entry_nData = QLineEdit(self.groupBox_2)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.entry_nData.sizePolicy().hasHeightForWidth())
        self.entry_nData.setSizePolicy(sizePolicy)
        self.entry_nData.setObjectName(_fromUtf8("entry_nData"))
        self.gridLayout_2.addWidget(self.entry_nData, 0, 1, 1, 1)
        ## self.label_8 = QtGui.QLabel(self.groupBox_2)
        self.label_8 = QLabel(self.groupBox_2)
        self.label_8.setObjectName(_fromUtf8("label_8"))
        self.gridLayout_2.addWidget(self.label_8, 0, 2, 1, 1)
        self.verticalLayout_3.addLayout(self.gridLayout_2)
        ## self.label_nData = QtGui.QLabel(self.groupBox_2)
        self.label_nData = QLabel(self.groupBox_2)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_nData.sizePolicy().hasHeightForWidth())
        self.label_nData.setSizePolicy(sizePolicy)
        self.label_nData.setObjectName(_fromUtf8("label_nData"))
        self.verticalLayout_3.addWidget(self.label_nData)
        self.verticalLayout_2.addWidget(self.groupBox_2)
        ## self.line_2 = QtGui.QFrame(Dialog)
        self.line_2 = QFrame(Dialog)
        ## self.line_2.setFrameShape(QtGui.QFrame.HLine)
        self.line_2.setFrameShape(QFrame.HLine)
        ## self.line_2.setFrameShadow(QtGui.QFrame.Sunken)
        self.line_2.setFrameShadow(QFrame.Sunken)
        self.line_2.setObjectName(_fromUtf8("line_2"))
        self.verticalLayout_2.addWidget(self.line_2)
        ## spacerItem2 = QtGui.QSpacerItem(20, 13, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Fixed)
        spacerItem2 = QSpacerItem(20, 13, QSizePolicy.Minimum, QSizePolicy.Fixed)
        self.verticalLayout_2.addItem(spacerItem2)
        ## self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## spacerItem3 = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem3 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout.addItem(spacerItem3)
        ## self.btn_cancel = QtGui.QPushButton(Dialog)
        self.btn_cancel = QPushButton(Dialog)
        self.btn_cancel.setObjectName(_fromUtf8("btn_cancel"))
        self.horizontalLayout.addWidget(self.btn_cancel)
        ## self.btn_ok = QtGui.QPushButton(Dialog)
        self.btn_ok = QPushButton(Dialog)
        self.btn_ok.setObjectName(_fromUtf8("btn_ok"))
        self.horizontalLayout.addWidget(self.btn_ok)
        self.verticalLayout_2.addLayout(self.horizontalLayout)

        self.retranslateUi(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def retranslateUi(self, Dialog):
        self.label.setText(_("gridEditorで表示させる行数・読み込みデータ数を設定する。"))
        self.groupBox.setTitle(_("cell内の表示行数"))
        self.label_3.setText(_("boundaryField"))
        self.label_2.setText(_("internalField"))
        self.label_4.setText(_("行"))
        self.label_5.setText(_("行"))
        self.label_6.setText(_("cellの最大表示行数を設定する。設定数以上は、表示しない。"))
        self.groupBox_2.setTitle(_("nonuniform Listの読み込みデータ数"))
        self.label_7.setText(_("データ数"))
        self.label_8.setText(_("個"))
        self.label_nData.setText(_("「nonuniform List」を含む行の最大読み込みデータ数を設定。"))
        self.btn_cancel.setText(_("キャンセル"))
        self.btn_ok.setText(_("OK"))


    def setEvent(self):
        """ eventを作成"""
        self.btn_cancel.clicked.connect(self.onCancel)
        self.btn_ok.clicked.connect(self.onOk)

    def onOk(self):
        """ OKボタンクリック時。nInternal, nPatchの最大値を確認する"""
        nInternal = int(self.entry_internal.text())
        if nInternal > 30:
            nInternal = 30
        nPatch = int(self.entry_boundary.text())
        if nPatch > 30:
            nPatch = 30
        self.nInternal = nInternal
        self.nPatch = nPatch
        self.nBinToAscii = int(self.entry_nData.text())
        self.result = [self.nInternal, self.nPatch, self.nBinToAscii]
        self.close()

    def onCancel(self):
        """ キャンセルボタンクリック時。戻り値を[]に設定する。"""
        self.result = []
        self.close()

    def initialize(self):
        """ 初期化。QLineEditにデータをセットする。
        titleとlabelをセットする。"""
        self.Dialog.setWindowTitle("表示行数・読取データ数の設定")
        mess = _("「nonuniform List」を含む行の最大読込データ数を設定。") + "\n"
        mess += _("全データを読み込む場合は「-1」を設定する。") + "\n"
        mess += _("formatがbinaryの場合は、この設定値がascii変換するデータ数になる。")
        self.label_nData.setText(mess)
        mess = _("cellの最大表示行数を設定する。設定数以上は、表示しない。") + "\n"
        mess += _("最大値は「30」であり、この値以上は、設定できない。")
        self.label_6.setText(mess)
        self.entry_internal.setText(str(self.nInternal))
        self.entry_boundary.setText(str(self.nPatch))
        self.entry_nData.setText(str(self.nBinToAscii))


if __name__ == "__main__":
    import gettext
    treeFoamPath = os.environ["TreeFoamPath"]
    gettext.install("treefoam", treeFoamPath + "/data/locale")
    #_ = gettext.gettext

    # import sys
    # app = QtGui.QApplication(sys.argv)
    # Dialog = QtGui.QDialog()
    # ui = Ui_Dialog()
    # ui.setupUi(Dialog)
    # Dialog.show()
    # sys.exit(app.exec_())

