#!/usr/bin/python3
#  coding:  utf-8
#
#   getHddValsResultFolders.py
#
#       HDD容量、結果folderの内容を確認する。
#
#   21/05/11    新規作成
#      06/01    標準エラー出力を標準出力に設定
#               エラーが発生した場合、そのエラーを検出するため。
#

import sys

#標準エラー出力を標準出力に設定
sys.stderr = sys.stdout

import pyTreeFoam

#
#  getHddValsResultFolders
#--------------------------
def getHddValsResultFolders(folderDir):
    """ HDDの空き容量と結果folderの内容を取得する。"""
    #結果folderを取得
    folType = pyTreeFoam.getFolderType(folderDir)
    nR, st, ed = "", "", ""
    if folType == "case" or folType == "caseLink":
        case = pyTreeFoam.case(folderDir)
        (nR, st, ed, nProc) = case.getNumberResult()
    resVals = [nR, st, ed]
    #HDD容量を取得
    total, free = pyTreeFoam.getHddVals(folderDir)
    #出力を作成
    ans = resVals + [str(total), str(free)]
    ans = ",".join(ans)
    print(ans)


if __name__ == "__main__":
    folderDir = sys.argv[1]
    getHddValsResultFolders(folderDir)
