#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   createSetFieldsDictQt4.py
#
#       createSetFieldsDictQtDialog.pyのGUI作成用
#
#   20/05/24    新規作成
#   24/08/27    Qt4軽専用としてfile名変更
#   25/07/14    retranslateUi:OF-13用を追加（label名変更）
#      07/20    setupUi,retranslateUi:geomFileButtonを追加。
#


import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()

import pyTreeFoam
configDict = pyTreeFoam.readConfigTreeFoam()


def _fromUtf8(s):
    return s

try:
    ## _encoding = QtGui.QApplication.UnicodeUTF8
    _encoding = QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        ## return QtGui.QApplication.translate(context, text, disambig, _encoding)
        return QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        ## return QtGui.QApplication.translate(context, text, disambig)
        return QApplication.translate(context, text, disambig)

class Ui_MainWindow(object):
    def setupUi(self, MainWindow, Table):       #tableWidgetを追加
        MainWindow.setObjectName(_fromUtf8("MainWindow"))
        MainWindow.resize(634, 541)
        ## self.centralwidget = QtGui.QWidget(MainWindow)
        self.centralwidget = QWidget(MainWindow)
        self.centralwidget.setObjectName(_fromUtf8("centralwidget"))
        ## self.verticalLayout = QtGui.QVBoxLayout(self.centralwidget)
        self.verticalLayout = QVBoxLayout(self.centralwidget)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        ## self.label = QtGui.QLabel(self.centralwidget)
        self.label = QLabel(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label.sizePolicy().hasHeightForWidth())
        self.label.setSizePolicy(sizePolicy)
        ## self.label.setFrameShadow(QtGui.QFrame.Plain)
        self.label.setFrameShadow(QFrame.Plain)
        self.label.setAlignment(Qt.AlignCenter)
        self.label.setObjectName(_fromUtf8("label"))
        self.verticalLayout.addWidget(self.label)
        ## self.line = QtGui.QFrame(self.centralwidget)
        self.line = QFrame(self.centralwidget)
        #sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.line.sizePolicy().hasHeightForWidth())
        self.line.setSizePolicy(sizePolicy)
        ## self.line.setFrameShape(QtGui.QFrame.HLine)
        self.line.setFrameShape(QFrame.HLine)
        ## self.line.setFrameShadow(QtGui.QFrame.Sunken)
        self.line.setFrameShadow(QFrame.Sunken)
        self.line.setObjectName(_fromUtf8("line"))
        self.verticalLayout.addWidget(self.line)
        ## self.gridLayout = QtGui.QGridLayout()
        self.gridLayout = QGridLayout()
        ## self.gridLayout.setSizeConstraint(QtGui.QLayout.SetFixedSize)
        self.gridLayout.setSizeConstraint(QLayout.SetFixedSize)
        self.gridLayout.setObjectName(_fromUtf8("gridLayout"))
        ## self.horizontalLayout_2 = QtGui.QHBoxLayout()
        self.horizontalLayout_2 = QHBoxLayout()
        self.horizontalLayout_2.setObjectName(_fromUtf8("horizontalLayout_2"))
        ## self.btn_addCellSet = QtGui.QPushButton(self.centralwidget)
        self.btn_addCellSet = QPushButton(self.centralwidget)
        self.btn_addCellSet.setObjectName(_fromUtf8("btn_addCellSet"))
        self.horizontalLayout_2.addWidget(self.btn_addCellSet)
        ## self.btn_addField = QtGui.QPushButton(self.centralwidget)
        self.btn_addField = QPushButton(self.centralwidget)
        self.btn_addField.setObjectName(_fromUtf8("btn_addField"))
        self.horizontalLayout_2.addWidget(self.btn_addField)
        ## self.btn_runTopoSet = QtGui.QPushButton(self.centralwidget)
        self.btn_runTopoSet = QPushButton(self.centralwidget)
        self.btn_runTopoSet.setObjectName(_fromUtf8("btn_runTopoSet"))
        self.horizontalLayout_2.addWidget(self.btn_runTopoSet)
        ## self.btn_runGridEditor = QtGui.QPushButton(self.centralwidget)
        self.btn_runGridEditor = QPushButton(self.centralwidget)
        self.btn_runGridEditor.setObjectName(_fromUtf8("btn_runGridEditor"))
        self.horizontalLayout_2.addWidget(self.btn_runGridEditor)
        ## spacerItem = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout_2.addItem(spacerItem)
        self.gridLayout.addLayout(self.horizontalLayout_2, 1, 1, 1, 1)
        ## self.label_3 = QtGui.QLabel(self.centralwidget)
        self.label_3 = QLabel(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Ignored, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Ignored, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_3.sizePolicy().hasHeightForWidth())
        self.label_3.setSizePolicy(sizePolicy)
        self.label_3.setAlignment(Qt.AlignRight|Qt.AlignTrailing|Qt.AlignVCenter)
        self.label_3.setObjectName(_fromUtf8("label_3"))
        self.gridLayout.addWidget(self.label_3, 1, 0, 1, 1)
        ## self.label_5 = QtGui.QLabel(self.centralwidget)
        self.label_5 = QLabel(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Ignored, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Ignored, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_5.sizePolicy().hasHeightForWidth())
        self.label_5.setSizePolicy(sizePolicy)
        self.label_5.setAlignment(Qt.AlignRight|Qt.AlignTrailing|Qt.AlignVCenter)
        self.label_5.setObjectName(_fromUtf8("label_5"))
        self.gridLayout.addWidget(self.label_5, 3, 0, 1, 1)
        ## self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## self.btn_loadDict = QtGui.QPushButton(self.centralwidget)
        self.btn_loadDict = QPushButton(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_loadDict.sizePolicy().hasHeightForWidth())
        self.btn_loadDict.setSizePolicy(sizePolicy)
        self.btn_loadDict.setObjectName(_fromUtf8("btn_loadDict"))
        self.horizontalLayout.addWidget(self.btn_loadDict)
        ## self.btn_saveDict = QtGui.QPushButton(self.centralwidget)
        self.btn_saveDict = QPushButton(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_saveDict.sizePolicy().hasHeightForWidth())
        self.btn_saveDict.setSizePolicy(sizePolicy)
        self.btn_saveDict.setObjectName(_fromUtf8("btn_saveDict"))
        self.horizontalLayout.addWidget(self.btn_saveDict)
        ## self.btn_saveRun = QtGui.QPushButton(self.centralwidget)
        self.btn_saveRun = QPushButton(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_saveRun.sizePolicy().hasHeightForWidth())
        self.btn_saveRun.setSizePolicy(sizePolicy)
        self.btn_saveRun.setObjectName(_fromUtf8("btn_saveRun"))
        self.horizontalLayout.addWidget(self.btn_saveRun)
        ## self.btn_loadCsv = QtGui.QPushButton(self.centralwidget)
        self.btn_loadCsv = QPushButton(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_loadCsv.sizePolicy().hasHeightForWidth())
        self.btn_loadCsv.setSizePolicy(sizePolicy)
        self.btn_loadCsv.setObjectName(_fromUtf8("btn_loadCsv"))
        self.horizontalLayout.addWidget(self.btn_loadCsv)
        ## self.btn_saveCsv = QtGui.QPushButton(self.centralwidget)
        self.btn_saveCsv = QPushButton(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_saveCsv.sizePolicy().hasHeightForWidth())
        self.btn_saveCsv.setSizePolicy(sizePolicy)
        self.btn_saveCsv.setObjectName(_fromUtf8("btn_saveCsv"))
        self.horizontalLayout.addWidget(self.btn_saveCsv)
        ## spacerItem1 = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem1 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout.addItem(spacerItem1)
        self.gridLayout.addLayout(self.horizontalLayout, 0, 1, 1, 1)
        ## self.label_6 = QtGui.QLabel(self.centralwidget)
        self.label_6 = QLabel(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Ignored, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Ignored, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_6.sizePolicy().hasHeightForWidth())
        self.label_6.setSizePolicy(sizePolicy)
        self.label_6.setAlignment(Qt.AlignRight|Qt.AlignTrailing|Qt.AlignVCenter)
        self.label_6.setObjectName(_fromUtf8("label_6"))
        self.gridLayout.addWidget(self.label_6, 4, 0, 1, 1)
        ## self.horizontalLayout_3 = QtGui.QHBoxLayout()
        self.horizontalLayout_3 = QHBoxLayout()
        self.horizontalLayout_3.setObjectName(_fromUtf8("horizontalLayout_3"))
        ## self.btn_addBox = QtGui.QPushButton(self.centralwidget)
        self.btn_addBox = QPushButton(self.centralwidget)
        self.btn_addBox.setObjectName(_fromUtf8("btn_addBox"))
        self.horizontalLayout_3.addWidget(self.btn_addBox)
        ## self.btn_addCylinder = QtGui.QPushButton(self.centralwidget)
        self.btn_addCylinder = QPushButton(self.centralwidget)
        self.btn_addCylinder.setObjectName(_fromUtf8("btn_addCylinder"))
        self.horizontalLayout_3.addWidget(self.btn_addCylinder)
        ## self.btn_addSphere = QtGui.QPushButton(self.centralwidget)
        self.btn_addSphere = QPushButton(self.centralwidget)
        self.btn_addSphere.setObjectName(_fromUtf8("btn_addSphere"))
        self.horizontalLayout_3.addWidget(self.btn_addSphere)
        #------ button 追加 ----
        self.btn_addGeomFile = QPushButton(self.centralwidget)
        self.btn_addGeomFile.setObjectName(_fromUtf8("btn_addGeomFile"))
        self.horizontalLayout_3.addWidget(self.btn_addGeomFile)
        #-----------------------
        ## spacerItem2 = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem2 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout_3.addItem(spacerItem2)
        self.gridLayout.addLayout(self.horizontalLayout_3, 2, 1, 1, 1)
        ## self.label_2 = QtGui.QLabel(self.centralwidget)
        self.label_2 = QLabel(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_2.sizePolicy().hasHeightForWidth())
        self.label_2.setSizePolicy(sizePolicy)
        self.label_2.setAlignment(Qt.AlignRight|Qt.AlignTrailing|Qt.AlignVCenter)
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.gridLayout.addWidget(self.label_2, 0, 0, 1, 1)
        ## self.label_4 = QtGui.QLabel(self.centralwidget)
        self.label_4 = QLabel(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_4.sizePolicy().hasHeightForWidth())
        self.label_4.setSizePolicy(sizePolicy)
        self.label_4.setAlignment(Qt.AlignRight|Qt.AlignTrailing|Qt.AlignVCenter)
        self.label_4.setObjectName(_fromUtf8("label_4"))
        self.gridLayout.addWidget(self.label_4, 2, 0, 1, 1)
        ## self.horizontalLayout_5 = QtGui.QHBoxLayout()
        self.horizontalLayout_5 = QHBoxLayout()
        self.horizontalLayout_5.setObjectName(_fromUtf8("horizontalLayout_5"))
        ## self.btn_copy = QtGui.QPushButton(self.centralwidget)
        self.btn_copy = QPushButton(self.centralwidget)
        self.btn_copy.setObjectName(_fromUtf8("btn_copy"))
        self.horizontalLayout_5.addWidget(self.btn_copy)
        ## self.btn_paste = QtGui.QPushButton(self.centralwidget)
        self.btn_paste = QPushButton(self.centralwidget)
        self.btn_paste.setObjectName(_fromUtf8("btn_paste"))
        self.horizontalLayout_5.addWidget(self.btn_paste)
        ## spacerItem3 = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem3 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout_5.addItem(spacerItem3)
        self.gridLayout.addLayout(self.horizontalLayout_5, 4, 1, 1, 1)
        ## self.horizontalLayout_4 = QtGui.QHBoxLayout()
        self.horizontalLayout_4 = QHBoxLayout()
        self.horizontalLayout_4.setObjectName(_fromUtf8("horizontalLayout_4"))
        ## self.btn_deleteCellSet = QtGui.QPushButton(self.centralwidget)
        self.btn_deleteCellSet = QPushButton(self.centralwidget)
        self.btn_deleteCellSet.setObjectName(_fromUtf8("btn_deleteCellSet"))
        self.horizontalLayout_4.addWidget(self.btn_deleteCellSet)
        ## self.btn_deleteField = QtGui.QPushButton(self.centralwidget)
        self.btn_deleteField = QPushButton(self.centralwidget)
        self.btn_deleteField.setObjectName(_fromUtf8("btn_deleteField"))
        self.horizontalLayout_4.addWidget(self.btn_deleteField)
        ## self.btn_clearCell = QtGui.QPushButton(self.centralwidget)
        self.btn_clearCell = QPushButton(self.centralwidget)
        self.btn_clearCell.setObjectName(_fromUtf8("btn_clearCell"))
        self.horizontalLayout_4.addWidget(self.btn_clearCell)
        
        ## spacerItem4 = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem4 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout_4.addItem(spacerItem4)
        
        self.gridLayout.addLayout(self.horizontalLayout_4, 3, 1, 1, 1)
        self.verticalLayout.addLayout(self.gridLayout)
        
        ## self.tableWidget = QtGui.QTableWidget(self.centralwidget)
        self.tableWidget = Table
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.tableWidget.sizePolicy().hasHeightForWidth())
        self.tableWidget.setSizePolicy(sizePolicy)
        
        font = QFont()
        font.setFamily(_fromUtf8("Monospace"))
        font.setPointSize(11)
        self.tableWidget.setFont(font)
        self.tableWidget.setAutoFillBackground(False)
        self.tableWidget.setRowCount(3)
        self.tableWidget.setColumnCount(3)
        self.tableWidget.setObjectName(_fromUtf8("tableWidget"))
        self.tableWidget.horizontalHeader().setCascadingSectionResizes(False)
        self.tableWidget.horizontalHeader().setStretchLastSection(False)
        self.verticalLayout.addWidget(self.tableWidget)
        ## self.line_2 = QtGui.QFrame(self.centralwidget)
        self.line_2 = QFrame(self.centralwidget)
        ## self.line_2.setFrameShape(QtGui.QFrame.HLine)
        self.line_2.setFrameShape(QFrame.HLine)
        ## self.line_2.setFrameShadow(QtGui.QFrame.Sunken)
        self.line_2.setFrameShadow(QFrame.Sunken)
        self.line_2.setObjectName(_fromUtf8("line_2"))
        self.verticalLayout.addWidget(self.line_2)
        ## self.horizontalLayout_6 = QtGui.QHBoxLayout()
        self.horizontalLayout_6 = QHBoxLayout()
        self.horizontalLayout_6.setSpacing(6)
        self.horizontalLayout_6.setObjectName(_fromUtf8("horizontalLayout_6"))
        ## spacerItem5 = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem5 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout_6.addItem(spacerItem5)
        ## self.btn_close = QtGui.QPushButton(self.centralwidget)
        self.btn_close = QPushButton(self.centralwidget)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.btn_close.sizePolicy().hasHeightForWidth())
        self.btn_close.setSizePolicy(sizePolicy)
        self.btn_close.setObjectName(_fromUtf8("btn_close"))
        self.horizontalLayout_6.addWidget(self.btn_close)
        self.verticalLayout.addLayout(self.horizontalLayout_6)
        MainWindow.setCentralWidget(self.centralwidget)
        ## self.menubar = QtGui.QMenuBar(MainWindow)
        self.menubar = QMenuBar(MainWindow)
        self.menubar.setGeometry(QRect(0, 0, 634, 37))
        self.menubar.setObjectName(_fromUtf8("menubar"))
        MainWindow.setMenuBar(self.menubar)
        ## self.statusbar = QtGui.QStatusBar(MainWindow)
        self.statusbar = QStatusBar(MainWindow)
        self.statusbar.setObjectName(_fromUtf8("statusbar"))
        MainWindow.setStatusBar(self.statusbar)

        self.retranslateUi(MainWindow)
        QMetaObject.connectSlotsByName(MainWindow)

    def retranslateUi(self, MainWindow):
        OFversion = configDict["OFversion"]
        numVer = pyTreeFoam.getNumVersion(OFversion)
        if numVer >= 13.0:
            addCell = _("cellZone追加...")
            delCell = _("行(cellZone)削除")
        else:
            addCell = _("cellSet追加...")            
            delCell = _("行(cellSet)削除")
        MainWindow.setWindowTitle(_translate("MainWindow", "MainWindow", None))
        self.label.setText(_translate("MainWindow", _("各Fileldへのデータセット"), None))
        #self.btn_addCellSet.setText(_translate("MainWindow", _("cellSet追加..."), None))
        self.btn_addCellSet.setText(_translate("MainWindow", addCell, None))
        self.btn_addField.setText(_translate("MainWindow", _("field追加..."), None))
        self.btn_runTopoSet.setText(_translate("MainWindow", _("topoSetEditor起動"), None))
        self.btn_runGridEditor.setText(_translate("MainWindow", _("gridEditor起動"), None))
        self.label_3.setText(_translate("MainWindow", _("追加:"), None))
        self.label_5.setText(_translate("MainWindow", _("削除:"), None))
        self.btn_loadDict.setText(_translate("MainWindow", _("Dict読込"), None))
        self.btn_saveDict.setText(_translate("MainWindow", _("Dict保存"), None))
        self.btn_saveRun.setText(_translate("MainWindow", _("Dict保存・実行"), None))
        self.btn_loadCsv.setText(_translate("MainWindow", _("csv読込..."), None))
        self.btn_saveCsv.setText(_translate("MainWindow", _("csv保存..."), None))
        self.label_6.setText(_translate("MainWindow", _("コピー:"), None))
        self.btn_addBox.setText(_translate("MainWindow", _("box追加"), None))
        self.btn_addCylinder.setText(_translate("MainWindow", _("cylinder追加"), None))
        self.btn_addSphere.setText(_translate("MainWindow", _("sphere追加"), None))
        self.btn_addGeomFile.setText(_translate("MainWindow", _("geomFile追加"), None))   #追加
        self.label_2.setText(_translate("MainWindow", _("ファイル:"), None))
        self.label_4.setText(_translate("MainWindow", _("geometry:"), None))
        self.btn_copy.setText(_translate("MainWindow", _("コピー"), None))
        self.btn_paste.setText(_translate("MainWindow", _("貼り付け"), None))
        #self.btn_deleteCellSet.setText(_translate("MainWindow", _("行(cellSet)削除"), None))
        self.btn_deleteCellSet.setText(_translate("MainWindow", delCell, None))
        self.btn_deleteField.setText(_translate("MainWindow", _("列(field)削除"), None))
        self.btn_clearCell.setText(_translate("MainWindow", _("cellのクリア"), None))
        self.tableWidget.setSortingEnabled(False)
        self.btn_close.setText(_translate("MainWindow", _("閉じる"), None))


if __name__ == "__main__":
    import sys
    app = QApplication(sys.argv)
    MainWindow = QMainWindow()
    #ui = Ui_MainWindow()
    #ui.setupUi(MainWindow)
    MainWindow.show()
    sys.exit(app.exec_())

