#!/usr/bin/python3
# coding: utf-8
#
#   checkVtkModule.py
#
#       vtkのimportチェック
#
#   22/01/07    新規作成
#   24/08/01    universalDialogs:全dialogに対しfuncOk、親windowを設定
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import os, sys

import gettext
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
gettext.install("treefoam", localeDir)

def isVtk(pgmName):
    isModule = False
    if "vtk" in sys.modules.keys():
        isModule = True
    else:
        try:
            import vtk
            isModule = True
        except:
            isModule = False
            import universalDialogs as unvDlg
            title = _("エラー")
            mess  = _("vtkがimportできない為、") + pgmName + _("が起動できません。\n")
            mess += _("  vtkをインストールしてください。")
            print(mess)
            okArgs = [closeDialog]
            dialog = unvDlg.errDialog(title, mess, funcOk=okArgs)
            dialog.show()
            Gtk.main()
    return isModule

def closeDialog():
    Gtk.main_quit()
