#!/usr/bin/python3
# coding: utf-8
#
#       changeConfigTreeFoamDDialog.py
#
#       configTreeFoamの修正用dialog
#
#   12/05.20    新規作成
#   12/09/12    OpenFOAMのバージョンセットを追加
#   13/04/30    バグ修正（helyxOSの変更ができていなかった。）
#      10/09    言語の設定を追加
#      12/21    logFile項目追加
#               stdout、stderrの設定（import logFileCreater）を追加
#      12/22    バグ修正（未設定項目が書き込めない）
#   14/07/12    dialogをframeに変更（TreeFoamが「segmentation fault」発生する為）
#   15/07/17    dialog起動方法を修正
#      07/23    dialogを作り直し
#               　fileの編集とappフォルダ内容をcomboBoxの候補に設定
#      07/25    setSelectDataToComboBoxes:バグ修正
#      07/26    ボタンを追加（setDefaultContents）
#   16/06/02    onSet:OFversionの書き込み追加。
#   17/09/10    setOFversion:bashrcの設定をbashFileを作成して取得する様に修正
#   19/09/09    python3, GTK+3用に書き換え
#   24/08/05    GtkParts,universalDialogsのモジュール使用に変更
#      08/06    changeConfigTreeFoam:新たにclassを追加。
#      08/10    モジュール名を「changeConfigTreeFoamDDialog.py」に変更
#      12/13    dialogApp:親のfreezeを削除
#   25/02/18    設定項目に「plotWatcher」を追加。
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os
import sys
import glob
import shutil
import GtkParts
import universalDialogs as unvDlg

try:
    import pyTreeFoam
except:
    import python.pyTreeFoam as pyTreeFoam


#--------------------
#  dialogApp class
#--------------------
class dialogApp:
    """ configTreeFoamの設定変更の為のdialog"""

    def __init__(self, configDict, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "changeConfigTreeFoamDialog.glade")
        self.dialogApp = self.builder.get_object("dialog1")
        #親を設定
        self.dialogApp.set_transient_for(parent)
        #modal（freeze）設定
        #self.dialogApp.set_modal(True)
        self.dialogApp.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.configDict = configDict 
        self.setGtkObject()
        self.initialize()

    #
    #  show
    #--------
    def show(self):
        """ dialogを表示、閉じた後はnewConfigDictを返す"""
        self.dialogApp.show()
        # self.dialogApp.run()
        # return self.newConfigDict

    def close(self, *args):
        """ windowを閉じた時"""
        #self.newConfigDict = {}
        self.dialogApp.destroy()

    def setGtkObject(self):
        """ GUIのidを取得"""
        cmbLang = self.builder.get_object("cmbLanguage")
        cmbLog = self.builder.get_object("cmbLogFile")
        cmbBashrc = self.builder.get_object("cmbBashrcFOAM")
        cmbParaFoam = self.builder.get_object("cmbRunParaFoam")
        cmbPlotWatcher = self.builder.get_object("cmbRunPlotWatcher")
        cmbSalome = self.builder.get_object("cmbRunSalomeMeca")
        cmbCad = self.builder.get_object("cmbRunCad")
        cmbEditor = self.builder.get_object("cmbRunEditor")
        self.cmbLang = GtkParts.comboBoxText(cmbLang)
        self.cmbLog = GtkParts.comboBoxText(cmbLog)
        self.cmbBashrc = GtkParts.comboBoxText(cmbBashrc)
        self.cmbParaFoam = GtkParts.comboBoxText(cmbParaFoam)
        self.cmbPlotWatcher = GtkParts.comboBoxText(cmbPlotWatcher)
        self.cmbSalome = GtkParts.comboBoxText(cmbSalome)
        self.cmbCad = GtkParts.comboBoxText(cmbCad)
        self.cmbEditor = GtkParts.comboBoxText(cmbEditor)
        self.button_bashrcFoam = self.builder.get_object("button_bashrcFoam")
        self.button_runParaFoam = self.builder.get_object("button_runParaFoam")
        self.button_runPlotWatcher = self.builder.get_object("button_runPlotWatcher")
        self.button_runSalome = self.builder.get_object("button_runSalome")
        self.button_runCad = self.builder.get_object("button_runCad")
        self.button_runEditor = self.builder.get_object("button_runEditor")
        self.button_configTreeFoam = self.builder.get_object("button_configTreeFoam")
        self.button_openAppFolder = self.builder.get_object("button_openAppFolder")
        self.button_reloadFolder = self.builder.get_object("button_reloadFolder")
        self.button_setDefault = self.builder.get_object("button_setDefault")
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_apply = self.builder.get_object("button_apply")

    def onApply(self, event):
        """ 設定ボタンのクリック時"""
        self.newConfigDict = self.getAllItems()
        pyTreeFoam.writeConfigTreeFoam(self.newConfigDict)
        #OpenFOAMのversionを記録
        bashrc = self.newConfigDict["bashrcFOAM"]
        cont = "#!/bin/bash\n"
        cont += ". " + bashrc + "\n"
        cont += os.getenv("TreeFoamPath") + os.sep + "bin" + os.sep + "getOFversionWriteConfig.py\n"
        fileName = os.getenv("TreeFoamUserPath") + "/temp/runBash"
        f = open(fileName, "w"); f.write(cont); f.close()
        pyTreeFoam.run().command("chmod a+x " + fileName)
        pyTreeFoam.run().commandWithLog(fileName)
        if self.newConfigDict["language"] != self.configDict["language"]:
            title = _("警告")
            mess  = _("使用言語が変更されました。") + "\n"
            mess += _("変更内容は、次回TreeFoam起動時に適用されます。")
        else:
            title = _("configTreeFoamの設定")
            mess = _("設定内容を設定しました")
        okArgs = [self.close]
        self.okDialog(title, mess, funcOk=okArgs)
        #self.close()

    def onCancel(self, event):
        """ キャンセルボタンのクリック時"""
        #self.newConfigDict = {}
        self.dialogApp.destroy()

    def initialize(self):
        """ 初期化"""
        self.appDir = os.getenv("TreeFoamUserPath") + os.sep + "app"
        self.loadAppDirSetComboBox()
        self.dialogApp.set_title(_("TreeFoamの設定変更"))

    def loadAppDirSetComboBox(self):
        """ configTreefoamの内容をcomboBoxに設定する"""
        #global configDict
        configDict = self.configDict
        files = glob.glob(self.appDir+os.sep+"*")
        #itemsを設定
        langs = ["English", "Japanese"]
        logs = ["yes", "no"]
        bashrcFiles = []
        runParaFoamFiles = []
        runPlotWatcherFiles = []
        runSalomeFiles = []
        runCadFiles = []
        runEditorFiles = []
        otherFiles = []
        addPath = "$TreeFoamUserPath" + os.sep + "app" + os.sep
        for fileName in files:
            name = fileName.split(os.sep)[-1]
            if name[:len("bashrc-FOAM")] == "bashrc-FOAM":
                bashrcFiles.append(addPath+name)
            elif name[:len("runParaFoam")] == "runParaFoam":
                runParaFoamFiles.append(addPath+name)
            elif name[:len("runPlotWatcher")] == "runPlotWatcher":
                runPlotWatcherFiles.append(addPath+name)
            elif name[:len("runSalomeMeca")] == "runSalomeMeca":
                runSalomeFiles.append(addPath+name)
            elif name[:len("runCAD")] == "runCAD":
                runCadFiles.append(addPath+name)
            elif name[:len("runEditor")] == "runEditor":
                runEditorFiles.append(addPath+name)
            else:
                otherFiles.append(addPath+name)
        bashrcFiles = list(set(bashrcFiles + [configDict["bashrcFOAM"]]))
        runParaFoamFiles = list(set(runParaFoamFiles + [configDict["paraFoam"]]))
        runPlotWatcherFiles = list(set(runPlotWatcherFiles + [configDict["plotWatcher"]]))
        runSalomeFiles = list(set(runSalomeFiles + [configDict["salomeMeca"]]))
        runCadFiles = list(set(runCadFiles + [configDict["CAD"]]))
        runEditorFiles = list(set(runEditorFiles + [configDict["editor"]]))
        bashrcFiles.sort()
        runParaFoamFiles.sort()
        runPlotWatcherFiles.sort()
        runSalomeFiles.sort()
        runCadFiles.sort()
        runEditorFiles.sort()
        #comboBoxにdataをセット
        self.cmbLang.setItems(langs)
        self.cmbLang.selectItem(configDict["language"])
        self.cmbLog.setItems(logs)
        self.cmbLog.selectItem(configDict["logFile"])
        self.cmbBashrc.setItems(bashrcFiles)
        self.cmbBashrc.selectItem(configDict["bashrcFOAM"])
        self.cmbParaFoam.setItems(runParaFoamFiles)
        self.cmbParaFoam.selectItem(configDict["paraFoam"])
        self.cmbPlotWatcher.setItems(runPlotWatcherFiles)
        self.cmbPlotWatcher.selectItem(configDict["plotWatcher"])
        self.cmbSalome.setItems(runSalomeFiles)
        self.cmbSalome.selectItem(configDict["salomeMeca"])
        self.cmbCad.setItems(runCadFiles)
        self.cmbCad.selectItem(configDict["CAD"])
        self.cmbEditor.setItems(runEditorFiles)
        self.cmbEditor.selectItem(configDict["editor"])

    def getAllItems(self):
        """ 全comboBoxの設定内容を辞書で取得"""
        newDict = {}
        newDict["language"] = self.cmbLang.getSelectedItem()
        newDict["logFile"] = self.cmbLog.getSelectedItem()
        newDict["bashrcFOAM"] = self.cmbBashrc.getSelectedItem()
        newDict["paraFoam"] = self.cmbParaFoam.getSelectedItem()
        newDict["plotWatcher"] = self.cmbPlotWatcher.getSelectedItem()
        newDict["salomeMeca"] = self.cmbSalome.getSelectedItem()
        newDict["CAD"] = self.cmbCad.getSelectedItem()
        newDict["editor"] = self.cmbEditor.getSelectedItem()
        return newDict

    def editBashrcFOAM(self):
        fileName = self.cmbBashrc.getSelectedItem()
        self.openEditor(fileName)

    def editRunParaFoam(self):
        fileName = self.cmbParaFoam.getSelectedItem()
        self.openEditor(fileName)

    def editRunPlotWatcher(self):
        fileName = self.cmbPlotWatcher.getSelectedItem()
        self.openEditor(fileName)

    def editRunSalomeMeca(self):
        fileName = self.cmbSalome.getSelectedItem()
        self.openEditor(fileName)

    def editRunCad(self):
        fileName = self.cmbCad.getSelectedItem()
        self.openEditor(fileName)

    def editRunEditor(self):
        fileName = self.cmbEditor.getSelectedItem()
        self.openEditor(fileName)

    def editConfigTreeFoam(self):
        fileName = os.getenv("TreeFoamUserPath") + os.sep + "configTreeFoam"
        self.openEditor(fileName)

    def openAppFolder(self):
        pyTreeFoam.run(self.appDir).fileManager()

    def reloadFolder(self):
        self.loadAppDirSetComboBox()

    def setDefault(self):
        title = _("configTreeFoamの設定")
        mess = _("configTreeFoamの内容をデフォルトの状態に戻します\n")
        mess += _("  よろしいですか？")
        okArgs = [self.setDefault_run]
        self.okCancelDialog(title, mess, funcOk=okArgs)
        return
        
    #  setDefault_run
    def setDefault_run(self):
        #global configDict
        print(_("configTreeFoamの内容をデフォルトの状態に戻します\n"))
        copyDir = os.getenv("TreeFoamPath") + os.sep + "app"
        pasteDir = os.getenv("TreeFoamUserPath") + os.sep + "app"
        copyFiles = glob.glob(copyDir+os.sep+"*")
        for copyFile in copyFiles:
            shutil.copy(copyFile, pasteDir)
        copyFile = os.getenv("TreeFoamPath") + os.sep + "configTreeFoam"
        pasteDir = os.getenv("TreeFoamUserPath")
        shutil.copy(copyFile, pasteDir)
        self.configDict = pyTreeFoam.readConfigTreeFoam()
        self.initialize()
        self.newConfigDict = {}
        self.newConfigDict["language"] = self.configDict["language"]
        self.newConfigDict["logFile"] = self.configDict["logFile"]
        self.newConfigDict["bashrcFOAM"] = self.configDict["bashrcFOAM"]
        self.newConfigDict["paraFoam"] = self.configDict["paraFoam"]
        self.newConfigDict["salomeMeca"] = self.configDict["salomeMeca"]
        self.newConfigDict["CAD"] = self.configDict["CAD"]
        self.newConfigDict["editor"] = self.configDict["editor"]

    def openEditor(self, fileName):
        """ editorでfileを開く"""
        fileName = os.path.expandvars(fileName)
        if len(glob.glob(fileName)) == 0:
            title = _("エラー")
            mess = _("ファイルが存在しません\n")
            mess += "  file: " + fileName
            self.errDialog(title, mess)
        else:
            pyTreeFoam.run().editor([fileName])

    #---- universalDialogs -------------
    #  okDialog
    def okDialog(self, title, mess, funcOk=[]):
        dialog = unvDlg.okDialog(
            title, mess, 
            parentWin=self.dialogApp, funcOk=funcOk)
        dialog.show()

    #errDialog
    def errDialog(self, title, mess, funcOk=[]):
        dialog = unvDlg.errDialog(
            title, mess, 
            parentWin = self.dialogApp, funcOk=funcOk)
        dialog.show()

    #okCancelDialog
    def okCancelDialog(self, title, mess, funcOk=[], funcCancel=[]):
        dialog = unvDlg.okCancelDialog(
            title, mess, 
            funcOk=funcOk, funcCancel=funcCancel, 
            parentWin=self.dialogApp)
        dialog.show()

#------------------------------------
#  changeConfigTreeFoam class
#------------------------------------
class changeConfigTreeFoam:

    def __init__(self, configDict, funcOk=[], funcCancel=[], parent=None):
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        self.dialog = dialogApp(configDict, parent=parent)
        self.dialog.button_bashrcFoam.connect("clicked", self.onEditBashrcFOAM)
        self.dialog.button_runParaFoam.connect("clicked", self.onEditRunParaFoam)
        self.dialog.button_runPlotWatcher.connect("clicked", self.onEditRunPlotWatcher)
        self.dialog.button_runSalome.connect("clicked", self.onEditRunSalomeMeca)
        self.dialog.button_runCad.connect("clicked", self.onEditRunCad)
        self.dialog.button_runEditor.connect("clicked", self.onEditRunEditor)
        self.dialog.button_configTreeFoam.connect("clicked", self.onEditConfigTreeFoam)
        self.dialog.button_openAppFolder.connect("clicked", self.onOpenAppFolder)
        self.dialog.button_reloadFolder.connect("clicked", self.onReloadFolder)
        self.dialog.button_setDefault.connect("clicked", self.onSetDefault)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_apply.connect("clicked", self.onApply)

    def show(self):
        self.dialog.show()

    #------ event handler ---------------------
    def onEditBashrcFOAM(self, event):          #bashrcFoam
        self.dialog.editBashrcFOAM()
    def onEditRunParaFoam(self, event):         #runParaFoam
        self.dialog.editRunParaFoam()
    def onEditRunPlotWatcher(self, event):      #runPlotWatcher
        self.dialog.editRunPlotWatcher()
    def onEditRunSalomeMeca(self, event):       #runSalome
        self.dialog.editRunSalomeMeca()
    def onEditRunCad(self, event):              #runCAD
        self.dialog.editRunCad()
    def onEditRunEditor(self, event):           #runEditor
        self.dialog.editRunEditor()
    def onEditConfigTreeFoam(self, event):      #configTreeFoam
        self.dialog.editConfigTreeFoam()
    def onOpenAppFolder(self, event):           #openAppFolder
        self.dialog.openAppFolder()
    def onReloadFolder(self, event):            #reloadFolder
        self.dialog.reloadFolder()
    def onSetDefault(self, event):              #setDefault
        self.dialog.setDefault()
    def onCancel(self, event):                  #キャンセル
        self.cancel(event)
    def onApply(self, event):                   #OK
        self.apply(event)


    #
    #  cancel
    #-----------
    def cancel(self, event):
        self.dialog.onCancel(event)
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)

    #
    #  apply
    #-----------
    def apply(self, event):
        self.dialog.onApply(event)
        newDict = self.dialog.newConfigDict
        #self.dialog.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(newDict, *args)
            GLib.timeout_add(100, funcName, newDict, *args)


if __name__ == "__main__":
    import gettext
    import locale
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    locale.bindtextdomain("treefoam", localeDir)
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

