#!/usr/bin/python3
#  coding: utf-8
#
#           QtVar.py
#
#       Qtのversionに応じた変数の値を取得する
#
#   24/08/27    新規作成
#      10/23    AlignBottom,Left,Right,HCenter,VCenterを追加。
#

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()

#Qtのversionに応じて変数を定義
#  TreeFoam内で使用している変数のみ定義
if getPyQtModule.UiCode == "Qt4":
    #-----------------------
    #Qt4,Qt5,PySide,PySide2用の変数定義
    #-----------------------
    #  icon関連
    Normal = QIcon.Normal
    Off    = QIcon.Off
    #  cellの設定
    Select            = QItemSelectionModel.Select
    ExtendedSelection = QAbstractItemView.ExtendedSelection
    PositionAtCenter  = QAbstractItemView.PositionAtCenter
    AlignCenter       = Qt.AlignCenter
    AlignTop          = Qt.AlignTop
    AlignBottom       = Qt.AlignBottom
    AlignLeft         = Qt.AlignLeft
    AlignRight        = Qt.AlignRight
    AlignHCenter      = Qt.AlignHCenter
    AlignVCenter      = Qt.AlignVCenter
    #  mouseButton
    LeftButton   = Qt.LeftButton
    #  dialogのbutton設定
    OkButton     = QMessageBox.Ok
    CancelButton = QMessageBox.Cancel
    #  Event関連
    CustomContextMenu = Qt.CustomContextMenu
    KeyPress     = QEvent.KeyPress
    NoModifier   = Qt.NoModifier
    #  KeyCode
    Key_Return = Qt.Key_Return
    Key_Enter  = Qt.Key_Enter
    Key_Shift  = Qt.Key_Shift
    Key_Control = Qt.Key_Control
    Key_Alt    = Qt.Key_Alt
    Key_Left   = Qt.Key_Left
    Key_Up     = Qt.Key_Up
    Key_Right  = Qt.Key_Right
    Key_Down   = Qt.Key_Down
    Key_Delete = Qt.Key_Delete
    Key_A = Qt.Key_A
    Key_B = Qt.Key_B
    Key_C = Qt.Key_C
    Key_D = Qt.Key_D
    Key_E = Qt.Key_E
    Key_F = Qt.Key_F
    Key_G = Qt.Key_G
    Key_H = Qt.Key_H
    Key_I = Qt.Key_I
    Key_J = Qt.Key_J
    Key_K = Qt.Key_K
    Key_L = Qt.Key_L
    Key_M = Qt.Key_M
    Key_N = Qt.Key_N
    Key_O = Qt.Key_O
    Key_P = Qt.Key_P
    Key_Q = Qt.Key_Q
    Key_R = Qt.Key_R
    Key_S = Qt.Key_S
    Key_T = Qt.Key_T
    Key_U = Qt.Key_U
    Key_V = Qt.Key_V
    Key_W = Qt.Key_W
    Key_X = Qt.Key_X
    Key_Y = Qt.Key_Y
    Key_Z = Qt.Key_Z

elif getPyQtModule.UiCode == "Qt6":
    #-------------
    #Qt6,PySide6用の変数定義
    #-------------
    #  icon関連
    Normal = QIcon.Mode.Normal
    Off    = QIcon.State.Off
    #  cellの設定
    Select            = QItemSelectionModel.SelectionFlag.Select
    ExtendedSelection = QAbstractItemView.SelectionMode.ExtendedSelection
    PositionAtCenter  = QAbstractItemView.ScrollHint.PositionAtCenter
    AlignCenter       = Qt.AlignmentFlag.AlignCenter
    AlignTop          = Qt.AlignmentFlag.AlignTop
    AlignBottom       = Qt.AlignmentFlag.AlignBottom
    AlignLeft         = Qt.AlignmentFlag.AlignLeft
    AlignRight        = Qt.AlignmentFlag.AlignRight
    AlignHCenter      = Qt.AlignmentFlag.AlignHCenter
    AlignVCenter      = Qt.AlignmentFlag.AlignVCenter
    #  mouseButton
    LeftButton   = Qt.MouseButton.LeftButton
    #  dialogのbutton設定
    OkButton     = QMessageBox.StandardButton.Ok
    CancelButton = QMessageBox.StandardButton.Cancel
    #  Event関連
    CustomContextMenu = Qt.ContextMenuPolicy.CustomContextMenu
    KeyPress     = QEvent.Type.KeyPress
    NoModifier   = Qt.KeyboardModifier.NoModifier
    #  KeyCode
    Key_Return = Qt.Key.Key_Return
    Key_Enter  = Qt.Key.Key_Enter
    Key_Shift  = Qt.Key.Key_Shift
    Key_Control = Qt.Key.Key_Control
    Key_Alt    = Qt.Key.Key_Alt
    Key_Left   = Qt.Key.Key_Left
    Key_Up     = Qt.Key.Key_Up
    Key_Right  = Qt.Key.Key_Right
    Key_Down   = Qt.Key.Key_Down
    Key_Delete = Qt.Key.Key_Delete
    Key_A = Qt.Key.Key_A
    Key_B = Qt.Key.Key_B
    Key_C = Qt.Key.Key_C
    Key_D = Qt.Key.Key_D
    Key_E = Qt.Key.Key_E
    Key_F = Qt.Key.Key_F
    Key_G = Qt.Key.Key_G
    Key_H = Qt.Key.Key_H
    Key_I = Qt.Key.Key_I
    Key_J = Qt.Key.Key_J
    Key_K = Qt.Key.Key_K
    Key_L = Qt.Key.Key_L
    Key_M = Qt.Key.Key_M
    Key_N = Qt.Key.Key_N
    Key_O = Qt.Key.Key_O
    Key_P = Qt.Key.Key_P
    Key_Q = Qt.Key.Key_Q
    Key_R = Qt.Key.Key_R
    Key_S = Qt.Key.Key_S
    Key_T = Qt.Key.Key_T
    Key_U = Qt.Key.Key_U
    Key_V = Qt.Key.Key_V
    Key_W = Qt.Key.Key_W
    Key_X = Qt.Key.Key_X
    Key_Y = Qt.Key.Key_Y
    Key_Z = Qt.Key.Key_Z

