#!/usr/bin/python3
#
#       waitToRunFrontISTR.py
#
#       runFistrのファイル有無を確認し、あればFrontISTRを起動する
#       FrontISTR起動後は、runFistrを削除する。
#
#   23/09/28    新規作成
#      10/20    waitToRunFrontIstr,runFrontIstr:交互計算に対応させる為に
#               timeName==endTimeで終了をtimeName>endTimeで終了に変更
#      10/25    waitToRunFrontIstr:時間制限で停止させる様に修正。
#      11/22    runFrontIstr:全コアをprocess並列とthread並列に振り分けて
#               実行するように修正
#      11/28    mmap関連は、allCommonConcAltnモジュールに変更
#

import os, sys
import time
import subprocess
import pyCoupling
import allCommonConcAltn as allComm

waitCount = 5000
waitTime = 0.01

#---------------------
#  waitToRunFrontIstr
#---------------------
def waitToRunFrontIstr():
    """ file有無を確認し、FrontISTRを起動する"""
    fluidCaseDir = couplingDict["fluidCaseDir"]
    maxWaitTime = couplingDict["maxWaitTime"]
    endTime = couplingDict["endTime"]
    waitCount = int(maxWaitTime)
    #logFileをクリア
    logFile = fluidCaseDir + "/solidSolve.log"
    f = open(logFile, "w"); f.close()
    #FrontISTRを繰り返し実行
    lastFlag = 0
    count = waitCount
    while True:
        flag, cont = getRunFistr()
        if flag == True:
            #FrontISTR起動
            calcEndTime = runFrontIstr(cont)
            #countをリセットして繰り返す
            count = waitCount
            # if calcEndTime < float(endTime):
            #     #countをリセットして繰り返す
            #     count = waitCount
            # elif lastFlag == 1:
            #     #計算終了
            #     break
            # else:
            #     lastFlag = 1
        time.sleep(waitTime)
        count -= 1
        if count < 0:
            break

#
#  getRunFistr
#--------------
def getRunFistr():
    """ 共有メモリの内容を読み込み確認する"""
    #cont = readCommonArea()
    cont = mmCommArea.readCommonArea()
    if len(cont) > 0:
        lines = cont.split("\n")
        if len(lines) >= 3:
            words = lines[0].split()
            if len(words) >= 2:
                if words[1] == "runFistr":
                    return True, cont
    return False, ""

#
#  runFrontIstr
#----------------
def runFrontIstr(cont):
    """ FrontISTRを起動する
    全ての設定は完了している為、ここでは起動のみ"""
    solidAnaComm = couplingDict["solidAnaComm"]
    solidCaseDir = couplingDict["solidCaseDir"]
    fluidCaseDir = couplingDict["fluidCaseDir"]
    nThreads = couplingDict["nThreads"]
    endTime = couplingDict["endTime"]
    deltaT = couplingDict["deltaT"]
    nStepsOF = couplingDict["nStepsOF"]
    (timeName, msg) = getFooterMessage(cont)
    #終了確認
    if float(timeName) > float(endTime):
        #終了
        return float(timeName)
    if int(nThreads) == 1:
        np = 1
        nt = 1
        comm = solidAnaComm + " -t " + nThreads
    else:
        np = nParallelFistrFromCnt()    #process数
        if np == 1:
            nt = int(nThreads)
            comm = solidAnaComm + " -t " + nThreads
        else:
            nt = int(nThreads) // np         #thread数
            comm = "mpirun -np " + str(np) + " " + solidAnaComm + " -t " + str(nt)
    print("(py) ---  ( procs:" + str(np) + "  threads:" + str(nt) + " )")
    #FrontISTR起動
    logFile = fluidCaseDir + "/solidSolve.log"
    fo = open(logFile, "a")
    t = time.time()
    saveDir = os.getcwd()
    os.chdir(solidCaseDir)
    proc = subprocess.run(
        comm,
        shell=True,
        stdout=fo,
        stderr=fo)
    #終了した事を共有メモリに記載
    cont = "title FistrFinished\n"
    cont += "#end\n"
    #writeCommonArea(cont)
    mmCommArea.writeCommonArea(cont)
    #footerを出力
    l = time.time() - t
    l = int(l * 100 + 0.5) / 100
    line = msg + " " + str(l) + " sec\n\n"
    fo.write(line)
    fo.close()
    os.chdir(saveDir)
    #計算終了時のtimeを戻す
    calcEndTime = float(timeName) + int(nStepsOF) * float(deltaT)
    return calcEndTime

#
#  nParallelFistrFromCnt
def nParallelFistrFromCnt():
    """ Fistrの並列数を現在のdatファイルから取得し返す"""
    solidCaseDir = couplingDict["solidCaseDir"]
    np = pyCoupling.getNumProcsFistrFromDat(solidCaseDir)
    return np

#
#  getFooterMessage
def getFooterMessage(cont):
    """ contからtimeNameとmessを取得する"""
    footer = ""
    lines = cont.split("\n")
    for line in lines:
        words = line.split()
        if len(words) >= 2:
            if words[0] == "footer":
                footer = " ".join(words[1:])
            elif words[0] == "time":
                timeName = words[1]
    return (timeName, footer)



if __name__ == "__main__":
    fluidCaseDir = os.getcwd()
    couplingData = pyCoupling.couplingData(fluidCaseDir)
    couplingDict = couplingData.read()
    couplingDict["fluidCaseDir"] = fluidCaseDir
    #共有メモリの設定
    #mmCommon = createCommonArea()
    mmCommFile = allComm.createCommonArea(couplingDict)
    mmCommArea = allComm.mmCommonArea(couplingDict, mmCommFile)
    waitToRunFrontIstr()
