#!/usr/bin/python3
#
#       contRun_couplingSource_cht.py
#
#       OpenFOAMが出力した熱流束から、FrontISTRを実行して、温度を出力する。
#
#   23/10/02    新規作成
#      11/14    chtCommonConcurrentモジュール使用に変更
#      11/16    allCommonConcAltnモジュール使用に変更
#   24/04/23    endTime時（最後の計算）は、restartFile名のチェックを追加。
#

import sys, os
import shutil
import pyCoupling
import chtCommonConcurrent as chtComm
import allCommonConcAltn as allComm


waitCount = 5000
waitTime = 0.01


#------------------
#  coupling_cht
#------------------
def coupling_cht():
    """ OpenFOAMが出力した熱流束から、FrontISTRが温度を計算する。"""
    solidCaseDir = couplingDict["solidCaseDir"]
    fluidCaseDir = couplingDict["fluidCaseDir"]
    patchName = couplingDict["mappingPatch"]
    timeName = couplingDict["timeName"]
    procNo = couplingDict["procNo"]
    dataDir = fluidCaseDir + "/coupling_FrontISTR/data"
    #---- heatFluxをmapping ---------
    #heatFluxの点群ファイル作成
    htFile = dataDir + "/" + patchName + "_faceHeatFlux_" + timeName + "_" + procNo + "tm"
    chtComm.createHeatFluxPtcFile(couplingDict, htFile)
    if int(procNo) == 0:
        #heatFluxをmappingしてcntファイルに反映
        chtComm.createMappingHeatFlux(couplingDict)
        #---- fistr実行 --------------
        #fsi計算前の設定
        setFsiChtCntFile("cht")
        endStep, endTime = chtComm.setDeltaTInCnt_cht(couplingDict)
        #Fistr起動
        runFistr("cht", endStep, endTime)
        #--- 温度を取得 ---------
        #変位のptcデータを作成
        print("(py) --- creating temperature PTC ...", flush=True)
        np = pyCoupling.getNumProcsFistrFromDat(solidCaseDir)
        tempDict = chtComm.getTempDictFromResFile(couplingDict, endStep, np)
        tempPtc = chtComm.createTempPtc(couplingDict, tempDict)
        #温度をmappingしたfileを作成
        print("(py) --- temperature value is mapping to patch '" + patchName + "' ...", flush=True)
        chtComm.createMappingTempFile(couplingDict, tempPtc, endStep)
        #--- 結果file整理（file削除、restart設定）----
        chtComm.deleteResSetRestartFileCht(couplingDict, np)
    return ""

#
#  setFsiChtCntFile
def setFsiChtCntFile(sect):
    """ sectに応じたdatファイルに修正"""
    solidCaseDir = couplingDict["solidCaseDir"]
    pasteDatFile = solidCaseDir + os.sep + "hecmw_ctrl.dat"
    if sect == "fsi":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_fsi.dat"
    elif sect == "cht":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_cht.dat"
    elif sect == "chtss":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_chtss.dat"
    shutil.copy(datFile, pasteDatFile)

#
#  runFistr
#----------
def runFistr(sect, endStep, endTime):
    """ FrontISTRを起動"""
    allComm.runFistr(couplingDict, mmCommArea, sect, endStep, endTime)
    return


if __name__ == "__main__":
    import gettext
    gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext

    currTime = sys.argv[1]      #currTime
    beforeTime = sys.argv[2]    #前回のtime
    procNo = sys.argv[3]        #procNo
    nProcs = sys.argv[4]        #nProcs
    timeIndex = sys.argv[5]     #timeIndex
    fluidCaseDir = os.getcwd()
    couplingData = pyCoupling.couplingData(fluidCaseDir)
    couplingDict = couplingData.read()
    couplingDict["fluidCaseDir"] = fluidCaseDir
    couplingDict["timeName"] = currTime
    couplingDict["beforeTime"] = beforeTime
    couplingDict["procNo"] = procNo
    couplingDict["nProcs"] = nProcs
    couplingDict["timeIndex"] = timeIndex
    waitCount = int(couplingDict["maxWaitTime"])
    #共有メモリの設定
    mmCommFile = allComm.createCommonArea(couplingDict)
    mmCommArea = allComm.mmCommonArea(couplingDict, mmCommFile)
    #現在時間が終了時間？
    if float(couplingDict["timeName"]) >= float(couplingDict["endTime"]):
        #最後にrestartFile名をチェック修正する
        chtComm.couplingDict = couplingDict
        chtComm.correctTimeNameRestartFileName(currTime, timeIndex)
        exit()
    #----flagをチェック --------------
    if int(procNo) == 0:
        #busy状態？（自身が起動していれば、終了まで待つ）
        mmCommArea.waitUntilFreeCommonArea()
        #setBusy（busyをセット）
        mmCommArea.writeCommonArea("running python\n")
    #---- coupling開始 -------------
    #mainへ
    stat = coupling_cht()
    if stat != "":
        raise NameError(stat)
    #---- flagをクリア -------------
    if int(procNo) == 0:
        #clearBusy（freeをセット）
        mmCommArea.writeCommonArea("")
