#!/usr/bin/python3
#  coding: utf-8
#
#       contRun_altnSource_fsi.py
#
#       流体側の圧力からFrontISTRを実行して変位を出力する。
#       contRun_couplingSource_fsi.pyを交互計算用に修正。
#
#   23/10/20    saveMappingDisp:交互計算に対応させる為、
#               dispのfile名のstep数をendStepからtimeIndexに変更
#               setDeltaTInCnt_fsi,deleteResSetRestartFileFsi:大幅修正
#               createCommTimeArea:新規追加。（前回のcouplingTime取得の為）
#      11/06    fsiCommonAlternateのモジュールを利用に変更
#      11/16    allCommonConcAltnモジュールの利用に変更
#

import sys, os
import pyCoupling
import shutil
import fsiCommonAlternate as fsiComm
import allCommonConcAltn as allComm

waitCount = 5000
waitTime = 0.01


#----------------------
#  coupling_fsi
#----------------------
def coupling_fsi():
    """ 圧力dataをsolidFaceにmappingしてFrontISTRを実行、変位を計算する。"""
    patchName = couplingDict["mappingPatch"]
    timeName = couplingDict["timeName"]
    procNo = couplingDict["procNo"]
    solidCaseDir = couplingDict["solidCaseDir"]
    dataDir = fluidCaseDir + "/coupling_FrontISTR/data"
    #--- 圧力をmapping ------
    #ptcDataの読み込み
    pressFile = dataDir + "/" + patchName + "_facePress_" + timeName + "_" + procNo + "tm"
    #圧力の点群ファイルを作成
    fsiComm.createPressPtcFile(couplingDict, pressFile)
    if int(procNo) == 0:
        #圧力をmappingしてcntファイルに反映
        fsiComm.createMappingPressFile(couplingDict)
        #--- fistr実行 ----------
        #fsi計算前の設定
        setFsiChtCntFile("fsi")
        bfrStep, bfrTime = mmCommPressArea.getBeforeCouplingTime()
        endStep, endTime = fsiComm.setDeltaTInCnt(couplingDict, bfrStep, bfrTime)
        #Fistr起動
        runFistr("fsi", endStep, endTime)
        #--- 変位を取得 ---------
        #変位のptcデータを作成
        print("(py) --- creating displacement PTC ...", flush=True)
        np = pyCoupling.getNumProcsFistrFromDat(solidCaseDir)
        dispDict = fsiComm.getDispDictFromResFile(couplingDict, endStep, np)
        dispPtc = fsiComm.createDispPtc(couplingDict, dispDict)
        #変位のmapping結果fileを作成
        print("(py) --- displacement value is mapping to patch '" + patchName + "' ...", flush=True)
        fsiComm.createMappingDispFile(couplingDict, dispPtc, endStep)
        #--- 結果file整理（file削除、restart設定）-----
        fsiComm.deleteResSetRestartFile(couplingDict, bfrStep, bfrTime, np)
    return ""

#
#  setFsiChtCntFile
def setFsiChtCntFile(sect):
    """ sectに応じたdatファイルに修正"""
    solidCaseDir = couplingDict["solidCaseDir"]
    pasteDatFile = solidCaseDir + os.sep + "hecmw_ctrl.dat"
    if sect == "fsi":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_fsi.dat"
    elif sect == "cht":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_cht.dat"
    elif sect == "chtss":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_chtss.dat"
    shutil.copy(datFile, pasteDatFile)

#
#  runFistr
#-----------
def runFistr(sect, endStep, endTime):
    """ FrontISTRを起動"""
    allComm.runFistr(couplingDict, mmCommArea, sect, endStep, endTime)
    return


if __name__ == "__main__":
    import gettext
    gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext

    currTime = sys.argv[1]      #currTime
    beforeTime = sys.argv[2]    #前回のtime
    procNo = sys.argv[3]        #procNo
    nProcs = sys.argv[4]        #nProcs
    timeIndex = sys.argv[5]     #timeIndex
    fluidCaseDir = os.getcwd()
    couplingData = pyCoupling.couplingData(fluidCaseDir)
    couplingDict = couplingData.read()
    couplingDict["fluidCaseDir"] = fluidCaseDir
    couplingDict["timeName"] = currTime
    couplingDict["beforeTime"] = beforeTime
    couplingDict["procNo"] = procNo
    couplingDict["nProcs"] = nProcs
    couplingDict["timeIndex"] = timeIndex
    waitCount = int(couplingDict["maxWaitTime"])
    #共有メモリの設定
    mmCommFile = allComm.createCommonArea(couplingDict)
    mmCommArea = allComm.mmCommonArea(couplingDict, mmCommFile)
    mmCommPressFile = allComm.createCommTimePressArea(couplingDict)
    mmCommPressArea = allComm.mmCommonArea(couplingDict, mmCommPressFile)
    #couplingTimeを共有メモリに保存
    mmCommPressArea.saveCouplingTime()
    #現在時間が終了時間？
    if float(couplingDict["timeName"]) > float(couplingDict["endTime"]):
        exit()
    #beforeTimeが計算開始時間よりも前 or 現時点がbeforeTime？
    if (float(beforeTime) <  float(couplingDict["startTime"]) or    #restart初回
        float(beforeTime) == float(currTime)):                      #計算初回
        exit() 
    #mainへ
    stat = coupling_fsi()
    if stat != "":
        raise NameError(stat)
