#!/usr/bin/python3
#
#           chtssCommonConcurrent.py
#
#       同時計算用のchtss連成の共通関数群
#
#   23/11/14    新規作成
#

import os
import pyFistr_ptc as pyFistr
import chtssCommonAlternate as chtssCommAltn

couplingDict = {}
waitCount = 5000
waitTime = 0.01
 
FistrModel_cnt = "FistrModel_chtss.cnt"
resHeaderName = "FistrModel.res"
hecmwCtrlFile = "hecmw_ctrl_chtss.dat"

#
#  waitUntilExistingFile
#------------------------
def waitUntilExistingFile(fileName):
    """ fileが出来上がるまで待つ"""
    chtssCommAltn.waitUntilExistingFile(fileName)
    return

#-----------------------------------
#  remakeFistrCntFileForTemperature
#-----------------------------------
def remakeFistrCntFileForTemperature(dataDict, tempDict):
    """ temperatureの計算結果をcntファイルに反映"""
    chtssCommAltn.remakeFistrCntFileForTemperature(dataDict, tempDict)
    return

    # global couplingDict
    # couplingDict = dataDict
    # solidCaseDir = couplingDict["solidCaseDir"]
    # #cntFileを修正
    # cntFile = solidCaseDir + os.sep + "FistrModel_chtss.cnt"
    # f = open(cntFile); lines = f.readlines(); f.close()
    # #挿入場所は、!TEMPERATUREのALLに、'otherData=yes'を追加して挿入。
    # si = 0
    # i = 0
    # while i < len(lines):
    #     i = pyFistr.getNextHeaderName(lines, i, "!TEMPERATURE", "")
    #     i += 1
    #     if i >= len(lines):
    #         break
    #     words = pyFistr.deleteSp(lines[i]).split(",")
    #     if words[0] == "ALL":
    #         #!TEMPERATUREの行に'otherData=yes'を追加
    #         lines[i-1] = pyFistr.setValName(lines[i-1], "otherData=yes")
    #         si = i + 1
    #         ei = pyFistr.skipNextHeader(lines, i)
    #         break
    # if si == 0:
    #     print("error: could not find !TEMPERATURE card!")
    #     return
    # #tempLinesを追加
    # lines = lines[:si] + tempLines + lines[ei:]
    # f = open(cntFile, "w"); f.writelines(lines); f.close()

#---------------------
#  createChtssDispPtc
#---------------------
def createChtssDispPtc(dataDict):
    """ chtss変位の点群データ取得"""
    dispPtc = chtssCommAltn.createChtssDispPtc(dataDict)
    return dispPtc

#--------------------------
#  getDispDictFromResFile
#--------------------------
def getDispDictFromResFile(dataDict, endStep, np):
    """ FrontISTRの変位計算結果を辞書形式で返す。
    dispDict={<nodeNo>: [x,y,z]}"""
    dispDict = chtssCommAltn.getDispDictFromResFile(dataDict, endStep, np)
    return dispDict

#-----------------
#  createDispPtc
#-----------------
def createDispPtc(couplingDict, chtssDispDict):
    """ 辞書からptcを作成して返す"""
    chtssDispPtc = chtssCommAltn.createDispPtc(couplingDict, chtssDispDict)
    return chtssDispPtc

#------------------------
#  createMappingDispFile
#------------------------
def createMappingDispFile(couplingDict, chtssDispPtc, endStep):
    """ 変位をpatchにmappingしたfileを作成する"""
    chtssCommAltn.createMappingDispFile(couplingDict, chtssDispPtc, endStep)
    return
