#!/usr/bin/python3
# -*- coding: UTF-8 -*-
#
#       unicode2chara3.py  （python3用）
#
#       16進のunicodeを文字列（str形式）に変換する
#
#   17/11/03    新規作成
#   18/05/13    python3用に書き換え
#

import sys
import glob

#
#  helpMsg
#
def helpMsg():
    msg = """
--------- < unicode2chara3.py ヘルプ > ----------------------------------
ファイル内の16進unicodeで記述された文字列をstr形式の文字列に変換する。(python3用)
変換対象の文字列は、「u"\\u5236\\u5623ABC"」の様な文字列を変換する。
変換後のファイル名は、「<変換ファイル>.conv」になる。

使い方
    unicode2chara3.py <fileName>

fieName     :変換対象のファイル名

"""
    print (msg)

#
#  getUnicode
#    line[n]以降から「""」までの16進unicodeを抽出する
def getUnicode(line, n):
    uniWord = ""
    ned = line.find('"', n+2)
    if ned < 0:
        return uniWord

    uniWord = line[n+2:ned]
    return uniWord

#
#  convUnicode
#    unicodeの単語（Hex）をchara（文字）に変換
#    1文字づつ確認し変換する
def convUnicode(uniWord):
    strWord = ""
    i = 0
    while i < len(uniWord):
        if uniWord[i:i+2] == "\\u":
            #unicodeの場合
            chara = uniWord[i+2:i+6]
            #strChara = unichr(int("0x"+chara, 16))
            strChara = chr(int("0x"+chara, 16))
            i += 6
        else:
            #strの場合
            strChara = uniWord[i]
            i += 1
        strWord += strChara
    #if type(strWord) == unicode:
    #    strWord = strWord.encode("utf-8")
    strWord = ("%s" % strWord).encode().decode("utf-8")
    return strWord

#
#  convChara
#    unicodeをstrに変換する
def convChara(fileName):
    #ファイルの読み込み
    f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
    #1行づつ変換する
    newLines = []
    i = 0
    for line in lines:
        uniFlag = 0
        uniWords = []
        n = line.find('u"', 0)
        while n > 0:
            #1行の中にunicodeの単語が無くなるまで変換する
            uniFlag = 1
            uniWord = getUnicode(line, n)           #unicode単語を取得
            strWord = convUnicode(uniWord)          #文字に変換
            uniWords.append([uniWord, n, strWord])  #結果を保存
            n = line.find('u"', n+2)
        if uniFlag == 0:
            #unicodeを含まない場合
            newLines.append(line)
        else:
            #unicodeを含む場合
            newLine = ""
            nst = 0
            #unicode単語を文字に置き換える
            for [uniWord, n, strWord] in uniWords:
                newLine += line[nst:n+2] + strWord
                nst = n + len(uniWord) + 2
            newLine += line[n+2+len(uniWord):]
            newLines.append(newLine)
        i += 1
    #変換後、ファイルに保存
    f = open(fileName+".conv", "w", encoding="utf-8")
    for line in newLines:
        f.write(line)
    f.close()


if __name__ == "__main__":
    if len(sys.argv) == 1:
        helpMsg()
        exit()    
    convFile = sys.argv[1]
    if len(glob.glob(convFile)) == 0:
        print (convFile + u" ファイルは、存在しません。")
        helpMsg()
        exit()
    convChara(convFile)

