#!/usr/bin/python3
# coding: utf-8
#
#       teeCorrect.py
#
#       OpenFOAMの出力を整形して出力する。
#       plotWatcher.pyが読める形式に変換する。
#
#   <修正内容>
#       Time = 0.2s     Time = 0.2      最後の文字を削除。
#
#   22/07/17    新規作成
#

import sys

#
#  ccorrectLog
def correctLog(logFile):
    """ 入力を整形してlogFileに出力する"""
    f = open(logFile, "w")
    loop = True
    while loop:
        try:
            line = input()
            print(line)
            #
            #  Time = 0.2s →　Time = 0.2 に修正
            if line[:len("Time = ")] == "Time = ":
                words = line.split()
                #最後の文字が数字以外の場合？
                if "0" > words[2][-1] or words[2][-1] > "9":
                    words[2] = words[2][:-1]
                    line = " ".join(words)
            line += "\n"
            f.write(line)
        except:
            break
    f.close()


if __name__ == "__main__":
    logFile = sys.argv[1]
    correctLog(logFile)


