#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   runPraFoam.py
#
#       regionがある場合は、空fileを作成する
#
#   13/01/12    paraFoam終了後、空fileを削除する事を追加
#      03/17    multiRegionのチェック方法を変更
#      05/04    paraFoamの起動を環境設定後、起動するように修正（「;」→「\n」へ変更）
#      05/08    空file「*.foam」を追加
#      10/19    国際化のため修正
#   14/07/05    paraFoamのoptionを追加、system内に「controlDict.foam」を追加
#      07/27    -builtinオプション有無、region有無で起動方法を変更
#               regionがある時
#                   -builtin有り  constant/polyMeshがあるとエラー（削除）
#                   オプション無し constant/polyMeshがないとエラー（追加）
#   15/03/18    -builtin、region有無で起動方法を変えていたものを元に戻す
#      07/14    -builtinオプション有無、region有無で起動方法を変更（前に戻す）
#   16/12/31    makeConstantRegNames:constant内に<regName>folderを作成する。
#               makeConstantPolyMeshInRegin:constant/<regName>内にpolyMesh作成
#               runParaFoam:OF-ext用に修正
#   17/09/09    runParaFoam:paraFoam起動用のbashFileを作成する様に修正。
#   19/05/21    makeConstantRegNames,makeConstantPolyMeshInRegin:
#               shellの「mkdir」コマンドの使用を止め、python上でdirを作成。
#   19/09/05    python3用に書き換え
#


import os
import sys
import glob
import shutil

#
#  isMultiRegion
#
def isMultiRegion():
    #currentDir内でpolyMeshを検索する
    regMeshDirs = glob.glob("*/*/polyMesh/boundary")
    location = ""
    timeMeshes = []
    for meshDir in regMeshDirs:
        time = meshDir.split(os.sep)[0]
        try:
            a = float(time)
            timeMeshes.append([a, meshDir])
        except:
            pass
    regNames = []
    if len(timeMeshes) > 0:
        timeMeshes.sort()
        location = timeMeshes[0][1].split(os.sep)[0]
        for timeMesh in timeMeshes:
            if timeMesh[1].split(os.sep)[0] == location:
                name = timeMesh[1].split(os.sep)[1]
                regNames.append(name)
    else:
        location = "constant"
        for meshDir in regMeshDirs:
            if meshDir.split(os.sep)[0] == location:
                regNames.append(meshDir.split(os.sep)[1])
    #戻り値を設定
    ans = False
    if len(regNames) > 0:
        ans = True
        regNames.sort()
    return [ans, location, regNames]

#
#  runParaFoam
#   envFoam: paraFoamの環境設定ファイル
#   option:  paraFoam起動時のオプション
def runParaFoam(envFoam, option):
    OpenFoamEnvFile = envFoam
    #wdir = os.getcwd()

    #multiRegionのチェック
    [region, dummy_loc, regNames] = isMultiRegion()
    if region == True and option != "-builtin":
        #Regionがあり、普通にparaFoamを起動する場合
        #constant/polyMeshを作成する
        makeConstantPolyMesh(regNames)
        #constant/<regName>が存在しない場合、作成する。（folderのみ）
        makeConstantRegNames(regNames)
        #constant/<regName>内のpolyMeshが存在しない場合は、作成する。
        makeConstantPolyMeshInRegin(regNames)
        #読み込みファイルを作成
        command = "#!/bin/bash\n"
        command += ". " + OpenFoamEnvFile + "\n"
        for regName in regNames:
            command += "paraFoam -region " + regName + " -touch\n"
        bashFile = os.getenv("TreeFoamUserPath") + "/temp/runBash"
        f=open(bashFile, "w"); f.write(command); f.close()
        os.system("chmod a+x " + bashFile)
        os.system(bashFile)

    if region == True and option == "-builtin":
        #regionがあり、builtinでparaFoamを起動する場合
        #constant/polyMeshを削除する
        #deleteConstantPolyMesh()
        pass

    # paraFoam を起動
    #   次の行を「;」→「\n」に修正
    command = "#!/bin/bash\n"
    command += ". " + OpenFoamEnvFile + "\n paraFoam " + option
    bashFile = os.getenv("TreeFoamUserPath") + "/temp/runBash"
    f=open(bashFile, "w"); f.write(command); f.close()
    os.system("chmod a+x " + bashFile)
    os.system(bashFile)

    #空fileを削除
    if len(glob.glob("*.OpenFOAM")) > 0:
        command = "rm *.OpenFOAM"
        os.system(command)
    if len(glob.glob("*.foam"))>0:
        command = "rm *.foam"
        os.system(command)
    if len(glob.glob("system/*.OpenFOAM")) > 0:
        command = "rm system/*.OpenFOAM"
        os.system(command)
    if len(glob.glob("system/*.foam")) > 0:
        command = "rm system/*.foam"
        os.system(command)
    if len(glob.glob("*.blockMesh")) > 0:
        command = "rm *.blockMesh"
        os.system(command)

def makeConstantPolyMesh(regNames):
    if len(glob.glob("constant/polyMesh")) == 0:
        copyDir = "constant/"+ regNames[0] + "/polyMesh"
        distDir = "constant"
        comm = "cp -rf " + copyDir + " " + distDir
        os.system(comm)

def makeConstantRegNames(regNames):
    for regName in regNames:
        if len(glob.glob("constant/"+regName)) == 0:
            #comm = "mkdir constant/" + regName
            #os.system(comm)
            wdir = os.getcwd()
            os.mkdir(wdir + "/constant/" + regName)

def makeConstantPolyMeshInRegin(regNames):
    setRegNames = []
    for regName in regNames:
        if len(glob.glob("constant/"+regName+"/polyMesh")) == 0:
            setRegNames.append(regName)
    meshDir = ""
    if len(setRegNames) > 0:
        for regName in setRegNames:
            meshDirs = glob.glob("*/" + regName + "/polyMesh/boundary")
            if len(meshDirs) > 0:
                ansList = []
                for meshDir in meshDirs:
                    dirs = meshDir.split("/")
                    try:
                        a=float(dirs[0])
                        ansList.append([a,dirs[:-1]])
                    except:
                        pass
                if len(ansList) > 0:
                    wdir = os.getcwd()
                    ansList.sort()
                    meshDir = "/".join(ansList[0][1])
                    copyDir = wdir + "/" + meshDir
                    pasteDir = wdir + "/constant/" + regName + "/polyMesh"
                    shutil.copytree(copyDir, pasteDir)
                    #comm = "mkdir constant/" + regName + "/polyMesh;"
                    #comm += "cp -rf " + meshDir + " " + "constant/" + regName
                    #os.system(comm)


def deleteConstantPolyMesh():
    if len(glob.glob("constant/polyMesh")) != 0:
        delDir = "constant/polyMesh"
        comm = "rm -rf " + delDir
        os.system(comm)


#言語の設定
import gettext
treeFoamPath = os.environ["TreeFoamPath"]
gettext.install("treefoam", treeFoamPath + "/data/locale")

option = ""                     #paraFoam起動時のオプション
envFoam = sys.argv[1]           #paraFoamの環境設定ファイル
if envFoam[0] == ".":
    envFoam = os.getcwd() + "/" + envFoam
if len(sys.argv) >= 3:
    option = sys.argv[2]
runParaFoam(envFoam, option)

