#!/usr/bin/python3
#  coding: utf-8
#
#           remeshAndMappingFsi.py
#
#       FSI用のcaseでremesh, mappingを行う
#

import os
import glob
import pyTreeFoam
import pyFistr_ptc as pyFistr
import createPointCloudFromOpenFoam as createPtc
import remeshAndMapping
import pyCoupling
import runCoupling

#
#  beforeRemeshProcess
#--------------------------
def beforeRemeshProcess():
    """ remesh前の設定。
    初期の変位shiftを取得する"""
    global couplingDict, timeFolders
    fluidCaseDir = os.getcwd()
    couplingData = pyCoupling.couplingData(fluidCaseDir)
    couplingDict = couplingData.read()
    patchName = couplingDict["mappingPatch"]
    nProcs = couplingDict["nProcs"]
    dataDir = fluidCaseDir + "/coupling_FrontISTR/data/"
    # for p in range(int(nProcs)):
    #     procNo = str(p)
    #     faceNodesFile = patchName + "_mapPointFaceNodes_" + procNo
    #     faceCenterFile = patchName + "_mapFaceCenterNodes_" + procNo
    #     if os.path.exists(dataDir + faceNodesFile) == True:
    #         os.remove(dataDir + faceNodesFile)
    #     if os.path.exists(dataDir + faceCenterFile) == True:
    #         os.remove(dataDir + faceCenterFile)
    # #dispShitを作成

    #dispPtcDataを作成（remesh前の状態で、ptcDataを作成する）
    case = pyTreeFoam.case(fluidCaseDir)
    if len(glob.glob(fluidCaseDir + "/processor*")) > 0:
        timeFolders = case.getTimeFolders("processor0")
    else:
        timeFolders = case.getTimeFolders()
    stTime = timeFolders[-1]
    solidCaseDir = couplingDict["solidCaseDir"]
    files = glob.glob(solidCaseDir + "/*.restart_" + stTime + "_*")
    if len(files) > 0:
        step = files[0].split("_")[-1].split(".")[0]
    else:
        step = "0"
    for p in range(int(nProcs)):
        ptcLines = []        #点群data
        procNo = str(p)
        name = patchName + "_disp_" + step + "_" + procNo
        dispFile = glob.glob(dataDir + name + "*")[0]
        f = open(dispFile); dispLines = f.readlines(); f.close()
        name = patchName + "_mapPointFaceNodes_" + procNo
        locFile = dataDir + name
        f = open(locFile); locLines = f.readlines(); f.close()
        #dispの点群data作成（newMeshに変換するため）
        for i in range(len(dispLines)):
            #fistrの変位
            disp = list(map(float, dispLines[i].split()))
            #remesh前の座標
            loc = list(map(float, locLines[i].split()[1:4]))    
            x = disp[0] + loc[0]
            y = disp[1] + loc[1]
            z = disp[2] + loc[2]
            newLoc = [x,y,z]
            ptc = map(str, newLoc + disp)
            ptcLine = " ".join(ptc) + "\n"
            ptcLines.append(ptcLine)
        name = patchName + "_dispPtcData_" + procNo
        ptcDataFile = dataDir + name
        f = open(ptcDataFile, "w"); f.writelines(ptcLines); f.close()

    #mapPointFaceNodes, mapPointFaceCenterNodesを削除
    #  remeshしている為、更新する必要あり。
    for p in range(int(nProcs)):
        procNo = str(p)
        faceNodesFile = patchName + "_mapPointFaceNodes_" + procNo
        faceCenterFile = patchName + "_mapFaceCenterNodes_" + procNo
        mapTriFile = "mappingTriFile*.bin"
        mapTriFiles = glob.glob(dataDir + mapTriFile)
        if os.path.exists(dataDir + faceNodesFile) == True:
            os.remove(dataDir + faceNodesFile)
        if os.path.exists(dataDir + faceCenterFile) == True:
            os.remove(dataDir + faceCenterFile)
        for mapTriFile in mapTriFiles:
            os.remove(mapTriFile)



    # couplingData = pyCoupling.couplingData(fluidCaseDir)
    # couplingDict = couplingData.read()
    # couplingDict["fluidCaseDir"] = fluidCaseDir
    # couplingDict["remeshStart"] = "yes"
    # couplingData.write({"remeshStart": "yes"})
    # fluidCase = pyTreeFoam.case(fluidCaseDir)
    # if len(glob.glob(fluidCaseDir + "/processor*")) == 0:
    #     timeFolders = fluidCase.getTimeFolders()
    # else:
    #     timeFolders = fluidCase.getTimeFolders("processor0")
    # startTime = timeFolders[-1]
    # runCoupling.fluidCaseDir = fluidCaseDir
    # runCoupling.couplingDict = couplingDict
    # runCoupling.createInitialDispShiftFile(startTime)
    

#
#  remeshMapping
#------------------
def remeshMapping():
    """ remesh, mapping"""
    global couplingDict
    comm = "remeshAndMapping.py"
    #fluidCaseDir = couplingDict["fluidCaseDir"]
    fluidCaseDir = os.getcwd()
    run = pyTreeFoam.run(fluidCaseDir)
    run.command(comm)

#
#  afterRemashProcess
#---------------------
def afterRemeshProcess():
    """ remesh後の処理"""
    global couplingDict, timeFolders
    fluidCaseDir = os.getcwd()
    patchName = couplingDict["mappingPatch"]
    nProcs = couplingDict["nProcs"]
    dataDir = fluidCaseDir + "/coupling_FrontISTR/data/"
    #pressFile(_facePress_)を再設定
    case = pyTreeFoam.case(fluidCaseDir)
    if nProcs == "1":
        #patchのfaceNoを取得
        maxTime = timeFolders[-1]
        region = "."
        meshDir = case.getCurrMeshDir(maxTime, region, "boundary")
        patchConts = case.getPatchNameFromBoundary(meshDir)
        for patchCont in patchConts:
            pName, patchType, nFaces, startFace = patchCont
            if pName == patchName:
                nFaces = int(nFaces)
                startFace = int(startFace)
                break
        #cellNoを取得
        ownerFile = fluidCaseDir + "/" + meshDir + "/owner"
        f = open(ownerFile); ownerCont = f.read(); f.close()
        ownerOp = pyTreeFoam.strOp(ownerCont)
        p = ownerOp.skipFoamFile(0)
        cont, p = ownerOp.getSmallPair(p)
        cellNos = cont.split()[startFace:startFace + nFaces]
        cellNos = list(map(int, cellNos))
        #patchName（zeroGradient）の圧力を取得
        pField = couplingDict["field"]
        fieldFile = fluidCaseDir + "/" + maxTime + "/" + pField
        f = open(fieldFile); pCont = f.read(); f.close()
        pressOp = pyTreeFoam.strOp(pCont)
        p = pressOp.skipFoamFile(0)
        p = pressOp.getKeywordPointer("internalField", p)
        vals, p = pressOp.getSmallPair(p)
        pressVals = vals.split()
        #_facePress_ファイルを作成
        lines = []
        for cellNo in cellNos:
            line = pressVals[cellNo] + "\n"
            lines.append(line)
        name = patchName + "_facePress_" + maxTime + "_0"
        fpFile = dataDir + name
        files = glob.glob(fpFile + "*")
        for fileName in files:
            os.remove(fileName)
        f = open(fpFile, "w"); f.writelines(lines); f.close()
    else:
        meshDirDict = {}
        cellNosDict = {}
        faceNosDict = {}
        for pr in range(int(nProcs)):
            procNo = str(pr)
            #patchのfaceNoを取得
            maxTime = timeFolders[-1]
            region = "."
            meshDir = case.getCurrMeshDir(maxTime, region, "boundary")
            meshDirDict[pr] = meshDir
            patchConts = case.getPatchNameFromBoundary(meshDir)
            for patchCont in patchConts:
                pName, patchType, nFaces, startFace = patchCont
                if pName == patchName:
                    nFaces = int(nFaces)
                    startFace = int(startFace)
                    faceNosDict[pr] = [nFaces, startFace]
                    break
            #cellNoを取得
            ownerFile = fluidCaseDir + "/processor" + procNo + "/" + meshDir + "/owner"
            f = open(ownerFile); ownerCont = f.read(); f.close()
            ownerOp = pyTreeFoam.strOp(ownerCont)
            p = ownerOp.skipFoamFile(0)
            cont, p = ownerOp.getSmallPair(p)
            cellNos = cont.split()[startFace:startFace + nFaces]
            cellNos = list(map(int, cellNos))
            cellNosDict[pr] = cellNos
        #全体のfieldを作成
        pressValsDict = {}
        for pr in range(int(nProcs)):
            procNo = str(pr)
            maxTime = timeFolders[-1]
            #patchName（zeroGradient）の圧力を取得
            pField = couplingDict["field"]
            fieldFile = fluidCaseDir + "/processor" + procNo + "/" + maxTime + "/" + pField
            f = open(fieldFile); pCont = f.read(); f.close()
            pressOp = pyTreeFoam.strOp(pCont)
            p = pressOp.skipFoamFile(0)
            p = pressOp.getKeywordPointer("internalField", p)
            vals, p = pressOp.getSmallPair(p)
            pressVals = vals.split()
            cellAddressFile = fluidCaseDir + "/processor" + procNo + "/" + meshDirDict[pr] + "/cellProcAddressing"
            f = open(cellAddressFile); addCont = f.read(); f.close()
            addOp = pyTreeFoam.strOp(addCont)
            p = addOp.skipFoamFile(0)
            addVals, p = addOp.getSmallPair(p)
            cells = addVals.split()
            for i in range(len(cells)):
                cellNo = cells[i]
                press = pressVals[i]
                pressValsDict[cellNo] = press
        #proc毎のpressFileを作成
        for pr in range(int(nProcs)):
            procNo = str(pr)
            cellNos = cellNosDict[pr]
            lines = []
            for cellNo in cellNos:
                press = pressValsDict[cellNo]
                line = str(press) + "\n"
                lines.append(line)
            name = patchName + "_facePress_" + maxTime + "_" + procNo
            fpFile = dataDir + name
            files = glob.glob(fpFile + "*")
            for fileName in files:
                os.remove(fileName)
            f = open(fpFile, "w"); f.writelines(lines); f.close()




if __name__ == "__main__":
    import gettext
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    beforeRemeshProcess()
    remeshMapping()
    afterRemeshProcess()