#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   getOFversionWriteConfig.py
#
#       OpenFOAMのバージョンをconfigTreeFoamに書き込む
#       使い方：OpenFOAMの環境設定後、起動する
#
#   12/09/11    新規作成
#      10/15    国際化のため、修正
#   15/07/13    configの場所を変更
#   16/12/31    OF-extに対応。extのversionの場合は「ext-3.2」の用に作成する。
#   17/02/13    バグ修正（起動時にエラー発生するので修正）
#   19/08/12    python3用に書き換え
#

import os
import sys

def readWriteConfigFile(ver):
    #fileName = os.environ["TreeFoamPath"] + "/configTreeFoam"
    fileName = os.environ["TreeFoamUserPath"] + "/configTreeFoam"
    f = open(fileName)
    cont = f.readlines()
    f.close()
    if ver == None:
        ver = "XXXX"
    n = 0
    flag = 0
    for line in cont:
        if line[:9] == "OFversion":
            cont[n] = line[:9] + " " + ver + "\n"
            flag = 1
            break
        n += 1
    if flag == 0:
        cont.append(_(u"# OpenFOAMのバージョン\n"))
        cont.append("OFversion " + ver + "\n")
    f = open(fileName, "w")
    for line in cont:
        f.write(line)
    f.close()



import gettext
treeFoamPath = os.environ["TreeFoamPath"]
gettext.install("treefoam", treeFoamPath + "/data/locale")

#ver = sys.argv[1]
#ver = os.environ["WM_PROJECT_VERSION"]
openfoam = os.getenv("WM_PROJECT")
ver = os.getenv("WM_PROJECT_VERSION")
version = None
if openfoam == "OpenFOAM":
    version = ver
elif openfoam == "foam":
    version = "ext-"+ver
readWriteConfigFile(version)


