#!/usr/bin/python3  
# -*- coding: utf-8 -*-    
#
#   treefoam.py
#
#       OpenFOAM用のランチャ
#
#               programed by s.fujii
#
#   11/04/15    新規作成（ver 1.0）
#      05/08    editBoundary(grid)を追加（ver 1.1）
#      08/17    項目のダブルクリックでフォルダopen、plotWatcher追加（ver1.2）
#   12/01/01    ﾊﾞｸﾞ修正
#               reloadで数字ﾌｫﾙﾀﾞが存在しない場合、ｴﾗｰが発生していた
#               gridEditor:boundaryFieldにｺﾒﾝﾄ文がある時、正常に書き込めなかった
#               フォルダの追加削除を可能にした
#   12/01/03    gridEditorでpatchの削除を可能にした
#      01/06    ﾊﾞｸﾞ修正（ﾌｫﾙﾀﾞ名変更時、修正しない時にｴﾗｰが発生）
#      01/08    gridEditorでのpatch名の変更を可能にした
#      01/15    ﾊﾞｸﾞ修正（最初のpatch削除できなかった）。helpを表示
#      01/17    ﾊﾞｸﾞ修正（patch削除時ｺﾞﾐが残る）、ﾓﾃﾞﾙ倍率の保存方法修正
#      01/21    gridEditorｺﾏﾝﾄﾞ追加。これに伴いﾗﾝﾁｬを修正（ver1.21）
#      01/22    caseOpen, cntDictOpenボタン追加
#      02/05    windowClose時に終了処理追加
#      02/12    gridEditor:patch変更、削除時にglobal変数設定（ﾊﾞｸﾞ修正）
#      02/13    folder削除時のﾊﾞｸﾞ修正(削除するfolderが解析Caseの場合ｴﾗｰ発生)
#      02/18    treefoam,gridEditorにﾒﾆｭｰｷｰとｼｮｰﾄｶｯﾄkey追加
#      02/19    folderのｺﾋﾟｰ、貼付けを追加（ver1.22)
#      02/25    gridEditor:cellData読込みをtimerEventで実施
#      02/26    windowSizeを保存する様に変更。ﾌｫﾙﾀﾞ削除時のﾊﾞｸﾞ修正
#      03/10    iconNameを変数に変更
#      03/25    gridEditor直接起動メニューとアイコンを追加
#      04/08    フォントサイズをsystemFontのサイズに設定。copy時にgaugeを使用。
#               colWidthを保存。gridEditor:save時にgaugeを使用。
#      04/22    gridEditor:fieldの表示設定追加（ver1.23)
#      04/23    gridEditor:読込、保存時のｴﾗｰに対応
#      05/01    editorの設定追加、HD残り容量表示、表示を縞模様表示に、並列計算追加
#               gridEditorの起動方法変更
#      05/13    folderCopyを修正（同じfolderを同じ場所に10回以上copyは禁止）
#      05/20    folder削除を2回繰り返すとｴﾗｰ発生していた事を修正。
#               rootDirは削除できない様に修正。
#               configTreeFoamの修正用ｺﾏﾝﾄﾞ追加（ver1.24）
#      05/21    BOLD表示を削除（文字長さが変わる為）
#      06/02    openGridEditorDialogを修正（.displayFieldの読込み）
#      06/09    「gridEditor」ｺﾏﾝﾄﾞを修正
#      06/24    caseコピーを追加。folder複数選択可能に設定。deleteをゴミ箱へ変更。
#      07/15    popupﾒﾆｭｰを充実（ver1.25）
#      07/21    gridEDitor:第1番目のpatch名変更時のｴﾗｰ対応
#      08/05    gridEditor:最大cell内行数を変更
#      08/11    gridEditor:patch名変更・削除時、cell変更チェック追加
#      08/14    gridEditor:field名表示部修正（field削除時、表示のみ削除できなかった）
#      08/16    gridEditor:初期化時にcell(0,0),(1,0)のｸﾘｱを追加
#      08/25    gridEditor:close時に「保存して終了」を追加
#      09/11    MakePatchDialog.py:OF-2.1.0以降createBafflesが変わった為、これに対応
#      09/13    popupﾒﾆｭｰを変更（ver1.26）
#      09/17    pyTreeFoamのバグ修正
#      09/23    gridEditorのバグ修正,importするmoduleを整理(segmentation fault対策）
#               HelyxOS,結果folder削除ﾎﾞﾀﾝを追加（ver1.30）
#      10/13    結果フォルダの削除を修正（選択caseと解析caseが違っている時確認する）
#      10/14    toolTip表示を追加
#      10/29    frameのimportを廃止（dialogは残す）
#      11/03    runParallel:接続状態確認ルーチン修正
#      11/05    editBoundaryConditionDialogを修正（ﾊﾞｸﾞ）
#      11/07    caseCopyを修正（並列処理のcaseCopy時processor内の全てをcopyしていた）
#               renameで解析caseのdirが変わる場合、解析case無くなるｴﾗｰを修正
#               gridEditor:空patch追加,internalFieldｸﾘｱのｺﾏﾝﾄﾞを設定
#      11/12    caseCopyを修正（並列処理のcaseCopy時processor内のcopy処理修正）
#      11/17    runHelyxOS:caseDir, stlDir, eMeshDirを設定した上でHelyxOSを起動
#      11/21    runHelyxOS:newCaseを追加（ver1.31）
#      11/24    並列計算:processor内へのfaileｺﾋﾟｰ、削除追加
#      12/09    並列計算:multiRegionのバグ取り
#      12/16    topoSetEditor:cominedAction追加
#      12/17    topoSetEditor:表示・非表示設定修正
#   13/01/01    内部patch作成:OF-2.0に対応（ver1.32）
#      01/06    multiRegion内のfaile操作を追加
#      01/22    makeRunTopoSetを修正
#      01/27    topoSetEditorを修正（regionToCellがセットできる様に修正）
#      01/28    nRunningTreeFoamの場所を「/data」に変更
#      01/31    ﾊﾞｸﾞ修正（時々ダブってfolderが表示される事を修正
#      02/03    topoSetEditorに「newCellToFace」を追加
#      02/07    端末起動時にunicodeｴﾗｰ発生する場合あり、修正
#      02/10    folderOpenDDialogでcurrentDirを表示するように修正
#      02/11    treefoamnのiconをfileのimageに変更
#      02/17    gridEditor:cell内容に応じてﾌｫﾝﾄ色を変更
#      03/03    gridEditor:バグ修正（boundary誤読み込み発生）
#      03/04    pyTreeFoam:バグ修正（boundary誤書き込み発生）
#      03/10    gridEditor:patchContの読み込み修正
#      03/16    TreeFoam,gridEditorにsystemFont色を変数で設定
#               並列時、multiRegion判定をcellToRegionからregionPoperties有無に変更
#      04/06    「新しいcaseの作成」を追加（ver1.33）
#      04/07    menuの配置を変更（ver1.40）
#      04/14    setMultiRegionのアイコン追加、解析caseのアイコン変更、
#               gridEditor起動時にpolyMeshの場所検索をfieldDirから探す（第1優先）
#      04/18    cell(face)ZoneNamesFの高速検索に変更
#      04/30    createNewCaseをnotebookに変更
#               mesh入れ替えで同じmeshの場合、internalFieldを保存する（ver1.41）
#      05/01    unv2gmshToFoam変換にてzone名を直に書き出しするように変更
#      05/04    gridEditorの同時複数起動。HelyxOS-1.0.1起動時のdir設定のバグ修正
#      05/11    gridEditor起動時のboundaryの場所検索方法を変更
#               gridEditorのpatch名をsortして表示。（ver1.42）
#      05/12    createNewCase:tutorialsのcase表示もれがあったのを修正
#      05/13    timeFolderの編集をfirstTime,latestTime,startTimeの3種で決定。
#      05/20    multiReginをOF2.2.0に対応させる
#      05/21    multiRegionのchangeDictにUを追加
#      05/24    snappyHexのOF2.2.0対応としてHelyxOSのfeatureEdge作成を修正
#      06/09    gridEditor:patch名の「"xxx.*"」に対応した
#      06/10    gridEditor:{}付きのcellデータにｲﾝﾃﾞﾝﾄ追加。
#               boundaryField内にpatchﾃﾞｰﾀ以外(include等)がある場合も読込・保存可能
#      06/22    setMultiRegion:region名追加・変更・削除ボタンを追加
#      06/30    createBaffles, setFieldsをOF-2.2.用に修正
#      07/07    gridEditor:textEditorによる編集を追加
#      07/13    topoSetEditor:-timeｵﾌﾟｼｮﾝを削除。sourceMesh、resultMeshを表示
#      07/20    runHelyxOSDialog.getHelyxosData修正に伴う変更
#      07/27    createAndChangeCaseDialogのmesh入れ替えの表示を修正
#      08/01    rootDir,solveCaseDirが存在しなかった場合、
#               rootDir:homeDir、solveCaseDir:TreeFoamPathに設定する様変更
#      08/11    gridEditor:patch名sort時、saveFlagチェック追加
#      08/18    timeFolderの表示方法変更（latest, start, firstTimeを追加)
#               timeFolderの位置変更、menuButtonからtoolBarに変更（ver1.50）
#      08/21    createAndChangeCaseDialogを修正（バグ修正）
#      09/06    runHelyxosDialogにparaFoam起動ボタン追加
#      09/13    gridEditorのgzip、binaryﾌｧｲﾙへの対応(fieldのみ)、書込みの高速化
#               gridEditorのcellEditorバグ修正（2回目の編集できない）
#      09/15    field編集でbinaryの編集を可能にした
#      09/18    gridEditorの表示行数、nonuniform読込行数変更dialog追加
#      09/24    gridEditor:fieldの読込方法をasciiとdataに分離して読み込む
#      09/25    binaryMeshの読込書込に対応。
#      09/29    binary、gzipに完全対応（ver1.51）
#      10/04    deleteFolder時、selctCaseDirが親になっていたのを子に変更
#      10/06    多言語用に書き換え（ver1.52）
#      10/09    言語変更をmenuに追加。ｲﾝｽﾄｰﾙ後の初回起動時、$LANGの設定に合わせる
#      10/12    多言語対応（ver1.53）
#      11/02    runHlyxOS:stlのチェック、csvからsnappyDictを作り出す追加
#      11/13    fileOperationInRegion:表示を一部treeに変更（ver1.54）
#      12/02    setFieldsDictをgrid上で編集できる様に修正（ver1.55）
#      12/08    meshOperationDialogにcsvによるmesh作成を追加（ver1.56）
#      12/09    gridEditor:clipBoardをsystemのclipBoardに変更
#      12/14    TreeFoamに停止方法を追加（ver2.00）
#      12/21    TreeFoamnにlogWindow、BCPnを追加（ver2.10）
#      12/27    getFoamContents:バグ修正
#   14/01/11    getFoamContents:バグ修正
#      01/18    getSelectionTimeを修正（startTimeが実在しない場合、起動できず）
#               startTing画面が残る場合があるので、消す様に設定（ver2.11)
#      01/19    getSelectionTimeを再修正
#      02/04    csvによるsnappyでﾒｯｼｭ作成する時、csv作成後、csv編集する様に修正
#               modelSize取得時、patch座標→全stl座標で取得する様に修正
#      02/08    gridEditorバグ修正。
#      02/22    caseCopy時、log、bak、"~"ファイルをコピーしない様に修正 
#      03/01    case作成時、currentCaseにtimeフォルダが存在しないとｴﾗｰ発生を修正
#      03/02    起動時のOFversionの取得方法を修正
#      03/06    createSetFieldsDictDialogを修正
#      03/18    snappyHexMeshDialog(220)を修正、editBoundaryConditionsを修正
#               runHelyxOSDialog(220)を修正、createBlockAndSnappyDictを修正
#      04/07    fileOperationInRegion、selectFieldsForEdit、selectFolderFiles
#               のfileOpen方法を修正（asciiの場合は、直接openする）
#      04/12    snappyHexMeshDialog、snappyHexMeshDialog220でtrisurfaceﾌｫﾙﾀﾞが
#               無かった場合ｴﾗｰ発生を修正
#               createBafflesDialog220:Dictファイルを自動生成（ver2.12）
#      04/13    getFoamContents:「**.**」のfield名があった場合ｴﾗｰ発生を修正
#               環境変数:LANG、LANGUAGEとも言語を設定。(ubuntu 13.10 以降要)
#      04/14    setDataInFields, createBafflesDialogのbutton形状変更
#      05/01    foldersCasesPasteの後、reloadItemsを追加（pasteされたfolderを表示）
#           fileOperationInRegionDialog:popupMenu、toolTipを追加
#      05/03    meshOperationDialog:領域分割を2.3.0に対応
#      05/12    editBoundaryConditionに#include、inGroupsを追加（ver2.13）
#      05/14    gaugeDDialogを微修正、HELYXOS-2.0に対応。
#      05/18    runHelixosDialog、runHelyxosDialog220を微修正
#      06/01    runHelixosDialog、runHelyxosDialog220にtimeFolder追加
#      06/04    snappyHexMeshDialog、editBounadryConditionsDialogに
#               「全ての空patch削除」ﾒﾆｭｰを追加
#      06/07    splitMeshCellZones、setMultiRegionDialogを修正
#      06/11    gtkをimportして、systemのclipBoardの使用可能に修正。(ver2.20)
#               treeFoamの起動、終了をgtk形式に変更。ﾒﾆｭｰのｼｮｰﾄｶｯﾄ変更。
#      06/21    fileOperationInregionを修正
#      07/05    paraFoam起動方法を修正(ver2.21)
#      07/10    topoSetEditor起動方法を修正
#      07/12    createBlockAndSnappy:faceを追加。
#               snappyHexMesh, runHelyxOS:バグ修正
#               configTreeFoamを修正（segmentation faultが発生した為）（ver2.22）
#               runParaFoamDirを修正（　　↑　　）
#      07/15    changeConfigTreeFoam:solveCaseFixを保存
#      07/18    createBlockSnappyDictを修正
#      07/27    multiRegionの分割方法を修正、paraFoam起動方法修正
#      08/03    FOAM端末の画面サイズ変更、editBoundaryConditionDialog修正
#      08/23    editBoundaryConditionDialog:変数定義行を追加（ver2.23）
#      08/25    getfoamContents:文字列取得時のバグ修正
#      08/26    getFoamContents:binary保存時、unicodeｴﾗｰ発生を修正
#      09/02    createAndChangeCaseDialog:バグ修正（meshｺﾋﾟｰ時、ｴﾗｰ発生する）
#      09/05    treeFoam.runEditMesh:バグ修正（OF環境で起動していた。）
#               createLayerDialogを追加
#      10/12    createBCsForMultiRegionDialog:追加（ver2.24）
#      10/25    meshOperetionDialog, splitMeshCellZones:領域分割時fieldも配布
#               する様に修正。
#      10/26    gridEditor:階層型変数「$:」定義のﾈｽﾃｨﾝｸﾞ（最大10回）に対応。
#      11/04    setDataInFieldsDialog:mapFields追加
#      11/09    createBCsForMultiRegionDialog:region間境界面で自由waildCardを追加
#               selectFolderFilesDialog:ﾀﾞﾌﾞﾙｸﾘｯｸでdirectory移動やfileOpenを追加
#               createAndChangeCaseDialog:copyMeshとcurrMeshのチェックを追加
#      11/11    gridEditor, creaeBCsForMultiRegionDialogのバグ修正
#               gaugeDDialog:load時の「$:」変数解釈のバグ修正
#      11/14    createBCsForMultiRegionDialog:バグ修正
#      11/15    setMultiRegionDialog:ボタン2ヶ追加
#      11/24    fileOperationInRegionDialog:修正
#      11/29    fileOperationInRegionDialog:項目の選択表示方法を修正
#      11/30    runParallelDialog:処理方法を修正
#      12/08    runParallel, setFoamContents、makeRunTopoSet、createBaffles:修正
#      12/13    runParallelDialog:decomposeParを修正
#      12/17    createBaffleDialog:subCaseにcaseDir直下のfileのコピーを追加
#      12/23    createAndChangeCase, setMultiRegion, snappyHexMesh:バグ修正
#      12/25    meshOperationDialog:バグ修正
#      12/27    editStlFilesDialog:stlFile結合ﾎﾞﾀﾝ追加
#   15/01/05    runHelyxosDialog220:ﾊﾞｸﾞ修正
#      01/10    editStlFilesDialog:バグ修正
#      01/13    editStlFilesDialog:ボタン、toolTipを追加
#      01/14    caseCopy時、".png", ".jpg", ".obj"をｺﾋﾟｰしない様に修正
#      01/19    createSetFieldsDialog:バグ修正
#      01/25    createLayersDDialog:layerがpatch毎に設定できる様に修正
#      02/02    createSetFieldsDictDialog:バグ修正
#      02/05    casesCopy, deleteResultFoldersの作動を変更（ver2.25）
#      02/07    meshOperationDialog:領域分割時のfile配布方法を修正
#      02/08    fileOperationInRegionDialog:region選択時、fileListを再表示
#      02/09    fileOperationInRegionDialog:ﾎﾟｯﾌﾟｱｯﾌﾟﾒﾆｭｰを修正
#      02/12    createAndChangeCaseDialog:ﾊﾞｸﾞ修正
#      02/15    iniCase追加、deleteResultFoldersの作動を元に戻す、caseコピー削除
#               case貼付けをsystemClipBoardからcaseを取得
#               selReload：currentDirectoryを設定（os.getcwd()で取得できる様に）
#      02/16    setDataInFieldsDialog:バグ修正
#      02/18    setDataInFieldsDialog:mapFieldsの設定を保存する様に修正
#      02/23    fileOperationInRegionDialog:バグ修正
#      02/24    editBoundaryConditionsDialog:バグ修正、余分な行を削除
#      03/02    addDeleteRegion, editBoundaryConditions, fileOperationInRegion,
#               setMultiRegionDialogを修正
#      03/08    openGridEditorDialog, runGridEditorを修正
#      03/18    runParaFoamを修正
#      03/29    unv2abaqus.py, abaqus2fistr.py, unv2fistr.pyを追加
#      06/25    ubuntu15.04に対応。wxPythonが2.8→3.0にバージョンアップされ大幅修正
#               treeCtrl内のtoolTipは削除、gtkを削除（copy&pasteを外に出す）
#               (ver 2.30)
#      06/29    toolTipを再表示させる。
#      06/30    createBaffles:空patch不要、cyclic,mappedPatchが自動作成できる様修正
#      07/02    topoSetEditor:resultTypeに「sets」と「zones」を追加（ver 2.31）
#      07/05    gridEditorの起動方法を修正
#      07/07    runParallel:decomposeParDict内のsetPreserveを追加
#      07/10    editBoundaryConditions:バグ修正
#      07/13    clipBoardをTreeFoam/→TreeFoam/dataに移動
#      07/18    $TreeFoamUserPathを作成。version記録方法を修正
#      07/23    changeConfigTreeFoam:修正
#      07/26    changeConfigTreeFoam:ボタンを追加
#      07/27    foldersPaste,casesPaste:unicodeでpasteに変更
#      08/02    readConf:selCaseDirが存在しない場合、rootDirに設定
#      08/07    initializeTreeFoam:TreeFoamのversionの記録方法を変更
#      08/09      ↑（再度変更）
#      09/27    OnPopupItemSelected:CAD,SalomeMecaの起動方法変更（バグ修正）
#      10/10    combo_boxの定義文修正。changeTimeFolder, changeStopAtを修正
#               comboBox上でstartTiem、endTimeが修正できなかったのを修正
#      11/27    initializeTreeFoam:バグ修正。隠しファイルがい場合の言語の設定時エラー
#   16/03/02    sshfsDirを追加 (ver 2.37)
#      03/07    initializeTreeFoam:sshfs_dataファイル有無チェックを追加
#      05/04    runFoamTermDir:マウントfolderの場合の処理を変更
#      05/30    initializeTreeFoam:sshfsDirの読み取りを修正
#               pasteScpCompTransfer:サーバ内同士のコピーを追加
#      06/01    pasteScpCompTransfer:コピー先が同じ場合は、file名に
#               「_copy」が追加されるよう修正。
#      07/28    windowのサイズをwxとTreeFoamのバージョンのセットで変更する様に修正
#      09/19    server側のTreeデータ取得方法を修正
#      10/24    FOCUS_job管理メニューを追加
#      10/29    deleteFolders:ゴミ箱移動でエラーが発生した場合の処理追加
#               gnome-terminalを表で起動させ、「case貼り付け(scp圧縮転送,cp」を追加
#      11/01    treeDataの元データをcashデータとしてfolderContDataに保存
#      11/06    rootDirを選択してreloadするとエラー発生を修正（ver 2.40）
#               focusJobControlDialog.pyの起動方法修正。
#      12/01    onSelChanged:folderContをgetFolderContから取得
#               changeSolveCase:  ↑
#      12/04    class内の「__init__」の最後にreloadを追加（itemの2重表示防止）
#      12/19    addGrandChildren:serverから追加で読み取ったfolder内容を
#               folderContDataに追加。
#               onItemActivated:rootDirのDクリックは何もせず戻る様に修正。
#      12/30    OF-ext用に修正
#   17/01/03    quickReloadItemsを追加
#               insertFolder,renameFolder,foldersPaste_sub,casesPaste,
#               deleteFolder:reloadItemsをquickReloadItemsに変更。
#      01/06    onSelChanged:selCaseDirFixを設定するを追加。
#               deleteServerFoldersRm:追加（saver内folder削除）
#      01/13    deleteServerFoldersRm:バグ修正（currentCaseが変わってしまう）
#               reloadItems,quickReloadItems:バグ修正（存在しないdirの処理追加）
#      01/16    pasteScpCompTransfer,casePasteScpCompTransfer:systemClipBord内
#               の取り込み追加。
#               deleteServerFoldersRm:バグ修正（currentCaseが変化する時がある。）
#      02/09    readFolderContFile:バグ修正（サーバのmountPointを$HOME直下に
#               設定した場合、エラー発生していた。）
#               runFoamTermDir,runSolver,runPlotWatcher:バグ修正。
#               （端末起動時に「-t」→「--name=」に変更）
#      03/02    casePasteScpCompTransfer:serverのfolderをcaseCopyする時、
#               caseFolderではない場合、エラー発生していたので修正
#      03/11    runParaFoamDir:OFのcaseDir以外のfolderで、paraViewが起動できる
#               様に修正
#      03/14    sshfsServerUnmount:setLabelDataInFrameを追加
#      03/15    timerEventLog:windowSizeと分割を3回目のtimeEvent時に設定
#               __init__:wx.version()によってwindowSize変更していた処理を中止
#      03/18    setLabelDataInFrame:panal内のsolveCaseIconの書き込み追加
#               changeSolveCase:panel内のsolveCaseIconの書き込み削除
#      03/19    pasteScpCompTransfer,casePasteScpCompTransfer:serverからlocal
#               へcopyする場合をquickReloadに修正
#               pasteScpCompTransfer:pasteFolderをチェック後、caseDirとして設定
#      03/20    casePasteScpCompTransfer.getCopyNames:case貼り付けする方法を修正。
#      03/21    onIniCase,onDeleteResult,OnPopupItemResultSelected:caseDirに
#               よってreloadを変更（quickOrAllReloadItemsを追加）
#      04/11    veryQuickReloadItems:追加（folder構成をfolderContDataから取得。
#               server, localとも読みに行かないので、非常に高速）
#      04/15    getTreeDirUntilSelSolveCaseQuick:高速化のため、server側を読みに
#               行くのは、selCaseがserverの時のみに限定
#      04/25    server内caseをgridEditorで開ける様に修正（ver 2.41）
#      05/20    ssh, scp, sshfsコマンドに接頭語(sshHeader)を追加して実行する。
#      05/28    pasteScpCompTransfer, casePasteScpCompTransfer, deleteServerFoldersRm:
#               sshHeader追加する時、「" "」を追加せずに実行。
#      06/13    deleteServerFoldersRm:sshコマンド実行時にerrorCheckを廃止
#      06/18    readSshfsDataの呼び出し箇所を整形
#      06/30    複数のserverがマウントできる様に修正（ver 2.42）
#      07/04    hostCheckSshfsData:sshfs_dataが旧書式の場合、Host行を追加。
#               旧書式でも使用可能になる様に修正。
#      07/12    addPasteFolderInFolderContData,addCasePasteFolderInFolderContData:
#               貼付け時、subFolderがTree表示されていなかったので、修正。
#      07/14    createFolderContData:バグ（folderが2重に表示）修正。
#               onFolderOpen:日本語folderがopenできる様に修正。
#      07/18    getTreeDirUntilSelSolveCaseLocalServer:reloadItems時、非選択のserver内の
#               dirがクリアされてしまう為、非選択のserver内dirを保存する様に修正。
#      07/19    runServerJobControl:修正。（serverに応じたJob管理を起動する様に修正）
#      08/03    readConfig:rootDirFix,solveCaseFixの修正方法を変更
#      08/04    runEditMesh:meshOperationDialogの起動方法を修正。
#      08/09    getTreeDirUntilSelSolveCaseLocalServer:selSolveCaseがlocalでreloadした時
#               非選択のserverDirがクリアされる為、修正
#      08/17    deleteSameData:dataが無い場合、returnする様に修正（エラー停止する為）
#      09/08    createAndChangeCase,setMultiRegionDialog:solveCaseFixを引数で渡す様に変更
#      09/09    initializeTreeFoam:OFversionの取得方法を変更
#      09/12    global変数serverJobConに名大fx100を追加
#      10/03    serverJobConに"ff"を追加
#      10/11    getTreeDirUntilSelSolveCaseQuick:バグ修正（rename時、dir名の取得に誤りあった。）
#      10/14    foldersPaste,casesPaste,deleteFolders:貼り付け、case貼り付け、削除実行時
#               serverのdirが消えていたので、消えない様に修正。
#      11/12    quickReloadItems:quickReload後、server側のdirが消えるので、実行前後に
#               server側のdir保存と追加を設定。
#   18/06/05    gnome-terminalオプション「-x」を「--」に変更
#      06/12    gnome-terminalオプション「-e」を「--」に変更
#      06/17    getTreeDirUntilSelSolveCaseLocal, getNumberResult:高速化の為、修正。
#      06/19    onItemExpanded:高速化のため、孫を追加後、expandする様に修正。
#               getTreeDirUntilSelSolveCase, getTreeDirUntilSelSolveCaseLocal:
#               高速化の為、folderの取得から孫folderを取得しない様に修正。(ver 2.44)
#      06/20    readConfig:解析caseのcheckを追加。
#      06/21    deleteMountFolderInFolderContData:mountDirのfolder有無チェック追加。
#               getNumberResult:取得方法を変更。
#      06/24    onSelChanged:分割して、selChangedを追加
#               sshfsServerMount:サーバマウント後、selChangedを追加。
#      07/01    selChanged:global変数定義を追加（6/24修正時のバグ）
#      07/08    getTreeDirUntilSelSolveCase:rootのfolder取得時、子folderも追加。
#               addGrandChildren:孫folder追加時、孫folderを削除して追加する様修正
#               (6/19修正時のバグ：全てのfolderが取得できていなかったので修正）
#   19/02/03    getTreeDirUntilSelSolveCase:rootの孫folderの一部の取得追加。
#               (selCaseDir, solveCaseDir系列の孫のみ取得）（6/19修正時のバグ）
#      02/28    timerEventLog:text_ctrl内の最終行が表示されなかったので修正。
#      03/03    timerEventLog,delTextLog:0.2sのdelayでlogを表示させる様に修正。
#               __init__:windowSizeをwx.versionに合わせて修正するように修正
#      04/03    delTextLog:log削除方法変更（直接textCtrlから削除）
#               timerEventLog:logを削除しながら追加する様に修正
#               runThread_waitShowLog:追加（log表示thread）
#      04/16    gettextの処理方法修正（pylintでエラー発生する為）
#   19/05/21    runTopoSetEditor:toposetEditor起動方法を修正
#               OF-v1812対応でv1812用のtopoSetEditorを作成
#      05/22    initializeTreeFoam,sysPasteFolders:cpをshutil.copyに修正
#      07/03    timerEventLog:python2.7.16用に修正。
#               logFileが更新されても更新分が読み込めないので修正
#   19/08/16    GTK+3, python3用に大幅修正(ver 3.00)
#   20/02/02    関係する全スクリプト修正完
#      03/12    バグ取り
#      04/20    多言語化対応(ver 3.02)
#      05/28    getFilePathFromUris:filePathの取得を
#               GLib.filename_from_uri(uri)[0] に変更。
#               日本語のpathを含む場合、drag&dropでエラーが発生する為。
#      07/19    runParaFoam:解析caseでないDirをdoubleClickしてparaViewを起動する時、
#               解析caseでparaViewが起動してしまう為、修正（バグ）
#      07/25    editProperties,editDict:editorをfoamEditorから通常のeditorに修正
#               foamEditorの場合、editorを閉じないと修正が反映されないため。
#      07/29    changeCursor:solveCaseDirを選択した時、comboBoxを再表示させる。
#      08/02    setItemsToComboBox:startTimeの取得方法をfloatで比較して取得する様に修正。
#               実在するtimeFolder名にする為。(ver 3.04)
#      08/25    dragDataReceived:日本語を含むpathの場合、dragできない旨エラー表示追加
#      09/15    threadNewCase:newCaseを作成した時、pasteDir以下をreloadして、
#               newCaseを選択表示する様に修正。(ver 3.05)
#      11/15    setItemsToComboBox:バグ修正
#               combo_startFromの内容が正しく表示されなかった事を修正
#      11/16    iniCase:case初期化後、選択表示がおかしかった事を修正
#   21/05/07    getColumnNoFromPos:treeViewのheader位置がmousePosから検出できていない
#               為、header位置が検出できる様に修正
#      05/11    clearStatusBar:HDD容量取得をpyTreeFoamに移動
#               threadGetHddResults:threadを投入して、HDD容量、結果folder内容を
#               取得し、表示する。
#      05/20    checkHddResults:GLib.timeout_add()でtimerEventを発生させ、その度に
#               threadを投入していたが、直に起動してHDD容量、結果folder内容を取得
#               する様に修正。（thread内でGUIを操作すると、cpu負荷大時にハングする場合がある為）
#      06/01    threadGetHddResults, procGetHddResults:subprocess側でエラーが発生した事を検出し
#               エラー発生の場合は、timerEventを停止させる様に修正。
#               keyPress:[Delete],[Return],[F2]キーのevent追加。
#      06/05    deleteFolders:currDirが削除される事があるので、削除前にcurrDirを
#               $treeFoamPathに設定。(currDirが削除されるとsystemError発生)
#      06/06    showTreeViewAfterDelete:削除後の選択表示の方法を修正
#               main:「self.treeView.grab_focus()」を追加。
#               focusしないと、key_eventが効かない為（起動直後はkey_event効かない）
#      06/12    procGetHddResults:エラーチェックを厳格に行う。
#               changeCursor:treeのDirをチェック時、timer5sのeventが停止していた場合
#               timer5sEventを再起動させる様に修正
#      06/19    clearStatusBar:HDD容量チェックのdirをsolveCaseDirに変更
#      06/22    矢印key(↓↑→←)でtree内が移動できる様に修正。
#      07/19    renameFolder:バグ修正。delKeysの取得方法を修正
#      07/31    doubleClickRow:「colNo==-1」を「colNo<0」に変更
#      08/05    threadPaste:fileをpasteした時、選択標示されない為、修正
#               pasteUsingServer.ending: ↑
#      08/12    threadGetHddResults:HddResultの読込エラー回数が制限を超えた場合、
#               threadを停止するように修正。
#      09/20    getTreeFoamNo:PIDの取得方法を修正。
#               TreeFoamの初期化ができない事がある為。
#      09/23    initialize:OpenFOAMのversionが取得できない場合、
#               errorMessageを出力する様に修正。
#      11/18    changeStopAtCombo, changeStartFromCombo, changeInterval:
#               <enter>入力時は、全項目(Stop, Start, interval)取得する様に修正。
#      11/25    runMeshViewer:新規追加（meshViewerの起動）
#      12/17    onRunMeshViewer:meshViewer起動icon追加
#   22/01/04    setPopupMenuItems:meshViewer起動のmenuを追加。
#      01/08    threadNewCase:最初の起動時のfileOpen時、fileが存在
#               しない事があり、エラー発生する為、修正。
#      01/10    procGetHddResults:エラーチェック方法を修正。
#      01/22    changeCursor:timer5sが停止しているかどうかのチェックを追加。
#               停止している場合は、再起動させる。
#      01/27    setPopupMenuItems,showPopupMenu:popupMenuのaccelerator名の
#               表示を修正。
#          treeDa     keyPress:gladeファイル中にacceleratorを記述した為、
#               ここから削除した。
#      01/30    treefoam.glade:menuPasteFieldsMappingを追加。
#      02/02    threadPaste,threadPasteCases:copyLocalToLocalの戻り値が"error"
#               の場合、errorDialogを表示させる様に修正。
#      02/24    keyPress:acceleratorを復活し、glade内のacceleratorを削除。
#               entryのkeyが取られる為。
#      03/12    threadPaste,threadPasteCases:linkエラー時のlink元をコピー
#               した時に警告dialogを表示。
#      05/27    runcad:実行コマンドを修正。print(comm)追加。
#               runParaFoam,runSalome:print(comm)追加。
#      07/17    runSolver:teeをteeCorrect.pyに変更(OF-10対応)
#      07/18    topoSetEditor:OFversioncheck方法修正（OF-10対応）
#      07/22    menu名を修正（mapFields貼り付け→fieldのmapping貼り付け）
#               helpUsage:viewerをfirefox→evinceに変更。
#               snap版のfirefoxに変更された為、home外のfileに
#               アクセスできなくなった為。
#   23/01/30    runSolver:実行シェルスクリプトに「2>&1」を追加。
#      02/28    runCouplig:流体-構造連成解析を追加
#      07/28    setVisibleOfButton:toolBarのfsiボタンの非表示設定を追加
#               setGtkObject:menuBarのmenuCouplingの非表示設定
#   24/02/17    multiRegionDB内のregionWallBoundaryConditionsDict_11を
#               OF-11用で新設。
#      04/08    iniCase:バグ修正。
#      07/21    plotWatcher:plotWatcherの起動方法を修正（仮想環境を追加）
#      07/29    openFolderDialog:universalDialogs内の関数名変更による修正
#      08/01    universalDialogs:全dialogに対しfuncOk、親windowを設定
#      08/07    setLanguage:「localectl」commandでの言語変更を追加。
#      09/10    initialize:xclip,wl-clipboardのinstallCheckを追加。
#   25/02/18    plotWatcher:plotWatcherの起動方法を修正（TreeFoamの外に出す）
#               checkUserSettingFile:runPlotWatcher-venv有無チェック追加。
#               無ければcopyする。（configTreeFoamに追加したため）
#      07/04    onSigUser1:signal.SIGUSER1の受信待機を追加。
#      07/06    gridEditor:currTime取得結果のチェックを追加。
#      07/16    runSolver_run:controlDict内のapplicationが空白の場合の処理追加。
#               application=""でsolver!=""の場合、application="foamRun"を追加
#      07/17    topoSetEditor:OF-13用を追加（使用できないmessage追加）
#      07/21    runSolver_run:applicationチェック修正をpyTreeFoam.getControlDictに移動
#

#------------- glade (ui) ファイルの翻訳方法 -----------------
#   1) gladeファイルにdomainを追加
#       projectのpropertyにdomain名を設定する。
#       gladeファイルの以下行にdomeinが追加される。
#       <interface domain="treefoam">
#   1) または、gladeファイルにdomainを追加せずに、
#      builder定義後、domainをセットする。
#       builder = Gtk.Builder()
#       builder.set_translation_domain("treefoam")
#   2) 以下の2行を追加
#       import locale
#       locale.bindtextdomain(domainName, localeDir)
#   以上の修正でgladeファイル内の指定した文字列が翻訳される。
#     「翻訳可能な文字列」として設定した文字列を翻訳する。
#     その文字列は、xgettextで通常通り文字列が取得できる。
#-------------------------------------------------------------


import os

try:
    startFile = open(os.getenv("startingFile"), "w")
    startFile.write("importing module...\n")
except:
    pass

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, Gdk, GdkPixbuf, Pango, GLib, Gio
import sys
import glob
import shutil
import threading
import time
import subprocess
import signal

import python.pyTreeFoam as pyTreeFoam
import python.progressBar as progressBar
import python.runParaFoamOptionDDialog as runParaFoamOptionDDialog
import python.changeConfigTreeFoamDDialog as changeConfigTreeFoamDDialog
import python.mountServerDDialog as mountServerDDialog
import python.universalDialogs as unvDlg
import python.selectFolderFilesDialog as selectFolderFilesDialog
import python.inputTextDDialog as inputTextDDialog
import python.copyPasteFolders as copyPasteFolders
import python.meshViewerControl as meshViewerControl

import locale
#----Dexcs用追加--------------
import pyDexcsSwak
#-----------------------------

#glade(ui)ファイル内を翻訳
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

try:
    startFile.write("loading TreeFoam...\n")
except:
    pass

version = "3.31-250809+dexcsSwak"
homePath = os.getenv("HOME")        #homePathを定義
treeFoamPath = os.getcwd()          #treeFoamのpath
treeFoamUserPath = ""
nRunningTreeFoam = "nRunningTreeFoam"       #TreeFoamの起動No保存用ファイル名
nTreeFoam = ""                              #TreeFoamの起動数

builder = ""
mainWindow = ""

treeData = []                   #folderのtreeData
folderContDict = {}             #folder内容の辞書
treeSize = (800, 500)           #windowSize(width, height)
splitWidth = 400                #logWindowの高さ
colWidth = [300,                #Tree width
            200,                #solver width
            40,                 #BCPn width
            40,                 #nR width
            60,                 #st width
            60]                 #ed width
winSizeFile = "data/winSize"    #windowSizeの保存場所
OFversionFix = ""               #OpenFOAMのバージョン
clipboardFile = ""              #clipboard用

rootDir = homePath
solveCaseDir = rootDir + "/CAE/CAE-FOAM/OF-v1906/regCase_MR2_copy0"
selCaseDir = solveCaseDir

envOpenFOAMFix = ""             #OpenFOAMの環境設定file
logFileFix = ""                 #logFile名

serverDirs = []                 #serverをマウントしたDir

serverJobCon = {                #serverAddressとjob管理スクリプト
    "ff01.j-focus.jp": "focusJobControlDialog.py",
    "ff02.j-focus.jp": "focusJobControlDialog.py",
    "ff": "focusJobControlDialog.py",
    #"cx.cc.nagoya-u.ac.jp": "nagoyaCxJobControlDialog.py",
    #"fx.cc.nagoya-u.ac.jp": "nagoyaFxJobControlDialog.py",
    "vector1.archi.gifu-nct.ac.jp": "gridEngineJobControlDialog.py"
    }


#  ---------
#  windowApp
#  ---------
#    GUIの起動と終了
class windowApp():

    #  GUIの初期化
    def __init__(self):
        global builder, mainWindow
        builder = Gtk.Builder()
        #gladeファイル内の翻訳為、domainを定義
        builder.set_translation_domain("treefoam")
        #gladeファイル読み込み
        builder.add_from_file(os.path.dirname(os.path.abspath(__file__)) + os.sep + "treefoam.glade")
        #windowを定義
        mainWindow = builder.get_object("window1")
        mainWindow.connect("delete-event", self.close)
        #発信するsignalを接続
        builder.connect_signals(self)
        #GtkObjectの定義
        self.setGtkObject()
        #iconの定義
        iconDir = treeFoamPath + "/icons"
        iconFile = GdkPixbuf.Pixbuf.new_from_file
        self.iconFolder = iconFile(iconDir+"/folder16.png")
        self.iconFolderCk = iconFile(iconDir+"/folderCheck16.png")
        self.iconFolderLn = iconFile(iconDir+"/folderLink16.png")
        self.iconFolderLnCk = iconFile(iconDir+"/folderLinkCheck16.png")
        self.iconCase = iconFile(iconDir+"/x-office-document16.png")
        self.iconCaseCk = iconFile(iconDir+"/x-office-document_check16.png")
        self.iconCaseLn = iconFile(iconDir+"/x-office-document_link16.png")
        self.iconCaseLnCk = iconFile(iconDir+"/x-office-document_link_check16.png")
        self.iconSalome = iconFile(iconDir+"/edit-copy16.png")
        self.iconSalomeCk = iconFile(iconDir+"/edit-copyCheck16.png")
        self.iconSalomeLn = iconFile(iconDir+"/edit-copyLink16.png")
        self.iconSalomeLnCk = iconFile(iconDir+"/edit-copyLinkCheck16.png")
        self.iconServerFolder = iconFile(iconDir+"/serverFolder16.png")
        self.iconServerFolderCk = iconFile(iconDir+"/serverFolderCheck16.png")
        self.iconServerFolderLn = iconFile(iconDir+"/serverFolderLink16.png")
        self.iconServerFolderLnCk = iconFile(iconDir+"/serverFolderLinkCheck16.png")
        self.iconSolver = iconFile(iconDir+"/folder-documents16.png")
        self.iconBlank = None
        #fontの定義
        self.NORMAL = Pango.Weight.NORMAL   #標準
        self.BOLD = Pango.Weight.BOLD       #bold
        #treeStoreの位置定義
        self.COL_ICON = 0               #folderIcon
        self.COL_DIR = 1                #dir名
        self.COL_ICON_SOLVER = 2        #solverIcon
        self.COL_SOLVER = 3             #solver名
        self.COL_BCPN = 4               #BCPn
        self.COL_NR = 5                 #nR
        self.COL_ST = 6                 #st
        self.COL_ED = 7                 #ed
        self.COL_WEIGHT = 8             #Pango.weight(bold)
        self.COL_COLOR = 9              #fontColor
        #eventをmaskするflag
        self.maskTreeEvent = True       #eventをmask
        #選択caseのpath,clickModeを保存
        self.beforeSelectPathes = []
        self.clickMode = "click"        #"click" or "rightClick"
        # #tooltip関連
        self.toolTipDict = {
            -2: "",
            -1: _("ここをダブルクリックすると、\n  解析caseとして設定します。"),
            0 : _("ここをダブルクリックすると、\n  folderを開きます。"),
            1 : _("ここをダブルクリックすると、\n  controlDictを開きます。"),
            2 : _("ここをダブルクリックすると、\n  paraFoamを起動します。")
            }
        #threadの結果
        self.threadShowTreeDir = ""     #timerEventのthread終了後、表示させるdir
        self.threadResult = ""          #threadの実行結果（「""」以外はエラー）
        self.timer5s = "on"             #5s timer をセット
        self.gettingHddResults = "no"   #取得中のflag
        self.errorCountHddResult = 0    #error発生回数
        self.running5sEvent = "no"      #timerチェック用。timer内で"yes"がセットされる。
        self.checking5sEvent = "no"     #timerチェック中のflag
        #treeのicon設定用辞書作成
        self.createIconDict()
        self.meshViewer = ""            #meshViewerClass
        #signal受信を待機
        signal.signal(signal.SIGUSR1, self.onSigUser1)



    #  GUIの表示
    def main(self):
        #solveCaseDirがserver内かチェック
        self.checkCaseDirInServer()
        #directoryの構成を読み込み
        getTreeDirLocalServer(rootDir, selCaseDir, solveCaseDir)
        #treeDataを作成
        createTreeData(rootDir)
        #TreeFoamのtitleを設定
        self.setTreeFoamTitle()
        #windowSizeを設定
        self.setWindowSize()
        #treeDir、case内容を表示
        self.setTreeDataCaseConts()     #treeViewを作成する
        #popupMenuを設定
        self.setPopupMenuItems()
        #treeViewの原点を取得
        dummy_x0, y0 = self.treeView.convert_tree_to_widget_coords(0,0)
        #startFileをclose
        startFile.write("close\n")
        startFile.close()
        #GUIを表示
        mainWindow.show_all()
        #treeVieの原点のズレ量を取得
        dummy_x1, y1 = self.treeView.convert_tree_to_widget_coords(0,0)
        self.shift_y = y1 - y0
        #logFileの出力設定
        self.setLogOutput()
        #treeViewにfocusする(treeViewにconnectしたkey_eventが効かない為)
        self.treeView.grab_focus()
        #HDD, nResのチェック設定
        self.timer5s = "on"
        self.runCheckHddResults()
        #Gtkのloop
        Gtk.main()

    #
    #  GUIの終了
    #
    def close(self, *args):
        #meshViewerの処理
        if self.meshViewer != "":
            self.meshViewer.closeViewer()
        Gtk.main_quit(*args)

    #
    #  setGtkObject
    #
    def setGtkObject(self):
        #Treeの定義
        self.treeView = builder.get_object("treeList")
        #GtkBox（サイズ）の定義
        self.boxLogWindow = builder.get_object("GtkBoxLog")
        #GtkPaned（サイズ）の定義
        self.panedWin = builder.get_object("GtkPanedLog")
        #labelの定義
        self.label_caseDir = builder.get_object("label_caseDir1")
        self.label_OFenv = builder.get_object("label_OFenv1")
        self.label_solver = builder.get_object("label_solver1")
        self.label_logFile = builder.get_object("label_logFile")
        #comboBoxの定義
        self.combo_start = builder.get_object("combo_start")
        self.combo_stop = builder.get_object("combo_stop")
        #entryの定義
        self.entry_start = builder.get_object("entry_start")
        self.entry_stop = builder.get_object("entry_stop")
        self.entry_interval = builder.get_object("entry_interval")
        #textViewの定義
        self.text_log = builder.get_object("textView_log")
        #buttonの定義
        self.button_config = builder.get_object("configTreeFoam")
        self.button_changeRoot = builder.get_object("changeRoot")
        self.button_reload = builder.get_object("reload")
        self.button_exit = builder.get_object("exit")
        self.button_currCase = builder.get_object("currentCase")
        self.button_newCase = builder.get_object("newCase")
        self.button_editMesh = builder.get_object("editMesh")
        self.button_topoSet = builder.get_object("topoSetEditor")
        self.button_multiRegion = builder.get_object("setMultiRegion")
        self.button_gridEditor = builder.get_object("gridEditor")
        self.button_editField = builder.get_object("editField")
        self.button_dataSet = builder.get_object("dataSetClear")
        self.button_editPro = builder.get_object("editProperty")
        self.button_editDict = builder.get_object("editDict")
        self.button_iniCase = builder.get_object("iniCase")
        self.button_delResult = builder.get_object("deleteResult")
        self.button_solver = builder.get_object("runSolver")
        self.button_plotWatcher = builder.get_object("plotWatcher")
        self.button_para = builder.get_object("runParallel")
        self.button_fsi = builder.get_object("runFsi")
        self.button_cad = builder.get_object("runCad")
        self.button_foamTerm = builder.get_object("runFoamTerm")
        self.button_paraFoam = builder.get_object("runParaFoam")
        self.button_salome = builder.get_object("runSalome")
        self.button_editCntDict = builder.get_object("editControlDict")
        self.button_openLog = builder.get_object("openLog")
        #labelの定義
        self.label_startFrom = builder.get_object("label_startFrom")
        self.label_stopAt = builder.get_object("label_stopAt")
        self.label_writeInterval = builder.get_object("label_writeInterval")
        self.label_status = builder.get_object("label_status")
        #drag eventの設定
        #  treeViwへのdrop設定
        self.treeView.connect("drag-data-received", self.onDragDataReceived)
        dnd_list = Gtk.TargetEntry.new("text/uri-list", 0, 0)
        self.treeView.enable_model_drag_dest(
            [dnd_list],
            Gdk.DragAction.COPY )
        #  treeViewからdrag設定
        self.treeView.enable_model_drag_source(
            Gdk.ModifierType.BUTTON1_MASK,
            [dnd_list],
            Gdk.DragAction.COPY )
        self.treeView.connect("drag-data-get", self.onDragDataGet)
        #  dragIcon設定
        self.treeView.connect_after("drag-begin", self.onDragBegin)
        #  posのy方向ズレ量
        self.shift_y = 0      #表示後、取得
        #key eventの設定
        self.ctrlKeyFlag = 0        #ctrlKeyのflag設定
        self.treeView.connect("key-press-event", self.onKeyPress)
        self.treeView.connect("key-release-event", self.onKeyRelease)
        #menuBar関連
        self.menuItemChangeConfig = builder.get_object("menuChangeConfig")
        self.menuItemChangeRoot = builder.get_object("menuChangeRoot")
        self.menuItemReload = builder.get_object("menuReload")
        self.menuItemClose = builder.get_object("menuClose")
        self.menuItemCurrentCase = builder.get_object("menuCurrentCase")
        self.menuItemNewCase = builder.get_object("menuNewCase")
        self.menuItemEditMesh = builder.get_object("menuEditMesh")
        self.menuItemTopoSetEditor = builder.get_object("menuTopoSetEditor")
        self.menuItemMultiRegion = builder.get_object("menuMultiRegion")
        self.menuItemOpenFolder = builder.get_object("menuOpenFolder")
        self.menuItemGridEditor = builder.get_object("menuGridEditor")
        self.menuItemEditField = builder.get_object("menuEditField")
        self.menuItemSetFields = builder.get_object("menuSetFields")
        self.menuItemEditProperties = builder.get_object("menuEditProperties")
        self.menuItemEditDictionary = builder.get_object("menuEditDictionary")
        self.menuItemCopy = builder.get_object("menuCopy")
        self.menuItemPaste = builder.get_object("menuPaste")
        self.menuItemPasteCase = builder.get_object("menuPasteCase")
        self.menuItemRenameFolder = builder.get_object("menuRenameFolder")
        self.menuItemAddNewFolder = builder.get_object("menuAddNewFolder")
        self.menuItemDeleteFolder = builder.get_object("menuDeleteFolder")
        self.menuItemIniCase = builder.get_object("menuIniCase")
        self.menuItemDeleteRes = builder.get_object("menuDeleteRes")
        self.menuItemRunSolver = builder.get_object("menuRunSolver")
        self.menuItemPlotWatcher = builder.get_object("menuPlotWatcher")
        self.menuItemParallel = builder.get_object("menuParallel")
        self.menuItemCoupling = builder.get_object("menuCoupling")
        self.menuItemRunCad = builder.get_object("menuRunCad")
        self.menuItemRunFoamTerm = builder.get_object("menuRunFoamTerm")
        self.menuItemRunParaFoam = builder.get_object("menuRunParaFoam")
        self.menuItemRunSalome = builder.get_object("menuRunSalome")
        #----Dexcs用追加--------------
        self.menuItemRunDexcsDispBlockMesh = builder.get_object("menuRunDexcsDispBlockMesh")
        self.menuItemRunDexcsBlockMesh = builder.get_object("menuRunDexcsBlockMesh")
        self.menuItemRunDexcsCfMesh = builder.get_object("menuRunDexcsCfMesh")
        self.menuItemRunDexcsCheckMesh = builder.get_object("menuRunDexcsCheckMesh")
        self.menuItemRunDexcsAllrun = builder.get_object("menuRunDexcsAllrun")
        self.menuItemRunDexcsAllclean = builder.get_object("menuRunDexcsAllclean")
        self.menuItemRunDexcsSubmitJob = builder.get_object("menuRunDexcsSubmitJob")
        self.menuItemRunDexcsSubmitStatus = builder.get_object("menuRunDexcsSubmitStatus")
        self.menuItemRunDexcsJGP = builder.get_object("menuRunDexcsJGP")
        self.menuItemRunDexcsPlotTool = builder.get_object("menuRunDexcsPlotTool")
        self.menuItemRunDexcsKdiff3 = builder.get_object("menuRunDexcsKdiff3")
        self.menuItemRunDexcsSearch = builder.get_object("menuRunDexcsSearch")
        #-----------------------------
        #menuBarの非表示設定
        self.showMenuSetting = [
            #   menu項目                  非OF
            [self.menuItemChangeConfig,   True],
            [self.menuItemChangeRoot,     True],
            [self.menuItemReload,         True],
            [self.menuItemClose,          True],
            [self.menuItemCurrentCase,    True],
            [self.menuItemNewCase,        True],
            [self.menuItemEditMesh,       False],
            [self.menuItemTopoSetEditor,  False],
            [self.menuItemMultiRegion,    False],
            [self.menuItemOpenFolder,     True],
            [self.menuItemGridEditor,     False],
            [self.menuItemEditField,      False],
            [self.menuItemSetFields,      False],
            [self.menuItemEditProperties, False],
            [self.menuItemEditDictionary, False],
            [self.menuItemCopy,           True],
            [self.menuItemPaste,          True],
            [self.menuItemPasteCase,      True],
            [self.menuItemRenameFolder,   True],
            [self.menuItemAddNewFolder,   True],
            [self.menuItemDeleteFolder,   True],
            [self.menuItemIniCase,        False],
            [self.menuItemDeleteRes,      False],
            [self.menuItemRunSolver,      False],
            [self.menuItemPlotWatcher,    False],
            [self.menuItemParallel,       False],
            [self.menuItemCoupling,       False],
            [self.menuItemRunCad,         True],
            [self.menuItemRunFoamTerm,    True],
            [self.menuItemRunParaFoam,    True],
            [self.menuItemRunSalome,      True]
        ]

    #
    #  createIconDict
    #------------------
    def createIconDict(self):
        """ Treeのicon設定用の辞書を作成する。"""
        #local用のicon
        self.iconLocalDict = {
            #foltype        iconTree            iconSolber       checkIcon
            "folder":       (self.iconFolder,   self.iconBlank,  self.iconFolderCk),
            "folderLink":   (self.iconFolderLn, self.iconBlank,  self.iconFolderLnCk),
            "case":         (self.iconCase,     self.iconSolver, self.iconCaseCk),
            "caseLink":     (self.iconCaseLn,   self.iconSolver, self.iconCaseLnCk),
            "salome":       (self.iconSalome,   self.iconBlank,  self.iconSalomeCk),
            "salomeLink":   (self.iconSalomeLn, self.iconBlank,  self.iconSalomeLnCk)
            }
        #server用のicon
        self.iconServerDict = {
            "folder":       (self.iconServerFolder,   self.iconBlank,  self.iconServerFolderCk),
            "folderLink":   (self.iconServerFolderLn, self.iconBlank,  self.iconServerFolderLnCk),
            "case":         (self.iconCase,           self.iconSolver, self.iconCaseCk),
            "caseLink":     (self.iconCaseLn,         self.iconSolver, self.iconCaseLnCk),
            "salome":       (self.iconSalome,         self.iconBlank,  self.iconSalomeCk),
            "salomeLink":   (self.iconSalomeLn,       self.iconBlank,  self.iconSalomeLnCk)
            }
        

    #
    #  handler（eventの処理）---------
    #
    #---- menuBar -------------------------
    #configTreeFoam
    def menuChangeConfig(self, event):
        self.configTreeFoam()
    #changeRoot
    def menuChangeRoot(self, event):
        self.changeRoot()
    #reload
    def menuReload(self, event):
        self.reload()
    #exit
    def menuClose(self, event):
        self.exitTreeFoam()
    #解析case設定
    def menuCurrentCase(self, event):
        self.setCurrentCase()
    #newCase
    def menuNewCase(self, event):
        self.newCase()
    #mesh操作
    def menuEditMesh(self, event):
        self.editMesh()
    #topoSet
    def menuTopoSetEditor(self, event):
        self.topoSetEditor()
    #multiRegion操作
    def menuMultiRegion(self, event):
        self.setMultiRegion()
    #folder開く
    def menuOpenFolder(self, event):
        openFolder(selCaseDir)
    #gridEditor起動
    def menuGridEditor(self, event):
        self.gridEditor()
    #foamEditor起動
    def menuEditField(self, event):
        self.editField(solveCaseDir)
    #dataSetClear
    def menuSetFields(self, event):
        self.dataSetClear()
    #properties編集
    def menuEditProperties(self, event):
        self.editProperties()
    #Dict編集
    def menuEditDictionary(self, event):
        self.editDict()
    #コピー
    def menuCopy(self, event):
        self.copyFolders()
    #貼り付け
    def menuPaste(self, event):
        self.pasteFolders()
    #case貼り付け
    def menuPasteCase(self, event):
        self.pasteCases()
    #mesh貼り付け
    def menuPasteMesh(self, event):
        self.pasteMesh()
    #mapFields
    def menuPasteFieldsMapping(self, event):
        self.pasteFieldsMapping()
    #rename
    def menuRenameFolder(self, event):
        self.renameFolder()
    #新しいfolder追加
    def menuAddNewFolder(self, event):
        self.addNewFolder()
    #folder削除
    def menuDeleteFolder(self, event):
        self.deleteFolders()
    #case初期化
    def menuIniCase(self, event):
        self.iniCase()
    #計算結果削除
    def menuDeleteRes(self, event):
        self.deleteResult()
    #計算開始
    def menuRunSolver(self, event):
        self.runSolver()
    #残渣の確認
    def menuPlotWatcher(self, event):
        self.plotWatcher()
    #並列計算
    def menuParallel(self, event):
        self.runParallel()
    #流体-構造連成解析
    def menuRunCoupling(self, event):
        self.runCoupling()
    #CAD起動
    def menuRunCad(self, event):
        self.runCad(solveCaseDir)
    #FOAM端末起動
    def menuRunFoamTerm(self, event):
        self.runFoamTerm(solveCaseDir)
    #meshViewer起動
    def menuRunMeshViewer(self, event):
        self.runMeshViewer(solveCaseDir)
    #paraFoam起動
    def menuRunParaFoam(self, event):
        self.runParaFoam(solveCaseDir)
    #salome起動
    def menuRunSalome(self, event):
        self.runSalome(solveCaseDir)
    #使い方
    def menuUsage(self, event):
        self.helpUsage()
    #version表示
    def menuVersion(self, event):
        self.helpVersion()
     #—-Dexcs用追加————–
    def menuRunDexcsDispBlockMesh(self,event):
        self.runDexcsDispBlockMesh(event)
    def menuRunDexcsBlockMesh(self,event):
        self.runDexcsBlockMesh(event)
    def menuRunDexcsCfMesh(self,event):
        self.runDexcsCfMesh(event)
    def menuRunDexcsCheckMesh(self,event):
        self.runDexcsCheckMesh(event)
    def menuRunDexcsAllrun(self,event):
        self.runDexcsAllrun(event)
    def menuRunDexcsAllclean(self,event):
        self.runDexcsAllclean(event)
    def menuRunDexcsSubmitJob(self,event):
        self.runDexcsSubmitJob(event)
    def menuRunDexcsSubmitStatus(self,event):
        self.runDexcsSubmitStatus(event)
    def menuRunDexcsJGP(self,event):
        self.runDexcsJGP(event)
    def menuRunDexcsPlotTool(self,event):
        self.runDexcsPlotTool(event)
    def menuRunDexcsKdiff3(self,event):
        self.runDexcsKdiff3(event)
    def menuRunDexcsSearch(self,event):
        self.runDexcsSearch(event)
    #—————————–
    #----- toolBar -------------------------
    #configTreeFoam
    def onConfigTreeFoam(self, event):
        self.configTreeFoam()
    #changeRoot
    def onChangeRoot(self, event):
        self.changeRoot()
    #reload
    def onReload(self, event):
        self.reload()
    #exit
    def onExit(self, event):
        self.exitTreeFoam()
    #setCurrentCase
    def onCurrentCase(self, event):
        self.setCurrentCase()
    #newCase
    def onNewCase(self, event):
        self.newCase()
    #mesh操作
    def onEditMesh(self, event):
        self.editMesh()
    #topoSetEditor
    def onTopoSetEditor(self, event):
        self.topoSetEditor()
    #multiRegion操作
    def onSetMultiRegion(self, event):
        self.setMultiRegion()
    #gridEditor起動
    def onGridEditor(self, event):
        self.gridEditor()
    #foamEditor起動
    def onEditField(self, event):
        self.editField(solveCaseDir)
    #datasetClear
    def onDataSetClear(self, event):
        self.dataSetClear()
    #properties編集
    def onEditProperty(self, event):
        self.editProperties()
    #Dict編集
    def onEditDict(self, event):
        self.editDict()
    #case初期化
    def onIniCase(self, event):
        self.iniCase()
    #計算結果削除
    def onDeleteResult(self, event):
        self.deleteResult()
    #計算開始
    def onRunSolver(self, event):
        self.runSolver()
    #残渣の表示
    def onPlotWatcher(self, event):
        self.plotWatcher()
    #runParallel
    def onRunParallel(self, event):
        self.runParallel()
    #runCoupling
    def onRunCoupling(self, event):
        self.runCoupling()
    #CAD起動
    def onRunCad(self, event):
        self.runCad(solveCaseDir)
    #FOAM端末起動
    def onRunFoamTerm(self, event):
        self.runFoamTerm(solveCaseDir)
    #meshViewer起動
    def onRunMeshViewer(self, event):
        self.runMeshViewer(solveCaseDir)
    #paraFoam起動
    def onRunParaFoam(self, event):
        self.runParaFoam(solveCaseDir)
    #salome起動
    def onRunSalome(self, event):
        self.runSalome(solveCaseDir)
    #changeStartFrom
    def onChangeStartFromCombo(self, combo, iter):
        if self.maskTreeEvent == False:
            self.changeStartFromCombo(solveCaseDir, iter)
    #changeStartFromEntry
    def onChangeStartFromEntry(self, entry):
        if self.maskTreeEvent == False:
            self.changeStartFromEntry(solveCaseDir)
    #changeStopAt
    def onChangeStopAtCombo(self, combo, iter):
        if self.maskTreeEvent == False:
            self.changeStopAtCombo(solveCaseDir, iter)
    #changeStopAtEntry
    def onChangeStopAtEntry(self, entry):
        if self.maskTreeEvent == False:
            self.changeStopAtEntry(solveCaseDir)
    #changeInterval
    def onChangeInterval(self, event):
        if self.maskTreeEvent == False:
            self.changeInterval(solveCaseDir)
    #editControlDict
    def onEditCntDict(self, event):
        self.editCntDict(solveCaseDir)
    #openLog
    def onOpenLogFile(self, event):
        self.openLogFile()

    #----- mouse 操作 --------------------------
    #moveCursor
    #def onMoveTooltip(self, treeview, x, y, keyboard, tooltip):
    def onMoveTooltip(self, treeview, event):
        if self.maskTreeEvent == False:
            pos = (event.x, event.y)
            self.setShowTooltip(pos)
    #treeExpand
    def onTreeExpand(self, treeview, treeiter, path):
        if self.maskTreeEvent == False:
            self.treeExpandEvent(path)
    #changeCursor(leftClick)
    def onChangeCursor(self, treeview):
        if self.maskTreeEvent == False:
            (dummy_treestore, pathes) = treeview.get_selection().get_selected_rows()
            if self.clickMode == "rightClick":
                #rightClickの場合、selectionを元に戻す
                treeSelection = self.treeView.get_selection()
                for path in self.beforeSelectPathes:
                    treeSelection.select_path(path)
                self.clickMode = ""
            elif self.clickMode == "click":
                if len(pathes) == 1:
                    path = pathes[0]
                    self.changeCursor(path)
                self.clickMode = ""
    #left, rightClick, doubleClick
    def onPressMouseButton(self, widget, event):
        self.pressMouseButton(widget, event)
    #dragDataGet(treeをドラッグ)
    def onDragDataGet(self, treeView, context, data, info, time):
        self.dragDataGet(treeView, context, data, info, time)
    #dragIconを設定
    def onDragBegin(self, widget, context):
        Gtk.drag_set_icon_pixbuf(context, self.iconFolder, 0, 0)
    #dragDataReceived(treeにドロップ)
    def onDragDataReceived(self, widget, drag_context, x,y, data, info, time):
        self.dragDataReceived(widget, drag_context, x,y, data, info, time)
    #--- popupMenu -------------------------
    #openFolder
    def popOpenFolder(self, menuItem):
        openFolder(selCaseDir)
    #端末の起動
    def popRunTerm(self, menuItem):
        self.runTerm(selCaseDir)
    #解析case設定
    def popSetCurrentCase(self, menuItem):
        self.setCurrentCase()
    #FOAM端末起動
    def popRunFoamTerm(self, menuItem):
        self.runFoamTerm(selCaseDir)
    #gridEditor起動
    def popGridEditor(self, menuItem):
        self.runGridEditor(selCaseDir)
    #copyFolders
    def popCopyFolders(self, menuItem):
        self.copyFolders()
    #pasteFolders
    def popPasteFolders(self, menuItem):
        self.pasteFolders()
    #pasteCases
    def popPasteCases(self, menuItem):
        self.pasteCases()
    #pasteMesh
    def popPasteMesh(self, menuItem):
        self.pasteMesh()
    #pasteFieldsMapping
    def popPasteFieldsMapping(self, menuItem):
        self.pasteFieldsMapping()
    #renameFolder
    def popRenameFolder(self, menuItem):
        self.renameFolder()
    #新しいfolder追加
    def popNewFolder(self, menuItem):
        self.addNewFolder()
    #deleteFolders
    def popDeleteFolders(self, menuItem):
        self.deleteFolders()
    #loginシェル起動
    def popLogInShell(self, menuItem):
        self.runLoginShell()
    #serverJob管理
    def popServerJob(self, menuItem):
        self.serverJobControl()
    #sshfsによるサーバマウント
    def popServerMount(self, menuItem):
        self.sshfsServerMount()
    #サーバアンマウント
    def popServerUnmount(self, menuItem):
        self.sshfsServerUnmount()
    #貼り付け(scp圧縮転送,cp)
    def popScpPasteFolder(self, menuItem):
        self.pasteScpCompTransfer()
    #case貼り付け(scp圧縮転送,cp)
    def popScpPasteCase(self, menuItem):
        self.casePasteScpCompTransfer()
    #フォルダ削除(rm -rf)
    def popDeleteServer(self, menuItem):
        self.deleteServerFoldersRm()
    #CAD起動
    def popRunCad(self, menuItem):
        self.runCad(selCaseDir)
    #Salome起動
    def popRunSalome(self, menuItem):
        self.runSalome(selCaseDir)
    #Field編集
    def popEditFields(self, menuItem):
        self.editField(selCaseDir)
    #setFields
    def popDataSetClear(self, menuItem):
        self.dataSetClear()
    #controlDict編集
    def popEditControlDict(self, menuItem):
        self.editCntDict(selCaseDir)
    #properties編集
    def popEditProperty(self, menuItem):
        self.editProperties()
    #Dict編集
    def popEditDict(self, menuItem):
        self.editDict()
    #mesh操作
    def popEditMesh(self, menuItem):
        self.editMesh()
    #toposetEditor
    def popTopoSetEditor(self, menuItem):
        self.topoSetEditor()
    #multiRegion操作
    def popMultiRegion(self, menuItem):
        self.setMultiRegion()
    #runSolver
    def popRunSolver(self, menuItem):
        self.runSolver()
    #残渣の表示
    def popPlotWatcher(self, menuItem):
        self.plotWatcher()
    #並列処理
    def popRunParallel(self, menuItem):
        self.runParallel()
    #流体_構造連成解析
    def popRunCoupling(self, menuItem):
        self.runCoupling()
    #meshViewer起動
    def popRunMeshViewer(self, menuItem):
        self.runMeshViewer(selCaseDir)
    #paraFoam起動
    def popRunParaFoam(self, menuItem):
        self.runParaFoam(selCaseDir)
    #結果を削除
    def popDeleteResFolder(self, menuItem):
        self.deleteResult()
    #caseの初期化
    def popIniCase(self, menuItem):
        self.iniCase()
    #----- key event -----------------------
    def onKeyPress(self, treeview, event):
        self.keyPress(event)
    def onKeyRelease(self, treeview, event):
        self.keyRelease(event)
    #----- signal event --------------------
    def onSigUser1(self, signum, frame):
        self.sigUser1()

    #
    #  setLogOutput
    #
    def setLogOutput(self):
        global logFileFix
        """ log出力の設定（初期化）"""
        #初期化
        self.waitCount = 0          #表示させるためのcounter
        logFileFix = "None"
        logFile = os.getenv("LogFile")
        self.threadShowTreeDir = ""
        self.threadResult = ""
        if not(logFile == None or logFile == ""):
            #logFile名を取得
            logFileFix = logFile
            #log出力の設定
            self.logBuffer = Gtk.TextBuffer.new(None)
            self.text_log.set_buffer(self.logBuffer)
            self.text_log.set_wrap_mode(Gtk.WrapMode(1))
            #file openしてtimerEventを設定
            self.logRead = open(logFile)
            GLib.timeout_add(200, self.timerEvent)
        #logFile名を表示
        self.setLogFileName()

    #
    #  timerEvent
    #
    def timerEvent(self):
        """ logFileを読み込み、textViewに書き込む。
        textViewの最終行を表示させる為に、次のtimerEventでもscrollさせる。
        textView更新直後でscrollしても最終行が表示されない。"""
        global folderContDict
        #logFile読み込み
        addText = self.logRead.read()
        #logが追加されているか
        if addText != "":
            #waitCountをセット
            self.waitCount = 2          #counterセット
            #bufferに追加のlogをinsert
            self.logBuffer.insert(self.logBuffer.get_end_iter(), addText)
            #最終のiterを取得
            endIter = self.logBuffer.get_end_iter()
            #全行数を取得
            nLines = endIter.get_line()
            maxLines = 200
            if nLines > maxLines:
                #maxxLineを超えている場合
                delStart = self.logBuffer.get_start_iter()
                delEnd = self.logBuffer.get_iter_at_line(nLines-maxLines+50)
                #bufferから削除
                self.logBuffer.delete(delStart, delEnd)
                endIter = self.logBuffer.get_end_iter()
        #logの最終行を表示させる
        if self.waitCount > 0:          #counterをチェック
            endIter = self.logBuffer.get_end_iter()
            self.text_log.scroll_to_iter(endIter, 0, True, 0, 0)
            self.waitCount -= 1         #counterを減らす
        #threadResultを確認
        if self.threadResult != "":
            title = _("thread処理")
            mess = self.threadResult
            self.warningDialog(title, mess)
            self.threadResult = ""
        #thread終了を確認
        if self.threadShowTreeDir != "":
            #threadデータを取得
            showDir = self.threadShowTreeDir[0]
            folderConts = self.threadShowTreeDir[1]
            #追加するfolderをtimerEventでdictに保存
            for folderCont in folderConts:
                folderContDict[folderCont[0]] = folderCont[1:]
            #treeを再表示
            self.showTreeViewAtNewFolderDict(showDir)
            #threadデータをクリア
            self.threadShowTreeDir = ""
        #timerEventを設定
        GLib.timeout_add(200, self.timerEvent)

    #
    #  runCheckHddResults
    #----------------------
    def runCheckHddResults(self):
        if self.timer5s == "on":
            GLib.timeout_add(5000, self.checkHddResults)

    #
    #  checkHddResults
    #---------------------
    def checkHddResults(self):
        """ HDD容量や結果folderのチェックを定期的に行う設定。
        GLib.timeout_add()関数で起動する関数。
        戻り値が「True」の場合は、timerEventが続く。
        「False」を戻すと、timerEventは、止まる"""
        #flagをセット
        self.running5sEvent = "yes"
        #実行中の場合は、戻る
        if self.gettingHddResults == "yes":
            return
        #エラー発生時は、Falseが戻る
        resBool = self.threadGetHddResults()
        if resBool == False:
            #timerを停止
            self.timer5s = "off"
        return resBool

    #
    #  threadGetHddresults
    #----------------------
    def threadGetHddResults(self):
        """ HDD容量、結果folder内容を取得して、statusBar、treeに書き込む。
        HDD容量と結果folder内容は、timeoutを設定して、これを超える場合は、停止する。"""
        global solveCaseDir, folderContDict, rootDir
        folderDir = solveCaseDir
        if os.path.exists(folderDir) == False:
            return True
        #flagをセット
        self.gettingHddResults = "yes"
        #floderCont, typeを取得
        folderCont = folderContDict[folderDir]
        folType = folderCont[0]
        #caseの場合のみ、書き換える
        if folType == "case" or folType == "caseLink":
            #HDD容量、結果folder内容を取得。timeoutを設定
            res = self.procGetHddResults(folderDir, timeout=0.2)
            if type(res) != list:
                #エラー発生時
                print(res)          #エラー内容を出力
                text = self.label_status.get_text()
                text = "**" + text[1:]
                self.label_status.set_text(text)
                self.gettingHddResults = "no"
                return False        #Falseを戻し、次のeventを中止
            if len(res) == 0:
                #timeoutした場合
                text = self.label_status.get_text()
                text = "*" + text[1:]
                self.label_status.set_text(text)
                self.gettingHddResults = "no"
                self.errorCountHddResult += 1
                if self.errorCountHddResult > 3:
                    #停止
                    return False    
                else:
                    return True
            #正常終了した場合
            (nR, st, ed, total, free) = res
            #nR,edが変わっているか？
            if nR != folderCont[3] or ed != folderCont[5]:
                #solveCaseを書き直す
                path = self.getPathInTreeStore(rootDir, folderDir)
                treeiter = self.treestore.get_iter(path)
                self.treestore.set_value(treeiter, self.COL_NR, nR)
                self.treestore.set_value(treeiter, self.COL_ST, st)
                self.treestore.set_value(treeiter, self.COL_ED, ed)
                folderCont[3] = nR
                folderCont[4] = st
                folderCont[5] = ed
                folderContDict[folderDir] = folderCont
            #HDD内容を書き換え
            self.writeHddStatus(int(total), int(free))
            self.gettingHddResults = "no"
            return True

    #
    #  procGetHddResults
    #--------------------
    def procGetHddResults(self, folderDir, timeout=None):
        """ HDD容量、結果をtimeoutを設定して取得する"""
        #subprocessを定義
        comm = "python3 " + treeFoamPath + "/python/getHddValsResultFolders.py " + folderDir
        proc = subprocess.Popen(
            comm,
            shell=True,
            stdin=subprocess.PIPE,
            stdout=subprocess.PIPE
            )
        #subprocess実行
        try:
            outs, errs = proc.communicate(timeout=timeout)
        except:
            #timeoutした場合
            proc.kill()
            outs, errs = proc.communicate()
        #結果をbinary→strに変更
        res = outs.decode()
        if res == "":
            #timeout時
            return []
        else:
            #正常終了時（全て文字で戻す）
            #エラー発生した場合、エラー内容も含まれる。
            words = res.split(",")
            #  listの数をチェック
            if len(words) != 5:
                #エラー発生時
                words = res
            # #  戻り値の内容をチェック
            # try:
            #     nR = int(words[0])
            #     st = float(words[1])
            # except:
            #     #エラー発生時
            #     words = res
            return words

    #
    #  checkCaseDirInServer
    #-----------------------
    def checkCaseDirInServer(self):
        """ solveCaseDirがserver内かどうかチェックする。"""
        global solveCaseDir, selCaseDir
        mountServers = pyTreeFoam.servers().getMountedServers()
        if len(mountServers) == 0:
            return
        serverDirs = list(map(lambda x: x[2], mountServers))
        flag = 0
        mountServerDir = ""
        for serverDir in serverDirs:
            if solveCaseDir[:len(serverDir) + 1] == serverDir + "/":
                mountServerDir = serverDir
                flag = 1
                break
        if flag == 0:
            return
        #dialogを表示
        title = _("TreeFoam起動確認")
        mess = _("解析caseがserver内に設定されています。") + "\n"
        mess += _("  通信状況により、起動に時間がかかる事があります。")
        self.okDialog(title, mess)
        return

    #
    #  setTreeFoamTitle
    #
    def setTreeFoamTitle(self):
        """ TreeFoamのタイトルを設定する"""
        title = "TreeFoam_" + version + " (" + nTreeFoam + ")"
        mainWindow.set_title(title)

    #
    #  setWindowSize
    #
    def setWindowSize(self):
        """ windowのサイズを設定する"""
        global treeSize, splitWidth
        #全体のwidowSize
        (x,y) = treeSize
        mainWindow.set_default_size(x, y)
        #logWindowのheight設定(GtkBoxのサイズ設定)
        self.panedWin.set_position(splitWidth)

    #
    #  self.setLogFileName()
    #
    def setLogFileName(self):
        self.label_logFile.set_label(logFileFix)

    #
    #  setPopupMenuItems
    #
    def setPopupMenuItems(self):
        #popupMenu項目
        self.dirMenuItems = [
            #  ラベル                     accName 非slvCase 非OF　 handler　　　　　 iconFile名      accelerator名(表示のみ)
            [_("開く"),                     "Return", True,  True,  self.popOpenFolder, ""],
            [_("端末の起動"),               "",       True,  True,  self.popRunTerm, "runTerm.png"], 
            [_("解析caseとして設定"),       "",       True,  True,  self.popSetCurrentCase, "setCase.png"],
            ["-",                           "",       True,  True,  "", ""], 
            [_("FOAM端末の起動"),           "",       True,  True,  self.popRunFoamTerm, "runFoamTerm.png"], 
            [_("gridEditor起動..."),        "",       True,  False, self.popGridEditor, "gridEditor.png"],
            ["-",                           "",       True,  True,  "", ""], 
            [_("コピー"),                   "Ctrl+C", True,  True,  self.popCopyFolders, ""], 
            [_("貼り付け"),                 "Ctrl+V", True,  True,  self.popPasteFolders, ""],
            [_("caseの貼り付け"),           "Ctrl+B", True,  True,  self.popPasteCases, ""],
            [_("meshの貼り付け..."),        "",       True,  False, self.popPasteMesh, ""],
            #[_("mapFields貼り付け..."),     "",       True,  False, self.popPasteFieldsMapping, ""],
            [_("fieldのmapping貼り付け..."), "",      True,  False, self.popPasteFieldsMapping, ""],
            ["-",                           "",       True,  True,  "", ""], 
            [_("フォルダ名変更..."),        "F2",     True,  True,  self.popRenameFolder, ""], 
            [_("新しいフォルダ追加"),       "Ctrl+N", True,  True,  self.popNewFolder, ""],
            [_("フォルダ削除..."),          "Delete", True,  True,  self.popDeleteFolders, ""],
            ["-",                           "",       True,  True,  "", ""],
            [_("loginシェル起動"),          "",       True,  True,  self.popLogInShell, ""], 
            [_("server Job管理"),           "",       True,  True,  self.popServerJob, ""],
            [_("sshfsサーバ マウント"),     "",       True,  True,  self.popServerMount, ""], 
            [_("sshfsサーバ アンマウント"), "",       True,  True,  self.popServerUnmount, ""],
            [_("貼り付け(scp圧縮転送,cp)"), "",       True,  True,  self.popScpPasteFolder, ""], 
            [_("case貼り付け(scp圧縮転送,cp)"), "",   True,  True,  self.popScpPasteCase, ""],
            [_("server内フォルダ削除(rm)"), "",       True,  True,  self.popDeleteServer, ""],
            ["-",                           "",       True,  True,  "", ""], 
            [_("CADの起動"),                "",       True,  True,  self.popRunCad, "runCAD.png"], 
            [_("meshViewerの起動"),         "",       True,  False, self.popRunMeshViewer, "meshViewer.png"],
            [_("paraFoam起動"),             "",       True,  True,  self.popRunParaFoam, "pqAppIcon22.png"], 
            [_("SalomeMecaの起動"),         "",       True,  True,  self.popRunSalome, "salome_default.png"]
            ]
        self.solveMenuItems = [
            [_("開く"),                     "Return", True,  True,  self.popOpenFolder, ""], 
            [_("FOAM端末の起動"),           "",       True,  True,  self.popRunFoamTerm, "runFoamTerm.png"],
            ["-",                           "",       True,  True,  "", ""], 
            [_("gridEditor起動..."),        "",       True,  False, self.popGridEditor, "gridEditor.png"], 
            [_("Fieldの編集..."),           "",       False, False, self.popEditFields, "editFields.png"],
            [_("Fieldにデータセット..."),   "",       False, False, self.popDataSetClear, "dataSetClear.png"],
            [_("Properties(const)の編集..."), "",     False, False, self.popEditProperty, "editProperties-cons.png"],
            [_("Dictionaries(sys)の編集..."), "",     False, False, self.popEditDict, "editDict-sys.png"], 
            [_("controlDictの編集"),        "",       False, False, self.popEditControlDict, ""], 
            ["-",                           "",       True,  True,  "", ""], 
            [_("Meshの編集..."),            "",       False, False, self.popEditMesh, "editMesh.png"],
            [_("topoSetEditor起動"),        "",       False, False, self.popTopoSetEditor, "topoEditMesh.png"],
            [_("multiRegionの設定"),        "",       False, False, self.popMultiRegion, "multiRegion.png"],
            ["-",                           "",       True,  True,  "", ""], 
            [_("solver実行"),               "",       False, False, self.popRunSolver, "runSolver.png"], 
            [_("plotWatcherを実行"),        "",       False, False, self.popPlotWatcher, "plotWatcher.png"], 
            [_("並列処理..."),              "",       False, False, self.popRunParallel, "parallel.png"],
            [_("流体_構造連成解析..."),     "",       False, False, self.popRunCoupling, "fsiOfFistr.png"]
            ]
        self.resMenuItems = [
            [_("開く"),                     "Return", True,  True,  self.popOpenFolder, ""], 
            ["-",                           "",       True,  True,  "", ""], 
            [_("FOAM端末の起動"),           "",       True,  True,  self.popRunFoamTerm, "runFoamTerm.png"], 
            [_("gridEditor起動..."),        "",       True,  False, self.popGridEditor, "gridEditor.png"],
            [_("残渣の確認(plotWatcher起動)"), "",    False, False, self.popPlotWatcher, "plotWatcher.png"], 
            [_("meshViewerの起動"),         "",       True,  False, self.popRunMeshViewer, "meshViewer.png"],
            [_("paraFoam起動"),             "",       True,  True,  self.popRunParaFoam, "pqAppIcon22.png"], 
            ["-",                           "",       True,  True,  "", ""], 
            [_("結果フォルダの削除"),       "",       False, False, self.popDeleteResFolder, "deleteResult.png"],
            [_("caseの初期化"),             "",       False, False, self.popIniCase, "iniCase-4.png"]
            ]


    #
    #  setTreeDataCaseConts
    #
    def setTreeDataCaseConts(self):
        """ treeViewにtreeDataをセットし、case内容を設定"""
        #treeEventをmaskする
        self.maskTreeEvent = True
        #treeStoreを定義
        self.defineTreeStore()
        #treeを作成
        self.createTreeNodes()
        #treeの内容（titleなど）を定義
        self.defineTreeConts()
        #解析case、選択caseのTreeを設定
        self.setSelSolveCaseInTree(rootDir, solveCaseDir)
        #解析case、選択caseの展開、選択
        self.expandSelSolveCase(rootDir, selCaseDir, solveCaseDir)
        #解析caseの内容をpanelにセット
        self.setSolveCaseInPanel(solveCaseDir)
        #combox（startFromなど）を設定
        self.setItemsToComboBox(solveCaseDir)
        #buttonやtextBoxの非active化
        self.setVisibleOfButton(solveCaseDir)
        #statusBarの初期化
        self.clearStatusBar()
        #treeEventのmaskを解除
        self.maskTreeEvent = False


    #
    #  tree作成関連
    #
    #  defineTreeStore
    def defineTreeStore(self):
        pixbuf = GdkPixbuf.Pixbuf
        weight = Pango.Weight
        self.treestore = Gtk.TreeStore(
            #icon   dir  icon    slv  BCPn nR   st   ed   (bold)
            pixbuf, str, pixbuf, str, str, str, str, str, weight, str)

    #
    #  createTreeNodes
    #    Treeを作成
    def createTreeNodes(self):
        """ treeData(list)からtreeViewのnodeを作成する"""
        rootName = treeData[0]
        items = treeData[1]
        rootIter = self.treestore.append(
            None, [self.iconFolder, rootName, self.iconBlank, "",
                   "", "", "", "", self.NORMAL, "black"])
        self.addTreeNodes([rootName], self.treestore, rootIter, items)

    #  addTreeNodes
    def addTreeNodes(self, names, treeStore, parentIter, items):
        iconFol = self.iconFolder; iconSolv = self.iconSolver; weight = self.NORMAL
        solver = ""; BCPn = ""; nR = ""; st = ""; ed = ""; color = "black"
        path = treeStore.get_path(parentIter)
        parentDir = self.getDirFromTreePath(path)
        for item in items:
            if type(item) == str:
                itemDir = parentDir + [item]
                (folType, solver, BCPn, nR, st, ed) = getTreeConts(itemDir)
                (iconFol, iconSolv) = self.getImageIcon(folType, itemDir)
                newIter = treeStore.append(
                    parentIter, [iconFol, item, iconSolv, solver, 
                                 BCPn, nR, st, ed, weight, color])
            else:
                itemDir = parentDir + [item[0]]
                (folType, solver, BCPn, nR, st, ed) = getTreeConts(itemDir)
                (iconFol, iconSolv) = self.getImageIcon(folType, itemDir)
                newIter = treeStore.append(
                    parentIter, [iconFol, item[0], iconSolv, solver,
                                 BCPn, nR, st, ed, weight, color])
                self.addTreeNodes(names, treeStore, newIter, item[1])

    def getDirFromTreePath(self, path):
        """ treeのpathからdirectoryのlistを取得する。"""
        words = []
        for i in range(len(path)):
            treeiter = self.treestore.get_iter(path[:i+1])
            value = self.treestore.get_value(treeiter, self.COL_DIR)
            words.append(value)
        return words

    def getImageIcon(self, folType, itemDir):
        """ folTypeからiconを取得する"""
        if self.isServerDir(itemDir) == True:
            iconDict = self.iconServerDict
        else:
            iconDict = self.iconLocalDict
        (iconFol, iconSolve, _iconCk) = iconDict[folType]
        return (iconFol, iconSolve)

    #
    #  defineTreeConts
    #
    def defineTreeConts(self):
        self.treeView.set_model(model=self.treestore)
        cellRenderer = Gtk.CellRendererText()
        iconRenderer = Gtk.CellRendererPixbuf()
        #Tree
        tvcolumn = Gtk.TreeViewColumn("Tree")               #title
        tvcolumn.pack_start(iconRenderer, False)
        tvcolumn.pack_start(cellRenderer, False)
        tvcolumn.add_attribute(iconRenderer, "pixbuf", self.COL_ICON)
        tvcolumn.add_attribute(cellRenderer, "text", self.COL_DIR)
        tvcolumn.add_attribute(cellRenderer, "foreground", self.COL_COLOR)
        tvcolumn.set_fixed_width(colWidth[0])       #cell幅を設定
        tvcolumn.set_resizable(True)                #cell幅を可変
        self.treeView.append_column(tvcolumn)
        #solver
        tvcolumn = Gtk.TreeViewColumn("solver")              #title
        tvcolumn.pack_start(iconRenderer, False)
        tvcolumn.pack_start(cellRenderer, False)
        tvcolumn.add_attribute(iconRenderer, "pixbuf", self.COL_ICON_SOLVER)
        tvcolumn.add_attribute(cellRenderer, "text", self.COL_SOLVER)
        tvcolumn.add_attribute(cellRenderer, "weight", self.COL_WEIGHT)
        tvcolumn.set_fixed_width(colWidth[1])       #cell幅を設定
        tvcolumn.set_resizable(True)                #cell幅を可変
        self.treeView.append_column(tvcolumn)
        #BCPn
        tvcolumn = Gtk.TreeViewColumn("BCPn")              #title
        tvcolumn.pack_start(cellRenderer, False)
        tvcolumn.add_attribute(cellRenderer, "text", self.COL_BCPN)
        self.treeView.append_column(tvcolumn)
        #nR
        tvcolumn = Gtk.TreeViewColumn("nR")              #title
        tvcolumn.pack_start(cellRenderer, False)
        tvcolumn.add_attribute(cellRenderer, "text", self.COL_NR)
        self.treeView.append_column(tvcolumn)
        #st
        tvcolumn = Gtk.TreeViewColumn("st")              #title
        tvcolumn.pack_start(cellRenderer, False)
        tvcolumn.add_attribute(cellRenderer, "text", self.COL_ST)
        self.treeView.append_column(tvcolumn)
        #ed
        tvcolumn = Gtk.TreeViewColumn("ed")              #title
        tvcolumn.pack_start(cellRenderer, False)
        tvcolumn.add_attribute(cellRenderer, "text", self.COL_ED)
        self.treeView.append_column(tvcolumn)

    #
    #  setSelSolveCaseInTree
    #
    def setSelSolveCaseInTree(self, rootDir, solveCaseDir):
        """ Tree内の解析caseのicon、色等を設定する"""
        #solveCaseの位置を取得
        treeiter = self.getIterInTreeStore(rootDir, solveCaseDir)
        #  checkIcon,boldに変更
        dirCont = solveCaseDir.split("/")
        conts = getTreeConts(dirCont)
        folType = conts[0]
        iconDict = self.iconLocalDict
        if self.isServerDir(solveCaseDir) == True:
            iconDict = self.iconServerDict
        (_iconFol, _iconSolve, icon) = iconDict[folType]
        #設定       
        self.treestore.set_value(treeiter, self.COL_ICON, icon)
        self.treestore.set_value(treeiter, self.COL_WEIGHT, self.BOLD)
        self.treestore.set_value(treeiter, self.COL_COLOR, "red")

    #
    #  clearSelSolveCaseInTree
    #
    def clearSelSolveCaseInTree(self, rootDir, solveCaseDir):
        """ Tree内の解析caseのicon、色等を元の設定に戻す"""
        #solveCaseの位置を取得
        treeiter = self.getIterInTreeStore(rootDir, solveCaseDir)
        #  checkIcon,boldに変更
        dirCont = solveCaseDir.split("/")
        conts = getTreeConts(dirCont)
        folType = conts[0]
        iconDict = self.iconLocalDict
        if self.isServerDir(solveCaseDir) == True:
            iconDict = self.iconServerDict
        (icon, _iconSolve, _iconCk) = iconDict[folType]
        #設定       
        self.treestore.set_value(treeiter, self.COL_ICON, icon)
        self.treestore.set_value(treeiter, self.COL_WEIGHT, self.NORMAL)
        self.treestore.set_value(treeiter, self.COL_COLOR, "black")


    #  getIterInTreeStore
    #
    def getIterInTreeStore(self, rootDir, selCaseDir):
        """ selCaseDirからtree内の位置:treeiterを取得する。
            treeiterで直接treeの場所にアクセスできる"""
        path = self.getPathInTreeStore(rootDir, selCaseDir)
        treeiter = self.treestore.get_iter(path)
        return treeiter

    #  getPathInTreeStore
    #
    def getPathInTreeStore(self, rootDir, selCaseDir):
        """ selcaseDirからtreeのpathを取得する。
            path: 0:1:4:1 """
        rootWords = rootDir.split("/")
        selWords = selCaseDir.split("/")
        #pathを取得
        selCont = selWords[len(rootWords):]
        items = treeData[1]
        pathInt = [0]
        for word in selCont:
            for i in range(len(items)):
                if type(items[i]) == str:
                    if word == items[i]:
                        pathInt.append(i)
                        #items = []
                        break
                else:
                    if word == items[i][0]:
                        pathInt.append(i)
                        items = items[i][1]
                        break
        path = Gtk.TreePath.new_from_indices(pathInt)
        return path
    
    #
    #  expandSelSolveCase
    #
    def expandSelSolveCase(self, rootDir, selCaseDir, solveCaseDir):
        """ selCaseDir、solveCaseまでTreeを展開し、selCaseDirを選択する。
            selcaseDirまでscrollして表示する。"""
        #selCaseDirまで展開
        expDir = os.sep.join(selCaseDir.split(os.sep)[:-1])
        path = self.getPathInTreeStore(rootDir, expDir)
        self.treeView.expand_to_path(path)
        #selCaseDirを選択
        treeSelection = self.treeView.get_selection()
        path = self.getPathInTreeStore(rootDir, selCaseDir)
        treeSelection.select_path(path)
        #selCaseDirまでscrollする
        self.treeView.scroll_to_cell(path)
        #solveCaseDirを確認
        if selCaseDir != solveCaseDir:
            #solveCaseDirまで展開
            expDir = os.sep.join(solveCaseDir.split(os.sep)[:-1])
            path = self.getPathInTreeStore(rootDir, expDir)
            self.treeView.expand_to_path(path)
    
    #
    # expandSelSolveCaseNotScroll
    #
    def expandSelSolveCaseNotScroll(self, rootDir, selCaseDir, solveCaseDir):
        """ selCaseDir、solveCaseまでTreeを展開し、selCaseDirを選択する。
            selcaseDirまでscrollして表示しない。"""
        #selCaseDirを選択
        path = self.getPathInTreeStore(rootDir, selCaseDir)
        self.treeView.expand_to_path(path)
        self.treeView.collapse_row(path)
        treeSelection = self.treeView.get_selection()
        treeSelection.select_path(path)
        #selCaseDirまでscrollする
        #self.treeView.scroll_to_cell(path)
        #solveCaseDir
        path = self.getPathInTreeStore(rootDir, solveCaseDir)
        self.treeView.expand_to_path(path)
        self.treeView.collapse_row(path)

    #
    #  setSolveCaseInPanel
    #
    def setSolveCaseInPanel(self, solveCaseDir):
        """ solveCaseDirの内容をpnelに書き込む
            menuBarの非表示設定"""
        caseDir = solveCaseDir
        nMax = 60          #labelの最大文字数
        if len(caseDir) > nMax:
            caseDir = "..." + caseDir[-(nMax-3):]
        #folTypeに応じて設定
        conts = getFolderConts(solveCaseDir)
        folType = conts[0]
        if folType == "case" or folType == "caseLink":
            solver = conts[1]
            envOpenFOAM = envOpenFOAMFix.split("/")[-1]
        else:
            solver = " ---None--- "
            envOpenFOAM = envOpenFOAMFix.split("/")[-1]
        self.label_caseDir.set_label(caseDir)
        self.label_OFenv.set_label(envOpenFOAM)
        self.label_solver.set_label(solver)
        #folTypeに応じてmenuBarの非表示を設定
        if folType == "case" or folType == "caseLink":
            #全表示設定
            for itemConts in self.showMenuSetting:
                itemConts[0].set_sensitive(True)
        else:
            #showMenuSettingに従い設定
            for itemConts in self.showMenuSetting:
                itemConts[0].set_sensitive(itemConts[1])

    #
    #  setItemsToComboBox
    #
    def setItemsToComboBox(self, solveCaseDir):
        """ comboBoxにstartTime、endTimeなどを表示させる"""
        startItems = []
        stopItems = []
        interval = ""
        folConts = getFolderConts(solveCaseDir)
        folType = folConts[0]
        if folType == "case" or folType == "caseLink":
            #case内のデータを取得
            itemsDict = pyTreeFoam.case(solveCaseDir).getControlDict()
            startTime = itemsDict["startTime"]
            timeFolders = pyTreeFoam.case(solveCaseDir).getTimeFolders()
            for timeFolder in timeFolders:
                if float(startTime) == float(timeFolder):
                    startTime = timeFolder
                    break
            #startFrom
            if itemsDict["startFrom"] == "firstTime":
                selNo = 0
            elif itemsDict["startFrom"] == "startTime":
                selNo = 1
            else:
                selNo = 2
            startItems.append("firstTime")
            #startItems.append("startTime:"+ itemsDict["startTime"])
            startItems.append("startTime:"+ startTime)
            startItems.append("latestTime")
            self.combo_start = self.setComboDataInComboBox(self.combo_start, startItems)
            self.combo_start.set_active(selNo)
            #stopAt
            if itemsDict["stopAt"] == "endTime":
                stopSelNo = 0
            elif itemsDict["stopAt"] == "noWriteNow":
                stopSelNo = 1
            elif itemsDict["stopAt"] == "writeNow":
                stopSelNo = 2
            else:
                stopSelNo = 3
            stopItems.append("endTime:"+ itemsDict["endTime"])
            stopItems.append("noWriteNow")
            stopItems.append("writeNow")
            stopItems.append("nextWrite")
            self.combo_stop = self.setComboDataInComboBox(self.combo_stop, stopItems)
            self.combo_stop.set_active(stopSelNo)
            #interval
            interval = itemsDict["writeInterval"]
            self.entry_interval.set_text(interval)
        else:
            #データをクリア
            self.combo_start = self.setComboDataInComboBox(self.combo_start, startItems)
            self.entry_start.set_text("")
            self.combo_stop = self.setComboDataInComboBox(self.combo_stop, stopItems)
            self.entry_stop.set_text("")
            self.entry_interval.set_text(interval)

    #
    #  setComboDataInComboBox
    #
    def setComboDataInComboBox(self, comboBox, setNames):
        """ comboBoxにsetNamesを設定する。"""
        comboBox.clear()
        listModel = Gtk.ListStore(str)
        for name in setNames:
            listModel.append([name])
        cell = Gtk.CellRendererText()
        comboBox.pack_start(cell, True)
        comboBox.add_attribute(cell, "text", 0)
        comboBox.set_model(listModel)
        comboBox.set_entry_text_column(0)
        return comboBox

    #
    #  setVisibleOfButton
    #
    def setVisibleOfButton(self, solveCaseDir):
        """ button, labelなどの表示、非表示設定"""
        folConts = getFolderConts(solveCaseDir)
        folType = folConts[0]
        if folType == "case" or folType == "caseLink":
            #self.button_newCase.set_sensitive(True)
            self.button_editMesh.set_sensitive(True)
            self.button_topoSet.set_sensitive(True)
            self.button_multiRegion.set_sensitive(True)
            self.button_gridEditor.set_sensitive(True)
            self.button_editField.set_sensitive(True)
            self.button_dataSet.set_sensitive(True)
            self.button_editPro.set_sensitive(True)
            self.button_editDict.set_sensitive(True)
            self.button_iniCase.set_sensitive(True)
            self.button_delResult.set_sensitive(True)
            self.button_solver.set_sensitive(True)
            self.button_plotWatcher.set_sensitive(True)
            self.button_para.set_sensitive(True)
            self.button_fsi.set_sensitive(True)
            self.combo_start.set_sensitive(True)
            self.combo_stop.set_sensitive(True)
            self.entry_interval.set_sensitive(True)
            self.button_editCntDict.set_sensitive(True)
            self.label_startFrom.set_sensitive(True)
            self.label_stopAt.set_sensitive(True)
            self.label_writeInterval.set_sensitive(True)
        else:
            #self.button_newCase.set_sensitive(False)
            self.button_editMesh.set_sensitive(False)
            self.button_topoSet.set_sensitive(False)
            self.button_multiRegion.set_sensitive(False)
            self.button_gridEditor.set_sensitive(False)
            self.button_editField.set_sensitive(False)
            self.button_dataSet.set_sensitive(False)
            self.button_editPro.set_sensitive(False)
            self.button_editDict.set_sensitive(False)
            self.button_iniCase.set_sensitive(False)
            self.button_delResult.set_sensitive(False)
            self.button_solver.set_sensitive(False)
            self.button_plotWatcher.set_sensitive(False)
            self.button_para.set_sensitive(False)
            self.button_fsi.set_sensitive(False)
            self.combo_start.set_sensitive(False)
            self.combo_stop.set_sensitive(False)
            self.entry_interval.set_sensitive(False)
            self.button_editCntDict.set_sensitive(False)
            self.label_startFrom.set_sensitive(False)
            self.label_stopAt.set_sensitive(False)
            self.label_writeInterval.set_sensitive(False)

    #
    #  statusBar
    #
    def clearStatusBar(self):
        """ statusBarの初期化(HD容量を表示)"""
        #path = selCaseDir
        path = solveCaseDir
        total, free = pyTreeFoam.getHddVals(path)
        self.writeHddStatus(total, free)

    def writeHddStatus(self, total, free):
        total = "%.2f" % (total / 1000**3)
        free = "%.2f" % (free / 1000**3)
        msg = _(" 合計 ") + str(total) + _(" GB,  空き ") + str(free) + " GB"
        self.label_status.set_text(msg)

    def writeStatusBar(self, text):
        """ statusBarにtextを表示させる"""
        self.label_status.set_text(text)

    #
    #  exitTreeFoam
    #  ------------
    def exitTreeFoam(self):
        """ ending処理を行って、TreeFoamを閉じる"""
        global treeSize, splitWidth, colWidth
        #windowSizeを取得
        (width, height) = mainWindow.get_size()
        treeSize = (width, height)
        #windowの分割幅を取得
        splitWidth = self.panedWin.get_position()
        #treeViewColumnのcell幅を取得
        columns = self.treeView.get_columns()
        treeWidth = columns[0].get_width()
        solverWidth = columns[1].get_width()
        BCPnWidth = columns[2].get_width()
        nRWidth = columns[3].get_width()
        stWidth = columns[4].get_width()
        edWidth = columns[5].get_width()
        colWidth = [treeWidth, solverWidth, BCPnWidth, nRWidth, stWidth, edWidth]
        #ending処理
        endingTreeFoam(treeSize, splitWidth)
        self.close()

    #
    #  configTreeFoam
    #  --------------
    def configTreeFoam(self):
        """ configTreeFoamを設定し直す"""
        global envOpenFOAMFix
        configDict = pyTreeFoam.readConfigTreeFoam()
        #変更内容を取得
        #newDict = changeConfigTreeFoamDDialog.Show(configDict)
        okArgs = [self.configTreeFoam_run, configDict]
        dialog = changeConfigTreeFoamDDialog.changeConfigTreeFoam(configDict, funcOk=okArgs, parent=mainWindow)
        dialog.show()
        return
        
    #  configTreeFoam_run
    def configTreeFoam_run(self, newDict, configDict):
        global envOpenFOAMFix
        #変更したか？
        if len(newDict) > 0:
            #OpenFOAM環境が変更されたか？
            if newDict["bashrcFOAM"] != configDict["bashrcFOAM"]:
                envOpenFOAMFix = newDict["bashrcFOAM"]
                self.setSolveCaseInPanel(solveCaseDir)
            #appを再設定
            configDict = pyTreeFoam.readConfigTreeFoam()
            print(_("configTreeFoamを更新しました。"))

    #
    #  changeRoot
    #  ----------
    def changeRoot(self):
        global selCaseDir, solveCaseDir, rootDir
        """ rootDirを変更する"""
        rootDir = treeData[0]
        title = "select rootDir"
        okArgs = [self.changeRoot_run]
        self.openFolderDialog(title, rootDir, funcOk=okArgs)
        return
        
    #  changeRoot_run
    def changeRoot_run(self, newRootDir):
        """ rootDirを変更する"""
        global selCaseDir, solveCaseDir, rootDir
        if newRootDir == rootDir:
            return
        if os.path.exists(newRootDir) == False:
            return
        #changeRoot開始処理
        self.maskTreeEvent = True
        self.writeStatusBar("reloading...")
        #rootDirの変更
        rootDir = newRootDir
        #selCaseDir, solveCaseDirを設定
        folders = pyTreeFoam.getFolders(rootDir)
        if os.path.exists(solveCaseDir) == True:
            selCaseDir = solveCaseDir
        else:
            if len(folders) > 0:
                folders.sort()
                selCaseDir = folders[0]
                solveCaseDir = folders[0]
            else:
                selCaseDir = rootDir
                solveCaseDir = rootDir
        #configDictの修正
        configDict = {}
        configDict["rootDir"] = rootDir
        pyTreeFoam.writeConfigTreeFoam(configDict)
        #treeDirの読み込み---------
        #getTreeDirLocal(rootDir, selCaseDir, solveCaseDir)
        getTreeDirLocalServer(rootDir, selCaseDir, solveCaseDir)
        #treeDataを作成
        createTreeData(rootDir)
        #treeViewをクリア
        self.treestore.clear()
        self.createTreeNodes()
        #解析case、選択caseのtreeを設定
        self.treeView.get_selection().unselect_all()
        self.setSelSolveCaseInTree(rootDir, solveCaseDir)
        self.expandSelSolveCaseNotScroll(rootDir, selCaseDir, solveCaseDir)
        #解析caseの内容をpanelにセット
        self.setSolveCaseInPanel(solveCaseDir)
        self.setItemsToComboBox(solveCaseDir)
        self.setVisibleOfButton(solveCaseDir)
        #終了処理
        self.clearStatusBar()
        self.maskTreeEvent = False

    #
    #  reload
    #  ------
    def reload(self):
        """ directoryを再読込する"""
        global selCaseDir
        #treeEventをmaskする
        self.maskTreeEvent = True
        #statusBar設定
        self.writeStatusBar("reloading...")
        #root, selCase, solveCaseの各dirの有無チェック、無い場合は再設定
        checkDirRootSelSolveCase()
        #selcaseDirを保存（途中でselCaseDirが書き換わる為）
        selDir = selCaseDir
        #treeDirの読み込み-----------
        #getTreeDirLocal(rootDir, selCaseDir, solveCaseDir)
        getTreeDirLocalServer(rootDir, selCaseDir, solveCaseDir)
        #treeDataを作成
        createTreeData(rootDir)
        #treeViewをクリア
        self.treestore.clear()
        self.createTreeNodes()
        #selCaseDirを戻す
        selCaseDir = selDir
        #treeView上の選択行をクリア
        self.treeView.get_selection().unselect_all()
        #解析case、選択caseのTreeを設定
        self.setSelSolveCaseInTree(rootDir, solveCaseDir)
        #解析case、選択caseの展開、選択
        self.expandSelSolveCase(rootDir, selCaseDir, solveCaseDir)
        #解析caseの内容をpanelにセット
        self.setSolveCaseInPanel(solveCaseDir)
        #combox（startFromなど）を設定
        self.setItemsToComboBox(solveCaseDir)
        #buttonやtextBoxの非active化
        self.setVisibleOfButton(solveCaseDir)
        #statusBarをclear
        self.clearStatusBar()
        #treeEventのmaskを解除
        self.maskTreeEvent = False

    #
    #  setCurrentCase
    #  --------------
    def setCurrentCase(self):
        """ 選択caseを解析case(solveCaseDir)に設定する"""
        global solveCaseDir
        #treeEventをmask
        self.maskTreeEvent = True
        #statusBar設定
        self.writeStatusBar("setting currentCase...")
        #旧の解析caseを標準のiconなどに戻す
        self.clearSelSolveCaseInTree(rootDir, solveCaseDir)
        #solveCaeDirを更新
        solveCaseDir = selCaseDir
        #Treeの内容を新しい解析caseに更新
        self.setSelSolveCaseInTree(rootDir, solveCaseDir)
        #panelの内容を更新
        self.setSolveCaseInPanel(solveCaseDir)
        #comboBoxの内容を更新
        self.setItemsToComboBox(solveCaseDir)
        #buttonの非表示設定
        self.setVisibleOfButton(solveCaseDir)
        #meshViewerをチェック
        if self.meshViewer != "":
            if self.meshViewer.isAlive() == True:
                self.meshViewer.cancelViewer()
                case = pyTreeFoam.case(solveCaseDir)
                stlDir = case.getCreateMeshData()["stlDir"]
                if stlDir == "":
                    stlDir = "model"
                commLines  = ["start\n"]
                commLines += ["caseDir " + solveCaseDir + "\n"]
                commLines += ["time startFrom\n"]
                commLines += ["stlDir " + stlDir + "\n"]
                commLines += ["clear\n"]
                commLines += ["print 'loading ...'\n"]
                commLines += ["wait 0.1s\n"]
                commLines += ["load all\n"]
                commLines += ["resetCamera\n"]
                #commLines += ["setTreeList patches zones sets\n"]
                commLines += ["setTreeList\n"]
                commLines += ["end\n"]
                self.meshViewer.runDelayCommands(commLines)
        #statusBarをclear
        self.clearStatusBar()
        #treeEventを解除
        self.maskTreeEvent = False


    #
    #  newCase
    #  -------
    def newCase(self):
        print(_("新しいcaseを作成します。"))
        th = threading.Thread(target=self.threadNewCase, args=())
        th.start()

    #
    #  threadNewCase
    def threadNewCase(self):
        """ newcaseを作成する"""
        path = treeFoamPath + os.sep + "python"
        comm = "./createAndChangeCaseDialog.py " + solveCaseDir
        pyTreeFoam.run(path).command(comm)
        #追加したnewCaseを選択表示させる
        #  newCaseのpasteDirを取得
        fileName = os.getenv("TreeFoamUserPath") + "/temp/newCasePasteDir"
        if os.path.exists(fileName) == False:
            #fileが存在しない場合は、直ぐに戻る。
            return
        f = open(fileName); pasteDir = f.read(); f.close()
        if pasteDir == "":
            #tutorialsをcopyしていない場合は、直ぐに戻る
            return
        #  pasteDir以下のfolderContsを取得
        newFolders = pyTreeFoam.getNeedFolders(pasteDir)
        newFolders += pyTreeFoam.getChildFolders(newFolders)
        folderConts = addFolderContsData(newFolders)
        #  solveCaseDir以下で追加されたfolderを選択表示させる
        #  timerEvent中で選択表示する。
        self.threadShowTreeDir = [pasteDir, folderConts]


    #
    #  editMesh
    #  --------
    def editMesh(self):
        """ mesh操作Dialogを開く"""
        print(_("mesh操作"))
        treefoamPid = str(os.getpid())
        path = treeFoamPath + os.sep + "python"
        comm  = "./meshOperationDialog.py " + solveCaseDir + " "
        comm += treefoamPid + " &"
        pyTreeFoam.run(path).command(comm)

    #
    #  topoSetEditor
    #  ----------------
    def topoSetEditor(self):
        """ topoSetEditorを起動する"""
        print(_("topoSetEditorを起動"))
        configDict = pyTreeFoam.readConfigTreeFoam()
        OFversion = configDict["OFversion"]
        numVer = pyTreeFoam.getNumVersion(OFversion)
        if numVer >= 13.0:
            title = _("エラー")
            message = _(u"OpenFOAM-") + OFversion + _(u" ではTopoSetEditorは使えません\n")
            self.errDialog(title, message)
        elif OFversion[:3] == "ext":
            title = _(u"エラー")
            message = _(u"OpenFOAM-") + OFversion + _(u" ではTopoSetEditorは使えません\n")
            message += _(u"OpenFOAM-2.0.0 以降で使用できます。")
            self.errDialog(title, message)
        elif ( numVer >= 2.0 or 
               (OFversion[0] == "v" and OFversion <= "v1806") ):
            modelDict = pyTreeFoam.case(solveCaseDir).getCreateMeshData()
            stlDir = modelDict["stlDir"]
            path = treeFoamPath + os.sep + "python"
            comm = "./topoSetEditorDialog.py " + solveCaseDir + " --stl " + stlDir + " &"
            pyTreeFoam.run(path).command(comm)
        elif OFversion >= "v1812":
            modelDict = pyTreeFoam.case(solveCaseDir).getCreateMeshData()
            stlDir = modelDict["stlDir"]
            path = treeFoamPath + os.sep + "python"
            comm = "./topoSetEditorDialog.py " + solveCaseDir + " --stl " + stlDir + " &"
            pyTreeFoam.run(path).command(comm)
        else:
            title = _(u"エラー")
            message = _(u"OpenFOAM-") + OFversion + _(u" ではTopoSetEditorは使えません\n")
            message += _(u"OpenFOAM-2.0.0 以降で使用できます。")
            self.errDialog(title, message)

    #
    #  setMultiRegion
    #  --------------
    def setMultiRegion(self):
        """ multiRegionの設定dialogを開く"""
        print(_("multiRegionの設定"))
        path = treeFoamPath + os.sep + "python"
        comm = "./setMultiRegionDialog.py " + solveCaseDir + " &"
        pyTreeFoam.run(path).command(comm)

    #
    #  gridEditor
    #  ----------
    def gridEditor(self):
        """ gridEditorを起動する。"""
        caseDir = solveCaseDir
        currTime = pyTreeFoam.case(caseDir).getCurrTimeFolder()
        if currTime == "":
            title = _("エラー")
            mess  = _("currTimeが取得できない為、gridEditorが起動できません。\n")
            mess += _("timeFolderの有無、system/controlDictの内容を確認してください。")
            self.errDialog(title, mess)
            return 
        commPath = os.getenv("TreeFoamPath") + "/python"
        comm = ". " + envOpenFOAMFix + "; "
        comm += commPath + "/gridEditorQtDialog.py "
        comm += nTreeFoam + " " + caseDir + " " + currTime + " . &"
        print(comm)
        pyTreeFoam.run(caseDir).command(comm)

    #
    #  editField
    #------------
    def editField(self, currDir):
        """ foamEditorでfieldを開く"""
        caseDir = currDir
        currTime = pyTreeFoam.case(caseDir).getCurrTimeFolder()
        commPath = os.getenv("TreeFoamPath") + "/python"
        comm = ". " + envOpenFOAMFix + "; "
        comm += commPath + "/openFoamEditorDialog.py "
        comm += nTreeFoam + " " + caseDir + " " + currTime + " . &"
        pyTreeFoam.run(caseDir).command(comm)

    #
    #  dataSetClear
    #--------------
    def dataSetClear(self):
        """ fieldへのデータセット、クリア"""
        caseDir = solveCaseDir
        currTime = pyTreeFoam.case(caseDir).getCurrTimeFolder()
        commPath = os.getenv("TreeFoamPath") + "/python"
        comm = commPath + "/setDataInFieldsDialog.py " + caseDir + " " + currTime + " &"
        #pyTreeFoam.run().command(comm)
        pyTreeFoam.run(caseDir).command(comm)

    #
    #  editProperties
    #-----------------
    def editProperties(self):
        """ propertiesの編集"""
        selFiles = selectFolderFilesDialog.constantFiles(solveCaseDir, "constant")
        names = selFiles.main()
        if len(names) == 0:
            return
        names.sort()
        fileDir = solveCaseDir + "/constant/"
        files = list(map(lambda x: fileDir + x, names))
        pyTreeFoam.run(solveCaseDir).editor(files)
        #pyTreeFoam.run(solveCaseDir).foamEditor(files)

    #
    #  editDict
    #-------------
    def editDict(self):
        selFiles = selectFolderFilesDialog.systemFiles(solveCaseDir, "system")
        names = selFiles.main()
        if len(names) == 0:
            return
        names.sort()
        fileDir = solveCaseDir + "/system/"
        files = list(map(lambda x: fileDir + x, names))
        pyTreeFoam.run(solveCaseDir).editor(files)
        #pyTreeFoam.run(solveCaseDir).foamEditor(files)

    #
    #  changeStopAtCombo
    #  -----------------
    def changeStopAtCombo(self, caseDir, iter):
        """ controldict内のstopAt(combo)を書き換える"""
        #treeEventをmask
        self.treeEvent = True
        #comboの選択項目を取得
        iter = self.combo_stop.get_active_iter()
        model = self.combo_stop.get_model()
        stopAtTime = model.get_value(iter, 0)
        contDict = self.getStopDict(stopAtTime)
        pyTreeFoam.case(caseDir).setControlDict(contDict)
        #treeEventを解除
        self.maskTreeEvent = False
        #message表示
        title = _(u"controlDictの書き換え")
        mess = _(u"controlDictを書き換えました\n")
        mess += _("    stopAt")
        self.okDialog(title, mess)

    #
    #  changeStopAtEntry
    #  -----------------
    def changeStopAtEntry(self, caseDir):
        """ controldict内のstopAt(entry)を書き換える"""
        #treeEventをmask
        self.treeEvent = True
        #全内容を取得
        self.changeStartStopInterval(caseDir)
        #treeEventを解除
        self.maskTreeEvent = False
        #message表示
        title = _(u"controlDictの書き換え")
        mess = _(u"controlDictを書き換えました\n")
        mess += _("    startFrom\n")
        mess += _("    stopAt\n")
        mess += _("    writeInterval")
        self.okDialog(title, mess)

    #
    #  getStopDict
    def getStopDict(self, stopAtTime):
        """ stopAtTimeの辞書を作成"""
        contDict = {}
        #entryの内容に応じて処理
        if stopAtTime == "noWriteNow":
            contDict["stopAt"] = "noWriteNow"
        elif stopAtTime == "writeNow":
            contDict["stopAt"] = "writeNow"
        elif stopAtTime == "nextWrite":
            contDict["stopAt"] = "nextWrite"
        elif stopAtTime[:len("endTime")] == "endTime":
            stopAtTime = stopAtTime.replace(" ", "")
            words = stopAtTime.split(":")
            if len(words) == 2:
                if words[1] != "":
                    contDict["stopAt"] = "endTime"
                    contDict["endTime"] = words[1]
        return contDict

    #
    #  changeStartStopInterval
    def changeStartStopInterval(self, caseDir):
        """ startFrom, stopAt, writeIntervalを全て書き換える。"""
        contDict = {}
        #startFrom
        startFromTime = self.entry_start.get_text()
        startDict = self.getStartDict(startFromTime)
        contDict.update(startDict)
        #stopAt
        stopAtTime = self.entry_stop.get_text()
        stopDict = self.getStopDict(stopAtTime)
        contDict.update(stopDict)
        #writeInterval
        interval = self.entry_interval.get_text()
        contDict["writeInterval"] = interval
        pyTreeFoam.case(caseDir).setControlDict(contDict)

    #
    #  changeStartFromCombo
    #  --------------------
    def changeStartFromCombo(self, caseDir, iter):
        """ controlDict内のstartFrom（combo）を書き換える"""
        #treeEventをmask
        self.maskTreeEvent = True
        #comboの選択項目を取得
        iter = self.combo_start.get_active_iter()
        model = self.combo_start.get_model()
        startFromTime = model.get_value(iter, 0)
        contDict = self.getStartDict(startFromTime)
        pyTreeFoam.case(caseDir).setControlDict(contDict)
        #treeEventを解除
        self.maskTreeEvent = False
        #message表示
        title = _(u"controlDictの書き換え")
        mess = _(u"controlDictを書き換えました\n")
        mess += _("    startFrom")
        self.okDialog(title, mess)

    #
    #  changeStartFromEntry
    #  --------------------
    def changeStartFromEntry(self, caseDir):
        """ controlDict内のstartFrom（entry）を書き換える"""
        #treeEventをmask
        self.maskTreeEvent = True
        #全内容を取得
        self.changeStartStopInterval(caseDir)
        #treeEventを解除
        self.maskTreeEvent = False
        #message表示
        title = _(u"controlDictの書き換え")
        mess = _(u"controlDictを書き換えました\n")
        mess += _("    startFrom\n")
        mess += _("    stopAt\n")
        mess += _("    writeInterval")
        self.okDialog(title, mess)

    #
    #  getStartDict
    def getStartDict(self, startFromTime):
        contDict = {}
        #startFromの内容に応じて処理
        if startFromTime == "firstTime":
            #firstTimeに設定
            contDict["startFrom"] = "firstTime"
        elif startFromTime == "latestTime":
            #latestTimeに設定
            contDict["startFrom"] = "latestTime"
        elif startFromTime[:len("startTime")] == "startTime":
            #startTimeに設定
            words = startFromTime.split(":")
            if len(words) == 2:
                if words[1] != "":
                    contDict["startFrom"] = "startTime"
                    contDict["startTime"] = words[1]
        return contDict

    #
    #  changeInterval
    #  --------------
    def changeInterval(self, caseDir):
        """ controlDict内のwriteIntervalを書き換える"""
        #treeEventをmask
        self.treeEvent = True
        #全内容を取得
        self.changeStartStopInterval(caseDir)
        #treeEventを解除
        self.maskTreeEvent = False
        #message表示
        title = _(u"controlDictの書き換え")
        mess = _(u"controlDictを書き換えました\n")
        mess += _("    startFrom\n")
        mess += _("    stopAt\n")
        mess += _("    writeInterval")
        self.okDialog(title, mess)

    #
    #  openLogFile
    #  -----------
    def openLogFile(self):
        """ logFileをopenする"""
        logFile = os.getenv("LogFile")
        pyTreeFoam.run().editor([logFile])

    #
    #  editCntDict
    #  -----------
    def editCntDict(self, openDir):
        #statusBarの設定
        self.writeStatusBar("editing controlDict etc...")
        #folderの内容を取得
        conts = getFolderConts(openDir)
        folType = conts[0]
        if folType == "case" or folType == "caseLink":
            #解析caseかどうか確認
            if openDir == solveCaseDir:
                #controlDictなどをeditorで開く
                editControlDict(openDir)
            else:
                #解析caseに設定するかどうか確認する
                okArgs = [self.editCntDict_setEditCase, openDir]
                self.isSetSolveCaseDialog(okArgs)
                return
        #statusBarClear
        self.clearStatusBar()

    def editCntDict_setEditCase(self, openDir):
        #openDirを解析caseに設定
        self.setCurrentCase()
        #editorで開く
        editControlDict(openDir)
        #statusBarClear
        self.clearStatusBar()

    #
    #  treeExpandEvent
    #  ---------------
    def treeExpandEvent(self, path):
        """ treeView上のpath,treeiterの場所を開く（expand）する"""
        #statusBar設定
        self.writeStatusBar("expnding...")
        #expandDirを取得
        expandDir = os.sep.join(self.getDirFromTreePath(path))
        #subFolder名を取得
        treeiter = self.treestore.get_iter(path)
        subFolderIter = self.getSubFoldersInTree(treeiter)
        #subFolderの下にfolderが存在するかどうか
        if self.isSubfolderInfolders(subFolderIter) == True:
            #folderが存在する場合、Treeの修正必要ないので戻る
            pass
        else:
            #実際のfolder確認し、Treeに追加する
            self.addSubFoldersInTree(expandDir, subFolderIter)
        #statusBarをclear
        self.clearStatusBar()

    def getSubFoldersInTree(self, treeiter):
        """ treeiterをparentとしてchildrenのnameとiterを取得"""
        iter = self.treestore.iter_children(treeiter)   #firstChild
        subFolders = []
        while iter:
            subFolders.append([self.treestore.get_value(iter, self.COL_DIR), iter])
            iter = self.treestore.iter_next(iter)
        return subFolders

    def isSubfolderInfolders(self, folderIter):
        """ flderIterをparentとしてchildren有無を確認"""
        flag = False
        for [dummy, treeiter] in folderIter:
            subFolders = self.getSubFoldersInTree(treeiter)
            if len(subFolders) != 0:
                flag = True
                break
        return flag

    def addSubFoldersInTree(self, expandDir, subFolderIter):
        """ 実際のfolderを取得し、Treeに追加する"""
        global treeData, folderContDict
        #追加するfolderContDataを取得
        names = list(map(lambda x: x[0], subFolderIter))
        folderConts = getFolderContData(expandDir, names)
        #folderContDictを更新
        for folderCont in folderConts:
            folderContDict[folderCont[0]] = folderCont[1:]
        #treeDataを再作成
        rootDir = treeData[0]
        createTreeData(rootDir)
        #treeViewにnodeを追加
        for folderCont in folderConts:
            itemDir = folderCont[0]
            parentDir = os.sep.join(itemDir.split(os.sep)[:-1])
            parentIter = self.getIterInTreeStore(rootDir, parentDir)
            itemName = itemDir.split(os.sep)[-1]
            weight = self.NORMAL
            color = "black"
            (folType, solver, BCPn, nR, st, ed) = getFolderConts(itemDir)
            (iconFol, iconSolv) = self.getImageIcon(folType, itemDir)
            #treeViewに追加
            self.treestore.insert(parentIter, -1, 
                            [iconFol, itemName, iconSolv, solver,
                             BCPn, nR, st, ed, weight, color])

    #
    #  setShowTooltip
    #
    def setShowTooltip(self, pos):
        """ tooltipの設定、表示。
        TreeViewで「motion-notify-event」でeventを発生させる。
        #gladeファイル内のpropertyを直接修正してtooltipを表示する。
        glgade側で、widgetの「共通」タグ内のtooltipにその内容を記述しておく。
        gladeファイルのpropertyの取得方法は、
            <widget>.property("tooltip-text") or
            <widget>.prop.tooltip_text
        で取得できる。"""
        (x, y) = pos
        pathInfo = self.treeView.get_path_at_pos(x, y)
        #pathが取得できない場合、直ぐに戻る。
        if pathInfo == None:
            return
        (path, _col, x, y) = pathInfo
        if path == None:
            return
        #dirを取得
        tooltipDirList = self.getDirFromTreePath(path)
        tooltipDir = os.sep.join(tooltipDirList)
        #選択case上にマウスカーソルがあるか？
        if tooltipDir == selCaseDir:
            #マウスカーソルの位置を取得
            colNo = self.getColumnNoFromPos(path, pos)
            if colNo in self.toolTipDict.keys():
                pass
            else:
                colNo = 2
            #位置に応じたtooltipTextを取得。
            tooltipText = self.toolTipDict[colNo]
        else:
            #tooltip非表示設定
            tooltipText = ""
        #tooltipを設定
        self.treeView.props.tooltip_text = tooltipText

    #
    #  changeCursor
    #  ------------
    def changeCursor(self, path):
        """ cursor行を変更した時の処理。
        クリックして選択した時。"""
        global selCaseDir, folderContDict
        #treeEventをmask
        self.maskTreeEvent = True
        self.writeStatusBar("changing row...")
        #選択行のdirを取得
        newDir = os.sep.join(self.getDirFromTreePath(path))
        #global変数を変更
        selCaseDir = newDir
        #selCaseDirのfolderContDictを取得して更新する
        (folType, solver, BCPn, nR, st, ed) = getFolderConts(newDir)
        if folType == "case":
            #caseの場合、caseContを再取得してDictを更新する
            (solver, BCPn, nR, st, ed) = pyTreeFoam.case(selCaseDir).getCaseCont()
            folderContDict[selCaseDir] = ["case", solver, BCPn, nR, st, ed]
        elif folType == "caseLink":
            #caseLinkの場合、caseContを再取得してDictを更新する
            (solver, BCPn, nR, st, ed) = pyTreeFoam.case(selCaseDir).getCaseCont()
            folderContDict[selCaseDir] = ["caseLink", solver, BCPn, nR, st, ed]
        #選択行を書き直す
        treeiter = self.treestore.get_iter(path)
        self.treestore.set_value(treeiter, self.COL_SOLVER, solver)
        self.treestore.set_value(treeiter, self.COL_BCPN, BCPn)
        self.treestore.set_value(treeiter, self.COL_NR, nR)
        self.treestore.set_value(treeiter, self.COL_ST, st)
        self.treestore.set_value(treeiter, self.COL_ED, ed)
        #solveCaseの場合は、entryを再読込し、再表示
        if newDir == solveCaseDir:
            self.setItemsToComboBox(solveCaseDir)
        #statusBarをクリア
        self.clearStatusBar()
        #timer5sをチェック
        self.check5sTimerEvent()
        # if self.timer5s == "off":
        #     self.timer5s = "on"
        #     self.runCheckHddResults()
        #treeEventのmaskを解除
        self.maskTreeEvent = False

    #
    #  check5sTimerEvent
    def check5sTimerEvent(self):
        """ 5s timerが動いているかどうかチェック。
        停止している場合は、起動させる。"""
        #チェック中か？
        if self.checking5sEvent == "yes":
            #チェック中は、直ぐに戻る
            return
        #flagを変更
        self.checking5sEvent = "yes"
        self.running5sEvent = "no"
        self.timer5s = "on"
        #6s後に再チェックする。
        GLib.timeout_add(6000, self.check5sTimerEvent_sub)

    def check5sTimerEvent_sub(self):
        if self.running5sEvent == "no":
            self.checkHddResults()
            self.runCheckHddResults()
        self.checking5sEvent = "no"

    #  getColumnNoFromPos
    #
    def getColumnNoFromPos(self, path, pos):
        """ pathとpos(x,y)から、そのposのcolumnNoを返す。
        colNo=-2:欄外（Y方向:header部）
        colNo=-1:欄外（X方向:dirの左側）
        colNo=0:treeDir部
        colNo=1:solver部
        colNo=2:BCPn部..."""
        for i in range(len(self.treeView.get_columns())):
            #cellサイズを取得
            # (rect.x 〜 rect.x + rect.width)
            rect = self.treeView.get_cell_area(path, self.treeView.get_column(i))
            if pos[0] < rect.x:
                break
        #mouseのx位置がcell高さよりも小さい？
        if pos[0] < rect.height:
            #treeViewのheader位置
            colNo = -2
        else:
            colNo = i - 1
        return colNo

    #
    #  showPopupMenu
    #  -------------
    def showPopupMenu(self, pos):
        """ クリック場所に応じてpopupMenuを表示する。"""
        #click場所をcolNoで取得
        treeSelection = self.treeView.get_selection()
        (dummy, pathes) = treeSelection.get_selected_rows()
        colNo = self.getColumnNoFromPos(pathes[0], pos)
        #click場所に応じてmenuItemsを取得
        if colNo == -1 or colNo == -2:
            #欄外
            return
        if colNo == 0:
            #dirMenu
            menuItems = self.dirMenuItems
        elif colNo == 1:
            #solveMenu
            menuItems = self.solveMenuItems
        elif colNo >= 2:
            #resMenu
            menuItems = self.resMenuItems
        #folTypeを取得
        folConts = getFolderConts(selCaseDir)
        folType = folConts[0]
        #popupMenu作成
        menu = Gtk.Menu()
        for i in range(len(menuItems)):
            menuName = menuItems[i]
            (itemName, accName, unSolve, unOF, func, icon) = menuName
            if itemName == "-":
                #セパレータをセット
                item = Gtk.SeparatorMenuItem()
            else:
                #menuItemをセット
                if icon != "":
                    #iconとlabelをセット
                    # item = Gtk.ImageMenuItem()
                    
                    #box = Gtk.Box()
                    box = Gtk.Box.new(Gtk.Orientation.HORIZONTAL, 0)
                    item = Gtk.MenuItem()
                    
                    img = Gtk.Image()
                    iconPath = treeFoamPath + "/icons/" + icon
                    img.set_from_file(iconPath)
                    
                    label = Gtk.Label()
                    label.set_text(itemName)
                    box.pack_start(img, False, False, 4)
                    box.pack_start(label, False, False, 4)
                    labelAcc = Gtk.Label()
                    labelAcc.set_text(accName)
                    labelAcc.set_xalign(1)                  #右詰め
                    box.pack_start(labelAcc, True, True, 0)
                    item.add(box)
                    
                    # item.set_image(img)
                    # item.set_always_show_image(True)
                    # item.set_label(menuName[0])   
                else:
                    # item = Gtk.MenuItem()
                    
                    item = Gtk.MenuItem()
                    #box = Gtk.Box()
                    box = Gtk.Box.new(Gtk.Orientation.HORIZONTAL, 0)
                    label = Gtk.Label()
                    label.set_text(itemName)
                    label.set_xalign(0)                     #左詰め
                    box.pack_start(label, True, True, 36)
                    labelAcc = Gtk.Label()
                    labelAcc.set_text(accName)
                    labelAcc.set_xalign(1)                  #右詰め
                    box.pack_start(labelAcc, True, True, 0)
                    item.add(box)
                    
                item.connect("activate", func)
                #フォルダtypeに応じて処理
                if folType != "case":
                    #非OFフォルダの場合
                    item.set_sensitive(unOF)
                elif selCaseDir != solveCaseDir:
                    #OFフォルダ非選択の場合
                    item.set_sensitive(unSolve)

            menu.append(item)
        #menuを表示
        menu.show_all()
        menu.popup(None, None, None, None, 0, Gtk.get_current_event_time())

    #
    #  doubleClickRow
    #  --------------
    def doubleClickRow(self, pos):
        """ doubleClick時の処理"""
        #click場所をcolNoで取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        colNo = self.getColumnNoFromPos(pathes[0], pos)
        if colNo < 0:
            #解析caseに設定する
            self.setCurrentCase()
        elif colNo == 0:
            #そのfolderを開く
            openFolder(selCaseDir)
        elif colNo == 1:
            #controlDict編集
            self.editCntDict(selCaseDir)
        elif colNo >= 2:
            #paraFoamを起動
            #self.runParaFoam(solveCaseDir)
            self.runParaFoam(selCaseDir)

    #
    #  pressMouseButton
    #  ----------------
    def pressMouseButton(self, widget, event):
        """ 左右クリック、ダブルクリック時の動作。
        eventは、クリックした瞬間に発生しているので、
        TreeViewのrowは未だ選択されていない状態。"""
        pos = (event.x, event.y)
        #rightClick?
        if event.button == 3:
            self.clickMode = "rightClick"   #clickModeを保存
            treeSelection = self.treeView.get_selection()
            #rightClick場所を取得
            pathinfo = self.treeView.get_path_at_pos(event.x, event.y)
            path, _col, _x, _y = pathinfo
            #ctrKeyのチェック
            if self.ctrlKeyFlag == 1:
                #選択が反転する（非選択）ので、0.1s後に再度選択する
                thread = threading.Thread(target=self.afterSelectRow, args=(path,))
                thread.start()
            else:
                #ctrKeyを押していない場合
                _treestore, selPathes = treeSelection.get_selected_rows()
                if len(selPathes) == 1:
                    treeSelection.unselect_all()
                #右クリック行のみ選択
                treeSelection.select_path(path)
            #現在のselectedPathを保存（onChangeCursorで使用する）
            _treestore, self.beforeSelectPathes = treeSelection.get_selected_rows()
            #popupMenu表示
            self.showPopupMenu(pos)
        #single or doubleClick?
        elif event.button == 1:
            if event.type.value_name == "GDK_2BUTTON_PRESS":
                self.clickMode = "doubleClick"
                #doubleClick:columnに応じた動作
                self.doubleClickRow(pos)
            elif event.type.value_name == "GDK_BUTTON_PRESS":
                #singleClickの動作
                self.clickMode = "click"

    def afterSelectRow(self, path):
        """ 0.1s後にpathを選択する"""
        time.sleep(0.1)
        treeSelection = self.treeView.get_selection()
        treeSelection.select_path(path)

    #
    #  keyPress
    #  --------
    def keyPress(self, event):
        """ key press eventの処理"""
        keyName = Gdk.keyval_name(event.keyval)
        if keyName == "Delete":
            self.deleteFolders()        #deleteFolders
        elif keyName == "F2":
            self.renameFolder()         #renameFolder
        elif keyName == "Return":
            openFolder(selCaseDir)      #openFolder
        elif keyName == "Right":
            self.expandTree()           #expand
        elif keyName == "Left":
            self.collapseTree()         #collapse
        elif keyName == "Up":
            self.upCursorTree()
        elif keyName == "Down":
            self.downCursorTree()
        #controlKey?
        if keyName == "Control_L" or keyName == "Control_R":      #controlKey?
            self.ctrlKeyFlag = 1
        elif self.ctrlKeyFlag == 1: 
            if keyName.lower() == "c":
                #ctrl+c（コピー）の処理
                self.copyFolders()
            elif keyName.lower() == "v":
                #ctrl+v（貼り付け）の処理
                self.pasteFolders()
            elif keyName.lower() == "b":
                #ctrl+b（case貼り付け）の処理
                self.pasteCases()
            elif keyName .lower() == "n":
                #ctrl+n（新しいfolder追加）の処理
                self.addNewFolder()

    #
    #  keyRelease
    #  ----------
    def keyRelease(self, event):
        """ key release eventの処理
            control keyを押しているか確認の為"""
        keyName = Gdk.keyval_name(event.keyval)
        if keyName == "Control_L" or keyName == "Control_R":
            self.ctrlKeyFlag = 0

    #
    #  sigUser1
    #-----------
    def sigUser1(self):
        """ signal.SIGUSER1のhandler"""
        #1s後に処理する
        GLib.timeout_add(1000, self.sigUser1Handler)

    def sigUser1Handler(self):
        """ signal.SIGUSER1のhandler"""
        global selCaseDir, solveCaseDir
        fileName = treeFoamUserPath + "/temp/signalData"
        if os.path.exists(fileName) == False:
            return
        f = open(fileName); lines = f.readlines(); f.close()
        for i in range(len(lines)):
            line = lines[i]
            print(line, end="")
            words = line.split()
            if words[0] == "changeCursor":
                #解析caseを設定する。
                print(lines[i+1], end="")
                ws = lines[i+1].split()
                newDir = ws[1]
                solveCaseDir = newDir
                selCaseDir = newDir
                self.reload()
                break
        os.remove(fileName)


    #  ---------- application の起動 ----------------
    #
    #  iniCase
    #  -------
    def iniCase(self):
        """ caseを初期化する"""
        global folderContDict
        print(_("caseを初期化する"))
        case = pyTreeFoam.case(solveCaseDir)
        needFolders = case.getIniCaseFolders()
        needFiles = case.getIniCaseFiles()
        allFolders = pyTreeFoam.getFolders(solveCaseDir)
        allFiles = pyTreeFoam.getFiles(solveCaseDir)
        if len(allFolders) > len(needFolders) or len(allFiles) > len(needFiles):
            title = _("caseの初期化")
            msg = _("計算結果や不要なファイルを削除して、caseを初期化します。")
            okArgs = [self.iniCase_checkCase, allFolders, needFolders, allFiles, needFiles]
            self.okCancelDialog(title, msg, funcOk=okArgs)
            return
    
    def iniCase_checkCase(self, allFolders, needFolders, allFiles, needFiles):
        """ 解析caseと選択caseが異なっているかチェック"""
        if selCaseDir != solveCaseDir:
            title = _("caseの初期化")
            msg = _("解析caseと選択しているcaseが異なっています。\n　解析caseを初期化しますか？")
            okArgs = [self.iniCase_run, allFolders, needFolders, allFiles, needFiles]
            self.okCancelDialog(title, msg, funcOk=okArgs)
            return
        self.iniCase_run(allFolders, needFolders, allFiles, needFiles)
    
    #  iniCase_run
    def iniCase_run(self, allFolders, needFolders, allFiles, needFiles):
        """ caseを初期化する"""
        #folderを削除
        delFolders = set(allFolders).difference(needFolders)
        for delDir in delFolders:
            shutil.rmtree(delDir)
        #fileを削除
        delFiles = set(allFiles).difference(needFiles)
        for delFile in delFiles:
            os.remove(delFile)
        #folderContDict内から対象のfolderを削除
        keyList = list(folderContDict.keys())
        keyList.sort()
        solveCaseWords = solveCaseDir.split("/")
        for key in keyList:
            keyWords = key.split("/")
            if keyWords[:len(solveCaseWords)] == solveCaseWords:
                dummy = folderContDict.pop(key)
        #対象のfolder以下を再取得
        folders = [solveCaseDir]
        folders += pyTreeFoam.getNeedFolders(solveCaseDir)
        folders += pyTreeFoam.getChildFolders(folders)
        folderConts = addFolderContsData(folders)
        for folderCont in folderConts:
            folderContDict[folderCont[0]] = folderCont[1:]
        #再表示
        #treeDataを再作成
        rootDir = treeData[0]
        createTreeData(rootDir)
        #treeViewをクリア
        rootIter = self.getIterInTreeStore(rootDir, rootDir)
        self.deleteAllChildren(rootIter)
        #treeViewを再作成
        items = treeData[1]
        parentName = rootDir
        self.addTreeNodes([parentName], self.treestore, rootIter, items)
        #solveCaseDirまで展開する
        parentDir = os.sep.join(solveCaseDir.split(os.sep)[:-1])
        path = self.getPathInTreeStore(rootDir, parentDir)
        self.treeView.expand_to_path(path)
        self.setSelSolveCaseInTree(rootDir, solveCaseDir)
        #解析case、選択caseの展開、選択
        self.expandSelSolveCase(rootDir, solveCaseDir, solveCaseDir)
        #solveCaseを再読み込み
        path = self.getPathInTreeStore(rootDir, solveCaseDir)
        self.changeCursor(path)
        #solveCaseを選択表示させる
        treeSelection = self.treeView.get_selection()
        treeSelection.unselect_all()
        treeSelection.select_path(path)

    #
    #  deleteResult
    #  ------------
    def deleteResult(self):
        """ 計算結果folderのみ削除する"""
        print(_("計算結果のみ削除する"))
        #case直下のtimeFolderを削除
        timeFolders = pyTreeFoam.case(solveCaseDir).getTimeFolders()
        if len(timeFolders) > 1:
            title = _("結果フォルダの削除")
            msg = _("最小時間のフォルダのみ残し、それ以外をゴミ箱に移動します。")
            okArgs = [self.deteteResult_checkCase, timeFolders]
            self.okCancelDialog(title, msg, funcOk=okArgs)

    #  deteteResult_checkCase
    def deteteResult_checkCase(self, timeFolders):
        if selCaseDir != solveCaseDir:
            title = _("結果フォルダの削除")
            msg = _("解析caseと選択しているcaseが異なっています。\n　解析caseの結果フォルダを削除しますか？")
            okArgs = [self.deleteResult_run, timeFolders]
            self.okCancelDialog(title, msg, funcOk=okArgs)
            return
        else:
            self.deleteResult_run(timeFolders)

    #  deleteResult_run
    def deleteResult_run(self, timeFolders):
        """ timeFolder内の結果を削除する"""
        #timeFolder内の結果fileの削除開始
        timeFolders.sort()
        for i in range(1, len(timeFolders)):
            delDir = solveCaseDir + os.sep + timeFolders[i]
            shutil.rmtree(delDir)
        #並列計算結果の削除
        folders = pyTreeFoam.getFolderNames(solveCaseDir)
        if len(glob.glob(solveCaseDir+os.sep+"processor*")) > 0:
            case = pyTreeFoam.case(solveCaseDir)
            timeFolders = case.getTimeFolders("processor0")
            if len(timeFolders) > 1:
                #削除開始
                for folder in folders:
                    if folder[:len("processor")] == "processor":
                        delFolders = case.getTimeFolders(folder)
                        for delFolder in delFolders[1:]:
                            delDir = os.sep.join([solveCaseDir, folder, delFolder])
                            shutil.rmtree(delDir)
        #solveCaseを再読み込み
        path = self.getPathInTreeStore(rootDir, solveCaseDir)
        self.changeCursor(path)

    #
    #  runSolver
    #  ---------
    def runSolver(self):
        """ controlDict内のsolverを実行する"""
        print(_("solverの実行"))
        #controlDict内の「runTimeModifiable」をチェック
        contDict = pyTreeFoam.case(solveCaseDir).getControlDict()
        mod = contDict["runTimeModifiable"].lower()
        if not(mod == "true" or mod == "yes" or mod == "on"):
            title = _("runTimeModifiableのチェック")
            mess = _("controlDict内のrunTmeModifiableが「no」になっています。\n")
            mess += _("計算中にcontrolDict内の修正ができません。\n")
            mess += _("このまま計算を開始しますか？")
            yesArgs = [self.runSolver_run, contDict]
            self.yesNoDialog(title, mess, funcYes=yesArgs)
            return
        self.runSolver_run(contDict)
            
    #  runSolver_run
    def runSolver_run(self, contDict):
        solver = contDict["application"]
        # if solver == "":
        #     if contDict["solver"] != "":
        #         solver = "foamRun"
        #         dataDict = {"application": "foamRun"}
        #         pyTreeFoam.case(solveCaseDir).setControlDict(dataDict)
        #     elif contDict["regionSolvers"] != "":
        #         solver = "foamMultiRun"
        #         dataDict = {"application": "foamMultiRun"}
        #         pyTreeFoam.case(solveCaseDir).setControlDict(dataDict)
        #    else:
        if solver == "":
            title = _("エラー")
            message = _("「controlDict」は、存在しません。\n")
            message = message + _("case directory が間違っています。")
            self.errDialog(title, message)
            return
        #スクリプトを作成
        cont  = "#!/bin/bash\n"
        cont += ". " + envOpenFOAMFix + "\n"
        #cont += solver + " | tee solve.log\n"
        #cont += solver + " 2>&1 | teeCorrect.py solve.log\n"
        cont += solver + " 2>&1 | tee solve.log\n"
        fileName = solveCaseDir + os.sep + "run"
        f = open(fileName, "w"); f.write(cont); f.close()
        runCase = pyTreeFoam.run(solveCaseDir)
        runCase.command("chmod a+x run")
        runCase.foamTerminal("run")

    #
    #  plotWatcher
    #  -----------
    def plotWatcher(self):
        """ plotWatcherの起動"""
        folType = pyTreeFoam.getFolderType(solveCaseDir)
        if folType != "case":
            title = _("エラー")
            mess = _("OpenFOAMのcaseでは、ありません。")
            self.errDialog(title, mess)
            return
        contDict = pyTreeFoam.case(solveCaseDir).getControlDict()
        configDict = pyTreeFoam.readConfigTreeFoam()
        solver = contDict["application"]
        envOpenFoam = configDict["bashrcFOAM"]
        runPlotWatcher = configDict["plotWatcher"]
        logFile = solveCaseDir + "/solve.log"
        if len(glob.glob(logFile)) == 0:
            logFile = solveCaseDir + "/log." + solver
            if len(glob.glob(logFile)) == 0:
                title = _("エラー")
                mess = _("logFileがありません。") + "\n"
                mess += _("計算開始させて、logFileを作成してください。")
                self.errDialog(title, mess)
                return
        cont = "#!/bin/bash\n"
        cont += ". " + envOpenFoam + "\n"
        cont += "echo \n"
        cont += 'echo -n "running plotWatcher\n"\n'
        cont += runPlotWatcher + " " + logFile + "\n"
        # if os.getenv("venvPython") == "yes":
        #     #仮想環境
        #     pythonName = os.getenv("venvPythonName")
        # else:
        #     pythonName = "python3"
        # cont += pythonName + " $pyFoamDir/bin/pyFoamPlotWatcher.py " + logFile + " > /dev/null\n"
        fileName = solveCaseDir + "/plotWatcher"
        f = open(fileName, "w"); f.write(cont); f.close()
        pyTreeFoam.run(solveCaseDir).command("chmod a+x " + fileName)
        comm = pyTreeFoam.TerminalRun + " " + fileName
        pyTreeFoam.run(solveCaseDir).command(comm)

    #
    #  runParallel
    #--------------
    def runParallel(self):
        path = os.getenv("TreeFoamPath") + "/python"
        comm = path + "/runParallelDialog.py " + solveCaseDir + " &"
        pyTreeFoam.run(solveCaseDir).command(comm)

    #
    #  runCoupling
    #---------------
    def runCoupling(self):
        """ openFOAMとFrontISTRの連成解析"""
        path = os.getenv("TreeFoamPath") + "/python"
        comm = path + "/couplingToFistrDialog.py " + solveCaseDir + " &"
        pyTreeFoam.run(solveCaseDir).command(comm)

    #
    #  runCad
    #  ------
    def runCad(self, wdir):
        """ CADの起動"""
        contDict = pyTreeFoam.readConfigTreeFoam()
        cad = contDict["CAD"]
        #comm = cad + " " + wdir + " &"
        comm = cad + " &"
        print(comm)
        pyTreeFoam.run(wdir).commandWithLog(comm)

    #
    #  runTerm
    #----------
    def runTerm(self, wdir):
        """ 端末の起動"""
        pyTreeFoam.run(wdir).terminal()

    #
    #  runFoamTerm
    #  -----------
    def runFoamTerm(self, wdir):
        """ FOAM端末の起動"""
        pyTreeFoam.run(wdir).foamTerminal(envOpenFOAMFix)

    #
    #  runGridEditor
    #----------------
    def runGridEditor(self, currDir):
        """ gridEditor起動"""
        commPath = os.getenv("TreeFoamPath") + "/python"
        comm = commPath + "/openGridEditorDialog.py " + nTreeFoam + " " + currDir
        pyTreeFoam.run(currDir).command(comm)

    #
    #  runMeshViewer
    #----------------
    def runMeshViewer(self, wdir):
        """ meshViewerの起動"""
        if self.meshViewer != "":
            if self.meshViewer.isAlive() == True:
                title = _("meshViewer")
                mess = _("meshViewerは、既に起動しています。")
                self.errDialog(title, mess)
                return
        folType = pyTreeFoam.getFolderType(wdir)
        if folType == "case" or folType == "caselink":
            if wdir != solveCaseDir:
                #解析caseに設定するかどうか確認する
                okArgs = [self.runMeshViewer_setCaseRun, wdir]
                self.isSetSolveCaseDialog(okArgs)
                return
            self.openMeshViewer(wdir)
        else:
            self.openMeshViewer(wdir)
            title = _("meshViewerの起動")
            mess = _("このfolderは、OpenFOAMのcaseフォルダではありません。") + "\n"
            self.errDialog(title, mess)
            return

    #  runMeshViewer_setCaseRun
    def runMeshViewer_setCaseRun(self, wdir):
        self.setCurrentCase()
        self.openMeshViewer(wdir)

    #
    #  openMeshViewer
    def openMeshViewer(self, caseDir):
        try:
            timeFolder = pyTreeFoam.case(caseDir).getCurrTimeFolder()
        except:
            timeFolder = "0"
        region = "."
        title = "meshViewer_TreeFoam_" + nTreeFoam
        self.meshViewer = meshViewerControl.control(caseDir, timeFolder, region, title)
        self.meshViewer.openViewer("full")
        case = pyTreeFoam.case(caseDir)
        stlDir = case.getCreateMeshData()["stlDir"]
        if stlDir == "":
            stlDir = "model"
        commLines  = [_("start\n")]
        commLines += [_("mess TreeFoamにlinkしています。\n")]
        commLines += [_("addMess '  patch, zone, set, stlが表示できます。'\n")]
        commLines += [_("addMess '  tree内の選択した項目が表示されます。'\n")]
        commLines += [_("time startFrom\n")]
        commLines += [_("stlDir ") + stlDir + "\n"]
        commLines += [_("print 'loading ...'\n")]
        commLines += [_("wait 0.2s\n")]     #GUIを完成させる為のwait
        commLines += [_("load all\n")]
        commLines += [_("show\n")]
        commLines += [_("resetCamera\n")]
        commLines += [_("setTreeList\n")]
        commLines += [_("end\n")]
        _stat = self.meshViewer.runMultiCommands(commLines)

    #
    #  runParaFoam
    #  -----------
    def runParaFoam(self, wdir):
        """ paraFoamの起動"""
        folType = pyTreeFoam.getFolderType(wdir)
        if folType == "case" or folType == "caselink":
            #解析caseかどうか確認
            if wdir != solveCaseDir:
                #解析caseい設定するかどうか確認する
                okArgs = [self.runParaFoam_setCaseRun, wdir]
                self.isSetSolveCaseDialog(okArgs)
                return
            #paraViewを起動
            self.runParaFoam_getOption(wdir)
        else:
            title = _("paraViewの起動")
            mess = _("このfolderは、OpenFOAMのcaseフォルダではありません。") + "\n"
            mess += _("  paraViewを起動しますか？")
            okArgs = [self.runParaFoam_runParaview, wdir]
            self.okCancelDialog(title, mess, funcOk=okArgs)
            return

    #  runParaFoam_setCaseRun
    def runParaFoam_setCaseRun(self, wdir):
        """ 選択caseを解析caseに設定してparaFoamを起動する。"""
        #openDirを解析caseに設定
        self.setCurrentCase()
        self.runParaFoam_getOption(wdir)

    #  runParaFoam_runParaview
    def runParaFoam_runParaview(self, wdir):
        """ paraviewのみを起動する"""
        comm = "paraview &"
        print(comm)
        pyTreeFoam.run(wdir).command(comm)

    #  runParaFoam_run
    def runParaFoam_getOption(self, wdir):
        """ paraViewを起動する"""
        [isRegion, _loc, _regNames] = pyTreeFoam.case(wdir).isMultiRegion()
        okArgs = [self.runParaFoam_run, wdir]
        dialog = runParaFoamOptionDDialog.runParaFoamOption(isRegion, funcOk=okArgs, parent=mainWindow)
        dialog.show()
        return

    #  runParaFoam_run
    def runParaFoam_run(self, option, wdir):
        #出力をlogFileにもteeで出力させる
        contDict = pyTreeFoam.readConfigTreeFoam()
        paraFoam = contDict["paraFoam"]
        comm = paraFoam + " " + option + " &"
        print(comm)
        pyTreeFoam.run(wdir).commandWithLog(comm)

    #
    #  runSalome
    #  ---------
    def runSalome(self, wdir):
        """ Salomeの起動"""
        contDict = pyTreeFoam.readConfigTreeFoam()
        salome = contDict["salomeMeca"]
        comm = salome + " " + wdir + " &"
        print(comm)
        pyTreeFoam.run(wdir).command(comm)

    #
    #  helpUsage
    #------------
    def helpUsage(self):
        """ 使い方の表示"""
        #firefox終了時エラーが出るので、firefoxのエラー表示をキャンセル
        treeFoamDir = os.getenv("TreeFoamPath")
        #comm = "firefox " + treeFoamDir + "/help/TreeFoam-manual.pdf 2> /dev/null &"
        comm = "evince " +  treeFoamDir + "/help/TreeFoam-manual.pdf 2> /dev/null &"
        pyTreeFoam.run().command(comm)

    #
    #  helpVersion
    #--------------
    def helpVersion(self):
        """ TreeFoamのversionを表示"""
        title = _("TreeFoamのversion")
        mess = "TreeFoam-" + version + "\n\n"
        mess += " "*20 + "programed by s.Fujii"
        self.okDialog(title, mess)
    #----Dexcs用追加--------------
    def dexcsReload(self):
        self.writeStatusBar(u"tree data を読み込み中...")
        #currentCaseを保存
        item = self.treeView.get_selection()
        #selCaseDir = self.getDirectory(item)
        #再読込
        self.reload()
        #caseName, solverをlabelにセット
        #caseItem = self.getItem(solveCaseDir)
        #self.changeSolveCase(caseItem)
        #currentCaseを設定
        #self.setSelectCase(self.convDirToList(selCaseDir))
        #self.clearStatus()
    def runDexcsDispBlockMesh(self,event):
        contDict = pyTreeFoam.readConfigTreeFoam()
        paraFoam = contDict["paraFoam"]
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.dispBlockMesh(solveCaseDir, paraFoam)
        self.dexcsReload()
        #event.Skip()
    def runDexcsBlockMesh(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runBlockMesh(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsCheckMesh(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runCheckMesh(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsCfMesh(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runCfMesh(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsAllrun(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runAllrun(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsAllclean(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runAllclean(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsSubmitJob(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runSubmitJob(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsSubmitStatus(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runSubmitStatus(solveCaseDir, envOpenFOAMFix)
        self.dexcsReload()
        #event.Skip()
    def runDexcsJGP(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runJGP(solveCaseDir, envOpenFOAMFix)
        #event.Skip()
    def runDexcsPlotTool(self,event):
        #global solveCaseFix, envOpenFOAMFix
        pyDexcsSwak.runPlotTool(solveCaseDir, envOpenFOAMFix)
        #event.Skip()
    def runDexcsKdiff3(self,event):
        os.system("kdiff3 " + solveCaseDir + " &")
        #event.Skip()
    def runDexcsSearch(self,event):
        #global envOpenFOAMFix
        pyDexcsSwak.runSearch(envOpenFOAMFix)
        #event.Skip()
    #-----------------------------

    #  ---------- copy paste 関連 -------------------
    #
    #  copyFolders
    #  -----------
    def copyFolders(self):
        """ 選択folderをclipboardへコピーする"""
        global clipboardFile
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        copyDirs = []
        for path in pathes:
            copyDirList = self.getDirFromTreePath(path)
            copyDir = os.sep.join(copyDirList)
            copyDirs.append(copyDir)
        f = open(clipboardFile, "w")
        f.write("foldersCopy\n")
        for copyDir in copyDirs:
            print("copy--->", copyDir)
            f.write(copyDir+"\n")
        f.close()
        copyPasteFolders.copyFolders(copyDirs)
        # comm = "./copyToSystemClipBoard.py " + clipboardFile + " &"
        # path = treeFoamPath + os.sep + "python"
        # pyTreeFoam.run(path).commandWithLog(comm)

    #
    #  pasteFolders
    #  ------------
    def pasteFolders(self):
        """ clipboardの内容をpasteする"""
        global clipboardFile
        #statusBar,treeEvenyをマスク
        self.writeStatusBar("copying...")
        self.maskTreeEvent = True
        #pasteDirのpathを取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        pasteDirList = self.getDirFromTreePath(pathes[0])
        pasteDir = os.sep.join(pasteDirList)
        #clipboardの内容を取得
        copyDirs = copyPasteFolders.pasteFolders()
        #copyDirをpasteして、Treeに表示（threadで実行）
        self.threadPaste(copyDirs, pasteDir)

    #
    #  threadPaste
    def threadPaste(self, copyDirs, pasteDir):
        """ folder貼り付け、treeに反映する。
        threadで実行する為に作成"""
        global folderContDict, selCaseDir
        treeSelection = self.treeView.get_selection()
        treeSelection.unselect_all()
        stat = copyLocalToLocal(copyDirs, pasteDir)
        if stat == "CANCEL":
            title = _("folderコピー")
            mess = _("folderコピーを中断しました")
            #self.warningDialog(title, mess)
            GLib.timeout_add(200, self.warningDialog, title, mess)
        elif stat == "error":
            title = _("エラー")
            mess = _("コピーエラーが発生しました。\n")
            mess += _("  logを確認してください。")
            GLib.timeout_add(200, self.errDialog, title, mess)
        elif stat == "warningLink":
            title = _("警告")
            mess = _("linkコピーでエラー発生の為、link元をコピーしました。")
            GLib.timeout_add(200, self.warningDialog, title, mess)
        #folderContDict作成
        newFolders = pyTreeFoam.getNeedFolders(pasteDir)
        newFolders += pyTreeFoam.getChildFolders(newFolders)
        #folderContを取得
        folderConts = addFolderContsData(newFolders)
        if len(folderConts) > 0:
            #threadデータをセット
            self.threadShowTreeDir = [pasteDir, folderConts]
        else:
            #pasteDirを選択表示させる
            treeSelection = self.treeView.get_selection()
            treeSelection.unselect_all()
            path = self.getPathInTreeStore(rootDir, pasteDir)
            treeSelection.select_path(path)
            selCaseDir = pasteDir
        #statusBarとeventのマスクを解除
        self.clearStatusBar()
        self.maskTreeEvent = False

    #
    #  showTreeViewAtNewFolderDict
    #
    def showTreeViewAtNewFolderDict(self, pasteDir):
        """ 新しいfolderContDictを使って、treeViewを再作成する。
        tree再作成後、pasteDir以下を再作成し、pasteDirを選択表示させる。
        追加（paste）したdirを選択表示させる。""" 
        global treeData, selCaseDir
        rootDir = treeData[0]
        pastePath = self.getPathInTreeStore(rootDir, pasteDir)
        children = getChildrenFromTreeData(pastePath)
        #treeDataを再作成
        createTreeData(rootDir)
        #copy前のchildrenNamesをTreeから取得
        newChildren = getChildrenFromTreeData(pastePath)
        #追加するitemNamesを取得
        addChildren = list(set(newChildren).difference(set(children)))
        if len(addChildren) == 0:
            return
        #pastedirのchildrenを全て削除し、
        # 　solvecaseDirがpasteDirならば、solveCaseDirを再設定する
        #childrenを削除する
        pasteIter = self.getIterInTreeStore(rootDir, pasteDir)
        self.deleteAllChildren(pasteIter)
        #新しいchildrenをtreeViewに追加する
        items = getParentTreeData(pastePath)
        pasteName = pasteDir.split(os.sep)[-1]
        self.addTreeNodes([pasteName], self.treestore, pasteIter, items)
        #pasteDirを展開する
        self.treeView.expand_row(pastePath, False)
        #solveCaseDirを確認
        solveCaseDirPath = self.getPathInTreeStore(rootDir, solveCaseDir)
        solveCaseDirList = self.getDirFromTreePath(solveCaseDirPath)
        pasteDirList = self.getDirFromTreePath(pastePath)
        if solveCaseDirList[:len(pasteDirList)] == pasteDirList:
            #solveCaseDirのcolor、iconを再設定
            self.setSelSolveCaseInTree(rootDir, solveCaseDir)
        #追加itemのdirを取得
        addItemDirs = []
        for addChild in addChildren:
            addItemDirs.append(pasteDir + os.sep + addChild)
        #cursorを設定
        cursorDir = addItemDirs[-1]
        cursorPath = self.getPathInTreeStore(rootDir, cursorDir)
        self.treeView.set_cursor(cursorPath, None, False)
        #追加itemを選択表示させる
        treeSelection = self.treeView.get_selection()
        treeSelection.unselect_all()
        for itemDir in addItemDirs:
            path = self.getPathInTreeStore(rootDir, itemDir)
            treeSelection.select_path(path)
        #selCaseDirを設定する
        selCaseDir = addItemDirs[0]
        #selCaseDirまでscrollする
        path = self.getPathInTreeStore(rootDir, selCaseDir)
        self.treeView.scroll_to_cell(path)

    #
    #  pasteCases
    #  ----------
    def pasteCases(self):
        """ clipboard内のcaseから、結果folderなどを除いてpasteする"""
        global clipboardFile
        #statusBar,treeEvenyをマスク
        self.writeStatusBar("copying...")
        self.maskTreeEvent = True
        #pasteDirのpathを取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        pasteDirList = self.getDirFromTreePath(pathes[0])
        pasteDir = os.sep.join(pasteDirList)
        #clipboardの内容を取得
        copyDirs = copyPasteFolders.pasteFolders()
        # pasteContFile = treeFoamUserPath + os.sep + "data" + os.sep + "pasteNames"
        # comm = "./pasteFromSystemClipBoard.py " + pasteContFile
        # path = treeFoamPath + os.sep + "python"
        # pyTreeFoam.run(path).command(comm)
        # f = open(pasteContFile); cont = f.read(); f.close()
        # copyDirs = cont.split()
        #caseをpaste、treeの表示（threadを投げて直ぐに戻る）
        th = threading.Thread(target=self.threadPasteCases, args=(copyDirs, pasteDir))
        th.start()

    #
    #  threadPasteCases
    def threadPasteCases(self, caseDirs, pasteDir):
        """ caseのみを貼り付ける（結果folderなどは貼り付けない
        threadで実行する"""
        global folderContDict
        stat = copyCaseLocalToLocal(caseDirs, pasteDir)
        if stat == "CANCEL":
            title = _("caseコピー")
            mess = _("caseコピーを中断しました")
            #self.warningDialog(title, mess)
            GLib.timeout_add(200, self.warningDialog, title, mess)
        elif stat == "error":
            title = _("エラー")
            mess = _("コピーエラーが発生しました。\n")
            mess += _("  logを確認してください。")
            #self.errDialog(title, mess)
            GLib.timeout_add(200, self.errDialog, title, mess)
        elif stat == "warningLink":
            title = _("警告")
            mess = _("linkコピーでエラー発生の為、link元をコピーしました。")
            GLib.timeout_add(200, self.warningDialog, title, mess)
        #folderContDict作成
        newFolders = pyTreeFoam.getNeedFolders(pasteDir)
        newFolders += pyTreeFoam.getChildFolders(newFolders)
        #folderContを取得
        folderConts = addFolderContsData(newFolders)
        #threadデータをセット
        self.threadShowTreeDir = [pasteDir, folderConts]
        #statusBarとeventのマスクを解除
        self.clearStatusBar()
        self.maskTreeEvent = False

    #
    #  pasteMesh
    #-------------
    def pasteMesh(self):
        """ caseのmeshを貼り付ける"""
        global clipboardFile, selCaseDir
        #copyDirを取得
        error = ""
        if os.path.exists(clipboardFile) == False:
            error = _("folderがコピーされていません")
        else:
            f = open(clipboardFile); lines = f.readlines(); f.close()
            dirs = list(map(lambda x: x[:-1], lines[1:]))
            if len(dirs) != 1:
                error = _("複数のfolderがコピーされています")
        if error == "":
            folType = pyTreeFoam.getFolderType(dirs[0])
            if not(folType == "case" or folType == "caseLink"):
                error = _("copyDirは、OpenFOAMのcaseではありません")
        if error != "":
            title = _("エラー")
            self.errDialog(title, error)
            return
        copyDir = dirs[0]
        #pasteDirを取得
        pasteDir = selCaseDir
        folType = pyTreeFoam.getFolderType(pasteDir)
        if not(folType == "case" or folType == "caseLink"):
            error = _("pasteDirは、OpenFOAMのcaseではありません")
            title = _("エラー")
            self.errDialog(title, error)
            return
        #meshCopy
        comm = "pasteMeshDialog.py " + copyDir + " " + pasteDir + " &"
        pyTreeFoam.run().command(comm)

    #
    #  pasteFieldsMapping
    #---------------------
    def pasteFieldsMapping(self):
        """ case内のfieldDataを別のcaseにmappingする"""
        global clipboardFile, selCaseDir
        #copyDirを取得
        error = ""
        if os.path.exists(clipboardFile) == False:
            error = _("folderがコピーされていません")
        else:
            f = open(clipboardFile); lines = f.readlines(); f.close()
            dirs = list(map(lambda x: x[:-1], lines[1:]))
            if len(dirs) != 1:
                error = _("複数のfolderがコピーされています")
        if error == "":
            folType = pyTreeFoam.getFolderType(dirs[0])
            if not(folType == "case" or folType == "caseLink"):
                error = _("copyDirは、OpenFOAMのcaseではありません")
        if error != "":
            title = _("エラー")
            self.errDialog(title, error)
            return
        copyDir = dirs[0]
        #pasteDirを取得
        pasteDir = selCaseDir
        folType = pyTreeFoam.getFolderType(pasteDir)
        if not(folType == "case" or folType == "caseLink"):
            error = _("pasteDirは、OpenFOAMのcaseではありません")
            title = _("エラー")
            self.errDialog(title, error)
            return
        #mapping
        comm = "pasteFieldsMappingDialog.py " + copyDir + " " + pasteDir + " &"
        pyTreeFoam.run().command(comm)

    #
    #  renameFolder
    #--------------
    def renameFolder(self):
        """ 選択しているfolder名を変更する"""
        global folderContDict, selCaseDir, solveCaseDir
        #選択folderのdirを取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        if len(pathes) > 1:
            title = _("エラー")
            mess = _("複数選択しています。") + "\n"
            mess += _("  1ヶのfolderを選択してください。")
            self.errDialog(title, mess)
            return
        #選択dirを取得
        folderDirList = self.getDirFromTreePath(pathes[0])
        folderDir = os.sep.join(folderDirList)
        if folderDir == rootDir:
            title = _("エラー")
            mess = _("rootDirは、renameできません")
            self.errDialog(title, mess)
            return
        #newNameを取得
        title = _("folder名の変更")
        mess = _("新しいfolder名を入力してください。")
        text = folderDirList[-1]
        okArgs = [self.renameFolder_run, folderDir]
        dialog = inputTextDDialog.getInputText(title, mess, text, funcOk=okArgs)
        dialog.show()
        return

    #  renameFolder_run
    def renameFolder_run(self, newName, folderDir):
        global folderContDict, selCaseDir, solveCaseDir
        #renameする
        newDir = os.path.dirname(folderDir) + "/" + newName 
        #newDir = "/".join(folderDirList[:-1] + [newName])
        os.rename(folderDir, newDir)
        #旧のdirを辞書から削除して、新のdirを追加
        folders = list(folderContDict.keys())
        delKeys = [folderDir]
        delKeys += list(filter(lambda x: x[:len(folderDir)+1] == folderDir+"/", folders))
        for delKey in delKeys:
            #旧の内容を取得
            folderCont = folderContDict[delKey]
            #旧を削除
            folderContDict.pop(delKey)
            #新を追加
            newKey = newDir + delKey[len(folderDir):]
            folderContDict[newKey] = folderCont

        #treeを再表示
        #  treeData再作成
        createTreeData(rootDir)
        #  親dir以下のchildrenを削除
        parentDir = "/".join(newDir.split("/")[:-1])
        parentIter = self.getIterInTreeStore(rootDir, parentDir)
        self.deleteAllChildren(parentIter)
        #  新しいchildrenをtreeViewに追加
        parentPath = self.getPathInTreeStore(rootDir, parentDir)
        items = getParentTreeData(parentPath)
        parentName = os.path.basename(parentDir)
        self.addTreeNodes([parentName], self.treestore, parentIter, items)
        #  parentDirを展開する
        self.treeView.expand_row(parentPath, False)
        #  solveCaseDirを確認
        if solveCaseDir[:len(folderDir)] == folderDir:
            solveCaseDir = newDir + solveCaseDir[len(folderDir):]
        solveCaseDirPath = self.getPathInTreeStore(rootDir, solveCaseDir)
        solveCaseDirList = self.getDirFromTreePath(solveCaseDirPath)
        parentDirList = self.getDirFromTreePath(parentPath)
        if solveCaseDirList[:len(parentDirList)] == parentDirList:
            #solveCaseDirのcolor、iconを再設定
            self.setSelSolveCaseInTree(rootDir, solveCaseDir)
        #  cursorを設定
        path = self.getPathInTreeStore(rootDir, newDir)
        self.treeView.set_cursor(path, None, False)
        #  newDirを選択表示させる
        treeSelection = self.treeView.get_selection()
        treeSelection.unselect_all()
        treeSelection.select_path(path)
        selCaseDir = newDir
        #newDirまでscrollする
        self.treeView.scroll_to_cell(path)

    #
    #  expandTree
    #--------------
    def expandTree(self):
        """ treeを展開する"""
        #選択dir、pathを取得
        treeSelection = self.treeView.get_selection()
        (dummy, pathes) = treeSelection.get_selected_rows()
        selPath = pathes[0]
        selDirList = self.getDirFromTreePath(selPath)
        selDir = os.sep.join(selDirList)
        #childrenがあるか確認
        parentIter = self.getIterInTreeStore(rootDir, selDir)
        nChildren = self.treestore.iter_n_children(parentIter)
        if nChildren > 0:
            #treeを展開
            self.treeView.expand_to_path(selPath)

    #
    #  collapseTree
    #---------------
    def collapseTree(self):
        """ treeを閉じる"""
        #選択dir、pathを取得
        treeSelection = self.treeView.get_selection()
        (dummy, pathes) = treeSelection.get_selected_rows()
        selPath = pathes[0]
        #treeを閉じる
        self.treeView.collapse_row(selPath)

    #
    #  upCursorTree
    #-------------
    def upCursorTree(self):
        """ treeを上に移動する"""
        global selCaseDir
        #選択dir、pathを取得
        treeSelection = self.treeView.get_selection()
        (dummy, pathes) = treeSelection.get_selected_rows()
        selPath = pathes[0]
        #cursorUpさせる
        pathInt = list(map(lambda x: x, selPath))
        if pathInt != [0]:
            if pathInt[-1] == 0:
                pathInt = pathInt[:-1]
            else:
                pathInt[-1] -= 1
        newPath = Gtk.TreePath.new_from_indices(pathInt)
        # treeSelection = self.treeView.get_selection()
        # treeSelection.unselect_all()
        # treeSelection.select_path(newPath)
        selDirList = self.getDirFromTreePath(newPath)
        selDir = os.sep.join(selDirList)
        #selCaseDirを設定
        selCaseDir = selDir

    #
    #  downCursorTree
    #-------------
    def downCursorTree(self):
        """ treeを下に移動する"""

        def downPath(pathInt):
            saveInt = pathInt
            while True:
                pathInt = pathInt[:-1]
                if pathInt == []:
                    #最後まで実在しなかった場合
                    #  元のpathIntで抜ける
                    pathInt = saveInt
                    break
                pathInt[-1] += 1
                newPath = Gtk.TreePath.new_from_indices(pathInt)
                try:
                    #実在するpathならば抜ける
                    _dirList = self.getDirFromTreePath(newPath)
                    break
                except:
                    #実在しない場合は繰り返す
                    pass
            return pathInt

        global selCaseDir
        #選択dir、pathを取得
        treeSelection = self.treeView.get_selection()
        (dummy, pathes) = treeSelection.get_selected_rows()
        selPath = pathes[0]
        #cursorDownさせる
        parentIter = self.getIterInTreeStore(rootDir, rootDir)
        nChildren = self.treestore.iter_n_children(parentIter)
        pathInt = list(map(lambda x: x, selPath))
        if pathInt != [0, nChildren-1]:
            parPath = pathInt[:-1]
            parDir = os.sep.join(self.getDirFromTreePath(parPath))
            parIter = self.getIterInTreeStore(rootDir, parDir)
            nCh = self.treestore.iter_n_children(parIter)
            if pathInt[-1] == nCh-1:
                pathInt = downPath(pathInt)
            else:
                if pathInt == [0]:
                    pathInt = [0, 0]
                else:
                    pathInt[-1] += 1
        newPath = Gtk.TreePath.new_from_indices(pathInt)
        # treeSelection = self.treeView.get_selection()
        # treeSelection.unselect_all()
        # treeSelection.select_path(newPath)
        selDirList = self.getDirFromTreePath(newPath)
        selDir = os.sep.join(selDirList)
        #selCaseDirを設定
        selCaseDir = selDir

    #
    #  addNewFolder
    #---------------
    def addNewFolder(self):
        """ 新しいfolderを追加"""
        global folderContDict
        #選択folderのdirを取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        if len(pathes) > 1:
            title = _("エラー")
            mess = _("複数選択しています。") + "\n"
            mess += _("  1ヶのfolderを選択してください。")
            self.errDialog(title, mess)
            return
        #選択dirを取得
        folderDirList = self.getDirFromTreePath(pathes[0])
        folderDir = os.sep.join(folderDirList)
        #新しいfolder「newFolder_N」を追加する。
        #  newNameを取得する
        folderNames = pyTreeFoam.getFolderNames(folderDir)
        i = 0
        while True:
            newName = "newFolder_" + str(i)
            if not(newName in folderNames):
                break
            i += 1
        #  folder作成
        newFolderDir = folderDir + "/" + newName
        os.mkdir(newFolderDir)
        #辞書追加
        folderContDict[newFolderDir] = ["folder"]
        #TreeView再表示
        #  treeData再作成
        createTreeData(rootDir)
        #  folderDir以下のchildrenを全て削除
        folderIter = self.getIterInTreeStore(rootDir, folderDir)
        self.deleteAllChildren(folderIter)
        #  folderDir以下のchildrenを再作成
        items = getParentTreeData(pathes[0])
        folderName = folderDirList[-1]
        self.addTreeNodes([folderName], self.treestore, folderIter, items)
        #  filderDirを展開する
        self.treeView.expand_row(pathes[0], False)
        #  追加したnewDirを選択表示
        treeSelection = self.treeView.get_selection()
        treeSelection.unselect_all()
        selPath = self.getPathInTreeStore(rootDir, newFolderDir)
        treeSelection.select_path(selPath)
        #新しいfolder名を入力
        #newNameを取得
        self.renameFolder()        

    #
    #  deleteFolders
    #----------------
    def deleteFolders(self):
        """ 選択しているfoldersをゴミ箱に移動する"""
        #選択folderのdirを取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        delFolders = []
        for path in pathes:
            folderDirList = self.getDirFromTreePath(path)
            folderDir = os.sep.join(folderDirList)
            delFolders.append(folderDir)
        if len(delFolders) == 0:
            #選択folderが存在しない場合、直ぐに戻る
            return
        #dialogを表示
        title = _("folderの削除")
        mess = _("選択したfolderをゴミ箱へ移動しますか？")
        okArgs = [self.deleteFolders_trush, delFolders]
        self.okCancelDialog(title, mess, funcOk=okArgs)
        return

    #  deleteFolders_trush
    def deleteFolders_trush(self, delFolders):
        """ 選択しているfoldersをゴミ箱に移動する"""
        #currDirが削除される可能性があるのでcurrDirを新たに設定
        os.chdir(treeFoamPath)
        #treeEventをmaskする
        self.maskTreeEvent = True
        #statusBar設定
        self.writeStatusBar("deleting folders...")
        #選択folderをゴミ箱に移動
        unFolders = pyTreeFoam.moveToTrash(delFolders)
        if len(unFolders) != 0:
            title = _("folder削除")
            folders = list(map(lambda x: os.path.basename(x), unFolders))
            if len(folders) > 5:
                fileLines = list(map(lambda x: "  "+x, folders[:5]))
                fileCont = "\n".join(fileLines) + "...\n"
            else:
                fileLines = list(map(lambda x: "  "+x, folders))
                fileCont = "\n".join(fileLines) + "\n"
            mess = _("以下の") + str(len(unFolders)) + _("個のfolderがゴミ箱に移動できません。\n")
            mess += fileCont
            mess += _("削除しますか?")
            okArgs = [self.deleteFolders_deleteOk, delFolders, unFolders]
            cancelArgs = [self.deleteFolders_deleteCancel, delFolders, unFolders]
            self.okCancelDialog(title, mess, funcOk=okArgs, funcCancel=cancelArgs)
            return
        #TreeViewを再表示
        self.showTreeViewAfterDelete(delFolders)
        self.deleteFolders_ending()

    def deleteFolders_ending(self):
        """ 終了処理"""
        #statusBarをclear
        self.clearStatusBar()
        #treeEventのmaskを解除
        self.maskTreeEvent = False

    #  deleteFolders_deleteOk
    def deleteFolders_deleteOk(self, delFolders, unFolders):
        """ ゴミ箱移動できなかった時: 削除を開始する。"""
        #削除する
        for delFolder in unFolders:
            shutil.rmtree(delFolder)
        #TreeViewを再表示
        self.showTreeViewAfterDelete(delFolders)
        self.deleteFolders_ending()

    #  deleteFolders_deleteCancel
    def deleteFolders_deleteCancel(self, delFolders, unFolders):
        """ ゴミ箱移動できなかった時: 削除をキャンセルする。"""
        #削除したfolderを取得
        newDelFolders = []
        for folder in delFolders:
            if not (folder in unFolders):
                newDelFolders.append(folder)
        delFolders = newDelFolders
        if len(delFolders) > 0:
            #TreeViewを再表示
            self.showTreeViewAfterDelete(delFolders)
        self.deleteFolders_ending()

    #
    #  showTreeViewAfterDelete
    def showTreeViewAfterDelete(self, delFolders):
        """ folder削除後にTreeViewを再表示させる。"""
        global folderContDict, treeData, selCaseDir, solveCaseDir, rootDir
        #delFoldersのpathを取得（後で選択表示させるため）
        delPathes = []
        for folder in delFolders:
            path = self.getPathInTreeStore(rootDir, folder)
            delPathes.append(path)
        #folderContDictを更新
        delKeys = delFolders[:]
        for folder in folderContDict:
            for delFolder in delFolders:
                matchFolder = delFolder + os.sep
                if folder[:len(matchFolder)] == matchFolder:
                    delKeys.append(folder)
                    break
        #  folderContDictから削除
        for delKey in delKeys:
            dummy_value = folderContDict.pop(delKey)
        #treeDataを再作成
        rootDir = treeData[0]
        createTreeData(rootDir)
        #treeViewをクリア
        rootIter = self.getIterInTreeStore(rootDir, rootDir)
        self.deleteAllChildren(rootIter)
        #treeViewを再作成
        items = treeData[1]
        parentName = rootDir
        self.addTreeNodes([parentName], self.treestore, rootIter, items)
        #solveCaseDirが削除されていないかチェック
        if not solveCaseDir in folderContDict.keys():
            #削除されている場合、solveCaseDirを設定し直す
            solveCaseList = solveCaseDir.split(os.sep)
            i = len(solveCaseList) - 1
            while i > 0:
                solveDir = os.sep.join(solveCaseList[:i])
                if solveDir in folderContDict.keys():
                    break
                i -= 1
            solveCaseDir = solveDir
            self.setSolveCaseInPanel(solveCaseDir)
            self.setItemsToComboBox(solveCaseDir)
            self.setVisibleOfButton(solveCaseDir)
        #solveCaseDirまで展開する
        parentDir = os.sep.join(solveCaseDir.split(os.sep)[:-1])
        path = self.getPathInTreeStore(rootDir, parentDir)
        self.treeView.expand_to_path(path)
        self.setSelSolveCaseInTree(rootDir, solveCaseDir)
        #delFolderの親を展開する
        for folder in delFolders:
            parentDir = os.sep.join(folder.split(os.sep)[:-1])
            parentPath = self.getPathInTreeStore(rootDir, parentDir)
            self.treeView.expand_to_path(parentPath)
        #選択表示の設定（delPathesを選択表示する）
        treeSelection = self.treeView.get_selection()
        treeSelection.unselect_all()
        for path in delPathes:
            parentDir = os.sep.join(self.getDirFromTreePath(path[:-1]))
            parentIter = self.getIterInTreeStore(rootDir, parentDir)
            #childrenの数を取得
            nChildren = self.treestore.iter_n_children(parentIter)
            #pathを数値のlistに変換
            pathInt = []
            for i in range(len(path)):
                pathInt.append(path[i])
            #childrenが存在するか？
            if nChildren > 0:
                #path[-1]をnChildrenと比較
                if pathInt[-1] >= nChildren:
                    pathInt[-1] = nChildren - 1
            else:
                #chilrenが無い場合
                pathInt = pathInt[:-1]
            path = Gtk.TreePath.new_from_indices(pathInt)
            #pathを選択表示
            treeSelection.select_path(path)
            dirList = self.getDirFromTreePath(path)
        #cursorを設定(最後のpath)
        self.treeView.set_cursor(path, None, False)
        #スクロール
        self.treeView.scroll_to_cell(path)
        #selCaseDirを設定（最後のdelFoldersに設定）
        selCaseDir = os.sep.join(dirList)

    #
    #  isSetSolveCaseDialog
    def isSetSolveCaseDialog(self, okArgs):
        """ 選択caseを解析caseに設定するかどうかの確認dialogを表示"""
        title = _("解析Caseの確認")
        message = _("選択したcaseは、解析caseとして設定されていません。\n  解析caseとして設定しますか？")
        self.okCancelDialog(title, message, funcOk=okArgs)

    #
    #  runLoginShell
    #  -------------
    def runLoginShell(self):
        """ 設定されているserverのloginシェルを起動する"""
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        if len(pathes) != 1:
            return
        print(_("loginシェルを起動します"))
        folderDirList = self.getDirFromTreePath(pathes[0])
        folderDir = "/".join(folderDirList)
        serverName = pyTreeFoam.servers().getServerName(folderDir)
        server = pyTreeFoam.server(serverName)
        #hostName = server.sshfsDict["hostName"]
        #userName = server.sshDict["user"]
        hostDir = server.sshfsDict["hostDir"]
        mountDir = server.sshfsDict["mountPoint"]
        #login = server.sshfsDict["login"]
        setEnviron = server.sshfsDict["setEnviron"]
        if mountDir == "":
            title = _("エラー")
            mess = _("serverがマウントされていません")
            self.errDialog(title, mess)
            return
        #loginDir, setEnvironを作成
        if mountDir == folderDir[:len(mountDir)]:
            openDir = hostDir + folderDir[len(mountDir):]
            lines = setEnviron.split("\n")
            i = len(lines) - 1
            while i >= 0:
                if lines[i][:len("cd")] == "cd":
                    #words = lines[i].split()
                    lines[i] = "cd " + openDir
                    break
                i -= 1
            setEnviron = "\n".join(lines)
        else:
            setEnviron = ""
        #tempFile作成
        name = "setEnviron"
        fileName = os.getenv("TreeFoamUserPath") + "/temp/" + name
        f=open(fileName, "w"); f.write(setEnviron); f.close()
        #environを転送
        server.scpCommandNoTerm(fileName, "~")
        #login端末を起動 
        server.runLoginTerm()

    #
    #  serverJobControl
    #  ----------------
    def serverJobControl(self):
        """ serverのJob管理。"""
        serverName = pyTreeFoam.servers().getServerName(selCaseDir)
        if serverName == "":
            title = _("エラー")
            mess = _("serverがマウントされていません")
            self.errDialog(title, mess)
            return
        #serverのaddress（url）を取得
        server = pyTreeFoam.server(serverName)
        serverAdd = server.sshDict["url"]
        #address(url)に対応するJob管理スクリプトを取得
        if not (serverAdd in serverJobCon.keys()):
            title = _("エラー")
            mess = serverName + "\n"
            mess += _("server Job管理は、登録されていません。")
            self.errDialog(title, mess)
            return
        #Job管理を起動
        jobControl = treeFoamPath + "/python/" + serverJobCon[serverAdd]
        comm = jobControl + " " + selCaseDir + " &"
        pyTreeFoam.run(selCaseDir).command(comm)
        return

    #
    #  sshfsServerMount
    #  ----------------
    def sshfsServerMount(self):
        """ sshfsによるサーバをマウントする"""
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        if len(pathes) != 1:
            return
        folderDirList = self.getDirFromTreePath(pathes[0])
        mountDir = os.sep.join(folderDirList)
        #errorチェック
        files = os.listdir(mountDir)
        if len(files) != 0:
            #エラー発生
            flag = 0
            for nameDir in files:
                name = os.path.basename(nameDir)
                if name == ".bashrc" or name == ".ssh":
                    flag += 1
            if flag == 2:
                title = _("警告")
                mess = _("既にマウントされています。")
                self.warningDialog(title, mess)
                return
            else:
                title = _("エラー")
                mess = _("マウントするfolder内にファイルが存在します。") + "\n"
                mess += _("マウントできません。")
                self.errDialog(title, mess)
                return
        #サーバをマウント
        self.writeStatusBar("server mounting...")
        (serverNames, mountedServers) = pyTreeFoam.servers().getAllServerNames()
        okArgs = [self.sshfsServerMount_setServer, mountDir, mountedServers]
        cancelArgs = [self.sshfsServerMount_cancel]
        self.selectMountServer(serverNames, okArgs, cancelArgs)
        return

    #  sshfsServerMount_cancel
    def sshfsServerMount_cancel(self):
        self.clearStatusBar()

    #  sshfsServerMount_setServer
    def sshfsServerMount_setServer(self, serverName, mountDir, mountedServers):
        #errorチェック
        flag = 0
        for mountedServer in mountedServers:
            if serverName == mountedServer:
                flag = 1
                break
        if flag == 1:
            title = _("エラー")
            mess = serverName + ": " + _("既にマウントされています。") + "\n"
            mess += _("マウントできません。")
            self.errDialog(title, mess)
            return
        #serverをマウント
        server = pyTreeFoam.server(serverName)
        (stat, errMess) = server.mount(mountDir)
        if stat == "OK":
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            #初めての接続の場合、tmpFolderを削除する
            #if self.isFirstConnection(hostName) == True:
            #    self.deleteServerTempFolder(serverName)
            #接続内容を表示
            title = _("サーバマウント")
            mess = _("サーバをマウントしました。") + "\n\n"
            mess += "host " + serverName + "\n"
            mess += "HostName:    " + hostName + "\n"
            mess += "User:        " + userName + "\n"
            mess += "HostDir:     " + hostDir + "\n"
            mess += "MountPoint:  " + mountDir + "\n"
            self.okDialog(title, mess)
        else:
            server.sshfsDict["mountPoint"] = ""
            server.writeSshfsData()
            title = _("エラー")
            mess = _("サーバをマウントできませんでした。") + "\n"
            mess += errMess
            self.errDialog(title, mess)
        self.reload()
        self.clearStatusBar()

    #
    #  selectMountServer
    def selectMountServer(self, serverNames, okArgs, cancelArgs):
        """ mountするsaverを取得する"""
        #(serverNames, mountedServers) = pyTreeFoam.servers().getAllServerNames()
        dialog = mountServerDDialog.mountServer(
            serverNames, funcOk=okArgs, funcCancel=cancelArgs, 
            parent=mainWindow)
        dialog.show()
        return

    #
    #  isFirstConnection
    def isFirstConnection(self, checkHostName):
        """ TreeFoam起動後最初の接続かどうかチェックする"""
        ans = False
        mountServers = pyTreeFoam.servers().getMountedServers()
        nCount = 0
        for (_serverName, hostName, _mountPoint) in mountServers:
            if hostName == checkHostName:
                nCount += 1
        if nCount == 1:
            ans = True
        return ans

    #
    #  isServerDir
    def isServerDir(self, itemDir):
        """ dirがserver内のDirかどうかチェック"""
        if type(itemDir) == list:
            itemDir = "/".join(itemDir)
        itemList = itemDir.split("/")
        ans = False
        for serverDir in serverDirs:
            serverList = serverDir.split("/")
            n = len(serverList)
            if serverList == itemList[:n]:
                ans = True
                break
        return ans

    #
    #  deleteServerTempFolder
    def deleteServerTempFolder(self, serverName):
        """serverにあるtempFolderを削除する"""
        delFolders = "~/TreeFoamServer/tmp/server_*"
        comm = "rm -rf " + delFolders
        pyTreeFoam.server(serverName).sendSshCommand(comm)

    #
    #  sshfsServerUnmount
    #  ------------------
    def sshfsServerUnmount(self):
        """ sshfsサーバをアンマウントする"""
        global solveCaseDir
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        if len(pathes) != 1:
            return
        folderDirList = self.getDirFromTreePath(pathes[0])
        unmountDir = os.sep.join(folderDirList)
        #アンマウントの確認
        title = _("sshfsサーバアンマウント")
        mess = _("サーバをアンマウントします。")
        okArgs = [self.sshfsServerUnmount_run, unmountDir]
        self.okCancelDialog(title, mess, funcOk=okArgs)
        return

    #  sshfsServerUnmount_run
    def sshfsServerUnmount_run(self, unmountDir):
        """ serverをアンマウントする"""
        #アンマウント
        self.writeStatusBar("server unmounting...")
        comm = "fusermount -z -u " + unmountDir
        (stat, _res, errMess) = pyTreeFoam.run().commandReturnCont(comm)
        if stat == "OK":
            serverName = pyTreeFoam.servers().getServerName(unmountDir)
            server = pyTreeFoam.server(serverName)
            #mountPointを削除
            server.sshfsDict["mountPoint"] = ""
            server.writeSshfsData()
            self.reload()
        else:
            title = _("エラー")
            mess = _("サーバをアンマウントできませんでした。") + "\n"
            mess += _("folder名を確認してください。") + "\n\n"
            mess += errMess
            self.errDialog(title, mess)
        self.clearStatusBar()

    #
    #  pasteScpCompTransfer
    #  --------------------
    def pasteScpCompTransfer(self):
        """ clipBoardのfileをscpで圧縮コピーする。
        serverが絡む場合のコピー。
        """
        #statusBar,treeEvenyをマスク
        self.writeStatusBar("copying...")
        self.maskTreeEvent = True
        #pasteDirのpathを取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        pasteDirList = self.getDirFromTreePath(pathes[0])
        pasteDir = os.sep.join(pasteDirList)
        #clipboardの内容を取得
        copyDirs = copyPasteFolders.pasteFolders()
        # pasteContFile = treeFoamUserPath + os.sep + "data" + os.sep + "pasteNames"
        # comm = "./pasteFromSystemClipBoard.py " + pasteContFile
        # path = treeFoamPath + os.sep + "python"
        # pyTreeFoam.run(path).commandWithLog(comm)
        # f = open(pasteContFile); cont = f.read(); f.close()
        # copyDirs = cont.split()
        #server名を取得
        copyServer = pyTreeFoam.servers().getServerName(copyDirs[0])
        pasteServer = pyTreeFoam.servers().getServerName(pasteDir)
        #paste開始(copyServer -> pasteServer)
        self.pasteUsingServer(copyServer, copyDirs, pasteServer, pasteDir)
        return

    #
    #  pasteUsingServer
    def pasteUsingServer(self, copyServer, copyDirs, pasteServer, pasteDir):
        """ copyServerのcopyDirsを、pasteServerのpasteDirにコピーする。
        localToServer、serverToLoacl、server内同士のコピーを判断して、コピーする。
        コピー後、Treeを再表示させる。
        """
        def getPasteName(name):
            """ pasteNameを取得"""
            pathNames = glob.glob(pasteDir+"/*")
            flag = 0
            for pathName in pathNames:
                if name == pathName.split("/")[-1]:
                    flag = 1
                    break
            if flag == 0:
                #同名のpathが存在しない場合は、そのまま返す
                return name
            #同名のpathが存在する場合
            i = 0
            while i < 10:
                flag = 0
                newName = name + "_copy" + str(i)
                for pathName in pathNames:
                    if pathName.split("/")[-1] == newName:
                        flag = 1
                        break
                if flag == 0:
                    break
                i += 1
            return newName

        def runCommand(filesLines, lines):
            """ scpコマンド実行"""
            #スクリプト作成
            fileName = os.getenv("TreeFoamUserPath") + "/temp/run"
            f=open(fileName, "w")
            for line in lines:
                f.write(line)
            f.close()
            pyTreeFoam.run().command("chmod a+x " + fileName)
            #実行ファイルを作成（log作成）
            logFile = treeFoamUserPath + "/temp/scpLog"
            #  空file作成
            f = open(logFile, "w"); f.close()
            #  全fileを取得
            lines = filesLines
            #  copyスクリプト
            line = "script " + logFile + " -a -q -f -c " + fileName
            line += " 2>&1 | tee -a " + os.getenv("LogFile")
            lines.append(line)
            #lines.append("script " + logFile + " -a -q -f -c " + fileName + "\n")
            fileName = treeFoamUserPath + "/temp/runrun"
            f = open(fileName, "w"); f.writelines(lines); f.close()
            pyTreeFoam.run().command("chmod a+x " + fileName)
            #実行
            comm = pyTreeFoam.TerminalRun + " " + fileName
            proc = subprocess.Popen(comm, shell=True, stdin=subprocess.PIPE)
            #GUIを表示
            stat = copyUsingServer(fileName, logFile)
            if stat == "CANCEL":
                #中断する
                proc.kill()
                print(_("中断しました。"))
            return stat

        def runCommandCp(filesLines, lines):
            """ cpコマンド実行"""
            fileName = os.getenv("TreeFoamUserPath") + "/temp/run"
            f=open(fileName, "w")
            for line in lines:
                f.write(line)
            f.close()
            pyTreeFoam.run().command("chmod a+x " + fileName)
            #実行ファイルを作成（log作成）
            logFile = treeFoamUserPath + "/temp/scpLog"
            #  空file作成
            f = open(logFile, "w"); f.close()
            #  全fileを取得
            lines = filesLines
            #  copyスクリプト(scriptコマンド使用しない)
            lines.append("echo 'Script started on' >> " + logFile + "\n")
            lines.append(fileName + " >> " + logFile + "\n")
            lines.append("echo 'Script done on' >> " + logFile + "\n")
            fileName = treeFoamUserPath + "/temp/runrun"
            f = open(fileName, "w"); f.writelines(lines); f.close()
            pyTreeFoam.run().command("chmod a+x " + fileName)
            #実行
            #pyTreeFoam.run().commandWithLog(fileName + " &")
            comm = fileName + " 2>&1 | tee -a " + os.getenv("LogFile") + " &"
            proc = subprocess.Popen(comm, shell=True, stdin=subprocess.PIPE)
            #GUIを表示
            stat = copyUsingServer(fileName, logFile)
            if stat == "CANCEL":
                #中断する
                proc.stdin.write(b"\x03")       #ctrl+cを出力
                proc.kill()
                print(_("中断しました。"))
            return stat

        def checkFolderReturnCaseName(folderDir):
            """ folderDirのcaseDirを取得する"""
            if pyTreeFoam.isNeedFolder(folderDir) == True:
                caseDir = folderDir
            else:
                caseDir = "/".join(folderDir.split("/")[:-1])
            return caseDir

        def threadRunCommand(filesLines, lines, pasteFolderName):
            """ commandを作成し実行。実行後、Treeの内容を再作成する。"""
            stat = runCommand(filesLines, lines)
            ending(stat, pasteFolderName)

        def threadRunCommandCp(filesLines, commLines, pasteFolderName):
            """ commandを作成し実行。実行後、Treeの内容を再作成する。"""
            stat = runCommandCp(filesLines, commLines)
            ending(stat, pasteFolderName)

        def ending(stat, pasteFolderName):
            global selCaseDir, folderContDict
            if stat == "CANCEL":
                self.threadResult = _("処理を中断しました。") + "\n"
                self.threadResult += _("  中断しない場合、処理中の端末を閉じてください")
            #treeにpasteしたfolderを追加
            caseDir = checkFolderReturnCaseName(pasteFolderName)
            selCaseDir = caseDir
            #pasteするfolderContを取得
            folderConts = getAddPasteFolderCont(copyDirs, pasteFiles)
            if len(folderConts) > 0:            
                #threadデータを変数にセット
                self.threadShowTreeDir = [pasteDir, folderConts]
            else:
                #pasteDirを洗濯表示させる
                treeSelection = self.treeView.get_selection()
                treeSelection.unselect_all()
                path = self.getPathInTreeStore(rootDir, pasteDir)
                treeSelection.select_path(path)
                selCaseDir = pasteDir
            print(_("clipBoardの内容を貼り付けました。"))
            #statusBarとeventのマスクを解除
            self.clearStatusBar()
            self.maskTreeEvent = False

        def getAddPasteFolderCont(copyFiles, pasteFiles):
            """ 追加するfolderContを取得"""
            #folderの内容を取得
            folderConts = []
            for i in range(len(copyFiles)):
                copyFile = copyFiles[i]
                if copyFile in folderContDict.keys(): 
                    cont = folderContDict[copyFile]
                    pasteFile = pasteFiles[i]
                    folderConts.append([pasteFile] + cont)
            return folderConts

        #  メイン
        #localからserverにコピー
        global selCaseDir
        if copyServer == "" and pasteServer != "":
            serverName = pasteServer
            server = pyTreeFoam.server(serverName)
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            mountDir = server.sshfsDict["mountPoint"]
            sshHeader = server.sshfsDict["sshHeader"]
            #貼り付け
            pasteFolder = hostDir + pasteDir[len(mountDir):]
            copyFiles = copyDirs
            pasteFiles = []
            lines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                name = copyFile.split("/")[-1]
                newName = getPasteName(name)
                line = sshHeader + "scp -Cr " + copyFile + " " + userName + "@" + hostName + ":" + pasteFolder + "/" + newName + "\n"
                lines.append(line)
                pasteFiles.append(pasteDir + "/" + newName)
            #全file名を取得
            logFile = treeFoamUserPath + "/temp/scpLog"
            filesLines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                filesLines.append("find " + copyFile + " -type f >> " + logFile + "\n")
            #実行（threadを投げて直ぐに戻る）
            pasteFolderName = mountDir + pasteFolder[len(hostDir):] + "/" + newName
            th = threading.Thread(target=threadRunCommand, args=(filesLines, lines, pasteFolderName))
            th.start()

        #serverからlocalにコピー
        elif copyServer != "" and pasteServer == "":
            serverName = copyServer
            server = pyTreeFoam.server(serverName)
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            mountDir = server.sshfsDict["mountPoint"]
            sshHeader = server.sshfsDict["sshHeader"]
            #copyFilesを取得
            copyFiles = []
            for name in copyDirs:
                if name[:len(mountDir)] == mountDir:
                    nameDir = hostDir + name[len(mountDir):]
                    copyFiles.append(nameDir)
            #貼り付け
            pasteFolder = pasteDir
            pasteFiles = []
            lines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                name = copyFile.split("/")[-1]
                newName = getPasteName(name)
                line = sshHeader + " " + "scp -Cr " + userName + "@" + hostName + ":" + copyFile + " " + pasteFolder + "/" + newName + "\n"
                lines.append(line)
                pasteFiles.append(pasteDir + "/" + newName)
            #全file名を取得
            logFile = treeFoamUserPath + "/temp/scpLog"
            filesLines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                line = sshHeader + " ssh " + userName + "@" + hostName
                line += " find " + copyFile + " -type f >> " + logFile + "\n"
                filesLines.append(line)
            #実行（threadを投げて直ぐに戻る）
            pasteFolderName = pasteFolder + "/" + newName
            th = threading.Thread(target=threadRunCommand, args=(filesLines, lines, pasteFolderName))
            th.start()

        #server内からserver内へコピー
        elif (copyServer != "" and pasteServer != ""):
            cpServer = pyTreeFoam.server(copyServer)
            psServer = pyTreeFoam.server(pasteServer)
            #同じserverName間でコピー
            if copyServer == pasteServer:
                server = cpServer
                hostName = server.sshfsDict["hostName"]
                userName = server.sshDict["user"]
                hostDir = server.sshfsDict["hostDir"]
                mountDir = server.sshfsDict["mountPoint"]
                sshHeader = server.sshfsDict["sshHeader"]
                #copyFilesを取得
                copyFiles = []
                for name in copyDirs:
                    if name[:len(mountDir)] == mountDir:
                        nameDir = hostDir + name[len(mountDir):]
                        copyFiles.append(nameDir)
                #貼り付けスクリプト
                pasteFolder = hostDir + pasteDir[len(mountDir):]
                lines = []; pasteFiles = []
                for copyFile in copyFiles:
                    name = copyFile.split("/")[-1]
                    newName = getPasteName(name)
                    line = "cp -rfv " + copyFile + " " + pasteFolder + "/" + newName
                    lines.append(line)
                    pasteFiles.append(pasteDir + "/" + newName)
                comms = '"' + ";".join(lines) + '"'
                commLine = "ssh " + userName + "@" + hostName + " " +comms
                print(commLine)
                commLine = sshHeader + commLine
                #全file名を取得スクリプト
                logFile = treeFoamUserPath + "/temp/scpLog"
                filesLines = ["#!/bin/bash\n"]
                for copyFile in copyFiles:
                    line = sshHeader + " ssh " + userName + "@" + hostName
                    line += " find " + copyFile + " -type f >> " + logFile + "\n"
                    filesLines.append(line)
                #実行、Treeを再表示（threadを投げて直ぐに戻る）
                pasteFolderName = mountDir + pasteFolder[len(hostDir):] + "/" + newName
                commLines = [commLine]
                th = threading.Thread(target=threadRunCommandCp, args=(filesLines, commLines, pasteFolderName))
                th.start()

            #同じhostName間でコピー（server名は異なる）
            elif cpServer.sshfsDict["hostName"] == psServer.sshfsDict["hostName"]:
                hostName = psServer.sshfsDict["hostName"]
                userName = psServer.sshDict["user"]
                sshHeader = psServer.sshfsDict["sshHeader"]
                copyHostDir = cpServer.sshfsDict["hostDir"]
                copyMountDir = cpServer.sshfsDict["mountPoint"]
                pasteHostDir = psServer.sshfsDict["hostDir"]
                pasteMountDir = psServer.sshfsDict["mountPoint"]
                #copyFilesを取得
                copyFiles = []
                for name in copyDirs:
                    if name[:len(copyMountDir)] == copyMountDir:
                        nameDir = copyHostDir + name[len(copyMountDir):]
                        copyFiles.append(nameDir)
                #貼り付け
                pasteFolder = pasteHostDir + pasteDir[len(pasteMountDir):]
                lines = []; pasteFiles = []
                for copyFile in copyFiles:
                    name = copyFile.split("/")[-1]
                    newName = getPasteName(name)
                    line = "cp -rfv " + copyFile + " " + pasteFolder + "/" + newName
                    lines.append(line)
                    pasteFiles.append(pasteDir + "/" + newName)
                comms = '"' + ";".join(lines) + '"'
                commLine = "ssh " + userName + "@" + hostName + " " + comms
                print(commLine)
                commLine = sshHeader + commLine
                #全file名を取得スクリプト
                logFile = treeFoamUserPath + "/temp/scpLog"
                filesLines = ["#!/bin/bash\n"]
                for copyFile in copyFiles:
                    line = sshHeader + " ssh " + userName + "@" + hostName
                    line += " find " + copyFile + " -type f >> " + logFile + "\n"
                    filesLines.append(line)
                #コマンド作成し実行、Tree再表示（threadを投げて直ぐに戻る）
                pasteFolderName = pasteMountDir + pasteFolder[len(pasteHostDir):] + "/" + newName
                commLines = [commLine]
                th = threading.Thread(target=threadRunCommandCp, args=(filesLines, commLines, pasteFolderName))
                th.start()
            
            #serverから別のserverへコピー
            else:
                title = _("エラー")
                mess = _("copyするserverとpasteするserverが異なっています。") + "\n"
                mess += _("同じserver内でcopyPasteしてください。")
                self.errDialog(title, mess)
                return
        #localからlocalにコピー
        elif copyServer == "" and pasteServer == "":
            title = _("エラー")
            mess = _("copyFolder, pasteFolderともlocal側の設定です。") + "\n"
            mess += _("通常の「貼り付け」で貼り付けてください。")
            self.errDialog(title, mess)
        return

    #
    #  casePasteScpCompTransfer
    #  ------------------------
    def casePasteScpCompTransfer(self):
        """ case貼り付け(scp圧縮転送,cp)"""
        #statusBar,treeEvenyをマスク
        self.writeStatusBar("copying...")
        self.maskTreeEvent = True
        #pasteDirのpathを取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        pasteDirList = self.getDirFromTreePath(pathes[0])
        pasteDir = os.sep.join(pasteDirList)
        #clipboardの内容を取得
        copyDirs = copyPasteFolders.pasteFolders()
        # pasteContFile = treeFoamUserPath + os.sep + "data" + os.sep + "pasteNames"
        # comm = "./pasteFromSystemClipBoard.py " + pasteContFile
        # path = treeFoamPath + os.sep + "python"
        # pyTreeFoam.run(path).commandWithLog(comm)
        # f = open(pasteContFile); cont = f.read(); f.close()
        # copyDirs = cont.split()
        #server名を取得
        copyServer = pyTreeFoam.servers().getServerName(copyDirs[0])
        pasteServer = pyTreeFoam.servers().getServerName(pasteDir)
        #copyServer -> pasteServerへコピー（scp or cp）
        self.casePasteUsingServer(copyServer, copyDirs, pasteServer, pasteDir)
        return

    #
    #  casePasteUsingServer
    def casePasteUsingServer(self, copyServer, copyDirs, pasteServer, pasteDir):
        """ copyServerのcopyDirsを、pasteServerのpasteDirにcaseコピーする。
        localToServer、serverToLoacl、server内同士のコピーを判断して、caseコピーする。
        caseコピー後、Treeを再表示させる。
        """
        def getPasteName(name):
            """ pasteNameを取得"""
            pathNames = glob.glob(pasteDir+"/*")
            flag = 0
            for pathName in pathNames:
                if name == pathName.split("/")[-1]:
                    flag = 1
                    break
            if flag == 0:
                #同名のpathが存在しない場合は、そのまま返す
                return name
            #同名のpathが存在する場合
            i = 0
            while i < 10:
                flag = 0
                newName = name + "_copy" + str(i)
                for pathName in pathNames:
                    if pathName.split("/")[-1] == newName:
                        flag = 1
                        break
                if flag == 0:
                    break
                i += 1
            return newName

        def checkCaseDir(caseDir):
            """ caseDir内にあるdirとfileを選別し、必要なものを返す。
            case初期化時に残すfolderとfileを返す"""
            case = pyTreeFoam.case(caseDir)
            folders = case.getIniCaseFolders()
            files = case.getIniCaseFiles()
            return (folders, files)

        def getCopyNames(folder):
            """ copyするfileNameを取得する"""
            (copyDirs, copyFiles) = checkCaseDir(folder)
            copyNames = []
            for nameDir in (copyDirs + copyFiles):
                name = nameDir.split("/")[-1]
                copyNames.append(name)
            return copyNames

        def isCaseDir(names):
            flag = 0
            for name in names:
                if name == "constant" or name == "system":
                    flag += 1
            if flag == 2:
                return True
            else:
                return False
        
        def runCommand(filesLines, lines):
            """ scp実行"""
            fileName = os.getenv("TreeFoamUserPath") + "/temp/run"
            f=open(fileName, "w")
            for line in lines:
                f.write(line)
            f.close()
            pyTreeFoam.run().command("chmod a+x " + fileName)
            #実行ファイルを作成（log作成）
            logFile = treeFoamUserPath + "/temp/scpLog"
            #  空file作成
            f = open(logFile, "w"); f.close()
            #  全fileを取得
            lines = filesLines
            #  copyスクリプト
            line = "script " + logFile + " -a -q -f -c " + fileName
            line += " 2>&1 | tee -a " + os.getenv("LogFile")
            lines.append(line)
            #lines.append("script " + logFile + " -a -q -f -c " + fileName + "\n")
            fileName = treeFoamUserPath + "/temp/runrun"
            f = open(fileName, "w"); f.writelines(lines); f.close()
            pyTreeFoam.run().command("chmod a+x " + fileName)
            #実行
            #pyTreeFoam.run().commandWithLog(fileName+" &")
            #comm = fileName + " 2>&1 | tee -a " + os.getenv("LogFile") + " &"
            comm = pyTreeFoam.TerminalRun + " " + fileName
            proc = subprocess.Popen(comm, shell=True, stdin=subprocess.PIPE)
            #GUIを表示
            stat = copyUsingServer(fileName, logFile)
            if stat == "CANCEL":
                #中断する
                #proc.stdin.write(b"\x03")   #ctrl+cを出力
                proc.kill()
                print(_("中断しました。"))
            return stat

        def runCommandCp(filesLines, lines):
            """ cpコマンド実行"""
            fileName = os.getenv("TreeFoamUserPath") + "/temp/run"
            f=open(fileName, "w")
            for line in lines:
                f.write(line)
            f.close()
            pyTreeFoam.run().command("chmod a+x " + fileName)
            #実行ファイルを作成（log作成）
            logFile = treeFoamUserPath + "/temp/scpLog"
            #  空file作成
            f = open(logFile, "w"); f.close()
            #  全fileを取得
            lines = filesLines
            #  copyスクリプト(scriptコマンド使用しない)
            lines.append("echo 'Script started on' >> " + logFile + "\n")
            lines.append(fileName + " >> " + logFile + "\n")
            lines.append("echo 'Script done on' >> " + logFile + "\n")
            fileName = treeFoamUserPath + "/temp/runrun"
            f = open(fileName, "w"); f.writelines(lines); f.close()
            pyTreeFoam.run().command("chmod a+x " + fileName)
            #実行
            #pyTreeFoam.run().commandWithLog(fileName + " &")
            comm = fileName + " 2>&1 | tee -a " + os.getenv("LogFile") + " &"
            proc = subprocess.Popen(comm, shell=True, stdin=subprocess.PIPE)
            #GUIを表示
            stat = copyUsingServer(fileName, logFile)
            if stat == "CANCEL":
                #中断する
                proc.stdin.write(b"\x03")   #ctrl+cを出力
                proc.kill()
                print(_("中断しました。"))
            return stat

        def checkFolderReturnCaseName(folderDir):
            """ folderDirのcaseDirを取得する"""
            if pyTreeFoam.isNeedFolder(folderDir) == True:
                caseDir = folderDir
            else:
                caseDir = "/".join(folderDir.split("/")[:-1])
            return caseDir

        def threadRunCommand(filesLines, lines, pasteFolderName):
            stat = runCommand(filesLines, lines)
            ending(stat, pasteFolderName)

        def threadRunCommandCp(filesLines, comms, pasteFolderName):
            stat = runCommandCp(filesLines, comms)
            ending(stat, pasteFolderName)

        def ending(stat, pasteFolderName):
            global selCaseDir
            if stat == "CANCEL":
                self.threadResult = _("処理を中断しました。") + "\n"
                self.threadResult += _("  中断しない場合、処理中の端末を閉じてください")
            #treeにpasteしたfolderを追加(結果を削除)
            caseDir = checkFolderReturnCaseName(pasteFolderName)
            selCaseDir = caseDir
            #  numFolder(結果folder)を削除したfolderContsを取得
            folderConts = getAddPasteFolderContDeleteNum(copyDirs, pasteFiles)
            #threadデータを変数にセット
            self.threadShowTreeDir = [pasteDir, folderConts]
            print(_("caseを貼り付けました。"))
            #statusBarとeventのマスクを解除
            self.clearStatusBar()
            self.maskTreeEvent = False

        def getAddPasteFolderContDeleteNum(copyFiles, pasteFiles):
            """ 追加するfolderContを取得"""
            #folderの内容を取得
            folderConts = []
            for i in range(len(copyFiles)):
                copyFile = copyFiles[i]
                cont = folderContDict[copyFile][:]
                #結果を削除
                cont[3] = " 1"
                cont[5] = ""
                pasteFile = pasteFiles[i]
                folderConts.append([pasteFile] + cont)
            return folderConts

        #  メイン
        global selCaseDir
        errorFlag = 0
        #localからserverにcaseコピー
        if copyServer == "" and pasteServer != "":
            serverName = pasteServer
            server = pyTreeFoam.server(serverName)
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            mountDir = server.sshfsDict["mountPoint"]
            sshHeader = server.sshfsDict["sshHeader"]
            #貼り付け
            pasteFolder = hostDir + pasteDir[len(mountDir):]
            copyFiles = copyDirs
            lines = ["#!/bin/bash\n"]
            mkdirLines = []
            pasteFiles = []
            for copyFile in copyFiles:
                name = copyFile.split("/")[-1]
                newName = getPasteName(name)
                line = sshHeader + " " + "ssh "+ userName + "@" + hostName + ' "mkdir ' + pasteFolder + "/" + newName + '"\n'
                #lines.append(line)
                mkdirLines.append(line)
                pasteFiles.append(pasteDir + "/" + newName)
                copyNames = getCopyNames(copyFile)
                if isCaseDir(copyNames) == False:
                    errorFlag = 1
                    break
                else:
                    for copyName in copyNames:
                        line = sshHeader + " " + "scp -Cr " + copyFile + "/" + copyName + " " + userName + "@" +  hostName + ":" + pasteFolder + "/" + newName + "/" + copyName + "\n"
                        lines.append(line)
            if errorFlag == 1:
                title = _("エラー")
                mess = _("「") + copyFile + _("」は、OpenFoamのcaseDirectoryではありません。\ncaseコピーできません。")
                print(mess)
                self.errDialog(title, mess)
                return
            else:
                #全file名を取得
                logFile = treeFoamUserPath + "/temp/scpLog"
                filesLines = ["#!/bin/bash\n"]
                for copyFile in copyFiles:
                    filesLines.append("find " + copyFile + " -type f >> " + logFile + "\n")
                filesLines += mkdirLines        #mkdirコマンドを追加
                #実行、Tree再表示（threadを投げて直ぐに戻る）
                pasteFolderName = mountDir + pasteFolder[len(hostDir):] + "/" + newName
                th = threading.Thread(target=threadRunCommand, args=(filesLines, lines, pasteFolderName))
                th.start()

        #serverからlocalにcaseコピー
        elif copyServer != "" and pasteServer == "":
            serverName = copyServer
            server = pyTreeFoam.server(serverName)
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            mountDir = server.sshfsDict["mountPoint"]
            sshHeader = server.sshfsDict["sshHeader"]
            #copyFilesを取得
            copyFiles = []
            for name in copyDirs:
                if name[:len(mountDir)] == mountDir:
                    nameDir = hostDir + name[len(mountDir):]
                    copyFiles.append(nameDir)
            #貼り付け
            pasteFolder = pasteDir
            mkdirLines = []
            pasteFiles = []
            lines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                name = copyFile.split("/")[-1]
                newName = getPasteName(name)
                line = "mkdir " + pasteFolder + "/" + newName + "\n"
                #lines.append(line)
                mkdirLines.append(line)
                copyHostFile = mountDir + copyFile[len(hostDir):]
                copyNames = getCopyNames(copyHostFile)
                if isCaseDir(copyNames) == False:
                    errorFlag = 1
                    break
                else:
                    for copyName in copyNames:
                        line = sshHeader + " " + "scp -Cr " + userName + "@" + hostName + ":" + copyFile + "/" + copyName + " " + pasteFolder + "/" + newName + "/" + copyName + "\n"
                        lines.append(line)
                        pasteFiles.append(pasteDir + "/" + newName)
            if errorFlag == 1:
                title = _("エラー")
                mess = _("「") + copyFile + _("」は、OpenFoamのcaseDirectoryではありません。\ncaseコピーできません。")
                print(mess)
                self.errDialog(title, mess)
                return
            else:
                #全file名を取得
                logFile = treeFoamUserPath + "/temp/scpLog"
                filesLines = ["#!/bin/bash\n"]
                for copyFile in copyFiles:
                    line = sshHeader + " ssh " + userName + "@" + hostName
                    line += " find " + copyFile + " -type f >> " + logFile + "\n"
                    filesLines.append(line)
                filesLines += mkdirLines        #mkdirコマンドを追加
                #実行、Tree再表示（threadを投げて直ぐに戻る）
                pasteFolderName = pasteFolder + "/" + newName
                th = threading.Thread(target=threadRunCommand, args=(filesLines, lines, pasteFolderName))
                th.start()

        #server内からserver内へcaseコピー
        elif (copyServer != "" and pasteServer != ""):
            cpServer = pyTreeFoam.server(copyServer)
            psServer = pyTreeFoam.server(pasteServer)
            #同じserverName間でコピー
            if copyServer == pasteServer:
                server = cpServer
                hostName = server.sshfsDict["hostName"]
                userName = server.sshDict["user"]
                hostDir = server.sshfsDict["hostDir"]
                mountDir = server.sshfsDict["mountPoint"]
                sshHeader = server.sshfsDict["sshHeader"]
                #copyFilesを取得
                copyFiles = []
                for name in copyDirs:
                    if name[:len(mountDir)] == mountDir:
                        nameDir = hostDir + name[len(mountDir):]
                        copyFiles.append(nameDir)
                #貼り付け
                pasteFolder = hostDir + pasteDir[len(mountDir):]
                lines = ["#!/bin/bash\n"]
                pasteFiles = []
                #flag = 0
                for copyFile in copyFiles:
                    name = copyFile.split("/")[-1]
                    newName = getPasteName(name)
                    line = "mkdir " + pasteFolder + "/" + newName + "\n"
                    lines.append(line)
                    pasteFiles.append(pasteDir + "/" + newName)
                    copyHostFile = mountDir + copyFile[len(hostDir):]
                    copyNames = getCopyNames(copyHostFile)
                    if isCaseDir(copyNames) == False:
                        errorFlag = 1
                        break
                    else:
                        for copyName in copyNames:
                            line = "cp -rfv " + copyFile + "/" + copyName + " " + pasteFolder + "/" + newName + "/" + copyName + "\n"
                            lines.append(line)
                if errorFlag == 1:
                    title = _("エラー")
                    mess = _("「") + copyFile + _(u"」は、OpenFoamのcaseDirectoryではありません。\ncaseコピーできません。")
                    print(mess)
                    self.errDialog(title, mess)
                    return
                else:
                    #server内に実行file作成
                    fileName = mountDir + "/tmpRun"
                    f = open(fileName, "w")
                    for line in lines:
                        f.write(line)
                    f.write("rm ~/tmpRun")      #tmpRunを削除を追記
                    f.close()
                    pyTreeFoam.run().command("chmod a+x " + fileName)
                    #実行
                    comm = sshHeader + " " + "ssh " + userName + "@" + hostName + " " + hostDir + "/tmpRun"
                    #全file名を取得スクリプト
                    logFile = treeFoamUserPath + "/temp/scpLog"
                    filesLines = ["#!/bin/bash\n"]
                    for copyFile in copyFiles:
                        line = sshHeader + " ssh " + userName + "@" + hostName
                        line += " find " + copyFile + " -type f >> " + logFile + "\n"
                        filesLines.append(line)
                    #コマンド作成し実行、Treeを再表示（threadを投げて直ぐに戻る）
                    pasteFolderName = mountDir + pasteFolder[len(hostDir):] + "/" + newName
                    comms = [comm]
                    th = threading.Thread(target=threadRunCommandCp, args=(filesLines, comms, pasteFolderName))
                    th.start()
            
            #同じhostName間でcaseコピー（serverNameは異なる）
            elif cpServer.sshfsDict["hostName"] == psServer.sshfsDict["hostName"]:
                hostName = psServer.sshfsDict["hostName"]
                userName = psServer.sshDict["user"]
                sshHeader = psServer.sshfsDict["sshHeader"]
                copyHostDir = cpServer.sshfsDict["hostDir"]
                copyMountDir = cpServer.sshfsDict["mountPoint"]
                pasteHostDir = psServer.sshfsDict["hostDir"]
                pasteMountDir = psServer.sshfsDict["mountPoint"]
                #copyFilesを取得
                copyFiles = []
                for name in copyDirs:
                    if name[:len(copyMountDir)] == copyMountDir:
                        nameDir = copyHostDir + name[len(copyMountDir):]
                        copyFiles.append(nameDir)
                #貼り付け
                pasteFolder = pasteHostDir + pasteDir[len(pasteMountDir):]
                lines = ["#!/bin/bash\n"]
                pasteFiles = []
                for copyFile in copyFiles:
                    name = copyFile.split("/")[-1]
                    newName = getPasteName(name)
                    line = "mkdir " + pasteFolder + "/" + newName + "\n"
                    lines.append(line)
                    pasteFiles.append(pasteDir + "/" + newName)
                    copyHostFile = copyMountDir + copyFile[len(copyHostDir):]
                    copyNames = getCopyNames(copyHostFile)
                    if isCaseDir(copyNames) == False:
                        errorFlag = 1
                        break
                    else:
                        for copyName in copyNames:
                            line = "cp -rfv " + copyFile + "/" + copyName + " " + pasteFolder + "/" + newName + "/" + copyName + "\n"
                            lines.append(line)
                if errorFlag == 1:
                    title = _("エラー")
                    mess = _("「") + copyFile + _("」は、OpenFoamのcaseDirectoryではありません。\ncaseコピーできません。")
                    print(mess)
                    self.errDialog(title, mess)
                    return
                else:
                    #server側に実行file作成
                    fileName = pasteMountDir + "/tmpRun"
                    f = open(fileName, "w")
                    for line in lines:
                        f.write(line)
                    f.write("rm ~/tmpRun")      #tmpRunを削除を追記
                    f.close()
                    pyTreeFoam.run().command("chmod a+x " + fileName)
                    #実行
                    comm = sshHeader + " " + "ssh " + userName + "@" + hostName + " " + pasteHostDir + "/tmpRun"
                    #全file名を取得スクリプト
                    logFile = treeFoamUserPath + "/temp/scpLog"
                    filesLines = ["#!/bin/bash\n"]
                    for copyFile in copyFiles:
                        line = sshHeader + " ssh " + userName + "@" + hostName
                        line += " find " + copyFile + " -type f >> " + logFile + "\n"
                        filesLines.append(line)
                    #コマンド作成し実行、Tree再表示（threadを投げて直ぐに戻る）            
                    pasteFolderName = pasteMountDir + pasteFolder[len(pasteHostDir):] + "/" + newName
                    comms = [comm]
                    th = threading.Thread(target=threadRunCommandCp, args=(filesLines, comms, pasteFolderName))
                    th.start()

            #serverから別のserverへコピー
            else:
                errorFlag = 1
                title = _("エラー")
                mess = _("copyするserverとpasteするserverが異なっています。") + "\n"
                mess += _("同じserver内でcopyPasteしてください。")
                self.errDialog(title, mess)
                return

        #localからlocalにコピー
        elif copyServer == "" and pasteServer == "":
            errorFlag = 1
            title = _("エラー")
            mess = _("copyFolder, pasteFolderともlocal側の設定です。") + "\n"
            mess += _("通常の「貼り付け」で貼り付けてください。")
            self.errDialog(title, mess)
        return

    #
    #  deleteServerFoldersRm
    #  ---------------------
    def deleteServerFoldersRm(self):
        """ server内のフォルダを削除する。"""
        print(_("serverフォルダを削除します"))
        #statusBar,treeEvenyをマスク
        self.writeStatusBar(_("フォルダを削除中..."))
        self.maskTreeEvent = True
        title = _("serverフォルダの削除")
        mess = _("server内のフォルダを削除します")
        okArgs     = [self.deleteServerFoldersRm_recheck]
        cancelArgs = [self.deleteServerFoldersRm_ending]
        self.okCancelDialog(title, mess, funcOk=okArgs, funcCancel=cancelArgs)
        return

    #  deleteServerFoldersRm_recheck
    def deleteServerFoldersRm_recheck(self):
        """ 削除の再確認"""
        title = _("serverフォルダの削除")
        mess = _("本当にフォルダを削除しますか?") + "\n"
        mess += _("削除後は、元に戻りません。")
        okArgs     = [self.deleteServerFoldersRm_run]
        cancelArgs = [self.deleteServerFoldersRm_ending]
        self.okCancelDialog(title, mess, funcOk=okArgs, funcCancel=cancelArgs)
        return

    #  deleteServerFoldersRm_ending
    def deleteServerFoldersRm_ending(self):
        """ endingの処理"""
        #statusBarとeventのマスクを解除
        self.clearStatusBar()
        self.maskTreeEvent = False

    #  deleteServerFoldersRm_run
    def deleteServerFoldersRm_run(self):
        """ server内の選択folderを削除する"""
        #delDirを取得
        (dummy, pathes) = self.treeView.get_selection().get_selected_rows()
        delDirs = []
        for path in pathes:
            delDirList = self.getDirFromTreePath(path)
            delDir = os.sep.join(delDirList)
            delDirs.append(delDir)
        #serverを取得
        serverName = pyTreeFoam.servers().getServerName(delDirs[0])
        server = pyTreeFoam.server(serverName)
        hostName = server.sshfsDict["hostName"]
        userName = server.sshDict["user"]
        hostDir = server.sshfsDict["hostDir"]
        mountDir = server.sshfsDict["mountPoint"]
        sshHeader = server.sshfsDict["sshHeader"]
        if mountDir == "":
            #statusBarとeventのマスクを解除
            self.clearStatusBar()
            self.maskTreeEvent = False
            #message出力
            title = _("エラー")
            mess = _("サーバが接続されていません")
            mess += _("local側のfolderを削除する場合は、「フォルダ削除...」を選択してください")
            self.errDialog(title, mess)
            return
        #削除
        for delDir in delDirs:
            delFolder = hostDir + delDir[len(mountDir):]
            comm = "rm -rf " + delFolder
            commLine = "ssh " + userName + "@" + hostName + ' "' + comm + '"'
            print(commLine)
            commLine = sshHeader + commLine       #sshにsshHeaderを追加
            pyTreeFoam.run().commandWithLog(commLine)
        #Treeを再表示
        self.showTreeViewAfterDelete(delDirs)
        print(_("folderを削除しました"))
        #終了処理
        self.deleteServerFoldersRm_ending()


    # --------- drag関連 ------------------------
    #
    #  dragDataReceived
    #  ----------------
    def dragDataReceived(self, widget, drag_context, x,y, data, info, time):
        """ dragしたfolder(file)名をdropした場所(pasteDir)にコピーする"""
        global folderContDict, treeData, selCaseDir
        #statusBarを設定
        self.writeStatusBar("copying...")
        #treeEventをmask
        self.maskTreeEvent = True
        #copyNameを取得
        uris = data.get_uris()
        #urisのチェック
        if len(uris) == 0:
            title = _("エラー")
            mess = _("dragしたfolderが取得できませんでした。") + "\n"
            mess += _("  copyできません。")
            self.errDialog(title, mess)
            return
        copyNames = self.getFilePathFromUris(uris)
        #pasteDirを取得
        path = self.treeView.get_path_at_pos(x,y-self.shift_y)[0]
        pasteDirList = self.getDirFromTreePath(path)
        pasteDir = os.sep.join(pasteDirList)
        #貼り付けのチェック
        if pasteDir in copyNames:
            return
        #確認用のdialogを表示
        title = _("folderの貼り付け")
        mess = _("folder「") + pasteDirList[-1] + _("」に貼り付けますか？")
        okArgs = [self.dragDataReceived_paste, copyNames, pasteDir]
        self.okCancelDialog(title, mess, okArgs)
        return
    
    #  dragDataReceived_paste
    def dragDataReceived_paste(self, copyNames, pasteDir):
        """ 貼り付け開始"""
        #貼り付け開始
        #statusBarを設定
        self.writeStatusBar("copying...")
        #treeEventをmask
        self.maskTreeEvent = True
        #serverを含むかどうかチェック
        copyServer = pyTreeFoam.servers().getServerName(copyNames[0])
        pasteServer = pyTreeFoam.servers().getServerName(pasteDir)
        #コピー開始
        if copyServer == "" and pasteServer == "":
            #localToLocalのコピー
            #　copyNamesをpasteして、Treeに表示(threadで実行して、直ぐに戻る)
            th = threading.Thread(target=self.threadPaste, args=(copyNames, pasteDir))
            th.start()
        else:
            #serverが絡むコピー（scp or cp）
            self.pasteUsingServer(copyServer, copyNames, pasteServer, pasteDir)
            #statusBarのクリア
            self.clearStatusBar()
            #treeEventを解除
            self.maskTreeEvent = False
            
    #
    #  dragDataGet
    #  -----------
    def dragDataGet(self, treeView, context, data, info, time):
        """ dragするfolder名をuriとして取得"""
        selection = treeView.get_selection()
        dummy_treestore, pathes = selection.get_selected_rows()
        uris = []
        for path in pathes:
            dirList = self.getDirFromTreePath(path)
            copyName = os.sep.join(dirList)
            uris.append("file://" + copyName)
        data.set_uris(uris)



    # --------- treeに関する処理 ----------------------

    #
    #  getChildren
    def getChildren(self, parentIter):
        """ treeViewからchildrenを取得する"""
        iter = self.treestore.iter_children(parentIter)     #firstChild
        children = []
        while iter:
            children.append(self.treestore.get_value(iter, self.COL_DIR))
            iter = self.treestore.iter_next(iter)           #nextChild
        return children

    #
    #  deleteAllChildren
    def deleteAllChildren(self, parentIter):
        """ parent内の全childrenをTreeViewから削除する"""
        iter = self.treestore.iter_children(parentIter)
        while iter:
            self.treestore.remove(iter)
            iter = self.treestore.iter_children(parentIter)

    #
    #  getFilePathFromUris
    def getFilePathFromUris(self, uris):
        """ uri表記をpathに置き換える"""
        filePathes = []
        for uri in uris:
            #name = uri.replace("file://", "")
            name = GLib.filename_from_uri(uri)[0]
            filePathes.append(name)
        return filePathes

    # --------- universal dialog ----------------
    #  okDialog
    def okDialog(self, title, mess, funcOk=[]):
        """ okDialog表示"""
        dialog = unvDlg.okDialog(
            title, mess, parentWin=mainWindow, funcOk=funcOk)
        dialog.show()

    #  errDialog
    def errDialog(self, title, mess, funcOk=[]):
        """ errDialog表示"""
        dialog = unvDlg.errDialog(
            title, mess, parentWin=mainWindow, funcOk=funcOk)
        dialog.show()

    #  warningDialog
    def warningDialog(self, title, mess, funcOk=[]):
        """ 警告Dialog表示"""
        dialog = unvDlg.warningDialog(
            title, mess, parentWin=mainWindow, funcOk=funcOk)
        dialog.show()

    #  okCancelDialog
    def okCancelDialog(self, title, mess, 
                       funcOk=[], funcCancel=[]):
        """ okCancel dialog表示"""
        dialog = unvDlg.okCancelDialog(
            title, mess, parentWin=mainWindow, 
            funcOk=funcOk, funcCancel=funcCancel)
        dialog.show()

    #  yesNoDialog
    def yesNoDialog(self, title, mess, funcYes=[], funcNo=[]):
        dialog = unvDlg.yesNoDialog(
            title, mess, funcYes=funcYes, funcNo=funcNo, 
            parentWin=mainWindow)
        dialog.show()

    # openFolderDialog
    def openFolderDialog(
            self, title, path, funcOk=[], funcCancel=[], 
            selName="", patterns=[]):
        dialog = unvDlg.openFolderDialog(
            title, path, 
            funcOk=funcOk, funcCancel=funcCancel, 
            parentWin=mainWindow, selName=selName, 
            filterSets=patterns)
        dialog.show()

#
#  getTreeConts
#    solverなどの内容を取得
def getTreeConts(treeDir):
    treeDir = "/".join(treeDir)
    return getFolderConts(treeDir)

#
#  getFolderConts
def getFolderConts(folderDir):
    conts = folderContDict[folderDir]
    solver = ""; BCPn = ""; nR = ""; st = ""; ed = ""
    folType = conts[0]
    if folType == "case" or folType == "caseLink":
        [solver, BCPn, nR, st, ed] = conts[1:]
    return (folType, solver, BCPn, nR, st, ed)

#
#  createTreeData
#    folderContDictからtreeDataを作成する
def createTreeData(rootDir):
    global treeData
    #treeData作成
    rootName = "root"
    treeData = [rootDir, []]
    folders = []
    folderDirs = list(folderContDict.keys())
    folderDirs.sort()
    for folder in folderDirs:
        if folder != rootDir:
            folderDir = rootName + folder[len(rootDir):]
            words = folderDir.split("/")
            folders.append(words)
    for folderWords in folders:
        treeData = setTreeDataFolder(0, treeData, folderWords)

#
#  setTreeDataFolder
#    folderをtree状に作成する
def setTreeDataFolder(nest, tree, folder):
    nest += 1
    if nest > 50:
        print(_(u"フォルダのネスティングが深すぎます。"))
        return

    #親folderまでskipする
    parentDir = folder[nest]
    ii = 0
    while ii < len(tree[1]):
        if type(tree[1][ii]) == list:
            if tree[1][ii][0] == parentDir:
                setTreeDataFolder(nest, tree[1][ii], folder)
                break
        else:
            if tree[1][ii] == parentDir:
                tree[1][ii] = [parentDir, []]
                setTreeDataFolder(nest, tree[1][ii], folder)
                break
        ii += 1
    #親folderの位置ならchildを追加する
    if nest == len(folder) - 1:
        #parent = folder[-2]
        child = folder[-1]
        tree[1].append(child)
    return tree

def getChildrenFromTreeData(parentPath):
    """ treeDataからchildrenNamesを取得する"""
    tree = treeData[1]
    for i in parentPath[1:]:
        tree = tree[i][1]
    children = []
    if type(tree) == str:
        return children
    for item in tree:
        if type(item) == str:
            children.append(item)
        else:
            children.append(item[0])
    return children

def getParentTreeData(parentPath):
    """ parentのtreeData(items)を取得する"""
    tree = treeData[1]
    for i in parentPath[1:]:
        tree = tree[i][1]
    return tree

#
#  getTreeDirLocalServer
#  ---------------------
def getTreeDirLocalServer(rootDir, selCaseDir, solveCaseDir):
    """ local, server両方のTreeDirを取得する。
    selCase, solveCaseDirまでのdirと内容を取得する。"""
    global folderContDict, serverDirs
    #local側を取得
    getTreeDirLocal(rootDir, selCaseDir, solveCaseDir)
    #mountServerを確認
    mountServers = pyTreeFoam.servers().getMountedServers()
    if len(mountServers) == 0:
        serverDirs = []
        return
    #serverDirsを設定（global変数に）
    serverDirs = list(map(lambda x: x[2], mountServers))
    #server側を取得
    getTreeDirServer(rootDir, selCaseDir, solveCaseDir)

#
#  getTreeDirLocal
#  ---------------
def getTreeDirLocal(rootDir, selCaseDir, solveCaseDir):
    """ local側のtreeDirを取得する。
    selCase、solveCaseまでのdirと内容を取得。"""
    global folderContDict, serverDirs

    def addFoldersToDict(folders, folderDict):
        for folder in folders:
            folderDict[folder] = []
        return folderDict

    def isInServerDir(wdir):
        ans = False
        wdirList = wdir.split("/")
        for serverDir in serverDirs:
            serverDirList = serverDir.split("/")
            n = len(serverDirList)
            if wdirList[:n] == serverDirList:
                ans = True
                break
        return ans

    #serverがマウントされているdirを取得
    serverDirs = []
    mountServers = pyTreeFoam.servers().getMountedServers()
    if len(mountServers) > 0:
        serverDirs = list(map(lambda x: x[2], mountServers))
    #serverDirsに含まれるDirは取得しない。
    #rootDirを確認
    if len(glob.glob(rootDir)) == 0:
        print(_("rootDirがありません。\n　homeDirをrootDirに設定しました。"))
        rootDir = os.getenv("HOME")
    #辞書をクリア
    folderContDict = {}
    folderDict = {}
    #rootDirを設定
    folderDict[rootDir] = []
    #rootDirを取得
    folders = pyTreeFoam.getFoldersBetweenDir(rootDir, rootDir, maskDirs=serverDirs)
    folderDict = addFoldersToDict(folders, folderDict)
    #selCase系列のfolderを取得
    if selCaseDir != rootDir and isInServerDir(selCaseDir) == False:
        folders = pyTreeFoam.getFoldersBetweenDir(rootDir, selCaseDir, maskDirs=serverDirs)
        folderDict = addFoldersToDict(folders, folderDict)
    #solveCase系列のfolderを取得
    if selCaseDir != solveCaseDir and isInServerDir(solveCaseDir) == False:
        #startDirを取得
        selWords = selCaseDir.split("/")
        solveWords = solveCaseDir.split("/")
        nLoop = len(selWords)
        if len(selWords) > len(solveWords):
            nLoop = len(solveWords)
        for i in range(nLoop):
            if selWords[i] != solveWords[i]:
                break
        st = i + 1
        startDir = "/".join(solveWords[:st])
        #folderを取得
        folders = pyTreeFoam.getFoldersBetweenDir(startDir, solveCaseDir, maskDirs=serverDirs)
        folderDict = addFoldersToDict(folders, folderDict)
    #子folderを追加
    folders = pyTreeFoam.getChildFolders(folderDict.keys(), maskDirs=serverDirs)
    folderDict = addFoldersToDict(folders, folderDict)
    #folderの内容を追加（folTypeなど）
    folders = list(folderDict.keys())
    folderConts = addFolderContsData(folders)
    #結果をglobal変数（辞書）に保存
    for folderCont in folderConts:
        folderContDict[folderCont[0]] = folderCont[1:]
    return

#
#  getTreeDirServer
#  ----------------
def getTreeDirServer(rootDir, selCaseDir, solveCaseDir):
    """ server側のtreeDirを取得する。
    selCase、solveCaseまでのdirと内容を取得。"""
    global folderContDict, serverDirs

    def isSetServerDir(serverDir):
        """ serverDirのfolderを2ヶさかのぼって、root, selCase, solveCaseに含まれるdirかどうか確認する。"""
        if isSetServerChildDir(serverDir) == True:
            return True
        serverDirList = serverDir.split("/")
        n = len(serverDirList)
        #親の親dirをチェック
        checkDirs = [rootDirList[:n-2], selCaseDirList[:n-2], solveCaseDirList[:n-2]]
        if serverDirList[:n-2] in checkDirs:
            return True
        return False

    def isSetServerChildDir(serverDir):
        """ serverDirのfolderを1ヶさかのぼって、root, selCase, solveCaseに含まれるdirかどうか確認する。"""
        serverDirList = serverDir.split("/")
        n = len(serverDirList)
        #親dirをチェック
        checkDirs = [rootDirList[:n-1], selCaseDirList[:n-1], solveCaseDirList[:n-1]]
        if serverDirList[:n-1] in checkDirs:
            return True
        return False

    #serverがマウントされているdirを取得
    mountServers = pyTreeFoam.servers().getMountedServers()
    if len(mountServers) == 0:
        return
    serverDirs = list(map(lambda x: x[2], mountServers))
    #server側のdirを取得
    folders = []
    rootDirList = rootDir.split("/")
    selCaseDirList = selCaseDir.split("/")
    solveCaseDirList = solveCaseDir.split("/")
    #  serverDirをチェック
    for serverDir in serverDirs:
        #serverDirを2ヶまでさかのぼって、
        #   root, selCase, solveCaseに含まれるdirかどうか確認
        if isSetServerDir(serverDir) == True:
            #serverDirをfolderContDictに追加
            folders.append(serverDir)
            folderConts = addFolderContsData(folders)
            for folderCont in folderConts:
                folderContDict[folderCont[0]] = folderCont[1:]
            #子dirをチェック
            if isSetServerChildDir(serverDir) == True:
                #どこまで取得するかチェック
                selCaseDir_server = serverDir
                solveCaseDir_server = serverDir
                serverDirList = serverDir.split("/")
                n = len(serverDirList)
                if serverDirList == selCaseDirList[:n]:
                    #selCaseDirまで取得
                    selCaseDir_server = selCaseDir
                if serverDirList == solveCaseDirList[:n]:
                    #solveCaseDirまで取得
                    solveCaseDir_server = solveCaseDir
                #mountServerのDirを取得（暫定）
                folderConts = getDirFromTreeFoamServer(serverDir, selCaseDir_server, solveCaseDir_server)
                #辞書追加
                for folderCont in folderConts:
                    folderContDict[folderCont[0]] = folderCont[1:]

#
#  getDirFromTreeFoamServer
def getDirFromTreeFoamServer(mountDir, selCaseDir, solveCaseDir):
    """ mountDirからserverを確定し、server内のfolderContsを取得する。
    selCaseDir、solveCaseDirまでのfolderContsを取得する。"""
    #serverName = pyTreeFoam.servers().getServerName(mountDir)
    #暫定的にTreeFoamServerを使わずにDirを取得する
    #selCaseDir系列を取得
    folders = pyTreeFoam.getFoldersBetweenDir(mountDir, selCaseDir)
    #solveCaseDir系列を取得
    if selCaseDir != solveCaseDir:
        #startDirを取得
        selWords = selCaseDir.split("/")
        solveWords = solveCaseDir.split("/")
        nLoop = len(selWords)
        if len(selWords) > len(solveWords):
            nLoop = len(solveWords)
        for i in range(nLoop):
            if selWords[i] != solveWords[i]:
                break
        st = i + 1
        startDir = "/".join(solveWords[:st])
        #folderを取得
        folders += pyTreeFoam.getFoldersBetweenDir(startDir, solveCaseDir, maskDirs=serverDirs)
    #子Dirを取得
    folders += pyTreeFoam.getChildFolders(folders)
    folders = list(set(folders))
    folders.sort()
    folderConts = addFolderContsData(folders)
    return folderConts

#
#  getFolderContData
def getFolderContData(expandDir, names):
    """ expandDir + name 以下のfolderContDataを取得する"""
    #folderDirを取得
    folderDirs = []
    for name in names:
        currDir = os.sep.join([expandDir, name])
        folders = pyTreeFoam.getFoldersOnlyCurrDir(currDir)
        folders = list(filter(pyTreeFoam.isNeedFolder, folders))
        folderDirs += folders
    #folderDirsにfolderの内容を追加
    folderConts = addFolderContsData(folderDirs)
    folderConts.sort()
    return folderConts
    
#
#  addFolderContsData
def addFolderContsData(folderDirs):
    """ folderDirsにfolderの内容を追加して戻す。
        folderContDataのformat形式で戻す"""
    #folderの種類を取得
    folderConts = []
    for folder in folderDirs:
        folType = pyTreeFoam.getFolderType(folder)
        folderConts.append([folder, folType])
    #caseFolderの内容を設定
    for i in range(len(folderConts)):
        folderCont = folderConts[i]
        if folderCont[1] == "case" or folderCont[1] == "caseLink":
            folder = folderCont[0]
            caseCont = pyTreeFoam.case(folder).getCaseCont()
            folderConts[i] += caseCont
    return folderConts

#
#  getNumberResult
#    計算結果folderの数を取得
def getNumberResult(selectDir):
    #folderを取得
    folNames = pyTreeFoam.getFolderNames(selectDir)
    #並列数を確認
    nProc = 0
    for folder in folNames:
        if folder[:len("processor")] == "processor":
            nProc += 1
    #結果folder数を取得
    ans = []
    for folder in folNames:
        try:
            a = float(folder)
            ans.append(a)
        except:
            pass
    nRst = len(ans)
    if nProc > 1:
        #並列処理の計算結果を確認
        ansP = pyTreeFoam.case(selectDir).getTimeFolders("processor0")
        if len(ansP) > nRst:
            nRst = len(ansP)
            ans = ansP
    #戻り値を設定
    ansR = []
    if nRst != 0:
        ansR.append(" " + str(nRst))
        ansR.append(" " + str(min(ans)))
        if min(ans) == max(ans):
            ansR.append("")
        else:
            ansR.append(" " + str(max(ans)))
        if nProc == 0:
            ansR.append(" ")
        else:
            ansR.append(str(nProc))
    return ansR

#
#  openFolder
def openFolder(openDir):
    """ openDirを開く"""
    pyTreeFoam.run(openDir).fileManager()

#
#  editControlDict
def editControlDict(caseDir):
    """ geditでcontolDict、fvScheme, fvSolutionを開く"""
    pyTreeFoam.run(caseDir).editControlDict()

# ----------- copy関連 ----------------
#
#  copyLocalToLocal
def copyLocalToLocal(copyNames, pasteDir):
    """ local内でコピーする
    
    Args:
        copyNames (list(str))   :copyするfolder/fileのlist
        pasteDir (str)          :pasteするdirectory
    Returns:
        stat (str)              :"OK" or "CANCEL" """
    #progressDialog側は、copy, paste共listなので、
    # pasteDirをpasteDirsに変更して渡す。
    pasteDirs = [ pasteDir for i in range(len(copyNames))]
    stat = progressBar.pasteLocalToLocal(copyNames, pasteDirs).paste()
    return stat

#
#  copyUsingServer
def copyUsingServer(runFile, logFile):
    """ serverを使ったコピー。localToServer, serverToLocal, serverToserverのコピー。"""
    stat = progressBar.pasteServerLocal(runFile, logFile).paste()
    return stat

#
#  copyCaseLocalToLocal
def copyCaseLocalToLocal(caseDirs, pasteDir):
    """ local内でcaseCopyする
    
    Args:
        caseDirs (list(str))    :copyするcaseFolderのlist
        pasteDir (str)          :pasteするdirectory
    Returns:
        stat (str)              :"OK" or "CANCEL" """
    #progressDialog側は、copy, paste共listなので、
    # pasteDirをpasteDirsに変更して渡す。
    pasteDirs = [ pasteDir for i in range(len(caseDirs))]
    stat = progressBar.pasteCaseLocalToLocal(caseDirs, pasteDirs).paste()
    #stat = pasteCaseLocalToLocal(caseDirs, pasteDirs).paste()
    return stat

#
#  endingTreeFoam
def endingTreeFoam(treeSize, splitWidth):
    """ TreeFoamの終了処理。windowSizeを保存、TreeFoamの起動番号（nTreeFoam）を削除"""
    #windowSize、window分割幅、cell幅を保存
    saveTreeSize(treeSize, splitWidth)
    #rootDir, solveCaseDirを保存
    configDict = {}
    configDict["rootDir"] = rootDir
    configDict["workDir"] = solveCaseDir
    pyTreeFoam.writeConfigTreeFoam(configDict)
    #TreeFoamの起動番号（nTreeFoam）を削除
    fileName = os.sep.join([treeFoamUserPath, "data", nRunningTreeFoam])
    f = open(fileName); lines = f.readlines(); f.close()
    newLines = []
    for line in lines:
        words = line.split()
        if words[0] != nTreeFoam:
            newLines.append(line)
    f = open(fileName, "w"); f.writelines(newLines); f.close()

#
#  deleteBashComment
def deleteBashComment(lines):
    """ コメント（「#」から文末まで）を削除する"""
    newLines = []
    for line in lines:
        if line[0] != "#":
            n = line.find("#")
            if n < 0:
                newLines.append(line)
            else:
                newLine = line[:n] + "\n"
                newLines.append(newLine)
    return newLines

#
#  saveTreeSize
def saveTreeSize(treeSize, splitWidth):
    """ treeFoamのwindowSize、分割幅、cell幅を保存"""
    winDict = {}
    (width, height) = treeSize
    winDict["treeFoam"] = str(width) + " " + str(height)
    winDict["treeFoam_splitter"] = str(splitWidth)
    colWidthCont = " ".join(list(map(str, colWidth)))
    winDict["treeFoam_colWidth"] = colWidthCont
    pyTreeFoam.writeWindowSize(winDict)

#
#  getWindowSizeFromFile
def getWindowSizeFromFile():
    """ windowサイズをファイルから取得する"""
    global treeSize, splitWidth, colWidth
    #fileを読み込み
    winSizeDict = pyTreeFoam.readWindowSize()
    #fteeFoamサイズを設定
    if winSizeDict["treeFoam"] != "":
        words = winSizeDict["treeFoam"].split()
        treeSize = (int(words[0]), int(words[1]))
    else:
        treeSize = (800, 500)       #default値
    #treeFoam分割サイズを設定
    if winSizeDict["treeFoam_splitter"] != "":
        words = winSizeDict["treeFoam_splitter"].split()
        splitWidth = int(words[0])
    else:
        splitWidth = 100            #default値
    #colWidthを設定
    if winSizeDict["treeFoam_colWidth"] != "":
        words = winSizeDict["treeFoam_colWidth"].split()
        colWidth = list(map(int, words))
    else:
        colWidth = [300, 200, 40, 40, 60, 60]   ##default値

#
#  checkUserSettingFile
def checkUserSettingFile():
    global startFile

    def copyFiles(sourceDir, pasteDir):
        files = glob.glob(sourceDir + "/*")
        for fileName in files:
            if os.path.isfile(fileName):
                shutil.copy(fileName, pasteDir)

    #folder有無チェック
    if len(glob.glob(treeFoamUserPath)) == 0:
        os.makedirs(treeFoamUserPath)
        shutil.copy(treeFoamPath+os.sep+"configTreeFoam", treeFoamUserPath)
    if len(glob.glob(treeFoamUserPath+os.sep+"app")) == 0:
        os.makedirs(treeFoamUserPath+os.sep+"app")
        copyFiles(treeFoamPath + "/app", treeFoamUserPath + "/app")
    if len(glob.glob(treeFoamUserPath+os.sep+"data")) == 0:
        os.makedirs(treeFoamUserPath+os.sep+"data")
        copyFiles(treeFoamPath + "/data", treeFoamUserPath + "/data")
    if len(glob.glob(treeFoamUserPath+os.sep+"temp")) == 0:
        os.makedirs(treeFoamUserPath+os.sep+"temp")
    #file有無チェック
    #  configTreeFoam有無
    if len(glob.glob(treeFoamUserPath+os.sep+"configTreeFoam")) == 0:
        shutil.copy(treeFoamPath+os.sep+"configTreeFoam", treeFoamUserPath)
    #  sshfs_data(server接続)有無
    if len(glob.glob(treeFoamUserPath+"/data/sshfs_data")) == 0:
        copyFile = treeFoamPath + "/data/sshfs_data"
        pasteDir = treeFoamUserPath + "/data"
        shutil.copy(copyFile, pasteDir)
    #  runPlotWatcher-venv有無
    if len(glob.glob(treeFoamUserPath+"/app/runPlotWatcher-venv")) == 0:
        copyFile = treeFoamPath + "/app/runPlotWatcher-venv"
        pasteDir = treeFoamUserPath + "/app"
        shutil.copy(copyFile, pasteDir)
    #startingInputファイルをチェック
    try:
        startFile.write("chacking start file...\n")
    except:
        #書き込みエラー発生すれば、openする。
        startFile = open(os.getenv("startingFile"), "w")
        startFile.write("chacking start file...\n")
        pass

#
#  checkRootSelSolveCase
def checkRootSelSolveCase(configDict):
    """ config内のrootDir, selCaseDir, solveCaseDirをチェックする。
    存在しないdirの場合は、default値を設定する"""
    #書き込みflagを定義
    flag = 0
    #rootDirをチェック
    rootDir = configDict["rootDir"]
    if len(glob.glob(rootDir)) == 0:
        #存在しない場合は、homePathに設定する
        rootDir = homePath
        configDict["rootDir"] = homePath
        flag = 1
    #selCaseDirをチェック
    selCaseDir = configDict["workDir"]
    if len(glob.glob(selCaseDir)) == 0:
        #存在しない場合は、一段づつ遡る
        rootDirList = rootDir.split(os.sep)
        selCaseDirList = selCaseDir.split(os.sep)
        #selCaseDirがrootDir内にあるか
        if selCaseDirList[:len(rootDirList)] != rootDirList:
            #selCaseDirがrootDir以下に無い場合
            selCaseDir = rootDir
            solveCaseDir = rootDir
            configDict["workDir"] = rootDir
            flag = 1
        else:
            #一段づつrootDirまでさかのぼり、存在するdirを確認する
            selCaseDir = getDirFromBackTrace(rootDir, selCaseDir)
            configDict["workDir"] = selCaseDir
            solveCaseDir = selCaseDir
    else:
        #selCaseDirが存在する場合
        if selCaseDir[:len(rootDir)+1] == rootDir+os.sep:
            solveCaseDir = selCaseDir
        else:
            selCaseDir = rootDir
            solveCaseDir = selCaseDir
    if flag == 1:
        #configTreefoamを更新する
        pyTreeFoam.writeConfigTreeFoam(configDict)
    return (rootDir, selCaseDir, solveCaseDir)

#
#  checkDirRootSelSolveCase
def checkDirRootSelSolveCase():
    """ rootDir, selCaseDir, solveCaseDirをチェックする。
    存在しない場合は、rootDirを基準に再設定する。"""
    global rootDir, selCaseDir, solveCaseDir
    rootFlag = len(glob.glob(rootDir))
    selFlag = len(glob.glob(selCaseDir))
    solveFlag = len(glob.glob(solveCaseDir))
    if rootFlag == 1 and selFlag == 1 and solveFlag == 1:
        return
    #rootDirが存在しない場合
    if rootFlag == 0:
        rootDir = os.getenv("HOME")
    #selCaseDirが存在しない場合
    if selFlag == 0:
        selCaseDir = getDirFromBackTrace(rootDir, selCaseDir)
    #solveCaseDirが存在しない場合
    if solveFlag == 0:
        solveCaseDir = getDirFromBackTrace(rootDir, solveCaseDir)

#
#  getDirFromBacktrace
def getDirFromBackTrace(stdDir, wkDir):
    """ wkDirを一段づつstdDirまでさかのぼり、実在するDirを取得する。
    stdDirは、実在するDir。"""
    stdList = stdDir.split("/")
    wkList = wkDir.split("/")
    ansDir = stdDir
    for i in range(len(wkList)):
        ii = len(wkList) - i
        if ii <= len(stdList):
            ansDir = stdDir
            break
        cdir = "/".join(wkList[:ii])
        if len(glob.glob(cdir)) == 1:
            ansDir = cdir
            break
    return ansDir

#
#  getTreeFoamNo
def getTreeFoamNo():
    """ TreeFoamの起動Noを取得する"""
    #treeFoamの起動状況を確認
    #  treefoam.py関連の全PIDを取得
    comm = 'pgrep -l -f "treefoam.py"'
    print("\n"+comm)
    results = pyTreeFoam.run().commandReturnCont(comm)
    res = results[1]
    lines = res.split("\n")
    #  python3 treefoam.pyのみ取得
    #  sh treefoam.pyが含まれる場合がある
    pids = []
    for line in lines:
        words = line.split()
        if len(words) > 0:
            if (words[1][:len("python")] == "python" or
                words[1] == "treefoam.py"):
                pids.append(words[0])
    print("Running TreeFoam PID ----> ", " ".join(pids))
    fileName = os.sep.join([treeFoamUserPath, "data", nRunningTreeFoam])
    #初回起動？
    if len(pids) <= 1:
        #初回起動、nRunningTreeFoamをクリア
        f = open(fileName, "w"); f.close()
        #logFileを削除
        fileFilter = treeFoamUserPath + os.sep + "temp" + os.sep + "*_logTreeFoam"
        files = glob.glob(fileFilter)
        for name in files:
            os.remove(name)
        print("   delete tempFiles of TreeFoam.")

    # #treeFoamの起動状況を確認
    # print("Running TreeFoam PID ----> ", end="")
    # comm = 'pgrep -d " " -f "treefoam.py"'
    # results = pyTreeFoam.run().commandReturnCont(comm)
    # fileName = os.sep.join([treeFoamUserPath, "data", nRunningTreeFoam])
    # res = results[1]
    # if len(res.split()) <= 1:
    #     #初回起動、nRunningTreeFoamをクリア
    #     f = open(fileName, "w"); f.close()
    #     #logFileを削除
    #     fileFilter = treeFoamUserPath + os.sep + "temp" + os.sep + "*_logTreeFoam"
    #     files = glob.glob(fileFilter)
    #     for name in files:
    #         os.remove(name)

    #nRunningTreeFoamを読み込み
    f = open(fileName); lines = f.readlines(); f.close()
    Nos = []
    for line in lines:
        words = line.split()
        if len(words) > 0:
            Nos.append(int(words[0]))
    if len(Nos) == 0:
        No = 0
    else:
        No = max(Nos) + 1
    f = open(fileName, "a"); f.write(str(No)+"\n"); f.close()
    return str(No)

#
#  setMountDirInSshfsData
def setMountDirInSshfsData():
    """ sshfsDataを適正化する。mountDirを確認する。"""
    mountServers = pyTreeFoam.servers().getMountedServers()
    for (serverName, _hostName, mountDir) in mountServers:
        #files = os.listdir(mountDir)
        files = glob.glob(mountDir+"/*")
        if len(files) == 0:
            #mountPointをクリア
            server = pyTreeFoam.server(serverName)
            server.sshfsDict["mountPoint"] = ""
            server.writeSshfsData()
    return

#
#  clearTempFolder
def clearTempFolder():
    """ $TreeFoamUserPath/tempフォルダ内をクリアする"""
    tempFolder = os.getenv("TreeFoamUserPath") + "/temp"
    comm = "rm -rf " + tempFolder + "/*"
    pyTreeFoam.run().command(comm)

#
#  writeTreeFoamVersion
def writeTreeFoamVersion():
    """ TreeFoamのversionを記録する"""
    fileName = os.getenv("TreeFoamPath") + "/TreeFoamVersion"
    f = open(fileName, "w"); f.write(version); f.close()

#
#  setLanguage
def setLanguage(configDict):
    """ 言語の設定"""
    #install直後の起動か確認する
    #  .TreeFoamUserフォルダ有無で確認
    if len(glob.glob(os.getenv("HOME") + "/.TreeFoamUser")) == 0:
        #install後の初回起動
        if os.getenv("LANG")[:2] != "ja":
            configDict["language"] = "English"
        else:
            configDict["Language"] = "Japanese"
        pyTreeFoam.writeConfigTreeFoam(configDict)
    #言語を設定する
    if configDict["language"] == "English":
        comm = 'localectl set-locale LANG=en_US.UTF-8 LANGUAGE="en_US:en"'
        pyTreeFoam.run().command(comm)
        if os.getenv("LANG") != "en_US.UTF-8":
            os.environ["LANG"] = "en_US.UTF-8"
            os.environ["LANGUAGE"] = "en_US:en"
    else:
        comm = 'localectl set-locale LANG=ja_JP.UTF-8 LANGUAGE="ja_JP:jp"'
        pyTreeFoam.run().command(comm)
        if os.getenv("LANG") != "ja_JP.UTF-8":
            os.environ["LANG"] = "ja_JP.UTF-8"
            os.environ["LANGUAGE"] = "ja_JP:ja"
    #辞書再設定
    gettext.install("treefoam", os.getenv("TreeFoamPath") + "/data/locale")
    return


#
#  initialize
#---------------
def initialize():
    global treeFoamPath, treeFoamUserPath, OFversionFix, envOpenFOAMFix
    global clipboardFile
    global rootDir, selCaseDir, solveCaseDir
    global nTreeFoam

    #global変数を設定
    treeFoamPath = os.getenv("TreeFoamPath")
    treeFoamUserPath = os.getenv("TreeFoamUserPath")
    #folder、file有無チェック
    checkUserSettingFile()

    startFile.write("initializing...\n")

    configDict = pyTreeFoam.readConfigTreeFoam()
    #言語の設定
    setLanguage(configDict)

    #sshfsDataを初期化（montDirを適正化）
    setMountDirInSshfsData()

    #TreeFoamの起動Noを取得
    nTreeFoam = getTreeFoamNo()
    if int(nTreeFoam) == 0:
        #最初に起動したTreeFoamの場合、tempFolder内をクリア
        clearTempFolder()
    #TreeFoamのversionを記録する
    writeTreeFoamVersion()
    #windowSizeを設定
    getWindowSizeFromFile()
    #clipboardを定義
    clipboardFile = treeFoamUserPath + os.sep + "data" + os.sep + "clipBoard"
    #OpenFOAMのバージョンをconfigTreeFoamに記録する
    bashrc = configDict["bashrcFOAM"]
    cont = "#!/bin/bash\n"
    cont += ". " + bashrc + "\n"
    cont += treeFoamPath + os.sep + "bin" + os.sep + "getOFversionWriteConfig.py\n"
    fileName = os.getenv("TreeFoamUserPath") + "/temp/runBash"
    f = open(fileName, "w"); f.write(cont); f.close()
    pyTreeFoam.run().command("chmod a+x " + fileName)
    pyTreeFoam.run().command(fileName)
    #configを再読込
    configDict = pyTreeFoam.readConfigTreeFoam()
    OFversionFix = configDict["OFversion"]
    envOpenFOAMFix = configDict["bashrcFOAM"]
    #rootDirなどのdirectoryのチェック
    (rootDir, selCaseDir, solveCaseDir) = checkRootSelSolveCase(configDict)
    #logFileを設定
    if configDict["logFile"] == "yes":
        logDir = treeFoamUserPath + os.sep + "temp"
        os.environ["LogFile"] = logDir + os.sep + nTreeFoam + "_logTreeFoam"
    import python.logFileCreater
    python.logFileCreater.new()
    print("TreeFoam ver", version, " (" + nTreeFoam + ") " + _(u"を起動しました。"))
    print("OpenFOAM -", OFversionFix)
    if OFversionFix == "XXXX":
        print(_("  OpenFOAMの環境が設定できません。"))
        print(_("  「") + envOpenFOAMFix + "」を確認してください")

    #clipboardのチェック
    res = copyPasteFolders.checkClipApp()
    if res == False:
        print("  currently, could not copy/paste between TreeFoam and file manager.")


if __name__ == "__main__":
    #pythonScript内を翻訳
    import gettext
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    initialize()        #configTreeFoamを確認し、言語を設定
    app = windowApp()
    app.main()

