#!/usr/bin/python3
#  coding: utf-8
#

import sys, os, glob

# try:
#     #from PyQt4 import QtCore, QtGui
#     from PyQt6 import QtCore, QtGui
# except:
#     from PySide import QtCore, QtGui

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule
#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()


import QtParts as Qt4Parts

def _fromUtf8(s):
    return s

#-----------------------
#  Ui_MainWindow class
#-----------------------
class Ui_MainWindow(object):
    """ pyuic4でuiファイルをpyファイルに変換したもの"""
    def setupUi(self, MainWindow):
        """ GUIを作成"""
        MainWindow.setObjectName(_fromUtf8("MainWindow"))
        MainWindow.resize(532, 391)
        #self.centralwidget = QtGui.QWidget(MainWindow)
        self.centralwidget = QWidget(MainWindow)
        self.centralwidget.setObjectName(_fromUtf8("centralwidget"))
        #self.verticalLayout = QtGui.QVBoxLayout(self.centralwidget)
        self.verticalLayout = QVBoxLayout(self.centralwidget)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        self.treeWidget = QTreeWidget(self.centralwidget)
        self.treeWidget.setObjectName(_fromUtf8("treeWidget"))
        self.treeWidget.headerItem().setText(0, _fromUtf8("1"))
        self.verticalLayout.addWidget(self.treeWidget)
        MainWindow.setCentralWidget(self.centralwidget)
        self.menubar = QMenuBar(MainWindow)
        self.menubar.setGeometry(QRect(0, 0, 532, 37))
        self.menubar.setObjectName(_fromUtf8("menubar"))
        MainWindow.setMenuBar(self.menubar)
        self.statusbar = QStatusBar(MainWindow)
        self.statusbar.setObjectName(_fromUtf8("statusbar"))
        MainWindow.setStatusBar(self.statusbar)

        self.retranslateUi(MainWindow)
        QMetaObject.connectSlotsByName(MainWindow)

    def retranslateUi(self, MainWindow):
        #MainWindow.setWindowTitle(_translate("MainWindow", "MainWindow", None))
        MainWindow.setWindowTitle("MainWindow")


#-----------------------
#  treeWidget_test class
#-----------------------
class treeWidget_test(Ui_MainWindow):

    def __init__(self):
        #self.MainWindow = QtGui.QMainWindow()
        self.MainWindow = QMainWindow()
        self.setupUi(self.MainWindow)
        self.dataDict = {
            "/home/caeuser":                [],
            "/home/caeuser/CAE":            [0,0],
            "/home/caeuser/CAE/test":       [1, 2],
            "/home/caeuser/CAE/test1":      [3, 4],
            "/home/caeuser/CAE/test1/test": [6, 7],
            "/home/caeuser/TEST":           [0,0],
            "/home/caeuser/TEST/test_1":    [2, 1]
            }
        rootDir = "/home/caeuser"

        self.Tree = Qt4Parts.treeWidget(self.treeWidget)

        #アイコンを設定
        iconDir = "/home/caeuser/TreeFoam-glade333/icons"
        self.iconFolder = QIcon()
        self.iconFolder.addPixmap(QPixmap(iconDir + "/folder16.png"))
        #headerを作成
        headers = ["directory", "col1", "col2", "col3"]
        self.Tree.createTree(headers)
        #treeのデータを辞書で取得
        rootDir = os.getenv("HOME")
        selDir = rootDir + "/CAE/CAE-FOAM/OF-v1906/pitzDaily"
        self.dataDict = self.createDataDictionary(rootDir, selDir)
        #辞書データをtreeDataに変換
        self.Tree.createTreeData(self.dataDict)
        self.treeData = self.Tree.treeData
        #treeDataをtreeWidgetにセット
        self.Tree.setItems()
        #treeのselDirを展開し、選択
        self.Tree.selectDir(selDir)
        #col幅を調整する
        self.Tree.adjustColWidth()

    def main(self):
        # selDir = "/home/caeuser/CAE/test1/test"
        # self.selectDir(selDir)
        # selItem = self.getItemFromDir("/home/caeuser/TEST/test_1")
        # selDir = self.getDirFromItem(selItem)
        # rootDir = os.getenv("HOME")
        # selDir = rootDir + "/CAE/CAE-FOAM"
        self.createEvent()
        self.MainWindow.show()

    def close(self):
        QtGui.qApp.quit()

    def createEvent(self):
        """ eventを作成"""
        self.treeWidget.itemChanged.connect(self.onItemChangeed)
        self.treeWidget.itemClicked.connect(self.onItemClicked)
        self.treeWidget.itemExpanded.connect(self.onItemExpanded)

    #------- event handler --------------
    #itemの内容が変更された時
    def onItemChangeed(self, selItem, col):
        pass
    #itemをクリックした時
    def onItemClicked(self, selItem, col):
        self.Tree.adjustColWidth()
    #itemを展開した時
    def onItemExpanded(self, expItem):
        self.itemExpanded(expItem)
    #-----------------------------------------

    def itemExpanded(self, item):
        """ itemを展開した時、そのfolder内のdataを再読み込みし、treeを再作成する"""
        #itemの子itemを全て削除（辞書も該当部を削除）
        self.Tree.deleteChldren(item)
        #item以下のfolderを取得
        itemDir = self.Tree.getDirFromItem(item)
        folders = self.getFolders(itemDir)
        folders += self.getChildFolders(folders)
        #辞書を追加
        self.addDataToDataDict(folders)
        rootDir = self.treeData[0]
        self.Tree.createTreeData(self.dataDict)
        self.treeData = self.Tree.treeData
        #item以下を再作成
        items = self.Tree.getItemsFromTreeData(itemDir)
        parentDir = [rootDir] + itemDir[len(rootDir)+1:].split("/")
        self.Tree.addTreeNodes(item, parentDir, items)
        #col幅を調整する
        self.Tree.adjustColWidth()

    def addDataToDataDict(self, folders):
        """ folders内のデータをdataDictに追加する"""
        for folder in folders:
            colConts = self.getColContsAtFolder(folder)
            self.dataDict[folder] = [self.iconFolder, colConts]

    def createDataDictionary(self, rootDir, selDir):
        """ dirとそれに対応するdataの辞書を作成する。"""
        folders = self.getDirUnderRootToSelDir(rootDir, selDir)
        dataDict = {}
        for folder in folders:
            colConts = self.getColContsAtFolder(folder)
            dataDict[folder] = [self.iconFolder, colConts]
        return dataDict

    def getColContsAtFolder(self, folder):
        """ folderDirに対応するdata（colConts）を取得する"""
        colConts = [12, "opiu"]
        return colConts

    #--------- directoryの取得関連 ---------
    def getDirUnderRootToSelDir(self, rootDir, selDir):
        """ rootDirからselDir系列のdirectoryを取得する"""
        folders = self.getFoldersBetweenDir(rootDir, selDir)
        childFolders = self.getChildFolders(folders)
        folders += childFolders
        return folders

    def getFoldersBetweenDir(self, startDir, endDir):
        """ startDirからendDirまでのfolderを取得する"""
        folders = [startDir]
        folders += self.getFolders(startDir)
        if startDir == endDir:
            return folders
        currDir = ""
        for folder in folders:
            n = len(folder)
            if folder == endDir[:n]:
                currDir = folder
                break
        folders += self.getFolders(currDir)
        names = endDir[len(currDir)+1:].split("/")
        for name in names:
            currDir += "/" + name
            folders += self.getFolders(currDir)
        return folders 

    def getFolders(self, currDir):
        """ curDirのfolderDirを取得する"""
        items = glob.glob(currDir + "/*")
        folders = list(filter(lambda x: os.path.isdir(x), items))
        return folders

    def getChildFolders(self, folders):
        """ foldersの子foldersを取得する"""
        subFolders = []
        for folder in folders:
            subFolders += self.getFolders(folder)
        return subFolders


    
def showGui():
    global app
    #app = QtGui.QApplication(sys.argv)
    app = QApplication(sys.argv)    
    ui = treeWidget_test()
    ui.main()
    #sys.exit(app.exec_())
    try:
        app.exec_()
    except:
        app.exec()

if __name__ == "__main__":
    showGui()
