#!/usr/bin/python3
#  coding: utf-8
#
#   surfaceRotationDDialog.py
#
#       stlファイルを各軸周りに回転させる
#
#   21/07/13    新規作成
#   24/08/09    funcOk,funcCancel,parent追加
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys
#import multiprocessing

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

#------------------------
#  surfaceRotation class
#------------------------
class surfaceRotation:
    """ stlファイルを回転させる"""

    def __init__(self, funcOk=[], funcCancel=[], parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "surfaceRotationDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        #親windowの設定
        self.dialog.set_transient_for(parent)
        #modal(freeze)の設定
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        #self.stat = "CANCEL"
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        self.entry_rx.set_text("0.0")
        self.entry_ry.set_text("0.0")
        self.entry_rz.set_text("0.0")
        self.rotations = []

    #
    #  show
    #--------
    def show(self):
        """ dialogを表示"""
        self.dialog.show()
        # self.dialog.run()
        # return self.rotations

    #
    #  close
    #--------
    def close(self, *args):
        """ dialogを閉じた時のevent"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #----------------
    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        self.entry_rx = self.builder.get_object("entry_rx")
        self.entry_ry = self.builder.get_object("entry_ry")
        self.entry_rz = self.builder.get_object("entry_rz")
        

    #-------- event handler -----------
    #
    #  OK
    def onOk(self, event):
        #self.stat = "OK"
        #原点回りの角度
        rx = self.entry_rx.get_text()
        ry = self.entry_ry.get_text()
        rz = self.entry_rz.get_text()
        rotations = [rx, ry, rz]
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = [rotations] + self.funcOk[1:]
            #funcName(rotations, *args)
            GLib.timeout_add(10, funcName, *args)

    def onCancel(self, event):
        #self.stat = "CANCEL"
        #self.rotations = []
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(10, funcName, *args)


