#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   selectNamesQtDDialog.py
#
#   20/04/22    多言語化対応
#      05/02    PyQt4, PyQt5, PySide, PySide2に対応
#      05/24    PyQtの取得方法を修正（一元化）
#   24/08/23    setCenterParentPosition:新規追加。
#               （dialogをparentの中心に配置）
#      08/28     Qt4系、Qt6系の両方に対応する様に修正
#

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()

import QtVar

import sys
import os


def _fromUtf8(s):
    return s

try:
    _encoding = QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig)

#------------------
#  Ui_dialog class
#------------------
class Ui_Dialog(object):

    def __init__(self, title, message, subMessage, names, parent):
        self.title = title
        self.message = message
        self.subMessage = subMessage
        self.names = names
        self.parent = parent
        self.selNames = []
        self.Dialog = QDialog()

    def main(self):
        self.setupUi(self.Dialog)
        self.setEvent()
        self.label_mess.setText(self.message)
        self.label_subMess.setText(self.subMessage)
        self.Dialog.setWindowTitle(self.title)
        self.listmodel = QStringListModel(self.names)
        self.listView_names.setModel(self.listmodel)
        self.listView_names.setSelectionMode(QtVar.ExtendedSelection)
        self.btn_ok.setDefault(True)
        #dialogをparentの中心に設定する。
        self.setCenterParentPosition()
        self.Dialog.exec()
        return self.selNames

    def close(self):
        self.Dialog.close()

    def setCenterParentPosition(self):
        """ dialogの位置を親の中心に設定する。
        widgetのレイアウト設定後に実行する"""
        #parentの中心位置
        geo = self.parent.geometry()
        xy = (geo.left() + geo.width()//2, geo.top() + geo.height()//2)
        pos = QPoint(xy[0], xy[1])
        #設定位置を取得
        geo = self.Dialog.geometry()
        geoP = QPoint(geo.width()//2, geo.height()//2)
        newPos = pos - geoP
        self.Dialog.move(newPos)

    def setupUi(self, Dialog):
        """ Qtのバージョンに応じたGUIを設定"""
        if getPyQtModule.UiCode == "Qt4":
            self.setupUi_Qt4(Dialog)
        elif getPyQtModule.UiCode == "Qt6":
            self.setupUi_Qt6(Dialog)

    def setupUi_Qt6(self, Dialog):
        """ Qt6系のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(331, 300)
        self.verticalLayout = QVBoxLayout(Dialog)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        self.label_mess = QLabel(Dialog)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_mess.sizePolicy().hasHeightForWidth())
        self.label_mess.setSizePolicy(sizePolicy)
        ## self.label_mess.setAlignment(Qt.AlignCenter)
        self.label_mess.setAlignment(Qt.AlignmentFlag.AlignCenter)
        self.label_mess.setObjectName(_fromUtf8("label_mess"))
        self.verticalLayout.addWidget(self.label_mess)
        self.label_subMess = QLabel(Dialog)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_subMess.sizePolicy().hasHeightForWidth())
        self.label_subMess.setSizePolicy(sizePolicy)
        self.label_subMess.setObjectName(_fromUtf8("label_subMess"))
        self.verticalLayout.addWidget(self.label_subMess)
        self.listView_names = QListView(Dialog)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.listView_names.sizePolicy().hasHeightForWidth())
        self.listView_names.setSizePolicy(sizePolicy)
        self.listView_names.setObjectName(_fromUtf8("listView_names"))
        self.verticalLayout.addWidget(self.listView_names)
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## spacerItem = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        spacerItem = QSpacerItem(40, 20, QSizePolicy.Policy.Expanding, QSizePolicy.Policy.Minimum)
        self.horizontalLayout.addItem(spacerItem)
        self.btn_cancel = QPushButton(Dialog)
        self.btn_cancel.setObjectName(_fromUtf8("btn_cancel"))
        self.horizontalLayout.addWidget(self.btn_cancel)
        self.btn_ok = QPushButton(Dialog)
        self.btn_ok.setObjectName(_fromUtf8("btn_ok"))
        self.horizontalLayout.addWidget(self.btn_ok)
        self.verticalLayout.addLayout(self.horizontalLayout)

        self.retranslateUi(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def setupUi_Qt4(self, Dialog):
        """ Qt4系のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(331, 300)
        ## self.verticalLayout = QtGui.QVBoxLayout(Dialog)
        self.verticalLayout = QVBoxLayout(Dialog)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        ## self.label_mess = QtGui.QLabel(Dialog)
        self.label_mess = QLabel(Dialog)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_mess.sizePolicy().hasHeightForWidth())
        self.label_mess.setSizePolicy(sizePolicy)
        self.label_mess.setAlignment(Qt.AlignCenter)
        self.label_mess.setObjectName(_fromUtf8("label_mess"))
        self.verticalLayout.addWidget(self.label_mess)
        ## self.label_subMess = QtGui.QLabel(Dialog)
        self.label_subMess = QLabel(Dialog)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_subMess.sizePolicy().hasHeightForWidth())
        self.label_subMess.setSizePolicy(sizePolicy)
        self.label_subMess.setObjectName(_fromUtf8("label_subMess"))
        self.verticalLayout.addWidget(self.label_subMess)
        ## self.listView_names = QtGui.QListView(Dialog)
        self.listView_names = QListView(Dialog)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.listView_names.sizePolicy().hasHeightForWidth())
        self.listView_names.setSizePolicy(sizePolicy)
        self.listView_names.setObjectName(_fromUtf8("listView_names"))
        self.verticalLayout.addWidget(self.listView_names)
        ## self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## spacerItem = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout.addItem(spacerItem)
        ## self.btn_cancel = QtGui.QPushButton(Dialog)
        self.btn_cancel = QPushButton(Dialog)
        self.btn_cancel.setObjectName(_fromUtf8("btn_cancel"))
        self.horizontalLayout.addWidget(self.btn_cancel)
        ## self.btn_ok = QtGui.QPushButton(Dialog)
        self.btn_ok = QPushButton(Dialog)
        self.btn_ok.setObjectName(_fromUtf8("btn_ok"))
        self.horizontalLayout.addWidget(self.btn_ok)
        self.verticalLayout.addLayout(self.horizontalLayout)

        self.retranslateUi(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def retranslateUi(self, Dialog):
        Dialog.setWindowTitle(_translate("Dialog", "Dialog", None))
        self.label_mess.setText(_translate("Dialog", "TextLabel", None))
        self.label_subMess.setText(_translate("Dialog", "TextLabel", None))
        self.btn_cancel.setText(_translate("Dialog", _("キャンセル"), None))
        self.btn_ok.setText(_translate("Dialog", "OK", None))

    def setEvent(self):
        self.btn_cancel.clicked.connect(self.onCancel)
        self.btn_ok.clicked.connect(self.onOk)

    def onOk(self, event):
        indexes = self.listView_names.selectedIndexes()
        self.selNames = []
        for index in indexes:
            name = index.data()
            self.selNames.append(name)
        self.close()

    def onCancel(self):
        self.selNames = []
        self.close()

if __name__ == "__main__":
    import gettext
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    # import sys
    # app = QtGui.QApplication(sys.argv)
    # Dialog = QtGui.QDialog()
    # ui = Ui_Dialog()
    # ui.setupUi(Dialog)
    # Dialog.show()
    # sys.exit(app.exec_())

