#!/usr/bin/python3
#  coding: utf-8
#
#   selectFolderFiles.py
#
#   10/03/11    新規作成
#   12/03/18    アイコンの読み込み場所変更
#   13/05/09    listBoxが拡張する様に修正。
#               polyMeshDirの取得を「getBoundaryDir」に変更
#      05/23    バグ修正（clearZeroGradientでregion無しの場合ｴﾗｰ発生）
#      05/25    clearInternal、clearBoundaryで複数regionの選択が可能
#      06/30    起動時にregion選択して起動もできる様に追加修正
#      09/28    gzip, binaryファイルの編集ができる様に修正
#      10/15    国際化のため、修正
#      12/21    stdout、stderrの設定（import logFileCreater）を追加
#   14/04/07    fileの編集方法を変更
#      11/09    ダブルクリックでdirectoryの移動やfileOpenができるように修正
#   15/07/13    gridEditor_dataの保存場所変更
#      07/17    dialogの起動方法を修正
#   20/01/04    GTK+3, python3用に大幅修正
#      04/22    多言語化対応
#      06/11    if __name__ == "__main__" 以下を追加
#      08/22    起動時、window位置をmouseに合わせる様修正。
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, Gdk, GdkPixbuf

import os, sys

try:
    import pyTreeFoam
    import GtkParts
except:
    import python.pyTreeFoam as pyTreeFoam
    import python.GtkParts as GtkParts

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

import logFileCreater
logFileCreater.log()


#--------------------
#  constantFiles class
#--------------------
class constantFiles:

    def __init__(self, caseDir, selFolder):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path+"selectFolderFilesDialog.glade")
        self.mainWindow = self.builder.get_object("window1")
        #window位置をmouseに合わせる
        self.mainWindow.set_position(2)
        self.mainWindow.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        #GUIのobject名を取得
        self.setGtkObject()
        #属性の設定
        self.caseDir = caseDir
        self.selFolder = selFolder      #currDir
        self.folders = []
        self.files = []
        #  iconの設定
        iconDir = os.getenv("TreeFoamPath") + "/icons"
        iconFile = GdkPixbuf.Pixbuf.new_from_file
        self.iconFolder = iconFile(iconDir + "/folder16.png")
        self.iconFile = iconFile(iconDir + "/text8.png")
        self.iconFolderLink = iconFile(iconDir + "/folderLink16.png")
        self.iconFileLink = iconFile(iconDir + "/textLink8.png")
        #GUIの初期化
        self.iniGui()
        #初期のfolder, filesを取得
        self.getFolders()
        #treeListを初期化
        self.iniTreeList()

    #
    #  main
    #------------
    def main(self):
        #treeFolderへdataセット
        self.setDataToTreeFolder()
        #treeFileへdataセット
        self.changeFolder()
        #GUI表示
        self.mainWindow.show()
        Gtk.main()
        return self.files

    def close(self, *args):
        self.mainWindow.destroy()
        Gtk.main_quit()

    def setGtkObject(self):
        """ GUIのobject名を取得"""
        self.img_title = self.builder.get_object("img_title")
        self.label_title = self.builder.get_object("label_title")
        self.label_subTitle = self.builder.get_object("label_subTitle")
        self.label_loc = self.builder.get_object("label_loc")
        self.tree_folder = self.builder.get_object("tree_folder")
        self.tree_file = self.builder.get_object("tree_file")
        self.check_selectAll = self.builder.get_object("check_selectAll")

    def iniGui(self):
        """ GUIの初期化"""
        self.mainWindow.set_title(_("constant(properties)の編集"))
        fileName = os.getenv("TreeFoamPath") + "/icons/editFields.png"
        self.img_title.set_from_file(fileName)
        title = _("編集する Properties file を選択してください。")
        self.label_title.set_text(title)
        subTitle = _("Properties File は、./constant フォルダ内にあります。")
        self.label_subTitle.set_text(subTitle)
        loc = _("場所: ") + "./constant"
        self.label_loc.set_text(loc)

    def iniTreeList(self):
        """ treeListを初期化する。"""
        #tree_folder側
        GtkParts.treeListIcon(self.tree_folder).create(multi=False)
        #tree_field側
        GtkParts.treeListIcon(self.tree_file).create()


    #-------- event handler ----------------
    def onOk(self, event):
        self.files = self.getSelectFiles()
        self.close()
    def onCancel(self, event):
        self.files = []
        self.close()
    def onChangeFolder(self, event):
        self.changeFolder()
    def onChangeSelectAll(self, event):
        self.changeSelectAll()
    def onPressMouseButton(self, widget, event):
        self.pressMouseButton(widget, event)
    #------------------------------------------

    #
    #  pressMouseButton
    #-------------------
    def pressMouseButton(self, widget, event):
        """ mouseButtonのevent"""
        pos = (event.x, event.y)
        #rightClick?
        if event.button == 3:
            pass
        #leftClick?
        elif event.button == 1:
            if event.type.value_name == "GDK_2BUTTON_PRESS":
                #doubleClickの場合
                self.doubleClickEvent(widget, pos)

    #
    #  doubleClickEvent
    #-------------------
    def doubleClickEvent(self, widget, pos):
        """ ダブルクリックのevent"""
        if widget == self.tree_file:
            self.files = self.getSelectFiles()
            self.close()

    def getFolders(self):
        """ folderを取得する"""
        selFolderDir = self.caseDir + "/" + self.selFolder
        self.folders = pyTreeFoam.getFolderNames(selFolderDir)
        self.folders.sort()

    #
    #  getSelectFiles
    #-----------------
    def getSelectFiles(self):
        """ 選択fileを取得"""
        if self.check_selectAll.get_active() == True:
            files = self.getAllItemsInTreeList(self.tree_file)
        else:
            files = self.getSelectItemsInTreeList(self.tree_file)
        selFolders = self.getSelectItemsInTreeList(self.tree_folder)
        if len(selFolders) == 0:
            return []
        selFolder = selFolders[0]
        if selFolder == _("(現在のfolder)"):
            selFolder = "."
        files = list(map(lambda x: selFolder + "/" + x, files))
        return files

    #
    #  getAllItemsInTreeList
    def getAllItemsInTreeList(self, treeList):
        tree = GtkParts.treeListIcon(treeList)
        items = tree.getAllItems()
        names = list(map(lambda x: x[1], items))
        return names

    #
    #  setDataToTreeFolder
    #---------------------
    def setDataToTreeFolder(self):
        """ treeFolderへfolder名をセットする"""
        items = []
        folders = self.folders[:]
        folderDir = self.caseDir + "/" + self.selFolder
        for folder in folders:
            icon = self.iconFolder
            if os.path.islink(folderDir + "/folder"):
                icon = self.iconFolderLink
            items.append([icon, folder])
        #currDirを追加
        icon = self.iconFolder
        if os.path.islink(folderDir):
            icon = self.iconFolderLink
        items = [[icon, _("(現在のfolder)")]] + items
        #親dirを追加
        icon = self.iconFolder
        if os.path.islink(folderDir + "/.."):
            icon = self.iconFolderLink
        items = [[icon, ".."]] + items
        self.setDataToTreeList(self.tree_folder, items)
        selNames = [_("(現在のfolder)")]
        GtkParts.treeListIcon(self.tree_folder).selectItemNames(selNames)

    #
    #  setDataToTreeList
    def setDataToTreeList(self, treeList, items):
        """ treeListへデータをセットする"""
        GtkParts.treeListIcon(treeList).setItems(items)

    #
    #  changeFolder
    #---------------
    def changeFolder(self):
        """ folder名を選択した時の処理"""
        selFolders = self.getSelectItemsInTreeList(self.tree_folder)
        if len(selFolders) == 0:
            return
        selFolder = selFolders[0]
        if selFolder == _("(現在のfolder)"):
            selFolder = "."
        folderDir = self.caseDir + "/" + self.selFolder + "/" + selFolder
        files = pyTreeFoam.getFileNames(folderDir)
        files = self.getNeedFiles(files)
        files.sort()
        items = []
        for fileName in files:
            icon = self.iconFile
            if os.path.islink(folderDir + "/" + fileName):
                icon = self.iconFileLink
            items.append([icon, fileName])
        self.setDataToTreeList(self.tree_file, items)

    def getNeedFiles(self, files):
        newFiles = []
        for file in files:
            if (file[0] == "~" or file[0] == "." or file[-1] == "~" or
                file.split(".")[-1] == "bak"):
                pass
            else:
                newFiles.append(file)
        return newFiles

    #
    #  getSelectItemsInTreeList
    def getSelectItemsInTreeList(self, treeList):
        """ treeList内から選択項目を取得する"""
        tree = GtkParts.treeListIcon(treeList)
        items = tree.getSelectedItems()
        names = list(map(lambda x: x[1], items))
        return names
        # selection = treeList.get_selection()
        # treeStore, pathes = selection.get_selected_rows()
        # selItems = []
        # for path in pathes:
        #     selItem = treeStore[path][0]
        #     selItems.append(selItem)
        # return selItems

    #
    #  changeSelectAll
    #------------------
    def changeSelectAll(self):
        if self.check_selectAll.get_active() == True:
            self.tree_file.set_sensitive(False)
            selection = self.tree_file.get_selection()
            selection.unselect_all()
        else:
            self.tree_file.set_sensitive(True)
            selection = self.tree_file.get_selection()
            selection.select_all()


#--------------------
#  systemFiles class
#--------------------
class systemFiles(constantFiles):

    def iniGui(self):
        """ GUIの初期化"""
        self.mainWindow.set_title(_("system(dictionary)の編集"))
        fileName = os.getenv("TreeFoamPath") + "/icons/editFields.png"
        self.img_title.set_from_file(fileName)
        title = _("編集する Dictionary file を選択してください。")
        self.label_title.set_text(title)
        subTitle = _("Dictionary File は、./system フォルダ内にあります。")
        self.label_subTitle.set_text(subTitle)
        loc = _("場所: ") + "./system"
        self.label_loc.set_text(loc)


#---------------------------
#  clearInternalField class
#---------------------------
class clearInternalField(constantFiles):

    def iniGui(self):
        """ GUIの初期化"""
        self.mainWindow.set_title(_("internalFieldのクリア"))
        imgFile = os.getenv("TreeFoamPath") + "/icons/editFields.png"
        self.img_title.set_from_file(imgFile)
        title = _("選択された InternalField をクリアします。")
        self.label_title.set_text(title)
        #subTitle = _("Dictionary File は、./system フォルダ内にあります。")
        subTitle = _("list → uniformに変更します。") + "\n"
        subTitle += _("元々internalFieldがuniform形式なら、変更せずそのまま。")
        self.label_subTitle.set_text(subTitle)
        loc = _("場所: ") + "./" + self.selFolder
        self.label_loc.set_text(loc)


#---------------------------
#  clearBoundaryField class
#---------------------------
class clearBoundaryField(constantFiles):

    def iniGui(self):
        """ GUIの初期化"""
        self.mainWindow.set_title(_("boundaryFieldのクリア"))
        imgFile = os.getenv("TreeFoamPath") + "/icons/editFields.png"
        self.img_title.set_from_file(imgFile)
        title = _("選択された BoundaryField をクリアします。") + "\n"
        title += _("  boundaryとboundaryField間の整合性をとる。")
        self.label_title.set_text(title)
        #subTitle = _("Dictionary File は、./system フォルダ内にあります。")
        #subTitle = _("boundary内の空patchを削除する。") + "\n"
        subTitle = _("boundaryField内に追加されるpatchは") + "\n"
        subTitle += _("  zeroGradient, empty, symmetry, cyclic 等に設定される。")
        self.label_subTitle.set_text(subTitle)
        loc = _("場所: ") + "./" + self.selFolder
        self.label_loc.set_text(loc)


if __name__ == "__main__":
    import gettext
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    #変数の取り込み
    job =       sys.argv[1]
    caseDir =   sys.argv[2]
    selFolder = sys.argv[3]     #folder名のみ

    import pyTreeFoam

    if job == "editProperties":
        names = constantFiles(caseDir, selFolder).main()
        if len(names) > 0:
            names.sort()
            fileDir = caseDir + "/constant/"
            files = list(map(lambda x: fileDir + x, names))
            pyTreeFoam.run(caseDir).foamEditor(files)
    elif job == "editDictFile":
        names = systemFiles(caseDir, selFolder).main()
        if len(names) > 0:
            names.sort()
            fileDir = caseDir + "/system/"
            files = list(map(lambda x: fileDir + x, names))
            pyTreeFoam.run(caseDir).foamEditor(files)
    elif job == "clearBoundary":
        currTime = selFolder
        selFields = clearBoundaryField(caseDir, currTime).main()
        if len(selFields) > 0:
            region = selFields[0].split("/")[0]
            fields = list(map(lambda x: x.split("/")[-1], selFields))
            relMeshDir = pyTreeFoam.case(caseDir).getCurrMeshDir(currTime, region, "boundary")
            meshDir = caseDir + "/" + relMeshDir
            pyTreeFoam.case(caseDir).clearNullBoundaryFields(currTime, meshDir, fields, region)
            mess = _("選択したfieldのboundaryFieldをクリアしました。")
            print(mess)
    elif job == "clearInternal":
        currTime = selFolder
        selFields = clearInternalField(caseDir, currTime).main()
        if len(selFields) > 0:
            region = selFields[0].split("/")[0]
            fields = list(map(lambda x: x.split("/")[-1], selFields))
            fieldDir = caseDir + "/" + currTime + "/" + region
            pyTreeFoam.case(caseDir).clearInternalFields(fieldDir, fields)
            mess = _("選択したfieldのinternalFieldをクリアしました。")
            print(mess)
