#!/usr/bin/python3
#  coding:  utf-8
#
#           selectEditStructureCaseDDialog.py
#
#       EasyISTRが編集するcaseを取得する
#
#   23/04/20    新規作成
#      11/29    起動時の引数にanaItemを追加。
#   24/01/26    initialize:非active状態の項目が選択できる状態だった
#               為、修正。
#      08/09    funcOk,funcCancel,parentを追加
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import os, sys

#--------------------------------
#  selectEditStructureCase class
#--------------------------------
class selectEditStructureCase:
    """ EasyISTRで編集するcaseを選択する。
    
    Args:
        cases(list(str))    :選択できるcase
        anaItem             :loadする解析項目(fsi,cht or chtss)
    Returns:
        selCase(str)        :選択したcase"""
    
    def __init__(self, cases, anaItem, funcOk=[], funcCancel=[], parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "selectEditStructureCaseDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        #親windowを設定
        self.dialog.set_transient_for(parent)
        #modal(freeze)の設定
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.cases = cases
        self.stat = ""
        self.anaItem = anaItem
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        #初期化
        self.initialize()

    #
    #  show
    #-------
    def show(self):
        """ dialogの表示"""
        self.dialog.show()
        # self.dialog.run()
        # return self.stat

    #
    #  close
    #--------
    def close(self, *args):
        self.dialog.destroy()

    #-------- event handler -----------
    def onOk(self, event):
        selCase = self.getSelCase()
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(selCase, *args)
            GLib.timeout_add(100, funcName, selCase, *args)

    def onCancel(self, event):
        #self.stat = ""
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)
    #-----------------------------------

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        self.radio_fsi = self.builder.get_object("radio_fsi")
        self.radio_cht = self.builder.get_object("radio_cht")
        self.radio_chtss = self.builder.get_object("radio_chtss")

    #
    #  initialize
    #--------------
    def initialize(self):
        """ 初期化"""
        showItems = []
        self.radio_fsi.set_sensitive(False)
        self.radio_cht.set_sensitive(False)
        self.radio_chtss.set_sensitive(False)
        if "fsi" in self.cases:
            self.radio_fsi.set_sensitive(True)
            showItems.append("fsi")
        if "cht" in self.cases:
            self.radio_cht.set_sensitive(True)
            showItems.append("cht")
        if "chtss" in self.cases:
            self.radio_chtss.set_sensitive(True)
            showItems.append("chtss")
        if self.anaItem in showItems:
            self.setSelCase(self.anaItem)
        else:
            self.anaItem = showItems[0]
            self.setSelCase(self.anaItem)

    #
    #  setSelCase
    #-------------
    def setSelCase(self, case):
        """ caseを選択表示する"""
        if case == "fsi":
            self.radio_fsi.set_active(True)
        elif case == "cht":
            self.radio_cht.set_active(True)
        elif case == "chtss":
            self.radio_chtss.set_active(True)

    #
    #  getSelCase
    #-------------
    def getSelCase(self):
        """ 選択caseを取得する"""
        selCase = ""
        if self.radio_fsi.get_active() == True:
            selCase = "fsi"
        elif self.radio_cht.get_active() == True:
            selCase = "cht"
        elif self.radio_chtss.get_active() == True:
            selCase = "chtss"
        return selCase
    