#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   saveGoQtDialog.py
#
#       save, go, save&go の3個のボタンを持つdialog
#
#   20/04/22    多言語化対応
#      05/02    PyQt4, PyQt5, PySide, PySide2に対応
#      05/24    PyQtの取得方法を修正（一元化）
#   24/08/23    setCenterParentPosition:新規追加
#               (dialogの表示位置をparentの中心に表示)
#      08/28    Qt4系、Qt6系の両方に対応する様に修正
#

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()


import sys
import os


def _fromUtf8(s):
    return s

try:
    _encoding = QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig)


#-------------------
#  Ui_Dialog class
#-------------------
class Ui_Dialog(object):
    
    def __init__(self, title, message, buttonNames, parent):
        self.title = title
        self.message = message
        self.buttonNames = buttonNames
        self.parent = parent
        self.pushButton = ""
        #self.Dialog = QtGui.QDialog()
        self.Dialog = QDialog()

    def main(self):
        Dialog = self.Dialog
        self.setupUi(Dialog)
        self.setEvent()
        self.label_cont.setText(self.message)
        Dialog.setWindowTitle(self.title)
        self.btn_cancel.setText(self.buttonNames[0])
        self.btn_go.setText(self.buttonNames[1])
        self.btn_saveGo.setText(self.buttonNames[2])
        #dialogをparentの中心に表示させる
        self.setCenterParentPosition()
        Dialog.exec()

    def close(self):
        #QtGui.qApp.quit()
        self.Dialog.close()

    def setCenterParentPosition(self):
        """ dialogの位置を親の中心に設定する。
        widgetのレイアウト設定後に実行する"""
        #parentの中心位置
        geo = self.parent.geometry()
        xy = (geo.left() + geo.width()//2, geo.top() + geo.height()//2)
        pos = QPoint(xy[0], xy[1])
        #設定位置を取得
        geo = self.Dialog.geometry()
        geoP = QPoint(geo.width()//2, geo.height()//2)
        newPos = pos - geoP
        self.Dialog.move(newPos)

    def setupUi(self, Dialog):
        """ Qtのversionに応じたGUIを設定"""
        if getPyQtModule.UiCode == "Qt4":
            self.setupUi_Qt4(Dialog)
        elif getPyQtModule.UiCode == "Qt6":
            self.setupUi_Qt6(Dialog)

    def setupUi_Qt6(self, Dialog):
        """ Qt6系のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(400, 94)
        self.verticalLayout = QVBoxLayout(Dialog)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        self.label_cont = QLabel(Dialog)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_cont.sizePolicy().hasHeightForWidth())
        self.label_cont.setSizePolicy(sizePolicy)
        self.label_cont.setObjectName(_fromUtf8("label_cont"))
        self.verticalLayout.addWidget(self.label_cont)
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## spacerItem = QSpacerItem(78, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        spacerItem = QSpacerItem(78, 20, QSizePolicy.Policy.Expanding, QSizePolicy.Policy.Minimum)
        self.horizontalLayout.addItem(spacerItem)
        self.btn_cancel = QPushButton(Dialog)
        self.btn_cancel.setObjectName(_fromUtf8("btn_cancel"))
        self.horizontalLayout.addWidget(self.btn_cancel)
        self.btn_go = QPushButton(Dialog)
        self.btn_go.setObjectName(_fromUtf8("btn_go"))
        self.horizontalLayout.addWidget(self.btn_go)
        self.btn_saveGo = QPushButton(Dialog)
        self.btn_saveGo.setObjectName(_fromUtf8("btn_saveGo"))
        self.horizontalLayout.addWidget(self.btn_saveGo)
        self.verticalLayout.addLayout(self.horizontalLayout)

        self.retranslateUi(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def setupUi_Qt4(self, Dialog):
        """ Qt4系のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(400, 94)
        ## self.verticalLayout = QtGui.QVBoxLayout(Dialog)
        self.verticalLayout = QVBoxLayout(Dialog)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        ## self.label_cont = QtGui.QLabel(Dialog)
        self.label_cont = QLabel(Dialog)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_cont.sizePolicy().hasHeightForWidth())
        self.label_cont.setSizePolicy(sizePolicy)
        self.label_cont.setObjectName(_fromUtf8("label_cont"))
        self.verticalLayout.addWidget(self.label_cont)
        ## self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## spacerItem = QtGui.QSpacerItem(78, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        spacerItem = QSpacerItem(78, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout.addItem(spacerItem)
        ## self.btn_cancel = QtGui.QPushButton(Dialog)
        self.btn_cancel = QPushButton(Dialog)
        self.btn_cancel.setObjectName(_fromUtf8("btn_cancel"))
        self.horizontalLayout.addWidget(self.btn_cancel)
        ## self.btn_go = QtGui.QPushButton(Dialog)
        self.btn_go = QPushButton(Dialog)
        self.btn_go.setObjectName(_fromUtf8("btn_go"))
        self.horizontalLayout.addWidget(self.btn_go)
        ## self.btn_saveGo = QtGui.QPushButton(Dialog)
        self.btn_saveGo = QPushButton(Dialog)
        ## self.btn_saveGo.setLayoutDirection(Qt.LeftToRight)
        self.btn_saveGo.setObjectName(_fromUtf8("btn_saveGo"))
        self.horizontalLayout.addWidget(self.btn_saveGo)
        self.verticalLayout.addLayout(self.horizontalLayout)

        self.retranslateUi(Dialog)
        QMetaObject.connectSlotsByName(Dialog)

    def retranslateUi(self, Dialog):
        Dialog.setWindowTitle(_translate("Dialog", "Dialog", None))
        self.label_cont.setText(_translate("Dialog", "TextLabel", None))
        self.btn_cancel.setText(_translate("Dialog", _("キャンセル"), None))
        self.btn_go.setText(_translate("Dialog", _("このまま続行"), None))
        self.btn_saveGo.setText(_translate("Dialog", _("保存して続行"), None))

    def setEvent(self):
        self.btn_cancel.clicked.connect(self.onCancel)
        self.btn_go.clicked.connect(self.onGo)
        self.btn_saveGo.clicked.connect(self.onSaveGo)

    def onCancel(self):
        self.pushButton = "CANCEL"
        self.close()

    def onGo(self):
        self.pushButton = "GO"
        self.close()

    def onSaveGo(self):
        self.pushButton = "SAVE"
        self.close()


# def cancelSaveGo(title, mess, buttonNames):
#     #app = QtGui.QApplication(sys.argv)
#     Dialog = QtGui.QDialog()
#     ui = Ui_Dialog(title, mess, buttonNames)
#     #ui.setupUi(Dialog)
#     ui.main()
#     Dialog.show()
#     #sys.exit(app.exec())
#     Dialog.exec()
#     #app.exec_()
#     button = ui.pushButton
#     return button


if __name__ == "__main__":
    import gettext
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    title = _("setFieldsDict作成")
    mess = _("cell内容が変更されています。") + "\n"
    mess += _("  このまま処理を継続すると、変更内容が失われます。")
    buttonNames = [_("キャンセル"), _("このまま続行"), _("保存して続行")]
    #button = cancelSaveGo(title, mess, buttonNames)
    # import sys
    # app = QtGui.QApplication(sys.argv)
    # Dialog = QtGui.QDialog()
    # ui = Ui_Dialog()
    # ui.setupUi(Dialog)
    # Dialog.show()
    # sys.exit(app.exec_())

