#!/usr/bin/python3
# coding: utf-8
#
#   openFoamEditor.py
#
#       foamEditorでfieldをopenする。
#       openGridEditorDialogのclassを流用
#
#   20/01/03    新規作成
#      04/22    多言語化対応
#

import sys
import os

import pyTreeFoam
import openGridEditorDialog
import GtkParts

openGridEditor = openGridEditorDialog.windowApp

#------------------------
#  openFoamEditor class
#------------------------
class openFoamEditor(openGridEditor):

    def __init__(self, nTreeFoam, caseDir):
        openGridEditor.__init__(self, nTreeFoam, caseDir)

    def iniGui(self):
        """ GUIの初期化"""
        self.mainWindow.set_title(_("fieldを開く"))
        cont = _("選択した field をテキストエディタ(foamEditor)で開く") + "\n"
        cont += _("  ascii, binary, compressが編集可能") + "\n"
        cont += _("  data部は20行までに省略して読み込み")
        self.label_titleCont.set_text(cont)
        fileName = os.getenv("TreeFoamPath") + "/icons/editFields.png"
        self.imgIcon.set_from_file(fileName)

    def runApp(self):
        #foamEditor起動
        self.caseDir = self.entry_caseDir.get_text()
        selFolder = self.getFolderFromTreeFolder()
        caseDir = self.caseDir
        currTime = self.getTimeFolderFromCombo()
        if self.check_allFields.get_active() == True:
            selItems = pyTreeFoam.case(self.caseDir).getFieldNames(currTime, selFolder)
        else:
            treeList = GtkParts.treeListIcon(self.tree_field)
            selItems = treeList.getSelectedItems()
            selItems = list(map(lambda x: x[1], selItems))
        fieldDir = "/".join([caseDir, currTime, selFolder])
        files = []
        selItems.sort()
        for selItem in selItems:
            field = fieldDir + "/" + selItem
            files.append(field)
        pyTreeFoam.run(caseDir).foamEditor(files)
        # #自身を閉じる
        # self.close()


if __name__ == "__main__":
    import gettext
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    nTreeFoam = sys.argv[1]
    caseDir = sys.argv[2]
    winApp = openFoamEditor(nTreeFoam, caseDir)
    winApp.main()
    