#!/usr/bin/python3
#  coding: utf-8
#
#   12/01/03    patchの削除を可能にした。
#      01/08    patch名の修正を可能にした
#      01/17    patch削除時ﾊﾞｸﾞ修正（最後のcellにｺﾞﾐが残る）
#      02/05    windowClose時の終了処理追加
#      02/11    patch名変更、削除時にglobal変数を設定する様に変更（ﾊﾞｸﾞ修正）
#      02/18    ﾒﾆｭｰkeyとｼｮｰﾄｶｯﾄkey追加
#      02/19    読み込み時にｹﾞｰｼﾞ追加
#      02/25    gridEditorｺﾏﾝﾄﾞに対応できる様、cellDataの読込みをtimerEventで実施
#      02/26    終了時にwindowSizeを保存
#      03/10    iconNameを変数に修正
#      03/25    openメニュー追加
#      04/01    save時にもｹﾞｰｼﾞを追加
#      04/22    field非表示、表示順の設定追加
#      04/23    field保存時にｴﾗｰ表示追加
#      05/11    fieldCopy時に_copy0～_copy9まで可能な様に修正
#      05/25    ｱｲｺﾝの定義を相対pathに変更。
#      06/24    field削除をゴミ箱へ移動に変更。
#      08/04    cell内容変更して終了する時、保存確認するよう変更
#      08/05    最大cell内行数を変更
#      08/11    patch名変更・削除時にcell修正チェック追加
#      08/14    field名表示のバグ修正（field削除時、表示のみ削除できず）
#      08/16    cell(0,0),(1,0)のクリア追加
#      08/21    field全表示で隠しファイルが表示されていたので修正。
#      08/25    「全field表示」を「全表示/非表示の切替え」に変更。
#      09/12    表示変更関連（reload）時に保存確認を追加
#      09/22    reload時のcreateMatrix方法修正（ﾊﾞｸﾞ）
#      11/05    領域分割したとき、gridEditor開かずを修正（ﾊﾞｸﾞ）
#               空patch追加,空白cell,internalFieldの処理追加
#   13/01/11    patch名をpatchTypeと同じ名前にrenameするとｴﾗｰ発生を修正
#      01/28    nRunningGridの場所を「/data」に変更
#      02/11    zeroGradient, fixedValueについてfontColourを設定
#      02/17    editor起動中はﾌｫﾝﾄ色をﾘｾｯﾄ
#      03/03    boundary内容取得ﾊﾞｸﾞ修正（patch名を含んだ時、正しく表示できず）
#      03/10    getDefinePatchDataを修正
#      03/11    font色をsystemFont色（#4c4c4c:グレー）に設定
#      03/12    ﾊﾞｸﾞ修正（fieldが無かった場合、ｴﾗｰ発生）
#      03/23    clearZeroGradient, clearUniformのアイコン追加
#      04/20    polyMesh（boundary）の場所をgridに表示
#      05/22    patch名をsortして表示。表示切り替えpopupメニュー追加
#      05/25    saveCSVの時、表示するdialogをinputTextDialogに変更
#      06/09    definePatchData読み込み時、「\n;」→「;」に修正
#      06/10    cell内に{}がある場合、ｲﾝﾃﾞﾝﾄを付けた
#      06/26    labelのダブルclick時の操作を追加（editorで開く、patch名変更）
#               toolTip表示追加
#      07/06    cell内の表示行数が変更できる様にメニューに追加
#               cellCopy時、「***...」は、pasteしない様修正。逆は可能。
#      08/11    patch名sort時、saveFlagのチェックを追加
#      08/14    patch名sortをinternalField行にもメニューを追加
#      09/07    圧縮file(gzip)に対応
#      09/13    書込みの高速化（getMiddlePairMemFを使用）
#               cellEditorのバグ修正（2回目の編集ができない）
#      09/15    binaryFileへ対応
#      09/18    表示行数、nonuniform読込データ数変更dialog追加
#      09/25    getStartFaceNoAtNullPatch:取得方法変更(binMeshの場合ｴﾗｰ発生)
#      10/03    internalFieldのクリア:cellを選択後実行する様に修正
#      10/05    deletePatch時、空patchかどうか確認する様修正
#      10/12    多言語化のため修正
#      12/10    copy&paste時のclipBoardをsystemのclipBoardに変更
#      12/21    stdout、stderrの設定（import logFileCreater）を追加
#   14/02/08    patchデータ内にnull行があるとエラー発生を修正
#      03/18    setMatrixData:「;」のみの行があると表示されないｴﾗｰを修正
#      05/11    boundaryFieldの#includeとboundary内のinGroupsを追加
#      06/04    「全ての空patch削除」ﾒﾆｭｰを追加
#      08/03    getDefinePatchData:boundaryが存在しない場合ｴﾗｰ発生を修正
#      08/10    getDimensionInternalFieldData:変数名を追加
#      08/23    onSave:変数名の保存を追加
#               変数定義行の表示・非表示切り替えを追加
#      08/25    setFontColour:バグ修正
#      09/21    addNullPatches:同時に複数行の追加ができる様に修正。
#      09/23    reformInternalFieldCellData:internalFieldが1行のみの時、表示変
#      09/27    runCellEditor:変数行があると保存する行が狂う。
#               setEditCellBoundaryFieldData:保存時、wildCardPatchが有るとエラー
#      10/06    replaceOtherNames:変数を保存する場所を修正
#      10/25    labelクリック時、gridCursorをセット
#      10/26    getDimensionInternalFieldData:階層型変数名「$:」に対応
#      11/10    getInternalFieldRowFromGrid:patch名をsortさせた時、internalFieldの
#               rowNoが取得できず
#   15/02/24　  replaceOtherNames:バグ修正（変数挿入時pointerがずれていた）
#               replaceVariables:deleteOver2NullLinesを追加して余分な行を削除
#      02/28    replaceOtherNames:バグ修正（変数挿入時pointerがずれていた。再修正）
#      06/25    wxPython-2.8→3.0に伴い修正。
#               CreateGrid文は、2回記述できないので、1ヶをコメントアウト
#      06/26    createMatrixでcellEditorのセットをwxのversionで変更
#      06/27    labelのtoolTip出力を修正（wxのバージョンアップにより）
#      07/05    起動をimportからコマンド実行に変更。これにより、parameterの受け取り
#               方法を修正。「import gio」を削除。これにより、fieldの削除をゴミ箱
#               から削除に変更。
#               上記2点は、GridCellAutoWrapStringEditorと共存させるとsegmentation 
#               faultが発生する為。
#      07/10    loadFromGaugeDialog:loadを修正（gauge内を修正）
#      07/13    clipBoardの場所をTreeFoam/dataに変更
#      09/13    バグ修正。getAbsPath:環境変数の取得に$xxxを追加。
#                        getDimensionInternalFieldData:ポインタのズレ修正。
#      09/02    onNullCellZeroGrad:空白cellをzeroGradientで埋める時、emptyと
#               symmetry等を考慮する様に修正。
#               cell内容をクリア（空白cell作成）を追加。
#      10/07   「#includeEtc」を追加
#      11/02    バグ修正（popupMenuのcellコピー、cell貼付が機能しない）。
#   16/08/28    windowsサイズ設定を修正
#   18/09/23    getAbsPath:#includeのpath指定「<constant>」に対応
#      09/27    getAbsPath:#includeのpath指定「<system>」に対応
#   19/02/01    windowsサイズ設定を修正(wx.vrsion()のgtkVerを追加）
#   19/09/12    onOpen:openGridEditorDialogをos.systemで起動するように修正
#               moduleで起動すると突然落ちる為。
#   20/02/08    Qt4、python3用に大幅修正
#      04/21    多言語化対応
#      04/29    line2lines:バグ修正（patch名が消える場合あり）
#      05/02    PyQt4, PyQt5, PySide, PySide2に対応
#      05/19    patchViewerを追加
#      05/24    PyQtの確認方法を修正（一元化）
#      05/26    patchViewerにbuttonを追加
#      05/27    XYZ軸視のバグ修正
#      05/30    patchViewerにcloseボタンを追加
#      06/02    saveGridEditor:保存時にinclude行を削除する様に修正
#               include行が残ると、変数行が削除できない状態になる為。
#      06/03    remakePatchTypeLevelVariable:$:xxx.xxの解釈時、
#               「$:xxx.xx ;」の様に空白が入る場合があり、これに対応
#               OF-7.0からchangeDictionary実行時、空白が入る事がある。
#      06/12    freeCadから起動すると動かないので、修正。
#               freeCADがpythonの標準出力を書き換えているため？
#               (freeCAD起動時に環境変数SVGA_VGPU10=0を設定している為)
#      07/06    patchViewerにicon(rightToLeft, rolling90)を追加
#               setXaxis, setYaxis, setZaxis:camera位置を修正
#      08/10    selectedPatchs, clearUniform, getStRowFromGrid:
#               rowLabelの取得をgetRowLabelValueに変更。
#      10/29    load classを「readBoundaryAndFields」moduleに移動。
#   21/06/12    reloadVtk:新規追加。gridEditor上でpatch名変更した場合、
#               再読込しないと表示できない為。
#      08/27    reformBoundaryFieldCellData:getKeyWordで取得する
#               ポインタpを1ヶ進めてwordを取得。
#               「...」で終わる値を取得する時、文字数が1文字少なく
#               取得する為。
#   22/01/01    reloadVtk:vtk-9.3対応で大幅修正。
#      01/02    showVtk, reloadVtk:vtk起動前に選択cellのpatchを取得し
#               該当patchを選択表示してvtkを起動させる様に修正。 
#      01/04    gridEditor.__init__:self.Table.setMouseTracking(True)
#               を追加。Table内でmouseが動いた場合、Tableにfocusさせる為。
#      09/01    replacePatchData,reformBoundaryFieldCellData:
#               codedFixedValueの様にascii部が長くなる場合、正しく表示
#               できなかった事を修正
#      09/03    editCellEditor:編集有無を返す様に修正
#               runCellEditor:cell内容の編集有無を確認し、
#               編集した場合は、内容を修正する様に修正。
#      09/04    replacePatchData:cellに「...」があれば置き換え、無ければ
#               置き換えない様に修正。
#               runCellEditor:cellEditorの起動をthreadに変更
#   23/10/17    showVtk:meshが存在しない時、patchViewerを表示させると
#               エラー発生するため、修正。
#   24/04/06    getPatchContsFromGrid:余計な"\n"があった時エラー発生する為、修正。
#               tableEditorClose:cellEditorのclose後、そのtextを整形して
#               保存するように修正。余計な" ","\n"を削除する。
#      08/23    __init__:windowの位置をmousePointerに合わせる様修正。
#               editBoundary:wondowの中心位置の算出を追加
#               checkSaveFlag,checkSaveReload:wondowの中心位置の算出を追加
#               renameField,saveCsv,renamePatch:wondowの中心位置の算出を追加
#               getMaxLinesDialog:wondowの中心位置の算出を追加
#               fieldsHideShowDialog:wondowの中心位置の算出を追加
#      08/27    Qt4系とQt6系に対応するように修正。
#      08/28    changeOrder:CANCEL時は、直ぐに戻る様に修正
#      10/20    selectedPatchs:vtk画面でpatch選択した時、tableWidget側の
#               currentCellの設定を追加（self.Table.CurrRowCol=selCells[-1]を追加）
#

import sys
import os

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule
#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()
print("  imported " + PyQtModule)

import QtVar

#uiCodeの設定
if getPyQtModule.UiCode == "Qt4":
    import gridEditorQt4 as gridEditorQt    #Qt4系用のuiCode
elif getPyQtModule.UiCode == "Qt6":
    import gridEditorQt6 as gridEditorQt    #QT6系用のuiCode

#vtkのチェック
VtkFlag = None
try:
    import QtVtk
    VtkFlag = QtVtk.VtkFlag
except:
    VtkFlag = None

import glob
import subprocess
import time
import shutil
import threading

import pyTreeFoam
import progressBar
import QtParts
import saveGoQtDialog
import inputTextQtDialog
import openFieldsForGridEditorQtDDialog
import getMaxLinesDataQtDDialog
import copyPasteTextQt
import readBoundaryAndFields
import setBCInPatchViewerQtDDialog

if VtkFlag == None:
    print("error: could not import vtk !")

app = ""

#fontName = "ubuntu mono"
#fontName = "Monospace"          #gridEditorで使用するfont名
                                #存在しない場合は、defaultFontを使用

#--------------------
#  gridEditor class
#--------------------
class gridEditor(gridEditorQt.Ui_MainWindow):
    """ gridEditorのメインclass。gridEditorQt.Ui_MainWindowクラスを継承する。

    Argss:
        nTreeFoam (str) : 起動したTreeFoamNo
        caseDir (str)   : case directory
        timeFolder (str): time folder
        region (str)    : region
    """

    def __init__(self, nTreeFoam, caseDir, timeFolder, region):
        #属性の設定
        self.nTreeFoam = nTreeFoam          #TreeFoamNo
        self.caseDir = caseDir
        self.timeFolder = timeFolder
        self.region = region
        self.maxRowsInCellInternal = 5      #internalFieldCellの最大行数
        self.maxRowsInCell = 15             #gridEditorのcellの最大cell内行数
        self.nMaxLinesBinToAscii = 100      #dataを取得する行数
        self.isVariable = False             #全体変数行の表示flag
        self.isVariableBoundary = False     #boundary変数業の表示flag
        self.sortPatchName = "no"           #patchNameのsortのflag
        self.lenRowLabeName = 10            #rowlabel名の最大文字数
        self.clipBoard = os.getenv("TreeFoamUserPath") + "/data/clipBoard"
        self.nRunningGrid = os.getenv("TreeFoamUserPath") + "/data/nRunningGrid"
        self.noEditCell = [-1, -1, ""]      #edit禁止cell
        self.maskEvent = "no"               #eventのmask用
        self.windowTitle = ""               #windowTitle名
        #window関連（独自TableWidgetに変更する）
        #self.MainWindow = QtGui.QMainWindow()       #新たに定義
        self.MainWindow = QMainWindow()       #新たに定義
        self.Table = QtParts.Table()          #独自TableWidget
        self.Table.setMouseTracking(True)     #mouseMoveEventを有効ににする為
        self.setupUi(self.MainWindow, self.Table)   #GUIを作成
        #fontの設定（Monospace）
        #font = QFont()
        #font.setFamily(fontName)
        #self.MainWindow.setFont(font)
        #menuBarにshortCutの作成
        self.actionCopy_2.setShortcut('Ctrl+C')     #copy
        self.actionPaste_2.setShortcut('Ctrl+V')    #paste
        self.actionSave_2.setShortcut("Ctrl+S")     #save
        self.actionClose_2.setShortcut("Ctrl+Q")    #close
        #menuBarにiconの設定
        self.actionOpen_2.setIconVisibleInMenu(True)    #open
        self.actionSave_2.setIconVisibleInMenu(True)
        self.actionCSV_2.setIconVisibleInMenu(True)
        self.actionReload_2.setIconVisibleInMenu(True)
        self.actionClose_2.setIconVisibleInMenu(True)
        self.actionCopy_2.setIconVisibleInMenu(True)
        self.actionPaste_2.setIconVisibleInMenu(True)
        #eventを作成
        self.createEvent()
        #iconの設定(popupMenuで使用)
        iconDir = os.getenv("TreeFoamPath") + "/icons"
        self.iconCopy = self.createIconFromPixmap(iconDir + "/copy.png")
        self.iconPaste = self.createIconFromPixmap(iconDir + "/paste.png")
        self.iconClearUniform = self.createIconFromPixmap(iconDir + "/clearUniform.png")
        self.iconClearZeroGrad = self.createIconFromPixmap(iconDir + "/clearZeroGradient.png")
        #windowの位置ををmousePointerに合わせる
        self.setMousePosition()
        #toolTipを設定
        self.setToolTip()
        #splitterの左側（vtk）を非表示設定
        self.frame.setVisible(False)
        self.vtkMaskEvent = "yes"
        self.patchMesh = ""

    #
    #  main
    #-----------
    def main(self):
        self.initialize()               #初期化（gridEditor_data読み込み）
        self.loadData()                 #fieldデータ取得
        self.createMatrix()             #gridTableのrow,colのLabelをセット
        self.setMatrixData()            #cellにデータをセット
        self.initializeGrid()           #title, widowSizeをセット
        self.MainWindow.show()

    #
    #  close
    #-----------
    def close(self):
        """ GUIを閉じる"""
        global app
        app.quit()

    #  setMousePosition
    def setMousePosition(self):
        """ windowの中心位置をmouseに合わせる"""
        #windowの中心位置
        geo = self.MainWindow.geometry()
        xy = (geo.left() + geo.width()//2, geo.top() + geo.height()//2)
        pos = QPoint(xy[0], xy[1])
        #mousePosition
        mPos = QCursor.pos()
        #設定値を取得
        newPos = mPos - pos
        self.MainWindow.move(newPos)

    #
    #  createIconFromPixmap
    def createIconFromPixmap(self, iconFile):
        """ Qt4系とQt6系に分けてiconを作成する"""
        icon = QIcon()
        icon.addPixmap(QPixmap(iconFile), mode=QtVar.Normal, state=QtVar.Off)
        return icon

    #
    #  createEvent
    #---------------
    def createEvent(self):
        """ eventを作成"""
        #-------- menuBar, toolBarのevent
        self.actionOpen.triggered.connect(self.onOpen)
        self.actionSave.triggered.connect(self.onSave)
        self.actionCSV.triggered.connect(self.onSaveCsv)
        self.actionReload.triggered.connect(self.onReload)
        self.actionClose.triggered.connect(self.onClose)
        self.actionCopy.triggered.connect(self.onCopy)
        self.actionPaste.triggered.connect(self.onPaste)
        self.actionClearZeroGrad.triggered.connect(self.onClearZeroGrad)
        self.actionClearUniform.triggered.connect(self.onClearUniform)
        self.actionShowVtk.triggered.connect(self.onShowVtk)
        self.actionOpen_2.triggered.connect(self.onOpen)
        self.actionSave_2.triggered.connect(self.onSave)
        self.actionCSV_2.triggered.connect(self.onSaveCsv)
        self.actionReload_2.triggered.connect(self.onReload)
        self.actionClose_2.triggered.connect(self.onClose)
        self.actionRenamePatch.triggered.connect(self.onRenamePatch)
        self.actionDeletePatch.triggered.connect(self.onDeletePatch)
        self.actionCopy_2.triggered.connect(self.onCopy)
        self.actionPaste_2.triggered.connect(self.onPaste)
        self.actionEditor.triggered.connect(self.onEditor)
        self.actionChangeView.triggered.connect(self.onSwitchAllorHideFields)
        self.actionHideFields.triggered.connect(self.onHideFields)
        self.actionChangeOrder.triggered.connect(self.onChangeOrder)
        self.actionChangeViewLines.triggered.connect(self.onChangeMaxLines)

        #scroll, windowのresizeのevent（cellSizeをadjustさせる）
        # self.tableWidget.horizontalScrollBar().valueChanged.connect(self.onAdjustCellSize)
        # self.tableWidget.verticalScrollBar().valueChanged.connect(self.onAdjustCellSize)
        # self.MainWindow.resizeSignal.connect(self.onAdjustCellSize)

        #cell内容が変更された時のevent
        self.tableWidget.itemChanged.connect(self.onTableItemChanged)
        #largeTextSignal(外部editorを起動)
        self.Table.largeTextSignal.connect(self.onEditor)
        #currentCellを変更した時
        self.Table.itemSelectionChanged.connect(self.onChangeCurrentCell)

        #---- key event ---------------
        #Ctrl+Cのevent
        self.Table.copySignal.connect(self.onCopy)
        #Crtl+Vのevent
        self.Table.pasteSignal.connect(self.onPaste)
        #<enter> or <return> のevent
        self.Table.enterSignal.connect(self.onTableEditorClose)
        #----- mouse event -------------
        #cellをクリック
        self.tableWidget.itemClicked.connect(self.onAdjustCells)
        #headerをDクリック
        self.hHeaders = self.tableWidget.horizontalHeader()
        self.vHeaders = self.tableWidget.verticalHeader()
        try:
            #Qt4用
            #  colLabelのDクリックevent
            self.MainWindow.connect(self.tableWidget.horizontalHeader(), SIGNAL("sectionDoubleClicked(int)"), self.onColLabelDclick)
            #  rowLabelのDクリックevent
            self.MainWindow.connect(self.tableWidget.verticalHeader(), SIGNAL("sectionDoubleClicked(int)"), self.onRowLabelDclick)
        except:
            #Qt5,Qt6用
            #  colLabelのDクリックevent
            self.hHeaders.sectionDoubleClicked.connect(self.onColLabelDclick)
            #  rowLabelのDクリックevent
            self.vHeaders.sectionDoubleClicked.connect(self.onRowLabelDclick)
        #colLabelの右クリック
        self.hHeaders = self.createEventQt(self.hHeaders, self.onColLabelRclick)
        #rowLabelの右クリックevent
        self.vHeaders = self.createEventQt(self.vHeaders, self.onRowLabelRclick)
        #cellの右クリックevent
        self.tableWidget = self.createEventQt(self.tableWidget, self.onCellRclick)
        #------------ vtkのevent ------------------
        self.check_showEdge.stateChanged.connect(self.onShowHideEdge)
        self.check_opacity.stateChanged.connect(self.onSetOpacity)
        self.button_reset.clicked.connect(self.onResetCamera)
        self.button_Xaxis.clicked.connect(self.onSetXaxis)
        self.button_Yaxis.clicked.connect(self.onSetYaxis)
        self.button_Zaxis.clicked.connect(self.onSetZaxis)
        self.button_reloadVtk.clicked.connect(self.onReloadVtk)
        self.button_rightToLeft.clicked.connect(self.onRightToLeft)
        self.button_rolling90.clicked.connect(self.onRolling90)
        self.button_hidePatch.clicked.connect(self.onHidePatches)
        self.button_showAllPatches.clicked.connect(self.onShowAllPatches)
        self.button_boundary.clicked.connect(self.onEditBoundary)
        if VtkFlag != None:
            self.vtkWidget.selectedSignal.connect(self.onSelectedPatchs)
            #self.vtkWidget.rightClickSignal.connect(self.onRightClickVtk)
        self.button_vtkClose.clicked.connect(self.onVtkClose)

    def createEventQt(self, widget, eventCall):
        widget.setContextMenuPolicy(QtVar.CustomContextMenu)
        widget.customContextMenuRequested.connect(eventCall)
        return widget

    def setToolTip(self):
        colMess = _("ここをダブルクリックすると、") + "\n"
        colMess += _("  Editorでファイルを開きます。")
        self.Table.horizontalHeader().setToolTip(colMess)
        rowMess = _("patch名をダブルクリックすると、") + "\n"
        rowMess += _("  patch名が変更できます。")
        self.Table.verticalHeader().setToolTip(rowMess)

        self.check_showEdge.setToolTip(_("meshのedgeを表示する"))
        self.check_opacity.setToolTip(_("meshを半透明の表示にする"))
        self.button_reset.setToolTip(_("画面にフィットさせる（reset camera）"))
        self.button_Xaxis.setToolTip(_("x軸視（y-z 面）を表示"))
        self.button_Yaxis.setToolTip(_("y軸視（z-x 面）を表示"))
        self.button_Zaxis.setToolTip(_("z軸視（x-y 面）を表示"))
        self.button_reloadVtk.setToolTip(_("vtkデータの再読込"))
        self.button_rightToLeft.setToolTip(_("視点を反転(左右前後反転)"))
        self.button_rolling90.setToolTip(_("時計回りに90度回転"))
        self.button_hidePatch.setToolTip(_("選択patchを隠す（非表示）"))
        self.button_showAllPatches.setToolTip(_("全patchを表示させる"))
        self.button_boundary.setToolTip(_("選択patchの境界条件を設定する。\n(複数選択可)"))

    #-------- event handler ----------------------
    #開く
    def onOpen(self):
        self.openGridEditor()
    #保存
    def onSave(self):
        self.saveGridEditor()
    #csv保存
    def onSaveCsv(self):
        self.saveCsv()
    #再読み込み
    def onReload(self):
        self.reload()
    #閉じる
    def onClose(self):
        self.closeGridEditor()
    #cellコピー
    def onCopy(self):
        self.copyCell()
    #cell貼り付け
    def onPaste(self):
        self.pasteCell()
    #空白cellをzeroGradient etc.で埋める
    def onClearZeroGrad(self):
        self.clearZeroGradient()
    #internalFieldをクリア
    def onClearUniform(self):
        self.clearUniform()
    #vtkを表示
    def onShowVtk(self):
        self.showVtk()
    #patch名変更
    def onRenamePatch(self):
        self.renamePatch()
    #空patch削除
    def onDeletePatch(self):
        self.deleteNulPatch()
    #cellをeditorで編集
    def onEditor(self):
        self.editCellValue()
    #選択fieldを非表示
    def onHideFields(self):
        self.hideFields()
    #fieldの表示順を設定
    def onChangeOrder(self):
        self.changeOrder()
    #------ tableWidgetからのevent--------
    #textEditorを閉じた時
    def onTableEditorClose(self):
        self.tableEditorClose()
    #cell内容が変わった時
    def onTableItemChanged(self, event):
        if self.maskEvent == "no":
            self.tableItemChanged(event)
    #cellをクリックした時
    def onAdjustCells(self, event):
        self.selectVtkPatch()
        QtParts.tableWidget(self.tableWidget).adjustCells()
    #colLabelをDクリックした時
    def onColLabelDclick(self, event):
        self.colLabelDclick(event)
    #rowLabelをDクリックした時
    def onRowLabelDclick(self, event):
        self.rowLabelDclick(event)
    #colLabel右クリック時
    def onColLabelRclick(self, event):
        self.showColPopupMenu(event)
    #rowLabe右クリック時
    def onRowLabelRclick(self, event):
        self.showRowPopupMenu(event)
    #cell右クリック時
    def onCellRclick(self, event):
        self.showCellRclick(event)
    #currentCellを変更した時
    def onChangeCurrentCell(self):
        if self.maskEvent == "no":
            self.selectVtkPatch()
            QtParts.tableWidget(self.tableWidget).adjustCells()

    #-------- popupMenuのevent ---------
    #全表示、非表示切り替え
    def onSwitchAllorHideFields(self):
        self.switchAllOrHideFields()
    #fieldコピー
    def onCopyFields(self):
        self.copyFields()
    #field貼り付け
    def onPasteFields(self):
        self.pasteFields()
    #field名変更
    def onRenameField(self):
        self.renameField()
    #fieldを削除
    def onDeleteFields(self):
        self.deleteFields()
    #行コピー
    def onCopyRows(self):
        self.copyCell()
    #行貼り付け
    def onPasteRows(self):
        self.pasteCell()
    #patch名sort切り替え
    def onSwitchPatchSort(self):
        self.switchPatchSort()
    #表示行数変更
    def onChangeMaxLines(self):
        self.changeMaxLines()
    #空patch追加
    def onAddNullPatch(self):
        self.addNullPatch()
    #空patch削除
    def onDeleteNullPatch(self):
        self.deleteNullPatch()
    #全空patchを削除
    def onDeleteAllNullPatch(self):
        self.deleteAllNullPatch()
    #変数行の表示
    def onShowVariableRow(self):
        self.showVariableRow()
    #cellクリア
    def onClearCells(self):
        self.clearCells()
    #------- vtk window のevent ----------
    #edgeの表示/非表示
    def onShowHideEdge(self):
        if self.vtkMaskEvent != "yes":
            self.showHideEdge()
    #opacity可否
    def onSetOpacity(self):
        if self.vtkMaskEvent != "yes":
            self.setOpacity()
    #cameraをreset
    def onResetCamera(self):
        self.resetCamera()
    #x軸視
    def onSetXaxis(self):
        self.setXaxis()
    #y軸視
    def onSetYaxis(self):
        self.setYaxis()
    #z軸視
    def onSetZaxis(self):
        self.setZaxis()
    #vtk再読込
    def onReloadVtk(self):
        self.reloadVtk()
    #視点を反転
    def onRightToLeft(self):
        self.setReverseCamera()
    #時計回りに回転
    def onRolling90(self):
        self.rolling90()
    #patchを隠す
    def onHidePatches(self):
        self.hidePatches()
    #全patch表示
    def onShowAllPatches(self):
        self.showAllPatches()
    #patch選択時
    def onSelectedPatchs(self):
        self.selectedPatchs()
    #境界条件設定
    def onEditBoundary(self):
        self.editBoundary()
    #rightClickのevent
    # def onRightClickVtk(self):
    #     self.rightClickVtk()
    #vtkClose
    def onVtkClose(self):
        self.vtkClose()
    #-----------------------------------------


    #---------- vtk window　の処理 -----------
    def vtkClose(self):
        """ patchViewer(vtk)を閉じる"""
        self.frame.setVisible(False)

    def resetCamera(self):
        """ cameraをresetする"""
        self.patchMesh.ren.ResetCamera()
        self.vtkWidget.Initialize()
        return

    def setXaxis(self):
        """ X軸視（Y-Z plane）"""
        #camera位置を算出
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        cameraPos = (Xcenter+maxLeng*2.0, Ycenter, Zcenter)
        #X軸視に設定
        camera = self.patchMesh.ren.GetActiveCamera()
        #  camera位置を設定
        camera.SetPosition(*cameraPos)
        #  cameraの縦軸の単位vectorを設定
        camera.SetViewUp(0, 0, 1)
        #  表示
        self.patchMesh.ren.ResetCamera()
        self.vtkWidget.Initialize()
        return

    def setYaxis(self):
        """ Y軸視（Z-X plane）"""
        #camera位置を算出
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        cameraPos = (Xcenter, Ycenter+maxLeng*2.0, Zcenter)
        #Y軸視に設定
        camera = self.patchMesh.ren.GetActiveCamera()
        camera.SetPosition(*cameraPos)  #camera位置を設定
        camera.SetViewUp(1, 0, 0)       #cameraの縦軸方向単位vector
        self.patchMesh.ren.ResetCamera()
        self.vtkWidget.Initialize()
        return

    def setZaxis(self):
        """ Z軸視（X-Y plane）"""
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        cameraPos = (Xcenter, Ycenter, Zcenter+maxLeng*2.0)
        camera = self.patchMesh.ren.GetActiveCamera()
        camera.SetPosition(*cameraPos)
        camera.SetViewUp(0, 1, 0)

        self.patchMesh.ren.ResetCamera()
        self.vtkWidget.Initialize()
        return

    def reloadVtk(self):
        """ vtkを再読込して表示する"""
        self.vtkMaskEvent = "yes"
        #表示されている全actorを削除
        self.patchMesh.deleteAllActors()
        #再読込してpatch名を取得し直す
        caseDir = self.caseDir
        region = self.region
        timeFolder = self.timeFolder
        _patchMesh = QtVtk.OpenFoamPatchMesh(self.vtkWidget, caseDir, region, timeFolder)
        #再表示
        selPatchNames = self.getSelPatchNames()
        self.patchMesh.reloadRemakeRenderWindow(selPatchNames)
        #view方向をreset
        self.setZaxis()
        self.vtkMaskEvent = "no"

    def setReverseCamera(self):
        """ camera位置を反転（左右反転）させる"""
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        center = (Xcenter, Ycenter, Zcenter)
        camera = self.patchMesh.ren.GetActiveCamera()
        pos = camera.GetPosition()
        relPos = (pos[0]-center[0], pos[1]-center[1], pos[2]-center[2])
        newRelPos = list(map(lambda x: -x, relPos))
        newPos = (newRelPos[0]+center[0], newRelPos[1]+center[1], newRelPos[2]+center[2])
        camera.SetPosition(*newPos)
        self.patchMesh.ren.ResetCamera()
        self.vtkWidget.Initialize()
        return

    def rolling90(self):
        """ 視点を右回転（90°）させる。"""
        camera = self.patchMesh.ren.GetActiveCamera()
        camera.Roll(-90.0)
        self.patchMesh.ren.ResetCamera()
        self.vtkWidget.Initialize()
        return

    def getBoundsActors(self):
        """ 全actorのboundsを取得する"""
        actors = self.patchMesh.ren.GetActors()
        bounds = []
        for actor in actors:
            bound = actor.GetBounds()
            bounds.append(bound)
        Xmin = min(map(lambda x: x[0], bounds))
        Xmax = max(map(lambda x: x[1], bounds))
        Ymin = min(map(lambda x: x[2], bounds))
        Ymax = max(map(lambda x: x[3], bounds))
        Zmin = min(map(lambda x: x[4], bounds))
        Zmax = max(map(lambda x: x[5], bounds))
        return (Xmin, Xmax, Ymin, Ymax, Zmin, Zmax)

    def editBoundary(self):
        #vtk側の選択patch名を取得
        selPatchNames = self.patchMesh.selected_block
        if len(selPatchNames) == 0:
            return
        selPatchNames = list(map(lambda x: x.split("/")[-1], selPatchNames))
        #gridEditor側のfield（colLabel）を取得
        fields = self.fields
        table = QtParts.tableWidget(self.tableWidget)
        selCells = table.selectedCells()
        (row, col) = selCells[0]
        colLabel = table.getColLabelValue(col).split("\n")[0]
        selField = ""
        if colLabel in fields:
            selField = colLabel
        #選択pathcにおける各fieldの境界条件を取得
        conts = []
        for i in range(1, table.tableWidget.columnCount()):
            conts.append(table.getCellValue(row, i))
        #dialogを表示
        if len(selPatchNames) == 1:
            selPatchName = selPatchNames[0]
        else:
            selPatchName = selPatchNames[0] + " etc."
        dialog = setBCInPatchViewerQtDDialog.Ui_Dialog(
            selPatchName, selField, fields, conts, self.MainWindow)
        (selField, boundary) = dialog.Show()
        if selField == "" or boundary == "":
            return
        #取得した境界条件をgridEditorに設定する。
        selCol = -1
        for col in range(1, table.tableWidget.columnCount()):
            colLabel = table.getColLabelValue(col).split("\n")[0]
            if selField == colLabel:
                selCol = col
                break
        if selCol == -1:
            return
        table.unselectAll()
        for row, _col in selCells:
            table.setCellValue(row, selCol, boundary)
            self.setFontColour(row, selCol)
            table.selectCell(row, selCol)
        table.scrollToCell(row, selCol)
        return

    def selectedPatchs(self):
        """ vtkModelのpatchをmouseで選択した時に
        tableのrowをpatch名に合わせる"""
        if self.vtkMaskEvent == "yes":
            return
        #vtk側のpatchNameを取得
        selPatchNames = self.patchMesh.selected_block
        if len(selPatchNames) == 0:
            return
        selPatchNames = list(map(lambda x: x.split("/")[-1], selPatchNames))
        #gridEditor側のpatchNameを選択する
        self.vtkMaskEvent = "yes"
        table = QtParts.tableWidget(self.tableWidget)
        (row, col) = table.currentCell()
        table.unselectAll()
        selCells = []
        for row in range(self.tableWidget.rowCount()):
            rowLabel = QtParts.tableWidget(self.tableWidget).getRowLabelValue(row)
            rowName = rowLabel.replace("\n", "")
            if rowName in selPatchNames:
                selCells.append((row, col))
        #table.tableWidget.setCurrentCell(*selCells[-1])
        for row, col in selCells:
            table.selectCell(row, col)
        #currentCellを設定
        table.tableWidget.setCurrentCell(*selCells[-1])
        self.Table.CurrRowCol = selCells[-1]    #currRowColに保存
        table.scrollToCell(*selCells[-1])
        print("selected patches are ", selPatchNames)
        self.vtkMaskEvent = "no"
        return
        
    def selectVtkPatch(self):
        """ tableのcurrentCellのpatch名を読み取り、
        vtkモデル側の相当するpatchを選択表示する"""
        if self.patchMesh == "":
            return
        if self.vtkMaskEvent == "yes":
            return
        #選択しているcellを取得
        selPatchNames = self.getSelPatchNames()
        #vtk側のselPatchNamesを選択表示する。
        self.vtkMaskEvent = "yes"
        self.patchMesh.selectPatches(selPatchNames)
        self.vtkWidget.Initialize()
        self.vtkMaskEvent = "no"
        return

    def getSelPatchNames(self):
        """ 選択しているcellのpatchNameを取得して返す。"""
        #選択しているcellを取得
        table = QtParts.tableWidget(self.tableWidget)
        selCells = table.selectedCells()
        #選択しているpatchNameを取得
        selPatchNames = []
        for row, _col in selCells:
            rowLabel = table.getRowLabelValue(row)
            patchName = rowLabel.replace("\n", "")
            if self.region != ".":
                patchName = self.region + "/" + patchName
            selPatchNames.append(patchName)
        return selPatchNames

    def showHideEdge(self):
        """ modelのedge表示を反転させる"""
        if self.check_showEdge.isChecked() == False:
            #edgeを非表示
            self.patchMesh.showEdge = False
        else:
            #edgeを表示
            self.patchMesh.showEdge = True
        selPatchNames = self.patchMesh.selected_block
        self.patchMesh.selectPatches(selPatchNames)
        self.vtkWidget.Initialize()

    def setOpacity(self):
        """ modelを半透明、不透明に設定"""
        if self.check_opacity.isChecked() == False:
            #不透明
            self.patchMesh.setOpacity = False
        else:
            #透明
            self.patchMesh.setOpacity = True
        selPatchNames = self.patchMesh.selected_block
        self.patchMesh.selectPatches(selPatchNames)
        self.vtkWidget.Initialize()

    def hidePatches(self):
        """ 選択patchを隠す"""
        hidePatchNames = self.patchMesh.selected_block
        self.patchMesh.hidePatches(hidePatchNames)
        self.vtkWidget.Initialize()

    def showAllPatches(self):
        """ 全patchを表示する。"""
        self.patchMesh.remakeRenderWindow()
        self.vtkWidget.Initialize()

    #
    #  showVtk
    #----------
    def showVtk(self):
        """ vtkViewerを表示する"""
        if VtkFlag == None:
            title = _("エラー")
            mess = _("vtkがimportできない為、patchViewerが起動できません。")
            mess += _("  vtk をインストールしてください。")
            self.errDialog(title, mess)
            return
        if self.frame.isVisible():
            title = _("patch viewerの表示")
            mess = _("既にpatchViewerは、表示されています。")
            self.okDialog(title, mess)
            return
        if self.patchMesh != "":
            self.frame.setVisible(True)
            return
        if len(self.patchConts) == 0:
            title = _("エラー")
            mess = _("patchが存在しません。\n\n")
            mess += _("  meshが表示できません。")
            self.errDialog(title, mess)
            return
        #meshを読み込み表示
        self.frame.setVisible(True)
        self.vtkMaskEvent = "yes"
        caseDir = self.caseDir
        region = self.region
        timeFolder = self.timeFolder
        self.patchMesh = QtVtk.OpenFoamPatchMesh(self.vtkWidget, caseDir, region, timeFolder)
        if self.patchMesh.showEdge == True:
            self.check_showEdge.setChecked(True)
        if self.patchMesh.setOpacity == True:
            self.check_opacity.setChecked(True)
        self.vtkWidget.Initialize()
        #self.vtkWidget.Start()
        selPatchNames = self.getSelPatchNames()
        self.patchMesh.makeRenderWindow(selPatchNames)
        self.vtkWidget.Start()
        self.vtkMaskEvent = "no"


    #
    #  openGridEditor
    #-----------------
    def openGridEditor(self):
        """ 別のgridEditorを開く"""
        commPath = os.getenv("TreeFoamPath") + "/python"
        comm = commPath + "/openGridEditorDialog.py " + self.nTreeFoam + " " + self.caseDir
        pyTreeFoam.run(self.caseDir).command(comm)

    #
    #  saveGridEditor
    #----------------
    def saveGridEditor(self):
        """ gridEditor内のデータを保存する。"""

        def readField(field):
            """ field内容を読み込む"""
            fileName = self.fieldDir + "/" + field
            cont = pyTreeFoam.foamFile(self.nMaxLinesBinToAscii).read(fileName)
            return cont

        def writeField(field, cont):
            """ fieldの内容を書き込む"""
            fileName = self.fieldDir + "/" + field
            pyTreeFoam.foamFile(self.nMaxLinesBinToAscii).write(fileName, cont)

        def readBoundary():
            """ boundaryの読み込み"""
            fileName = self.boundaryDir + "/boundary"
            cont = pyTreeFoam.foamFile(self.nMaxLinesBinToAscii).read(fileName)
            return cont

        def writeBoundary(cont):
            """ boundaryの書き込み"""
            fileName = self.boundaryDir + "/boundary"
            pyTreeFoam.foamFile(self.nMaxLinesBinToAscii).write(fileName, cont)

        #progressDialog表示-------------------
        progress = progressBar.dialog()
        progress.showSettingDialog("gridEditorの保存", "saving.....")
        progress.numSettingDialog(0, "setting...")
        #gridDataを取得
        self.getAllDataFromGrid()
        #取得したデータを整形する(行頭に空白追加)
        patchConts = self.getPatchContsFromGrid()   #boundary
        patchData = self.getPatchDataFromGrid()     #boundaryField
        dimData = self.dimData[:]                   #dimension
        intData = self.getIntDataFromGrid()         #internalField      
        varData = self.varData[:]                   #variableData
        varBndData = self.getVarBndDataFromGrid()   #boundaryVariableData
        #patchConts, patchDataをboundaryの順番に直す
        (patchConts, patchData) = self.fitPatchOrderToBoundary(patchConts, patchData)
        #progressDialogの設定-----------------
        Value = 10.0
        dValue = 80.0 / len(self.fields)
        #fieldを保存する。
        for i in range(len(self.fields)):
            #progressDialogの設定--------------
            stat = progress.numSettingDialog(Value, "saving " + self.fields[i] + "...")
            if stat == "CANCEL":
                title = _("gridEditorの保存")
                mess = _("gridEditorの保存をキャンセルしました。")
                self.warningDialog(title, mess)
                break
            Value += dValue
            #fieldの保存
            field = self.fields[i]
            fieldCont = readField(field)
            #patchDataを入れ替え
            fieldCont = self.replacePatchData(fieldCont, patchConts, patchData[i])
            #internalFieldを入れ替え
            fieldCont = self.replaceIntData(fieldCont, intData[i])
            #dimDataを入れ替え
            fieldCont = self.replaceDimData(fieldCont, dimData[i])
            #varDataを入れ替え
            fieldCont = self.replaceVarData(fieldCont, varData[i])
            #varbndDataを入れ替え
            fieldCont = self.replaceVarBndData(fieldCont, varBndData[i])
            #include, includeEtc行をコメントアウトする。
            fieldCont = self.deleteIncludeLine(fieldCont)
            #fileに書き込み
            writeField(field, fieldCont)

        #progressDialogの設定--------------------
        progress.numSettingDialog(90, "ending...")
        #boundaryを保存
        cont = readBoundary()
        cont = self.replaceBoundaryData(cont, patchConts)
        writeBoundary(cont)
        print(u"boundaryFieldを保存しました")
        #保存flagをクリア
        self.alarmSaveFlagClear()
        #progressDialogを閉じる-----------------
        progress.closeSettingDialog()

    def deleteIncludeLine(self, cont):
        """ include, includeEtc行をコメントアウトする。"""
        contOp = pyTreeFoam.strOp(cont)
        pst = contOp.skipFoamFile()
        #全体のincludeをコメントアウトする
        lineCont = " "
        p = pst
        while lineCont != "":
            ps = p
            (lineCont, p, kind) = contOp.get1line(p)
            if kind == "include" or kind == "includeEtc":
                newLineCont = "//" + lineCont
                (cont, p, _keyword) = contOp.replace1line(ps, lineCont, newLineCont)
        newCont = contOp.line
        return newCont

    def replaceBoundaryData(self, cont, patchConts):
        """ boundaryの内容を置き換える"""
        contOp = pyTreeFoam.strOp(cont)
        ps = contOp.skipFoamFile()
        (bndCont, pp) = contOp.getSmallPair(ps)
        pst = pp - len(bndCont)
        bndContOp = pyTreeFoam.strOp(bndCont)
        ped = pp - 1
        header = cont[:pst]
        footer = cont[ped:]
        #patch内容を作成
        newCont = ""
        lineCont = " "; p = 0
        i = 0
        while lineCont != "":
            (lineCont, p, _kind) = bndContOp.get1line(p)
            if lineCont != "":
                lineContOp = pyTreeFoam.strOp(lineCont)
                (patchName, pp) = lineContOp.getKeyword(0)
                newPatchCont = "    " + patchName + "\n"
                newPatchCont += "    " + "{\n"
                newPatchCont += patchConts[i][1]
                newPatchCont += "        nFaces      " + patchConts[i][2] + ";\n"
                newPatchCont += "        startFace   " + patchConts[i][3] + ";\n"
                newPatchCont += "    " + "}\n"
                newCont += newPatchCont
            i += 1
        newLine = header + newCont + footer
        return newLine

    def replaceVarBndData(self, fieldCont, varCont):
        """ boundary変数の内容を入れ替え"""
        if varCont == "":
            return fieldCont

        #boundaryFieldを探す
        fieldContOp = pyTreeFoam.strOp(fieldCont)
        p = fieldContOp.skipFoamFile()
        lineCont = " "
        while lineCont != "":
            pst = p
            (lineCont, p, kind) = fieldContOp.get1line(p)
            (keyword, _pp) = pyTreeFoam.strOp(lineCont).getKeyword(0)
            if keyword == "boundaryField":
                (bndCont, _pp) = pyTreeFoam.strOp(lineCont).getMiddlePair(0)
                break
        #変数を削除
        delConts = []
        bndContOp = pyTreeFoam.strOp(bndCont)
        lineCont = " "; p = 0
        while lineCont != "":
            (lineCont, p, kind) = bndContOp.get1line(p)
            (keyword, _pp) = pyTreeFoam.strOp(lineCont).getKeyword(0)
            if (kind == "line" or kind == "other"):
                delConts.append(lineCont)
        #  delContsを削除
        for delCont in delConts:
            n = fieldCont.find(delCont)
            ne = n + len(delCont)
            if fieldCont[ne] == "\n":
                fieldCont = fieldCont[:n] + fieldCont[ne+1:]
            else:
                fieldCont = fieldCont[:n] + fieldCont[ne:]
        #変数を追加する場所を探す
        ps = 0
        lineCont = " "; p = 0
        while lineCont != "":
            (lineCont, p, kind) = bndContOp.get1line(p)
            if kind == "include" or kind == "includeEtc":
                ps = p
        #変数を追加
        bndCont = bndCont[:ps] + varCont + bndCont[ps:]
        #boundaryFieldを再作成
        newBndCont = "boundaryField\n"
        newBndCont += "{\n"
        newBndCont += bndCont
        newBndCont += "}"
        (newFieldCont, _pp, keyword) = fieldContOp.replace1lineKeyword(pst, newBndCont)
        return newFieldCont

    def replaceVarData(self, fieldCont, varCont):
        """ 全体変数の内容を入れ替える"""
        #変数を削除
        fieldContOp = pyTreeFoam.strOp(fieldCont)
        pst = fieldContOp.skipFoamFile()
        p = pst
        delConts = []
        lineCont = " "
        while lineCont != "":
            (lineCont, p, kind) = fieldContOp.get1line(p)
            (keyword, _pp) = pyTreeFoam.strOp(lineCont).getKeyword(0)
            if ((kind == "line" or kind == "other")
                    and keyword != "dimensions"
                    and keyword != "internalField"
                    and keyword != "boundaryField"):
                delConts.append(lineCont)
        #  delContsを削除
        for delCont in delConts:
            n = fieldCont.find(delCont)
            ne = n + len(delCont)
            if fieldCont[ne] == "\n":
                fieldCont = fieldCont[:n] + fieldCont[ne+1:]
            else:
                fieldCont = fieldCont[:n] + fieldCont[ne:]
        #varContが「""」の場合、戻る
        if varCont == "":
           return fieldCont
        #変数を追加する場所を探す
        fieldContOp = pyTreeFoam.strOp(fieldCont)
        lineCont = " "; keyword = " "
        p = pst; pinc = 0
        while lineCont != "":
            (lineCont, p, kind) = fieldContOp.get1line(p)
            (keyword, _pp) = pyTreeFoam.strOp(lineCont).getKeyword(0)
            if keyword == "dimensions":
                pdim = p
            elif kind == "include" or kind == "includeEtc":
                pinc = p
            elif keyword == "boundaryField":
                break
        if pinc != 0:
            ps = pinc
        else:
            ps = pdim
        #  変数を追加
        fieldCont = fieldCont[:ps] + "\n" + varCont + fieldCont[ps:]
        return fieldCont

    def replaceDimData(self, fieldCont, dim):
        """ fieldType, dimensionを入れ替える"""
        fieldType = dim.split("\n")[0]
        dimension = dim.split("\n")[1]
        fieldContOp = pyTreeFoam.strOp(fieldCont)
        #fieldTypeを書き換え
        (cont, p) = fieldContOp.getKeywordContents("FoamFile", 0)
        p = fieldContOp.skipIntoPair(p-len(cont))
        newLine = "class          " + fieldType + ";"
        (fieldCont, _pp, keyword) = fieldContOp.replace1lineKeyword(p, newLine)
        #dimensionを書き換え
        lineCont = " "; p = 0
        while lineCont != "":
            ps = p
            (lineCont, p, _kind) = fieldContOp.get1line(p)
            (keyword, _pp) = pyTreeFoam.strOp(lineCont).getKeyword(0)
            if keyword == "dimensions":
                newLine = "dimensions      " + dimension
                (fieldCont, _pp, keyword) = fieldContOp.replace1lineKeyword(ps, newLine)
                break
        return fieldCont

    def replaceIntData(self, fieldCont, internalData):
        """ internalFieldの内容を入れ替える"""
        fieldContOp = pyTreeFoam.strOp(fieldCont)
        if internalData[-4:] != "...\n":
            newLine, _p, _kind = pyTreeFoam.strOp(internalData).get1line(0)
            (newCont, _p, keyword) = fieldContOp.replace1lineKeyword(0, newLine)
        else:
            #「...」以降で行末までを取得
            lineCont = " "; p = 0
            while lineCont != "":
                (lineCont, p, _kind) = fieldContOp.get1line(p)
                (keyword, _pp) = pyTreeFoam.strOp(lineCont).getKeyword(0)
                if keyword == "internalField":
                    n = lineCont.find("...")
                    addLine = lineCont[n:]
                    break
            internalData = internalData[:-4] + "\n" + addLine
            (newCont, _p, keyword) = fieldContOp.replace1lineKeyword(0, internalData)
        return newCont

    def replacePatchData(self, fieldCont, patchConts, patchTypes):
        """ fieldのpatchデータを入れ替える。
        
        Args:
            fieldCont:  fieldの内容
            patchConts: gridEditor内のpatchCont（boundaryの内容)
            patchType:  gridEditor内のpatchTypes（boundaryFieldの内容）
        Returns:
            newFeldCont:    入れ替えたfieldの内容"""
        #boundaryFieldの内容（bndCont）を取得
        fieldContOp = pyTreeFoam.strOp(fieldCont)
        lineCont = " "; p = 0
        while lineCont != "":
            (lineCont, p, _kind) = fieldContOp.get1line(p)
            (keyword, pp) = pyTreeFoam.strOp(lineCont).getKeyword(0)
            if keyword == "boundaryField":
                (bndCont, pp) = pyTreeFoam.strOp(lineCont).getMiddlePair(pp)
                break
        bndContOp = pyTreeFoam.strOp(bndCont)
        #boundaryFieldを再作成する
        newCont = ""
        for i in range(len(patchTypes)):
            patchType = patchTypes[i]
            if patchType != "":
                patchName = patchConts[i][0]
                if patchType[-4:] != "...\n":
                    #gridEditor内のpatchに「...」が無い場合
                    pCont = "    " + patchName + "\n"
                    pCont += "    {\n"
                    pCont += patchType
                    pCont += "    }\n"
                else:
                    #field内の該当するpatch内容を取得する
                    lineCont = " "; p = 0
                    while lineCont != "":
                        (lineCont, p, _kind) = bndContOp.get1line(p)
                        (keyword, pp) = pyTreeFoam.strOp(lineCont).getKeyword(0)
                        if keyword == patchName:
                            #fieldデータから同じpatch内容を取得
                            pCont = "    " + lineCont + "\n"
                            break
                newCont += pCont
        #boundaryFieldを再作成
        newBoundaryCont = "boundaryField\n"
        newBoundaryCont += "{\n"
        newBoundaryCont += newCont
        newBoundaryCont += "}"
        #fieldContを再作成
        (newFieldCont, p, _keyword) = fieldContOp.replace1lineKeyword(0, newBoundaryCont)
        return newFieldCont

    def fitPatchOrderToBoundary(self, patchConts, patchData):
        """ patchの順番をboundaryの順番に合わせる。"""
        values = pyTreeFoam.case(self.caseDir).getPatchNameFromBoundary(self.boundaryDir)
        #順番を確認
        orders = []
        bndNames = list(map(lambda x: x[0], values))
        gridNames = list(map(lambda x: x[0], patchConts))
        for i in range(len(bndNames)):
            bName = bndNames[i]
            idx = gridNames.index(bName)
            orders.append(idx)
        #順番を入れ替え
        newConts = []
        for idx in orders:
            newConts.append(patchConts[idx])
        newData = []
        for patches in patchData:
            newPatches = []
            for idx in orders:
                newPatches.append(patches[idx])
            newData.append(newPatches)
        return (newConts, newData)

    def getVarBndDataFromGrid(self):
        """ 各fieldのvarBndDataを整形する。（空白を追加）"""
        varBndData = []
        for value in self.varBndData:
            if value != "":
                lines = value.split("\n")
                if len(lines) > 1:
                    newLines = []
                    for line in lines:
                        #newLine ="    " + " ".join(line.split()) + "\n"
                        newLine ="    " + " ".join(line.split())
                        newLines.append(newLine)
                    line = "\n".join(newLines) + "\n"
                else:
                    line = "    " + " ".join(value.split()) + "\n"
            else:
                line = value
            varBndData.append(line)
        return varBndData

    def getIntDataFromGrid(self):
        """ 各fieldのinternalFieldDataを整形する"""
        intData = []
        for value in self.intData:
            if value != "":
                value = self.reformInternalData(value)
            intData.append(value)
        return intData

    def reformInternalData(self, value):
        """ internalFieldのデータを整形する。"""
        lines = value.split("\n")
        words = lines[0].split()
        line = "internalField     "
        if len(lines) > 1:
            line += " ".join(words) + "\n"
            line += "\n".join(lines[1:]) + "\n"
        else:
            line += " ".join(words) + "\n"
        return line

    def getPatchDataFromGrid(self):
        """ 各fieldのboundaryDataを整形する"""
        fPatches = []
        for patches in self.patchData:
            newPatches = []
            for value in patches:
                if value != "":
                    value = self.reformPatchContents(value)
                newPatches.append(value)
            fPatches.append(newPatches)
        return fPatches

    def reformPatchContents(self, value):
        """ patch内容を整形する。
        行頭に空白を追加する。"""
        words = value.split("\n")
        i = 0
        while i < len(words):
            wds = words[i].split()
            if len(wds) > 0:
                wds0 = wds[0][0]
                if not (wds0 == "(" or
                        wds0 == ")" or
                        (wds0>="0" and wds0<="9") or
                        wds0 == "-" or wds0 == "+" or wds0 == "."):
                    #文字から始まる行の場合
                    words[i] = "        " + words[i]
                    if len(wds) > 1:
                        #spをskip
                        p = 0
                        while p < len(words[i]):
                            if words[i][p] == " ":
                                p += 1
                            else:
                                ep = p + 16
                                break
                        #文字をskip
                        while p < len(words[i]):
                            if words[i][p] != " ":
                                p += 1
                            else:
                                break
                        #sp追加
                        if p < ep:
                            sp = " " * (ep-p)
                            words[i] = words[i][:p] + sp + words[i][p+1:]
            i += 1
        value = "\n".join(words) + "\n"
        return value

    def getPatchContsFromGrid(self):
        """ boundaryのpatchTypeを整形する。"""
        patchConts = []
        stRow = self.getStRowFromGrid()
        maxRow = self.tableWidget.rowCount()
        tab2 = 20
        row = stRow
        #col = 0
        i = 0
        while row < maxRow:
            patchCont = self.patchConts[i]
            value = patchCont[1]
            lines = value.split("\n")
            newLines = []
            if len(lines) > 1:
                for line in lines:
                    words = line.split()
                    if len(words) > 0:
                        newLine = " " * 8 + words[0]
                        if len(words) > 1:
                            if len(newLine) < tab2:
                                newLine += (tab2-len(newLine)) * " "
                            else:
                                newLine += " "
                            newLine += " ".join(words[1:])
                    #newLine += "\n"
                    newLines.append(newLine)
                newValue = "\n".join(newLines) + "\n"
            else:
                words = value.split()
                newLine = " " * 8 + words[0]
                if len(words) > 1:
                    if len(newLine) < tab2:
                        newLine += (tab2-len(newLine)) * " "
                    else:
                        newLine += " "
                    newLine += " ".join(words[1:])
                newLine += "\n"
                newValue = newLine
            patchCont[1] = newValue
            patchConts.append(patchCont)
            i += 1
            row += 1
        return patchConts

    def getAllDataFromGrid(self):
        """ grid内の全Dataを取得する。
        self.patchConts, self.patchData, self.dimData, self.intData
        self.varData, self.varBndDataを取得する。"""
        stRow = self.getStRowFromGrid()
        maxRow = self.tableWidget.rowCount()
        table = QtParts.tableWidget(self.tableWidget)

        #patchConts(boundary)を取得
        patchConts = []
        col = 0
        row = stRow
        i = 0
        while row < maxRow:
            value = table.getCellValue(row, col)
            patchCont = self.patchConts[i]
            patchCont[1] = value
            patchConts.append(patchCont)            
            row += 1
            i += 1
        self.patchConts = patchConts

        #patchDataを取得
        fPatches = []
        col = 1
        for _field in self.fields:
            row = stRow
            patches = []
            while row < maxRow:
                value = table.getCellValue(row, col)
                patches.append(value)
                row += 1
            fPatches.append(patches)
            col += 1
        self.patchData = fPatches

        #dimDataを取得
        dimData = []
        row = 0
        col = 1
        for _field in self.fields:
            value = table.getCellValue(row, col)
            dimData.append(value)
            col += 1
        self.dimData = dimData

        #internalFieldを取得
        intData = []
        col = 1
        row = self.getInternalFieldRowFromGrid()
        for _field in self.fields:
            value = table.getCellValue(row, col)
            intData.append(value)
            col += 1
        self.intData = intData

        #verDataを取得
        if self.isVariable == True:
            varData = []
            varRow = 1
            col = 1
            for _field in self.fields:
                value = table.getCellValue(varRow, col)
                varData.append(value)
                col += 1
            self.varData = varData

        #varBndDataを取得
        varRow = -1
        if self.isVariable == True:
            if self.isVariableBoundary == True:
                varRow = 3
        else:
             if self.isVariableBoundary == True:
                 varRow = 2
        if varRow > 0:
            varBndData = []
            col = 1
            for _field in self.fields:
                #value = self.grid_1.GetCellValue(varRow, col)
                value = table.getCellValue(varRow, col)
                varBndData.append(value)
                col += 1
            self.varBndData = varBndData
        return

    def getInternalFieldRowFromGrid(self):
        """ grid中からinternalFieldの行を取得する。"""
        table = QtParts.tableWidget(self.tableWidget)
        intRow = 1
        maxRow = self.tableWidget.rowCount()
        row = intRow
        while row < maxRow:
            rowName = table.getRowLabelValue(row)
            rowName = "".join(rowName.split())
            if rowName[:len("internalField")] == "internalField":
                intRow = row
                break
            row += 1
        return intRow

    #
    #  saveCsv
    #----------
    def saveCsv(self):
        """ CSV形式で保存する。"""
        print(_("csv形式で保存します。"))

        title = _(u"csv形式で保存")
        message = _(u"gridEditorのイメージのままをcsv形式で保存します。\n保存場所は、caseDirです。")
        message += _("file名を入力してください。")
        inputText = u"boundaryField.csv"
        #inputText = self.textDialog(title, message, inputText)
        dialog = inputTextQtDialog.Ui_Dialog(title, message, inputText, self.MainWindow)
        inputText = dialog.main()
        if inputText == "":
            return

        #file名のチェック
        csvName = inputText
        csvName = csvName.split()[0]
        if csvName.split(".")[-1] != "csv":
            csvName += ".csv"
        #dataを取得
        maxRow = self.tableWidget.rowCount()
        maxCol = self.tableWidget.columnCount()
        #cellデータ取得
        table = QtParts.tableWidget(self.tableWidget)
        data = []
        for row in range(maxRow):
            line = []
            for col in range(maxCol):
                line.append(table.getCellValue(row, col))
            data.append(line)
        #rowName取得
        rowName = []
        for row in range(maxRow):
            rowName.append(table.getRowLabelValue(row))
        #colName取得
        colName = []
        for col in range(maxCol):
            colName.append(table.getColLabelValue(col))
        #csvデータ作成
        csvData = []
        #1行目（field名）作成
        line = u'""'
        for col in range(maxCol):
            line += ',"' + colName[col] + '"'
        line += '\n'
        csvData.append(line)
        #内部データ作成（patch名含む）
        for row in range(maxRow):
            line = '"' + rowName[row] + '"'
            for col in range(maxCol):
                line += ',"' + data[row][col] + '"'
            line += '\n'
            csvData.append(line)
        #保存
        res = "OK"
        if len(glob.glob(csvName)) != 0:
            title = _(u"csv保存")
            message = _(u"「") + csvName + _(u"」は、既に存在しています。\n　書き換えますか？")
            res = self.okCancelDialog(title, message)
        if res == "OK":
            f = open(csvName, "w")
            for line in csvData:
                f.write(line)
            f.close()
            title = _(u"csv保存")
            message = _(u"boundaryFieldをcsv形式で保存しました。")
            print(message)
            self.okDialog(title, message)

    #
    #  reload
    #---------
    def reload(self):
        """ boundaryと各fieldを再読み込みする。"""
        self.setStatus("loding data...")
        table = QtParts.tableWidget(self.tableWidget)
        (row, col) = table.currentCell()
        #データ読み込み
        self.loadData()
        #データセット
        self.remakeGrid()
        #currentCellを表示させる
        self.showSelectCell(row, col)
        #保存フラグをクリア
        self.alarmSaveFlagClear()
        self.clearStatus()
        print(_("reloadしました"))

    def remakeGrid(self):
        """ 読み込んでいるデータを使ってgridを再作成する。"""
        self.createMatrix()             #cell数を設定
        self.setMatrixData()            #cellにデータをセット
        self.clearStatus()              #statusBarをクリア
        self.setLabelColour()           #label色を設定
        self.setCellFontColour()        #font色を設定

    def showSelectCell(self, row, col):
        """ currentCellをスクロールして表示させる"""
        if row < 0:
            row = 0
        if col < 0:
            col = 0
        table = QtParts.tableWidget(self.tableWidget)
        table.scrollToCell(row, col)

    #
    #  closeGridEditor
    #-----------------
    def closeGridEditor(self):
        """ 閉じる"""
        flag = self.checkSaveFlag()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.onSave()
        #closeするgridNoを削除する
        self.endingGrid()
        #表示順を保存
        self.saveDisplayFieldsIfFile()
        #gridをcloseする
        self.close()

    def endingGrid(self):
        """ gridEditorの終了処理"""
        #自身のgridNoを削除する
        fileName = self.nRunningGrid
        f = open(fileName); lines = f.readlines(); f.close()
        currNos = self.nTreeFoam + ":" + self.gridNo
        newLines = []
        for line in lines:
            words = line.split()
            if words[0] != currNos:
                newLines.append(line)
        f = open(fileName, "w"); f.writelines(newLines); f.close()
        #windowSizeを保存
        gridSize = (self.MainWindow.width(), self.MainWindow.height())
        self.saveGridSize(gridSize)

    def checkSaveFlag(self):
        """ 保存の確認"""
        if self.checkEditedFlag() == 0:
            return "EXIT"
        else:
            title     = _(u"gridEditorの終了確認")
            message   = _(u"cell内容が変更されています。\n  このまま終了しますか？")
            cancelMsg = _(u"キャンセル")
            goMsg     = _(u"このまま終了")
            saveGoMsg = _(u"保存して終了")
            buttonsMsg = [cancelMsg, goMsg, saveGoMsg]
            msgBox = saveGoQtDialog.Ui_Dialog(title, message, buttonsMsg, self.MainWindow)
            msgBox.main()
            button = msgBox.pushButton
            return button

    def checkSaveReload(self):
        """ reloadの確認"""
        if self.checkEditedFlag() == 0:
            return "EXIT"
        else:
            title     = _(u"reload時の保存確認")
            message   = _(u"cell内容が変更されています。\n  このまま処理を継続すると、変更内容が失われます。")
            cancelMsg = _(u"キャンセル")
            goMsg     = _(u"このまま続行")
            saveGoMsg = _(u"保存して続行")
            buttonsMsg = [cancelMsg, goMsg, saveGoMsg]
            msgBox = saveGoQtDialog.Ui_Dialog(title, message, buttonsMsg, self.MainWindow)
            msgBox.main()
            button = msgBox.pushButton
            return button

    def checkEditedFlag(self):
        editedFlag = self.windowTitle.split(":")[1][0]
        if editedFlag == " ":
            ans = 0         #修正無し
        else:
            ans = 1         #修正あり
        return ans

    #
    #  copyCell
    #-----------
    def copyCell(self):
        """ 選択しているcell内容をclipboardにコピーする。"""
        table = QtParts.tableWidget(self.tableWidget)
        copyText = table.getCopyText()
        #clipboardに貼り付け
        copyPasteTextQt.copyText(copyText)

    #
    #  pasteCell
    #------------
    def pasteCell(self):
        """ clipboard内のdataをcellに貼り付ける"""
        #clipboardの内容を取得する。
        cont = copyPasteTextQt.pasteText()
        #tableに貼り付ける
        table = QtParts.tableWidget(self.tableWidget)
        table.setPasteText(cont)
        #font色を設定
        stRow = self.getStRowFromGrid()
        cells = table.selectedCells()
        for cell in cells:
            row = cell[0]
            col = cell[1]
            self.setFontColour(row, col, stRow)

    #
    #  clearZeroGradient
    #-------------------
    def clearZeroGradient(self):
        """ 空白cellにzeroGradient、empty etc.をセットする。"""

        def getBoundaryType(row):
            """ rowからpatchTypeを取得して返す。"""
            patchType = ""
            bCont = QtParts.tableWidget(self.tableWidget).getCellValue(row, 0)
            lines = bCont.split("\n")
            for line in lines:
                words = line.split()
                if words[0] == "type":
                    patchType = words[1]
                    break
            return patchType

        def getBoundaryContFromPatchType(pType):
            """ patchTypeからboundary内容を取得する。"""
            if (pType == "empty;" or pType == "symmetry;" or pType == "symmetryPlane;" or
                pType == "cyclic;" or pType == "cyclicAMI;" or pType == "cyclicACMI;" or
                pType == "cyclicSlip;" or pType == "wedge;"):
                pCont = "type " + pType
            else:
                pCont = "type zeroGradient;"
            return pCont

        cells = []
        table = QtParts.tableWidget(self.tableWidget)
        (curRow, curCol) = table.currentCell()
        flag = 0
        maxRow = self.tableWidget.rowCount()
        maxCol = self.tableWidget.columnCount()
        for col in range(maxCol):
            stRow = self.getStRowFromGrid()
            for row in range(stRow, maxRow):
                cellValue = table.getCellValue(row, col)
                if cellValue == "":
                    patchType = getBoundaryType(row)
                    value = getBoundaryContFromPatchType(patchType)
                    table.setCellValue(row, col, value)
                    cells.append((row, col))
                    flag = 1
        table.scrollToCell(curRow, curCol)
        #zeroGradientを書き込んだ場合保存flagをセット
        if flag == 1:
            self.alarmSaveFlagSet()
        #font色を設定
        for cell in cells:
            row = cell[0]
            col = cell[1]
            self.setFontColour(row, col)        

    #
    #  clearUniform
    #----------------
    def clearUniform(self):
        """ 選択したinternalFieldをuniform形式でクリアする。"""

        def getNewUniform(col):
            """ uniform形式の値を取得する。"""
            ans = ""
            volValue = QtParts.tableWidget(self.tableWidget).getCellValue(0, col)
            if volValue.find("Scalar") >= 0:
                ans = "uniform 0;"
            elif volValue.find("Vector") >= 0:
                ans = "uniform (0 0 0);"
            elif volValue.find("SymmTensor") >= 0:
                ans = "uniform (0 0 0 0 0 0);"
            elif volValue.find("Tensor") >= 0:
                ans = "uniform (0 0 0 0 0 0 0 0 0);"
            else:
                ans = "uniform 0;"
            return ans

        table = QtParts.tableWidget(self.tableWidget)
        (curRow, curCol) = table.currentCell()
        error = ["", ""]
        #選択範囲を取得
        cells = table.selectedCells()
        rows = list(set(map(lambda x: x[0], cells)))
        if len(rows) == 0:
            error = ["NG", _("cellが選択されていません。")]
        elif len(rows) > 1:
            error = ["NG", _(u"クリアするinternalFieldのcellを選択してください。")]
        else:
            row = rows[0]
            rowLabel = QtParts.tableWidget(self.tableWidget).getRowLabelValue(row)
            if rowLabel.split("\n")[0] != "internal":
                error = ["NG", _(u"クリアするinternalFieldのcellを選択してください。")]
        if error[0] != "":
            title = _(u"エラー")
            self.errDialog(title, error[1])
            return
        flag = 0
        for row, col in cells:
            value = table.getCellValue(row, col)
            if value[:len("uniform ")] != "uniform ":
                newValue = getNewUniform(col)
                table.setCellValue(row, col, newValue)
                flag = 1
        table.scrollToCell(curRow, curCol)
        #zeroGradientを書き込んだ場合保存flagをセット
        if flag == 1:
            self.alarmSaveFlagSet()

    #
    #  renamePatch
    #--------------
    def renamePatch(self):
        """ patch名の変更"""
        self.setStatus("renaming patch name...")
        #cellの変更内容をチェック
        if self.checkEditedFlag() == 1:
            #cell修正
            title = _(u"警告")
            mess = _(u"cell内容が変更されています。\nこのまま継続すると変更内容が失われます。\n　　継続しますか？")
            ans = self.okCancelDialog(title, mess)
            if ans != "OK":
                return
        #renameするpatch名を取得
        table = QtParts.tableWidget(self.tableWidget)
        cells = table.selectedCells()
        rows = list(set(map(lambda x: x[0], cells)))
        if len(rows) > 1:
            title = _("エラー")
            mess = _("renameするpatchが複数選択されています。") + "\n"
            mess += _("  選択し直してください。")
            self.errDialog(title, mess)
            return
        elif len(rows) == 0:
            title = _("エラー")
            mess = _("renameするpatch行が選択されていません。") + "\n"
            mess += _("  行をを選択し直してください。")
            self.errDialog(title, mess)
            return
        #選択行を確認
        row = rows[0]
        stRow = self.getStRowFromGrid()
        if row < stRow:
            title = _("エラー")
            mess = _("選択行は、patch行ではありません。")
            self.errDialog(title, mess)
            return
        #renameするpatch名を取得
        rowNames = list(map(lambda x: x[0], self.patchConts))
        delPatchName = table.getRowLabelValue(row)
        delPatchName = delPatchName.replace("\n", "")
        title = _(u"patch名変更")
        message = _(u"patch名を変更します")
        delText = delPatchName
        dialog = inputTextQtDialog.Ui_Dialog(title, message, delText, self.MainWindow)
        newPatchName = dialog.main()
        if (newPatchName != "") and (newPatchName != delPatchName):
            if newPatchName in rowNames:
                title = _("エラー")
                mess = _("「") + newPatchName + _("」は同じpatch名が存在します")
                self.errDialog(title, mess)
                return
            #patch名を変更
            error = self.changePatchName(delPatchName, newPatchName)
            if error[0] != "OK":
                self.errDialog(_("エラー"), error[1])
                return
            #再読み込み
            self.reload()
            #patch名をsortしている場合、rowNoが変わるので、rowNoを再確認
            table.unselectAll()
            for row in range(self.tableWidget.rowCount()):
                if table.getRowLabelValue(row) == newPatchName:
                    break
            table.selectRow(row)
            table.scrollToCell(row, 0)
            print(_("patch名を変更しました"))

    def changePatchName(self, oldPatchName, newPatchName):
        """ patchNameを変更する"""
        error = pyTreeFoam.case().changePatchName(self.boundaryDir,
                self.fieldDir, self.fields, oldPatchName, newPatchName)
        return error

    #
    #  deleteNulPatch
    #-----------------
    def deleteNulPatch(self):
        """ 空patchを削除する。"""

        def deletePatch(delPatch):
            """ patchを削除"""
            error = ""
            delPatchConts = list(filter(lambda x: x[0]==delPatch, self.patchConts))
            nFaces = delPatchConts[0][2]
            if nFaces != "0":
                error = _(u"削除するpatchは、空patchではありません。\n削除できません。")
                return error
            case = pyTreeFoam.case(self.caseDir)
            fields = case.getFieldNames(self.timeFolder, self.region)
            error = case.deletePatch(self.boundaryDir, self.fieldDir, fields, delPatch)
            return error

        #保存を確認
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        #削除するpatch名を取得
        table = QtParts.tableWidget(self.tableWidget)
        cells = table.selectedCells()
        selRows = list(set(map(lambda x: x[0], cells)))
        if len(selRows) == 0:
            title = _("エラー")
            mess = _("patch行が選択されていません。") + "\n"
            mess += _("  削除する空patchを選択してください。")
            self.errDialog(title, mess)
            return
        selRows.sort()
        stRow = self.getStRowFromGrid()
        if selRows[0] < stRow:
            title = _("エラー")
            mess = _("選択行は、patch行ではありません。")
            self.errDialog(title, mess)
            return
        #patchを削除
        for row in selRows:
            delPatchName = table.getRowLabelValue(row)
            delPatchName = delPatchName.replace("\n", "")
            error = deletePatch(delPatchName)
            if error != "":
                break
        if error != "":
            title = _(u"エラー")
            mess = error
            self.errDialog(title, mess)
            return
        #再読み込み
        self.reload()
        table.scrollToCell(selRows[0], 0)
        print(_("空patchを削除しました"))

    #
    #  editCellValue
    #----------------
    def editCellValue(self):
        """ cell内容をEditorで編集する"""
        (row, col) = QtParts.tableWidget(self.tableWidget).currentCell()
        error = self.runCellEditor(row, col)
        if error != "OK":
            title = _(u"エラー")
            mess = _(u"選択したcellは、Editorで編集できません。")
            self.errDialog(title, mess)

    def runCellEditor(self, row, col):
        """ cell内容をeditorで編集する。cell内の行数が多い場合。"""
        error = "OK"
        if col < 1:
            return "NG"
        table = QtParts.tableWidget(self.tableWidget)
        label = table.getColLabelValue(col)
        field = label.split("\n")[0]
        rowInt = self.getPosInternalRow()       #internalFieldの行
        rowName = self.getStRowFromGrid()       #boundaryFieldの行
        #internalField?
        if row == rowInt:
            nLines = self.getEditCellInternalFieldData(field)
            if self.checkEditLines(nLines) == "OK":
                #threadで起動する（cellには反映させない）
                th = threading.Thread(target=self.editInternalData, args=(field,))
                th.start()
        #boundaryField?
        elif row >= rowName:
            label = table.getRowLabelValue(row)
            patchName = label.replace("\n", "")
            #tempFileを作成し、その行数を取得する
            nLines = self.getEditCellBoundaryFieldData(field, patchName)
            if self.checkEditLines(nLines) == "OK":
                #threadで起動する（cellには反映させない）
                th = threading.Thread(target=self.editPatchData, args=(field, patchName))
                th.start()
        else:
            error = "NG"
        return error

    def editInternalData(self, field):
        """ internal内容をeditorで編集"""
        edit = self.editCellEditor(field, "")
        #編集したか？
        if edit == "edited":
            #編集内容を置き換え
            _newCont = self.setEditCellInternalFieldData(field)

    def editPatchData(self, field, patchName):
        """ patch内容をeditorで編集"""
        edit = self.editCellEditor(field, patchName)
        #編集したか？
        if edit == "edited":
            #置き換え
            _newCont = self.setEditCellBoundaryFieldData(field, patchName)

    def reformBoundaryFieldCellData(self, newCont):
        """ 空白を圧縮する。"""
        patchCont = newCont.split("\n")
        if len(patchCont) > self.maxRowsInCell:
            conts = patchCont[:self.maxRowsInCell]
            conts[-1] += "..."
        else:
            conts = patchCont
        #空白を圧縮
        cont = "\n".join(conts)
        newCont = pyTreeFoam.strOp(cont).compressSPCR()
        return newCont

    def refoamInternalFieldCellData(self, contents):
        """ internalFieldデータを整形する。
        「internalField」文字を削除して、
        maxRowsInCellInternalの値（5行）の行数に縮める"""
        contentsOp = pyTreeFoam.strOp(contents)
        (keyword, pp) = contentsOp.getKeyword(0)
        if keyword == "internalField":
            (keyword , pp) = contentsOp.getKeyword(pp)
        #pointerをkeywordの頭に戻す        
        pp = pp - len(keyword)
        #表示内容を取得
        cont = contents[pp:]
        if keyword == "uniform":
            a = cont
        else:
            lines = contents[pp:].split("\n")
            if len(lines) > self.maxRowsInCellInternal:
                a = "\n".join(lines[:self.maxRowsInCellInternal]) + "..."
            else:
                a = "\n".join(lines)
        return a

    def setEditCellBoundaryFieldData(self, field, patchName):
        """ boundaryFieldDataを書き換える。"""
        returnCont = ""
        fieldName = self.fieldDir + "/" + field
        tempFileName = self.getCellEditTempFileName(field, patchName)
        f = open(tempFileName); cont = f.read(); f.close()
        returnCont = cont
        conts = cont.split("\n")
        newConts = []
        for line in conts:
            if len(line) != 0:
                #数字、()、;で始まる行は、空白追加しない
                if (("0" <= line[0] and line[0] <= "9") or
                    line[0] == "(" or line[0] == ")" or
                    line[0] == ";"):
                    newConts.append(line)
                else:
                    newConts.append("        " + line)
        newCont = "\n".join(newConts)
        cont = pyTreeFoam.foamFile(self.nMaxLinesBinToAscii).read(fieldName)
        contOp = pyTreeFoam.strOp(cont)
        p = contOp.skipFoamFile()
        (boundCont, p) = contOp.getKeywordContents("boundaryField", p)
        boundContOp = pyTreeFoam.strOp(boundCont)
        sp = p - (len(boundCont)) - 1
        ep = p - 1
        newBoundConts = []
        lineCont = " "
        p = 0
        setFlag = 0
        while lineCont != "":
            (lineCont, p, kind) = boundContOp.get1line(p)
            if kind == "keyword":
                lineContOp = pyTreeFoam.strOp(lineCont)
                (keyword, _pp) = lineContOp.getKeyword(0)
                if pyTreeFoam.isPatternMatch([keyword], patchName) == True:
                    newCont = keyword + "\n    {\n" + newCont + "\n    }"
                    lineCont = newCont
                    setFlag = 1
            if len(lineCont.split()) > 0:
                newBoundConts.append("    " + lineCont)
        if setFlag == 0:
            lineCont = patchName + "\n    {\n" + newCont + "\n    }"
            newBoundConts.append("    " + lineCont)
        newBoundCont = "\n" + "\n".join(newBoundConts) + "\n"
        header = cont[:sp]
        footer = cont[ep:]
        contents = header + newBoundCont + footer
        pyTreeFoam.foamFile().write(fieldName, contents)
        return returnCont

    def getEditCellBoundaryFieldData(self, field, patchName):
        """ boundaryFieldDataを取得し、treeNo:gridNo:field.patchName.tempをtempフォルダに作成する。"""
        fieldName = self.fieldDir + "/" + field
        tempFileName = self.getCellEditTempFileName(field, patchName)
        cont = pyTreeFoam.foamFile(self.nMaxLinesBinToAscii).read(fieldName)
        contOp = pyTreeFoam.strOp(cont)
        p = contOp.skipFoamFile()
        (boundaryCont, p) = contOp.getKeywordContents("boundaryField", p)
        boundaryContOp = pyTreeFoam.strOp(boundaryCont)
        lineCont = " "
        p = 0
        while lineCont != "":
            (lineCont, p, kind) = boundaryContOp.get1line(p)
            if kind == "keyword":
                lineContOp = pyTreeFoam.strOp(lineCont)
                (keyword, _pp) = lineContOp.getKeyword(0)
                if pyTreeFoam.isPatternMatch([keyword], patchName) == True:
                    (patchCont, _pp) = lineContOp.getMiddlePair(0)
                    break
        if lineCont == "":
            patchCont = ""
            nLines = 0
        else:
            lines = patchCont.split("\n")
            newLines = []
            for line in lines:
                if len(line.split()) > 0:
                    i = 0
                    while i < 8 and line[i] == " ":
                        i += 1
                    newLine = line[i:]
                    newLines.append(newLine)
            nLines = len(newLines)
            patchCont = "\n".join(newLines)
        f = open(tempFileName, "w"); f.write(patchCont); f.close()
        return nLines

    def setEditCellInternalFieldData(self, field):
        """ internalFieldDataを書き換える。"""
        fieldName = self.fieldDir + "/" + field
        tempFileName = self.getCellEditTempFileName(field, "")
        cont = pyTreeFoam.foamFile(self.nMaxLinesBinToAscii).read(fieldName)
        contOp = pyTreeFoam.strOp(cont)
        p = contOp.skipFoamFile()
        p = contOp.getKeywordPointer("internalField", p)
        (_keyword, p) = contOp.getKeyword(p)
        (_chara, p) = contOp.skipNoChara(p)
        ps = p
        n = cont[ps:].find(";")
        p = ps + n
        pe = p + len(";")
        f=open(tempFileName); newCont=f.read(); f.close()
        fieldCont = cont[:ps] + newCont + cont[pe:]
        pyTreeFoam.foamFile().write(fieldName, fieldCont)
        return newCont

    def editCellEditor(self, field, patchName):
        """ cellEditorを起動。
        編集したかどうかをtimeStampを確認して、その結果を返す。
        
        Args:
            field:       field名
            patchName:   patch名、空文字は、internalField
        Returns:
            ans:     "edited" or "noEdit" """
        editFileName = self.getCellEditTempFileName(field, patchName)
        timeStampBefore = os.path.getmtime(editFileName)
        pyTreeFoam.run().editorWait([editFileName])
        timeStampAfter = os.path.getmtime(editFileName)
        
        

        #timeStampを確認し、編集有無を確認
        if timeStampAfter > timeStampBefore:
            ans = "edited"
        else:
            ans = "noEdit"
        #編集有無を返す
        return ans

    def checkEditLines(self, nLines):
        """ 編集する行数をチェックする。"""
        ans = "OK"
        if nLines > 500:
            title = _(u"cellの編集")
            mess = _(u"編集する行数が、500行を越えています。\n\n本当に編集しますか？")
            ans = self.okCancelDialog(title, mess)
        return ans

    def getEditCellInternalFieldData(self, field):
        """ internalFieldDataを取得し、treeNo:gridNo:field..tempをtempフォルダに作成する。"""
        fileName = self.fieldDir + "/" + field
        wFileName = self.getCellEditTempFileName(field, "")
        cont = pyTreeFoam.foamFile(self.nMaxLinesBinToAscii).read(fileName)
        contOp = pyTreeFoam.strOp(cont)
        p = contOp.skipFoamFile()
        p = contOp.getKeywordPointer("internalField", p)
        (_keyword, p) = contOp.getKeyword(p)
        (_chara, p) = contOp.skipNoChara(p)
        ps = p
        n = cont[ps:].find(";")
        p = ps + n
        pe = p + len(";")
        internalCont = cont[ps:pe]
        fw = open(wFileName, "w"); fw.write(internalCont); fw.close()
        nLines = len(internalCont.split("\n"))
        return nLines

    def getCellEditTempFileName(self, field, patchName):
        """ cellEdit用のtempFile名を取得する。"""
        gridTitle = self.windowTitle
        (nTreeGrid, _p) = pyTreeFoam.strOp(gridTitle).getSmallPair(0)
        name = nTreeGrid + ":" + field + "." + patchName + ".temp"
        fileName = os.getenv("TreeFoamUserPath") + "/temp/" + name
        return fileName

    #
    #  hideFields
    #-------------
    def hideFields(self):
        """ 選択したfieldを非表示"""
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        noDispFields = []
        #選択範囲を取得
        table = QtParts.tableWidget(self.tableWidget)
        cells = table.selectedCells()
        if len(cells) == 0:
            (_curRow, curCol) = table.currentCell()
            noDispFields.append(curCol)
        else:
            cols = list(set(map(lambda x: x[1], cells)))
            noDispFields = cols
        noDispFields.sort()
        #非表示列が0列かどうかチェック
        if noDispFields[0] == 0:
            noDispFields = noDispFields[1:]
        #非表示field名を取得
        colNames = self.fields
        hideFieldNames = list(map(lambda x: colNames[x-1], noDispFields))
        #colNamesを修正
        colNames = list(set(colNames).difference(hideFieldNames))
        colNames.sort()
        #fieldDataを修正する
        self.deleteFieldData(colNames)
        #dispFieldsを作成する
        self.saveDisplayFields()
        #gridを再表示させる。
        self.remakeGrid()
        #cellを選択表示させる
        table.unselectAll()
        selRow = 0
        selCol = noDispFields[0]
        table.selectCell(selRow, selCol)

    def deleteFieldData(self, colNames):
        """ 読み込んだfildDataから削除して、colNamesに合わせる。"""
        newFields = []
        newPatchData = []
        newDimData = []
        newIntData = []
        newVarData = []
        newVarBndData = []
        for i in range(len(self.fields)):
            field = self.fields[i]
            if (field in colNames):
                newFields.append(field)
                newPatchData.append(self.patchData[i])
                newDimData.append(self.dimData[i])
                newIntData.append(self.intData[i])
                newVarData.append(self.varData[i])
                newVarBndData.append(self.varBndData[i])
        self.fields = newFields
        self.patchData = newPatchData
        self.dimData = newDimData
        self.intData = newIntData
        self.varData = newVarData
        self.varBndData = newVarBndData

    #
    #  changeOrder
    #--------------
    def changeOrder(self):
        """ fieldの表示、非表示、表示順の設定"""
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        case = pyTreeFoam.case(self.caseDir)
        currTime = self.timeFolder
        allFields = case.getFieldNames(currTime, self.region)
        allFields.sort()
        hideNames = list(set(allFields).difference(self.fields))
        hideNames.sort()
        ans = self.fieldsHideShowDialog(self.fields, hideNames)
        #CANCEL?
        if len(ans) == 0:
            #CANCEL時は直ぐに戻る
            return
        self.fields = ans
        dispFileName = self.getSaveDisplayFieldsFileName()
        if self.fields == allFields:
            #全field表示の為、displayFieldを削除する
            if len(glob.glob(dispFileName)) != 0:
                os.remove(dispFileName)
        else:
            #displayFieldを書き換える
            newCont = "\n".join(self.fields) + "\n"
            f = open(dispFileName, "w"); f.write(newCont); f.close()
        self.reload()

    #
    #  tableEditorClose
    #-------------------
    def tableEditorClose(self):
        """ cellに組み込まれたtextEditorが終了した時の処理。
        編集後のtextをcellに挿入し、editorを閉じる"""
        #編集itemを取得
        item = self.Table.currentItem()
        self.Table.closePersistentEditor(item)
        index = self.Table.indexFromItem(item)
        #編集したtextを取得
        newText = self.Table.newText
        if newText != None:
            #textを修正
            newText = pyTreeFoam.strOp(newText).compressSPCR()
            #textをitemに設定
            row = index.row()
            col = index.column()
            QtParts.tableWidget(self.tableWidget).setCellValue(row, col, newText)
        self.Table.newText = None
        #font色をセット
        stRow = self.getStRowFromGrid()
        row = index.row()
        col = index.column()
        self.setFontColour(row, col, stRow)

    #
    #  tableItemChanged
    #---------------------
    def tableItemChanged(self, item):
        """ 内容が修正された場合のflagをセット。
        Dialogのtitleを修正"""
        self.alarmSaveFlagSet()
        row = item.row()
        col = item.column()
        QtParts.tableWidget(self.tableWidget).adjustCell(row, col)

    def alarmSaveFlagSet(self):
        """ gridのtitleに「*」マークを追加する"""
        title = self.windowTitle
        currFlag = title.split(":")[1][0]
        if currFlag != "*":
            newTitle = title.split(":")
            newTitle[1] = "*" + newTitle[1][1:]
            title = ":".join(newTitle)
            self.MainWindow.setWindowTitle(title)
            self.windowTitle = title
        #edit禁止cellのチェック
        if self.noEditCell[:2] == [-1, -1]:
            return
        else:
            row = self.noEditCell[0]
            col = self.noEditCell[1]
            cellCont = self.noEditCell[2]
            #self.grid_1.SetCellValue(row, col, cellCont)
            QtParts.tableWidget(self.tableWidget).setCellValue(row, col, cellCont)
            title = _(u"編集禁止")
            mess = _(u"このcellは、編集禁止cellです。\n変更内容は反映されません。")
            self.warningDialog(title, mess)

    def alarmSaveFlagClear(self):
        """ 保存flagをクリア"""
        #title = self.GetTitle()
        title = self.windowTitle
        currFlag = title.split(":")[1][0]
        if currFlag == " ":
            return
        else:
            newTitle = title.split(":")
            newTitle[1] = " " + newTitle[1][1:]
            title = ":".join(newTitle)
            self.windowTitle = title
            self.MainWindow.setWindowTitle(title)

    #
    #  colLabelDclick
    #-----------------
    def colLabelDclick(self, curCol):
        """ 列名をダブルクリックした時"""
        if curCol >= 1:
            field = self.fields[curCol-1]
            fieldDir = self.fieldDir
            openFile = fieldDir + "/" + field
            self.runEditorAsciiBinaryFile(openFile)
        elif curCol == 0:
            openFile = self.boundaryDir + "/boundary"
            pyTreeFoam.run().editor([openFile])

    def runEditorAsciiBinaryFile(self, openFile):
        """ fileをeditorで開き、編集する。
        file内容は、foamFile.readで読み込んで編集する。"""
        if self.nMaxLinesBinToAscii > 0:
            title = _(u"fileの編集")
            mess = _(u"nonuniform List の行は、「") + str(self.nMaxLinesBinToAscii) + _(u"」ヶのデータのみ表示します。\n")
            mess += u"    xxxx nonuniform List<xxx>\n"
            mess += u"    xx(xxx xxx xxx...);\n"
            mess += _(u"binaryの場合は、nonuniform Listを含む行は、編集できません。")
            mess += _(u"asciiの場合は、nonuniform Listのデータ数が「") + str(self.nMaxLinesBinToAscii) + _(u"」以下の場合、編集できます。\n")
            mess += _(u"データ数が「") + str(self.nMaxLinesBinToAscii) + _(u"」ヶを越える場合は、nonuniform Listを含む行のみ編集できません。")
            self.okDialog(title, mess)
        tempFolder = os.getenv("TreeFoamUserPath") + "/temp"
        path = os.getenv("TreeFoamPath") + "/python"
        comm = path + "/editFoamFile.py -t " + tempFolder + " -n " + str(self.nMaxLinesBinToAscii) + " " + openFile + " &"
        pyTreeFoam.run().command(comm)

    #
    #  rowLabelDclick
    #-----------------
    def rowLabelDclick(self, curRow):
        """ 行名をダブルクリック"""
        posRowName = self.getStRowFromGrid()
        if curRow >= posRowName:
            self.renamePatch()

    #
    #  showColPopupMenu
    #-------------------
    def showColPopupMenu(self, pos):
        """ columnのpopupMenuを表示する。"""
        menu = QMenu()
        menu.addAction(_("全表示/非表示fieldの切替え"), self.onSwitchAllorHideFields)
        menu.addAction(_("選択したfieldを非表示"), self.onHideFields)
        menu.addAction(_("field表示順変更"), self.onChangeOrder)
        menu.addSeparator()
        menu.addAction(_("fieldコピー"), self.onCopyFields)
        menu.addAction(_("field貼付(挿入)"), self.onPasteFields)
        menu.addSeparator()
        menu.addAction(_("field名変更"), self.onRenameField)
        menu.addAction(_("field削除"), self.onDeleteFields)
        #menu設定
        if getPyQtModule.UiCode == "Qt6":
            menu.exec(self.tableWidget.mapToGlobal(pos))
        elif getPyQtModule.UiCode == "Qt4":
            menu.exec_(self.tableWidget.mapToGlobal(pos))    

    #
    #  showRowPopupMenu
    #-------------------
    def showRowPopupMenu(self, pos):
        """ rowのpopupMenuを表示する。"""
        #menu = QtGui.QMenu()
        menu = QMenu()
        menu.addAction(_("行コピー"), self.onCopyRows)
        menu.addAction(_("行貼付"), self.onPasteRows)
        menu.addSeparator()
        menu.addAction(_("patch名sortする/しない切替え"), self.onSwitchPatchSort)
        menu.addAction(_("cell内の表示行数・データ数変更"), self.onChangeMaxLines)
        menu.addSeparator()
        menu.addAction(_("patch名変更"), self.onRenamePatch)
        menu.addAction(_("新しい空patch追加"), self.onAddNullPatch)
        menu.addAction(_("空patch削除"), self.onDeleteNullPatch)
        menu.addAction(_("全ての空patch削除"), self.onDeleteAllNullPatch)
        menu.addSeparator()
        menu.addAction(_("変数定義行（空）の表示/非表示切り替え"), self.onShowVariableRow)
        #Qtのversionに応じて処理
        if getPyQtModule.UiCode == "Qt6":
            menu.exec(self.tableWidget.mapToGlobal(pos))
        elif getPyQtModule.UiCode == "Qt4":
            menu.exec_(self.tableWidget.mapToGlobal(pos))    

    #
    #  showCellRclick
    #-----------------
    def showCellRclick(self, pos):
        """ cellのpopupMenuを表示する。"""
        menu = QMenu()

        actionCopy = QAction(self.iconCopy, _("cellコピー"), self.tableWidget)
        actionCopy.setShortcut("Ctrl+C")
        actionCopy.setIconVisibleInMenu(True)
        actionCopy.triggered.connect(self.copyCell)
        menu.addAction(actionCopy)

        actionPaste = QAction(self.iconPaste, _("cell貼付"), self.tableWidget)
        actionPaste.setShortcut("Ctrl+V")
        actionPaste.setIconVisibleInMenu(True)
        actionPaste.triggered.connect(self.pasteCell)
        menu.addAction(actionPaste)
        
        menu.addAction(_("cell内容をeditorで編集"), self.onEditor)
        menu.addSeparator()
        
        actionClearUniform = QAction(self.iconClearUniform, _("internalFieldのクリア"), self.tableWidget)
        actionClearUniform.setIconVisibleInMenu(True)
        actionClearUniform.triggered.connect(self.clearUniform)
        menu.addAction(actionClearUniform)

        actionClearZeroGrad = QAction(self.iconClearZeroGrad, _("空白cellにzeroGradientをセット"), self.tableWidget)
        actionClearZeroGrad.setIconVisibleInMenu(True)
        actionClearZeroGrad.triggered.connect(self.clearZeroGradient)
        menu.addAction(actionClearZeroGrad)

        menu.addAction(_("cell内容をクリア（空白cell作成）"), self.onClearCells)
        menu.addSeparator()
        menu.addAction(_("全表示/非表示fieldの切替え"), self.onSwitchAllorHideFields)
        menu.addAction(_("選択したfieldを非表示"), self.onHideFields)
        menu.addAction(_("field表示順変更"), self.onChangeOrder)
        menu.addSeparator()
        menu.addAction(_("cell内の表示行数・データ数変更"), self.onChangeMaxLines)
        #Qtのversionに応じて処理
        if getPyQtModule.UiCode == "Qt6":
            menu.exec(self.tableWidget.mapToGlobal(pos))
        elif getPyQtModule.UiCode == "Qt4":
            menu.exec_(self.tableWidget.mapToGlobal(pos))    

    #
    #  switchAllOrHideFields
    #------------------------
    def switchAllOrHideFields(self):
        """ 全表示、非表示の切り替え"""
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        fileName = self.getSaveDisplayFieldsFileName()
        if len(glob.glob(fileName)) == 0:
            if len(glob.glob(fileName + ".bak")) == 0:
                title = _(u"全field表示/非表示設定")
                mess = _(u"非表示設定ファイルがありません。\n")
                mess += _(u"fieldの非表示設定を行ってください。")
                self.okDialog(title, mess)
            else:
                #非表示設定
                os.rename(fileName + ".bak", fileName)
                self.reload()
        else:
            #全field表示
            os.rename(fileName, fileName + ".bak")
            self.reload()
            #selectionの操作
            QtParts.tableWidget(self.tableWidget).unselectAll()
        #保存フラグクリア
        self.alarmSaveFlagClear()
    
    #
    #  copyFields
    #-------------
    def copyFields(self):
        """ fieldのコピー"""
        table = QtParts.tableWidget(self.tableWidget)
        #選択cellを取得
        cells = table.selectedCells()
        cols = list(set(map(lambda x: x[1], cells)))
        cols.sort()
        if cols[0] == 0:
            cols = cols[1:]
        if len(cols) == 0:
            title = _(u"エラー")
            mess = _(u"fieldが選択されていません")
            self.errDialog(title, mess)
            return
        #fieldDirを取得
        fieldNameDirs = []
        for col in cols:
            fieldName = self.fields[col - 1]
            fieldNameDir = self.fieldDir + "/" + fieldName
            fieldNameDirs.append(fieldNameDir)
        #clipBoardに保存
        print("copy--> clipBoard")
        f = open(self.clipBoard, "w")
        for val in fieldNameDirs:
            f.write(val + "\n")
        f.close()

    #
    #  pasteFields
    #--------------
    def pasteFields(self):
        """ fieldの貼り付け（挿入）"""
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        #pasteFieldsDir,Nameを取得
        f = open(self.clipBoard); contents = f.readlines(); f.close()
        pasteFieldsDir = []
        pasteFieldsName = []
        for fieldDir in contents:
            name = fieldDir[:-1].split("/")[-1]
            pasteFieldsName.append(name)
            pasteFieldsDir.append(fieldDir[:-(len(name)+1)])
        #貼り付けるデータが正しいデータかどうかをチェック
        mess = ""
        for i in range(len(pasteFieldsName)):
            pasteDir = pasteFieldsDir[i] + pasteFieldsName[i]
            if len(glob.glob(pasteDir)) == 0:
                title = _(u"エラー")
                mess = _(u"貼り付けるデータが間違っています。\n貼付を中止します。")
                self.errDialog(title, mess)
                break
        if mess != "":
            return
        #fieldNameのチェック
        fields = pyTreeFoam.case(self.caseDir).getFieldNames(self.timeFolder, self.region)
        newPasteName = []
        for pasteName in pasteFieldsName:
            i = 0; flag = 0
            newName = pasteName
            while True:
                newName = pasteName + "_copy" + str(i)
                if newName in fields:
                    i += 1
                else:
                    break
            newPasteName.append(self.fieldDir + "/" + newName)
        #fieldを貼り付ける
        for i in range(len(pasteFieldsName)):
            copyName = pasteFieldsDir[i] + pasteFieldsName[i]
            pasteName = newPasteName[i]
            shutil.copy(copyName, pasteName)
        print("paste --->", pasteName)
        #grid再表示
        fileName = self.getSaveDisplayFieldsFileName()
        if len(glob.glob(fileName)) == 0:
            self.reload()
        else:
            dispNames = self.getDisplayFields()
            cells = QtParts.tableWidget(self.tableWidget).selectedCells()
            cols = list(set(map(lambda x: x[1], cells)))
            insCol = cols[0]
            i = 0; newNames = []
            while i < insCol:
                newNames.append(dispNames[i])
                i += 1
            for nameDir in newPasteName:
                newNames.append(nameDir.split("/")[-1])
            while i < len(dispNames):
                newNames.append(dispNames[i])
                i += 1
            self.fields = newNames
            self.saveDisplayFields()
            self.reload()

    #
    #  renameField
    #--------------
    def renameField(self):
        """ field名変更"""
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()

        table = QtParts.tableWidget(self.tableWidget)
        cells = table.selectedCells()
        cols = list(set(map(lambda x: x[1], cells)))
        if len(cols) != 1:
            title = _(u"エラー")
            mess = _(u"複数のfieldは選択しないでください。\n1個のfieldを選択して、field名を変更してください")
            self.errDialog(title, mess)
            return
        fieldName = self.fields[cols[0]-1]
        title = _(u"field名の変更")
        message = _(u"新しいfield名を入力してください")
        defText = fieldName
        #field名のチェック
        flag = 0
        while flag == 0:
            dialog = inputTextQtDialog.Ui_Dialog(title, message, defText, self.MainWindow)
            newName = dialog.main()
            if newName == "":
                flag = 1
            else:
                if len(glob.glob(self.fieldDir + "/" + newName)) != 0:
                    mess = _(u"同じ名前のfieldがあります。再入力してください。")
                    defText = newName
                else:
                    flag = 1
        if newName == "":
            return
        #field名の変更
        oldDir = self.fieldDir + "/" + fieldName
        newDir = self.fieldDir + "/" + newName
        os.rename(oldDir, newDir)
        #grid表示
        idx = self.fields.index(fieldName)
        self.fields[idx] = newName
        self.saveDisplayFieldsIfFile()
        self.reload()

    #
    #  deleteFields
    #---------------
    def deleteFields(self):
        """ fieldの削除"""
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()

        table = QtParts.tableWidget(self.tableWidget)
        cells = table.selectedCells()
        cols = list(set(map(lambda x: x[1], cells)))
        (curRow, curCol) = min(cells)
        delNames = []
        delNameDirs = []
        for col in cols:
            name = self.fields[col - 1]
            nameDir = self.fieldDir + "/" + name
            delNames.append(name)
            delNameDirs.append(nameDir)
        #field削除の確認メッセージ
        title = _(u"fieldの削除")
        mess = _(u"次のfieldを完全に削除します。\n")
        for n in range(len(delNames)):
            mess += delNames[n] + ", "
        mess = mess[:-2]
        ans = self.okCancelDialog(title, mess)
        if ans != "OK":
            return
        #field削除
        for i in range(len(delNameDirs)):
            #ファイルを削除
            os.remove(delNameDirs[i])
        #grid再表示
        newFields = list(set(self.fields).difference(delNames))
        self.fields = newFields
        self.saveDisplayFieldsIfFile()
        self.reload()
        #cursor, selectionを操作
        table.unselectAll()
        table.selectCell(curRow, curCol)

    #
    #  switchPatchSort
    #------------------
    def switchPatchSort(self):
        """ patchNameをsortして表示させる。"""
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()

        if self.sortPatchName == "yes":
            self.sortPatchName = "no"
        else:
            self.sortPatchName = "yes"
        self.writeConfigData()
        self.reload()
        print(_("patch名をsortしました。"))

    #
    #  changeMaxLines
    #-----------------
    def changeMaxLines(self):
        """ 表示行数、データ数を取得。"""
        #警告を表示
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()

        #行数変更dialogを表示
        result = self.getMaxLinesDialog(
                    self.maxRowsInCellInternal,
                    self.maxRowsInCell,
                    self.nMaxLinesBinToAscii)
        if len(result) == 0:
            return
        #値を設定
        self.maxRowsInCellInternal = result[0]
        self.maxRowsInCell = result[1]
        self.nMaxLinesBinToAscii = result[2]
        #値を書き込み
        self.writeConfigData()
        #gridEditor再表示
        self.reload()

    #
    #  addNullPatch
    #---------------
    def addNullPatch(self):
        """ 空patchを追加する。"""

        def getLatestFaceNo():
            """ patchContsから最後のfaceNoを取得する。"""
            faces = []
            for patchCont in self.patchConts:
                nFaces = int(patchCont[2])
                startFace = int(patchCont[3])
                faces.append([nFaces, startFace])
            faces.sort(key=lambda x: x[1])
            latestFaceNo = sum(faces[-1])
            return str(latestFaceNo)

        def addNullPatchToPatchConts(nInsert, patchConts, startFaceNo):
            """ patchContsに空patchを追加する。"""
            #「newPatch_」のpatch名を取得
            newPatchNames = []
            currPatchNames = list(map(lambda x: x[0], patchConts))
            n = 0
            for _i in range(nInsert):
                newName = "newPatch_" + str(n)
                while newName in currPatchNames:
                    n += 1 
                    newName = "newPatch_" + str(n)
                newPatchNames.append(newName)
                currPatchNames.append(newName)
            #patchContsを再作成
            for newPatchName in newPatchNames:
                patchCont = [newPatchName, "type patch;\n", "0", str(startFaceNo)]
                patchConts.append(patchCont)
            return (patchConts, newPatchNames)

        def writePatchContsToBoundary(patchConts):
            """ patchContsの内容をboundaryに保存する"""
            #新しいpatchContを作成する
            tab2 = 12
            patches = str(len(patchConts)) + "\n"   #patch数
            patches += "(\n"
            for patchCont in patchConts:
                patchTypes = patchCont[1].split("\n")
                patchTypes = list(filter(lambda x: x!="", patchTypes))
                patches += "    " + patchCont[0] + "\n"
                patches += "    {\n"
                for patchType in patchTypes:
                    words = patchType.split()
                    patches += "        " + words[0] + (tab2-len(words[0]))*" " + " ".join(words[1:]) + "\n"
                patches += "        nFaces      " + patchCont[2] + ";\n"
                patches += "        startFace   " + patchCont[3] + ";\n"
                patches += "    }\n"
            patches += ")"
            #boundaryの読み込み
            fileName = self.boundaryDir + "/boundary"
            cont = pyTreeFoam.foamFile().read(fileName)
            #boundaryを修正
            contOp = pyTreeFoam.strOp(cont)
            p = contOp.skipFoamFile()
            (keyword, p) = contOp.getKeyword(p)
            pst = p - len(keyword)
            (_pairCont, ped) = contOp.getSmallPair(p)
            newCont = cont[:pst] + patches + cont[ped:]
            #boundaryを書き込み
            pyTreeFoam.foamFile().write(fileName, newCont)
            return

        def writePatchDataToFields(newPatchNames):
            """ 各fieldに空patchを追加する。"""
            #追加するpatchを作成
            addPatch = ""
            for patchName in newPatchNames:
                addPatch += "    " + patchName + "\n"
                addPatch += "    {\n"
                addPatch += "        type            zeroGradient;\n"
                addPatch += "    }\n"
            #各fieldにpatchを追加
            case = pyTreeFoam.case(self.caseDir)
            allFields = case.getFieldNames(self.timeFolder, self.region)
            for field in allFields:
                fileName = self.fieldDir + "/" + field
                cont = pyTreeFoam.foamFile().read(fileName)
                contOp = pyTreeFoam.strOp(cont)
                p = contOp.skipFoamFile()
                (_bndCont, p) = contOp.getKeywordContents("boundaryField", p)
                pe = p - 1
                header = cont[:pe]
                footer = cont[pe:]
                #patchを追加する
                newCont = header + addPatch + footer
                #fileに書き込み
                pyTreeFoam.foamFile().write(fileName, newCont)
            return

        #保存を確認
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        #挿入行数を取得
        table = QtParts.tableWidget(self.tableWidget)
        cells = table.selectedCells()
        rows = list(set(map(lambda x: x[0], cells)))
        nInsert = len(rows)
        #patchContsを再作成
        startFaceNo = getLatestFaceNo()
        patchConts = pyTreeFoam.case(self.caseDir).getPatchNameFromBoundary(self.boundaryDir)
        (newPatchConts, newPatchNames) = addNullPatchToPatchConts(nInsert, patchConts, startFaceNo)
        #boundaryを再作成
        writePatchContsToBoundary(newPatchConts)
        #各field内を修正
        writePatchDataToFields(newPatchNames)
        #再読み込み
        self.reload()
        print(_("空pathを追加しました。"))
        #newpatchNameの行をselectさせる
        table.unselectAll()
        stRow = self.getStRowFromGrid()
        rowNames = list(map(lambda x: x[0], self.patchConts))
        for patchName in newPatchNames:
            idx = rowNames.index(patchName)
            selRow = stRow + idx
            table.selectRow(selRow)
        #追加した空patchが1ヶの場合は、patch名の入力を促す
        if nInsert == 1:
            self.renamePatch()

    #
    #  deleteNullPatch
    #------------------
    def deleteNullPatch(self):
        """ 空patchを削除する。"""

        def deletePatch(delPatch):
            """ patchを削除"""
            error = ""
            delPatchConts = list(filter(lambda x: x[0]==delPatch, self.patchConts))
            nFaces = delPatchConts[0][2]
            if nFaces != "0":
                error = _(u"削除するpatchは、空patchではありません。\n削除できません。")
                return error
            case = pyTreeFoam.case(self.caseDir)
            fields = case.getFieldNames(self.timeFolder, self.region)
            error = case.deletePatch(self.boundaryDir, self.fieldDir, fields, delPatch)
            return error

        #保存を確認
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        #削除するpatch名を取得
        table = QtParts.tableWidget(self.tableWidget)
        cells = table.selectedCells()
        selRows = list(set(map(lambda x: x[0], cells)))
        #selRows = self.grid_1.GetSelectedRows()
        stRow = self.getStRowFromGrid()
        selRows = list(filter(lambda x: x>=stRow, selRows))
        if len(selRows) == 0:
            return
        #空patch削除
        title = _(u"空patchの削除")
        mess = _(u"patch「") + str(len(selRows)) + _(u"ヶ」を削除します。\n\n　　削除後は、元に戻せません。")
        ans = self.okCancelDialog(title, mess)
        if ans != "OK":
            return
        #patchを削除
        rowNames = list(map(lambda x: x[0], self.patchConts))
        for row in selRows:
            delPatchName = rowNames[row-stRow]
            error = deletePatch(delPatchName)
            if error != "":
                break
        if error != "":
            #エラー処理
            title = _(u"エラー")
            mess = error
            self.errDialog(title, mess)
        else:
            self.reload()
            #self.grid_1.SelectRow(selRows[0])
            print(_("空patchを削除しました"))

    #
    #  deleteAllNullPatch
    #---------------------
    def deleteAllNullPatch(self):
        """ 全ての空patchを削除する"""
        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        #nullPatchを取得
        #  nfaces="0"を取得する
        nullPatchConts = list(filter(lambda x: x[2]=="0", self.patchConts))
        if len(nullPatchConts) == 0:
            title = _("全ての空patch削除")
            mess = _("空patchが存在しません。")
            self.okDialog(title, mess)
            return
        #削除の確認
        nullPatches = list(map(lambda x: x[0], nullPatchConts))
        title = _(u"全ての空patch削除")
        mess = _(u"全ての空patchを削除しますか？\n")
        mess += _(u"「") + str(len(nullPatches)) + _(u"」")
        mess += _(u"個の空patchがあります。")
        stat = self.okCancelDialog(title, mess)
        if stat != "OK":
            return
        #nullPatchを削除
        case = pyTreeFoam.case(self.caseDir)
        fields = case.getFieldNames(self.timeFolder, self.region)
        error = ""
        for nullPatch in nullPatches:
            error = case.deletePatch(self.boundaryDir, self.fieldDir, fields, nullPatch)
            if error != "":
                print(error)
                break
        if error != "":
            title = _("エラー")
            self.errDialog(title, error)
            return
        print(_("全ての空patchを削除しました。"))
        self.reload()

    #
    #  showVariableRow
    #------------------
    def showVariableRow(self):
        """ 変数定義行の表示・非表示切り替え"""

        def nRowCellValue(row):
            """ row行内で値がセットされているcellの数を返す"""
            col = 0
            n = 0
            while col < self.tableWidget.columnCount():
                val = table.getCellValue(row, col)
                if len(val.split()) != 0:
                    n += 1
                col += 1
            return n

        flag = self.checkSaveReload()
        if flag == "CANCEL":
            return
        elif flag == "SAVE":
            self.saveGridEditor()
        #変数定義行の表示・非表示
        table = QtParts.tableWidget(self.tableWidget)
        if self.isVariable == False or self.isVariableBoundary == False:
            #表示
            self.isVariable = True
            self.isVariableBoundary = True
        else:
            #非表示
            if self.isVariable == True and self.isVariableBoundary == True:
                row = 1
                if nRowCellValue(row) == 0:
                    self.isVariable = False
                row = 3
                if nRowCellValue(row) == 0:
                    self.isVariableBoundary = False
            elif self.isVariable == False and self.isVariableBoundary == True:
                row = 2
                if nRowCellValue(row) == 0:
                    self.isVariableBoundary = False
            elif self.isVariable == True and self.isVariableBoundary == False:
                row = 1
                if nRowCellValue(row) == 0:
                    self.isVariable = False
        self.reload()
        return

    #
    #  clearCells
    #-------------
    def clearCells(self):
        """ 選択cellをクリアする"""
        table = QtParts.tableWidget(self.tableWidget)
        cells = table.selectedCells()
        if len(cells) == 0:
            cell = table.currentCell()
            cells.append(cell)
        for row, col in cells:
            table.setCellValue(row, col, "")

    #
    #  loadData
    #-----------
    def loadData(self):
        """ boundaryとfieldのデータを読み込む。
        読み込んだ結果は、クラスの属性に反映される。
        
        反映する属性:
            self.boundaryDir    :boundaryの親dir
            self.fieldDir       :各fieldの親dir
            self.fields         :読み取るfield名のlist
            self.patchConts     :boundaryのpatchとpatchType
            self.patchData      :各fieldのpatchとpatch内容
            self.dimData        :各fieldのdimensionの内容
            self.intData        :各fieldのinternalFieldの内容
            self.varData        :各fieldの全体変数の内容
            self.varBndData     :各fieldのboundary変数の内容
            """
        #dataを取得するfield名を取得
        case = pyTreeFoam.case(self.caseDir)
        allFieldNames = case.getFieldNames(self.timeFolder, self.region)
        allFieldNames.sort()
        dispFields = self.getDisplayFields()
        if len(dispFields) == 0:
            #dispFieldsが無い場合
            self.fields = allFieldNames
        else:
            #dispFieldsで設定されている場合
            self.fields = []
            for field in dispFields:
                if field in allFieldNames:
                    self.fields.append(field)
        #data読み込み
        ld = readBoundaryAndFields.load(
                    self.caseDir, self.timeFolder, self.region, self.fields,
                    self.maxRowsInCellInternal,
                    self.maxRowsInCell,
                    self.nMaxLinesBinToAscii)
        error = ld.data()
        if error != "":
            self.errDialog(_("エラー"), error)
        #dataをセット
        self.boundaryDir  = ld.boundaryDir
        self.fieldDir     = ld.fieldDir    
        self.fields       = ld.fields
        self.patchConts   = ld.patchConts
        self.patchData    = ld.patchData
        self.dimData      = ld.dimData
        self.intData      = ld.intData
        self.varData      = ld.varData
        self.varBndData   = ld.varBndData
        #patch名をsort
        self.sortPatchNameIfsort()

    def sortPatchNameIfsort(self):
        """ self.sortPatchName="yes"の場合、patch名をsortする。"""
        if self.sortPatchName != "yes":
            return
        #patch名をsortする。
        newNames = []
        for i in range(len(self.patchConts)):
            newNames.append([self.patchConts[i][0], i])
        newNames.sort()
        patchConts = []
        patchData = [[] for i in range(len(self.fields))]
        for _name, idx in newNames:
            patchConts.append(self.patchConts[idx])
            for i in range(len(self.fields)):
                patchData[i].append(self.patchData[i][idx])
        self.patchConts = patchConts
        self.patchData = patchData

    #
    #  displayFields関連
    #-----------------------
    def saveDisplayFieldsIfFile(self):
        """ .displayFieldsファイルが存在する時、書き換える。"""
        fileName = self.getSaveDisplayFieldsFileName()
        if len(glob.glob(fileName)) != 0:
            f = open(fileName); lines = f.readlines(); f.close()
            names = list(map(lambda x: x.split("\n")[0], lines))
            colNames = self.fields
            if names != colNames:
                self.saveDisplayFields()

    def saveDisplayFields(self):
        """ .displayFieldsファイルを書き換える。"""
        fileName = self.getSaveDisplayFieldsFileName()
        colNames = self.fields
        f= open(fileName, "w")
        for name in colNames:
            line = name + "\n"
            f.write(line)
        f.close()

    def getDisplayFields(self):
        """ .displayFieldファイルから表示するfield名を取得する"""
        fileName = self.getSaveDisplayFieldsFileName()
        if len(glob.glob(fileName)) != 0:
            f = open(fileName); cont = f.read(); f.close()
            fields = cont.split()
        else:
            fields = []
        return fields

    def getSaveDisplayFieldsFileName(self):
        """ displayFieldのpathを取得する"""
        case = pyTreeFoam.case(self.caseDir)
        timeFolders = case.getTimeFolders()
        firstTime = timeFolders[0]
        fileName = self.caseDir + "/" + firstTime + "/" + self.region + "/.displayField"
        fileName = os.path.abspath(fileName)
        return fileName

    #
    #  createMatrix
    #---------------
    def createMatrix(self):
        """ matrixデータからgridを作成する。
        gridの背景色、row, colのlabelを設定する。"""
        #eventをmaskする
        self.maskEvent = "yes"
        #表の大きさを設定
        if self.variableListSize(self.varData) > 0:
            self.isVariable = True
        if self.variableListSize(self.varBndData) > 0:
            self.isVariableBoundary = True
        rowNames = list(map(lambda x: x[0], self.patchConts))
        colNames = self.fields
        #rowLabel名（patch名）を修正(長名を複数行に分ける)
        rowNames = self.line2lines(rowNames, 12)
        #colLabel名に番号を振る
        colNames = self.addNumToNames(colNames)
        #label名を設定する
        labelName = "internal\nField" 
        if self.sortPatchName == "yes":
            labelName = "internal\nField\n<sort patch>"
        rowLabels = ["field type\ndimensions", labelName] + rowNames
        place = self.getPlacePolyMesh()         #boundaryの場所を取得
        colLabels = ["define patch\nat " + place + "\n(boundary)"] + colNames
        #背景色の行Noを取得用変数
        rowPink = 0
        rowBlue = []                #変数行
        rowYellow = 1               #internalField
        #rowLabelを再設定
        if self.isVariable == True:
            rowLabels = rowLabels[:1] + ["otherNames"] + rowLabels[1:]
            rowBlue.append(1)       #変数 1行目
            rowYellow += 1          #internalField
        if self.isVariableBoundary == True:
            if self.isVariable == True:
                rowLabels = rowLabels[:3] + ["otherNames\n(boundary)"] + rowLabels[3:]
                rowBlue.append(3)   #boundary変数 3行目
            else:
                rowLabels = rowLabels[:2] + ["otherNames\n(boundary)"] + rowLabels[2:]
                rowBlue.append(2)   #boundary変数 2行目
        #表を作成
        QtParts.tableWidget(self.tableWidget).createTable(rowLabels, colLabels)
        
        #背景色を設定
        table = QtParts.tableWidget(self.tableWidget)
        maxCol = self.tableWidget.columnCount()
        maxRow = self.tableWidget.rowCount()
        #  0列をyellowに設定
        for row in range(maxRow):
            table.setCellColor_yellow(row, 0)
        #  pink, yellowを設定
        for col in range(maxCol):
            table.setCellColor_pink(rowPink, col)
            table.setCellColor_yellow(rowYellow, col)
        #  blueを設定
        for i in range(len(rowBlue)):
            for col in range(maxCol):
                table.setCellColor_lightGreen(rowBlue[i], col)
        #maskEventを解除
        self.maskEvent = "no"

    def variableListSize(self, vars):
        """ vars内の「""」以外の個数を返す。"""
        return len(list(filter(lambda x: x != "", vars)))

    def getPlacePolyMesh(self):
        """ boundaryDirからpolyMeshの場所を返す"""
        dirList = self.boundaryDir.split("/")
        if dirList[-2] == "constant":
            place = "constant"
        elif dirList[-3] == "constant":
            place = "constant/" + dirList[-2]
        else:
            flag = 0
            try:
                _a=float(dirList[-2])
                place = dirList[-2]
                flag = 1
            except:
                flag = 0
            if flag == 0:
                try:
                    _a=float(dirList[-3])
                    place = dirList[-3] + "/" + dirList[-2]
                except:
                    place = "****"
        return place

    def line2lines(self, lines, length):
        """ lineをlength幅で複数lineに分割。
        文字列の長さがlength±length/2に収める。"""

        def isSeparateChara(chara):
            """ 分割文字かどうかチェック"""
            if "0" <= chara and chara <= "9":
                return False
            if "a" <= chara and chara <= "z":
                return False
            return True

        def findSeparatePoint(checkPart):
            """ linePartから最適な分割点を探す"""
            #checkPartの最終文字を分割点に追加。
            #正負で同じ文字幅が存在したときに、最終文字が優先される様に
            #幅を -0.5 小さく設定している。
            #          文字幅                      分割位置
            points = [[len(checkPart)-width-0.5, len(checkPart)]]
            #checkPart内の分割位置を検索
            for i in range(len(checkPart)):
                chara = checkPart[i]
                if isSeparateChara(chara) == True:
                    #分割位置を取得
                    disp = abs(-width + i)      #文字幅
                    points.append([disp, i])
            #文字幅の最小値の分割位置を取得
            points.sort()
            sepLoc = points[0][1]       #分割位置を取得
            return sepLoc            

        ans = []
        for j in range(len(lines)):
            line = lines[j]
            if len(line) < length:
                ans.append(line)
            else:
                p = 0
                words = []
                width = int(length * 0.5)
                while p < len(line):
                    #分割箇所を検索
                    sp = p + width
                    checkPart = line[sp:sp+length]

                    sepLoc = findSeparatePoint(checkPart)
                    sep = sp + sepLoc
                    words.append(line[p:sep])
                    p = sep
                #最終行の文字数を確認
                if len(words[-1]) <= 3:
                    #最終行が3文字以下の場合は、接続する
                    words[-2] += words[-1]
                    words = words[:-1]
                #分割行を接続
                newLine = "\n".join(words)
                ans.append(newLine)
        return ans

    def addNumToNames(self, names):
        """ name番号を追加する"""
        newNames = []
        i = 1
        for name in names:
            newName = name + "\n(" + str(i) + ")"
            newNames.append(newName)
            i += 1
        return newNames

    #
    #  setMatrixData
    #----------------
    def setMatrixData(self):
        """ gridTableのcellにデータをセットする。"""

        def deleteLastCR(cont):
            """ 最後の文字が"\n"の場合、最後の"\n"を削除する。"""
            if cont != "":
                if cont[-1] == "\n":
                    cont = cont[:-1]
            return cont

        #eventをmask
        self.maskEvent = "yes"
        #boundary内の各patchに定義されているpatch内容
        #  defineData = [[patchName, patchType, nFaces, startFace], ...]
        defineData = self.patchConts
        table = QtParts.tableWidget(self.Table)
        #配列を準備
        maxRow = self.tableWidget.rowCount()
        maxCol = self.tableWidget.columnCount()
        rowColVals = [ [ "" for i in range(maxCol)] for ii in range(maxRow)]
        #boundaryの列を作成
        col = 0
        i = 0
        addRow = 2
        if self.isVariable == True:
            addRow += 1
        if self.isVariableBoundary == True:
            addRow += 1
        while i < len(defineData):
            row = i + addRow
            items = defineData[i]
            patchType = items[1]
            patchType = deleteLastCR(patchType)
            rowColVals[row][col] = patchType
            #nFacesをチェック
            if items[2] == "0":
                #nfacesが「0」の場合、該当行をyellowに設定
                coll = 0
                while coll < maxCol:
                    table.setCellColor_yellow(row, coll)
                    coll += 1
            i += 1
        #  1列以降にデータをセット
        data = self.patchData
        col = 1
        for labels in data:
            i = 0
            while i < len(labels):
                row = i + addRow
                #データセット
                setLabel = labels[i]
                setLabel = deleteLastCR(setLabel)
                rowColVals[row][col] = setLabel
                i += 1
            col += 1
        #  0行にデータ（dimensions）をセット
        dimData = self.dimData
        row = 0
        col = 1
        for value in dimData:
            if len(value) != 0:
                value = deleteLastCR(value)
                rowColVals[row][col] = value
            col += 1
        #  1行にデータ（internalField）をセット
        row = 1
        if self.isVariable == True:
            #variablesをセット
            col = 1
            for value in self.varData:
                value = deleteLastCR(value)
                rowColVals[row][col] = value
                col += 1
            row += 1
        intData = self.intData
        col = 1
        for value in intData:
            value = deleteLastCR(value)
            rowColVals[row][col] = value
            col += 1
        row += 1
        if self.isVariableBoundary == True:
            #variablesBoundaryをセット
            col = 1
            for value in self.varBndData:
                value = deleteLastCR(value)
                rowColVals[row][col] = value
                col += 1
        #値をtableにセット
        for row in range(maxRow):
            for col in range(maxCol):
                value = rowColVals[row][col]
                table.setCellValue(row, col, value)

        #labelの色をセット
        self.setLabelColour()
        #cellのfontColorを設定
        self.setCellFontColour()
        #cell幅を調整
        table.adjustCells()
        #maskEventを解除
        self.maskEvent = "no"

    def setLabelColour(self):
        """ field非表示設定ファイルの有無チェック"""
        fileName = self.getSaveDisplayFieldsFileName()
        table = QtParts.tableWidget(self.tableWidget)
        if len(glob.glob(fileName)) != 0:
            #全fieldかどうかチェック
            case = pyTreeFoam.case(self.caseDir)
            currTime = self.timeFolder
            region = self.region
            allFields = case.getFieldNames(currTime, region)
            allFields.sort()
            if allFields != self.fields:
                #ラベル色をdarkblueにセット
                table.setLabelsFontColor_darkBlue()

    def setCellFontColour(self):
        """ cellのfont色を設定"""
        #maxRow = self.grid_1.GetNumberRows()
        maxRow = self.tableWidget.rowCount()
        colNames = self.fields
        #patchのstartRowNoを取得
        stRow = self.getStRowFromGrid()
        #field毎にfont色を設定
        col = 0
        while col < len(colNames) + 1:
            row = 0
            while row < maxRow:
                #fontの色をセット
                self.setFontColour(row, col, stRow)
                row += 1
            col += 1

    def setFontColour(self, row, col, stRow=0):
        """ font色をセットする"""
        table = QtParts.tableWidget(self.tableWidget)
        if col <= 0 or row < stRow:
            #0列、stRow以前は、systemFont色
            table.setCellFontColor_sysFontColor(row, col)            
        else:
            #1列以降は内容に応じた色
            cellCont = table.getCellValue(row, col).split("\n")[0]
            if cellCont == "type zeroGradient;":
                table.setCellFontColor_blue(row, col)
            elif cellCont == "type fixedValue;":
                table.setCellFontColor_brown(row, col)
            elif cellCont == "type empty;":
                table.setCellFontColor_darkGreen(row, col)
            else:
                table.setCellFontColor_sysFontColor(row, col)

    def getStRowFromGrid(self):
        """ 表中からpatchNameの初期位置（startRowNo）を取得する。
        変数を表示させることがある為、patchの行Noが変化する。"""
        stRow = 2
        #maxRow = self.grid_1.GetNumberRows()
        maxRow = self.tableWidget.rowCount()
        row = stRow
        while row < maxRow:
            patch = QtParts.tableWidget(self.tableWidget).getRowLabelValue(row)
            patch = "\n".join(patch.split("\n")[:2])
            if (patch != "otherNames" and patch != "internal\nField"
                and patch != "otherNames\n(boundary)" ):
                stRow = row
                break
            row += 1
        return stRow

    def getPosInternalRow(self):
        """ internalFieldの行Noを返す。"""
        posRowName = 1              #defaultの位置
        if self.isVariable == True:
            posRowName += 1
        return posRowName 


    #
    #  initializeGrid
    #-----------------
    def initializeGrid(self):
        """ title, windowSizeを設定する。"""
        #titleの設定
        #  gridNoを取得
        self.getCurrGridNo()
        #  titleを作成
        caseDirList = self.caseDir.split("/")
        fieldDirList = self.fieldDir.split("/")
        fieldDir = "/".join(fieldDirList[len(caseDirList[:-1]):])
        self.windowTitle = "gridEditor: " + fieldDir + " (" + self.nTreeFoam + ":" + self.gridNo + ")"
        #  titleを設定
        self.MainWindow.setWindowTitle(self.windowTitle)
        #widowSizeを設定
        (w, h) = self.getGridSize()
        self.MainWindow.resize(w, h)
        #statusBarをクリア
        self.clearStatus()

    def getCurrGridNo(self):
        """ 起動したgridEditorのgridNoを取得する。"""
        #gridListを読み込む
        fileName = self.nRunningGrid
        if len(glob.glob(fileName)) == 0:
            self.gridNo = "0"
            lines = []
        else:
            f = open(fileName); lines = f.readlines(); f.close()
            Nos = [-1]
            for line in lines:
                words = line.split()
                treefoamNo = words[0].split(":")[0]
                gridNo = words[0].split(":")[1]
                if treefoamNo == self.nTreeFoam:
                    Nos.append(int(gridNo))
            self.gridNo = str(max(Nos) + 1)
        newLine = " ".join([self.nTreeFoam + ":" + self.gridNo,
                            self.boundaryDir,
                            self.fieldDir,
                            self.caseDir]) + "\n"
        #今回分を書き込み
        lines.append(newLine)
        f = open(fileName, "w"); f.writelines(lines); f.close()

    def getGridSize(self):
        """ 前回起動時のwindowSizeを取得する"""
        fileName = os.getenv("TreeFoamUserPath") + "/data/winSize"
        ans = (500, 500)
        if len(glob.glob(fileName)) != 0:
            f = open(fileName); lines = f.readlines(); f.close()
            for line in lines:
                words = line.split()
                if len(words) >= 3:
                    if words[0] == "gridEditor":
                        ans = (int(words[1]), int(words[2]))
        return ans

    def saveGridSize(self, gridSize):
        """ windowSizeを保存する。"""
        fileName = os.getenv("TreeFoamUserPath") + "/data/winSize"
        if len(glob.glob(fileName)) != 0:
            f = open(fileName); lines = f.readlines(); f.close()
            flag = 0
            for i in range(len(lines)):
                words = lines[i].split()
                if len(words) >= 3:
                    if words[0] == "gridEditor":
                        words[1] = str(gridSize[0])
                        words[2] = str(gridSize[1])
                        lines[i] = " ".join(words) + "\n"
                        flag = 1
                        break
            if flag == 0:
                newLine = " ".join(["gridEditor", str(gridSize[0]), str(gridSize[1])]) + "\n"
                lines += [newLine]
        else:
            lines = [" ".join(["gridEditor", str(gridSize[0]), str(gridSize[1])]) + "\n"]
        f = open(fileName, "w"); f.writelines(lines); f.close()


    #
    #  initialize
    #-------------
    def initialize(self):
        """ 初期化"""
        #gridEditorの起動状況を確認
        self.getRunningGridEditor()
        #初期値の設定
        self.readConfigData()
        self.caseDir = os.path.abspath(self.caseDir)
        #変数表示有無の初期化
        self.isVariable = False
        self.isVariableBoundary = False

    #
    #  getRunningGridEditor
    def getRunningGridEditor(self):
        """ gridEditorの起動状況を確認し、初めての起動の場合、tempFileを削除する。"""
        print(_("gridEditorを起動します。 PID: "), end="")
        pgmName = os.path.basename(__file__)
        comm = 'pgrep -d " " -f "' + pgmName + '"'
        results = pyTreeFoam.run().commandReturnCont(comm)
        res = results[1]
        if len(res.split()) <= 1:
            #初回起動時のため、nRunningGridEditorをクリアする
            fileName = self.nRunningGrid
            f = open(fileName, "w"); f.close()

    #
    #  readConfigData
    def readConfigData(self):
        """ data/gridEditor_dataファイルの読み込み"""
        #初期値の設定
        self.sortPatchName = "no"
        self.maxRowsInCellInternal = 5
        self.maxRowsInCell = 10
        self.nMaxLinesBinToAscii = 20
        #設定fileの読み込み
        fileName = os.getenv("TreeFoamUserPath") + "/data/gridEditor_data"
        if len(glob.glob(fileName)) != 0:
            f = open(fileName); lines = f.readlines(); f.close()
            for line in lines:
                words = line.split()
                if len(words) > 1:
                    if words[0] == "sortPatchName":
                        self.sortPatchName = words[1]
                    elif words[0] == "maxLinesCellInternal":
                        self.maxRowsInCellInternal = int(words[1])
                    elif words[0] == "maxLinesCellPatch":
                        self.maxRowsInCell = int(words[1])
                    elif words[0] == "nMaxLinesBinToAscii":
                        self.nMaxLinesBinToAscii = int(words[1])
        else:
            self.writeConfigData()

    #
    #  writeConfigData
    def writeConfigData(self):
        """ 設定ファイルの書き込み"""
        fileName = os.getenv("TreeFoamUserPath") + "/data/gridEditor_data"
        if len(glob.glob(fileName)) != 0:
            f = open(fileName); lines = f.readlines(); f.close()
            flags = [0,0,0,0]
            for i in range(len(lines)):
                line = lines[i]
                words = line.split()
                if len(words) > 1:
                    if words[0] == "sortPatchName":
                        words[1] = self.sortPatchName
                        lines[i] = " ".join(words) + "\n"
                        flags[0] = 1
                    elif words[0] == "maxLinesCellInternal":
                        words[1] = str(self.maxRowsInCellInternal)
                        lines[i] = " ".join(words) + "\n"
                        flags[1] = 1
                    elif words[0] == "maxLinesCellPatch":
                        words[1] = str(self.maxRowsInCell)
                        lines[i] = " ".join(words) + "\n"
                        flags[2] = 1
                    elif words[0] == "nMaxLinesBinToAscii":
                        words[1] = str(self.nMaxLinesBinToAscii)
                        lines[i] = " ".join(words) + "\n"
                        flags[3] = 1
            if sum(flags) != len(flags):
                if flags[0] == 0:
                    lines += ["sortPatchName " + self.sortPatchName + "\n"]
                if flags[1] == 0:
                    lines += ["maxLinesCellInternal " + str(self.maxRowsInCellInternal) + "\n"]
                if flags[2] == 0:
                    lines += ["maxLinesCellPatch " + str(self.maxRowsInCell) + "\n"]
                if flags[3] == 0:
                    lines += ["nMaxLinesBinToAscii " + str(self.nMaxLinesBinToAscii) + "\n"]
            #書き込み
            f = open(fileName, "w"); f.writelines(lines); f.close()

    #
    #  statusBar関連
    #----------------
    def clearStatus(self):
        """ statusBarの内容をクリアする。"""
        self.statusbar.showMessage("")

    def setStatus(self, text):
        """ statusBarにtextをセットする。"""
        self.statusbar.showMessage(text)

    #
    #  dialog関連
    #---------------
    def okDialog(self, title, mess):
        msgBox = QMessageBox()
        msgBox.information(self.MainWindow, title, mess, QtVar.OkButton)

    def errDialog(self, title, mess):
        msgBox = QMessageBox()
        msgBox.critical(self.MainWindow, title, mess, QtVar.OkButton)

    def okCancelDialog(self, title, mess):
        msgBox = QMessageBox()
        res = msgBox.information(self.MainWindow, title, mess, QtVar.CancelButton, QtVar.OkButton)
        if res == QtVar.OkButton:
            ans = "OK"
        else:
            ans = "CANCEL"
        return ans

    def warningDialog(self, title, mess):
        msgBox = QMessageBox()
        msgBox.warning(self.MainWindow, title, mess, QtVar.OkButton)

    def fieldsHideShowDialog(self, showNames, hideNames):
        dialog = openFieldsForGridEditorQtDDialog.Ui_Dialog(self.fieldDir, showNames, hideNames, self.MainWindow)
        newNames = dialog.Show()
        return newNames

    def getMaxLinesDialog(self, nInternal, nPatch, nBinToAscii):
        dialog = getMaxLinesDataQtDDialog.Ui_Dialog(nInternal, nPatch, nBinToAscii, self.MainWindow)
        result = dialog.Show()
        return result

#----------
#  showGui
#----------
def showGui():
    global app
    app = QApplication(sys.argv)
    ui = gridEditor(nTreeFoam, caseDir, timeFolder, region)
    ui.main()
    try:
        app.exec()
    except:
        app.exec_()


if __name__ == "__main__":
    import gettext
    localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    if len(sys.argv) <= 3:
        print(_("error: 引数が不足しています。"))
        print(_("  引数1  nTreefoam（TreeFoam起動No）"))
        print(_("  引数2  caseDir"))
        print(_("  引数3  timeFolder"))
        print(_("  引数4  region名（省略可）"))
        exit()

    if os.getenv("TreeFoamPath") == None:
        print(_("error: 環境変数 $TreeFoamPath が設定されていません"))
        exit()

    if os.getenv("TreeFoamUserPath") == None:
        print(_("error: 環境変数 $TreeFoamUserPath が設定されていません"))
        exit()

    if len(sys.argv) == 4:
        nTreeFoam = sys.argv[1]
        caseDir = sys.argv[2]
        timeFolder = sys.argv[3]
        region = "."

    if len(sys.argv) >= 5:
        nTreeFoam = sys.argv[1]
        caseDir = sys.argv[2]
        timeFolder = sys.argv[3]
        region = sys.argv[4]

    if int(nTreeFoam) >= 0:
        #単独起動のgridEditorの場合は、log作成しない。
        import logFileCreater
        logFileCreater.log()
    showGui()

