#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   gridEditorQt6.py
#
#       gridEditorQtDialog.pyのGUIを作成
#
#   20/04/21    多言語化対応
#      05/02    PyQt4, PyQt5, PySide, PySide2に対応
#      05/19    vtk用のwindowを追加
#      05/24    PyQt確認方法を修正（一元化）
#      05/26    patchViewerにbuttonを追加
#      06/12    erroe「already has a layout」で修正
#      07/06    icon2ヶ(rightToLeft, rolling90)を追加
#   21/06/12    reloadVtkButtonを追加
#   24/08/27    gridEditor.pyをQt6用に書き換え
#

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()


import os

#vtkのimportを確認
try:
    import QtVtk
    VtkFlag = "ok"
except:
    VtkFlag = None


def _fromUtf8(s):
    return s

try:
    _encoding = QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig)

#-------------------------
#  Ui_MainWindopw class
#-------------------------
class Ui_MainWindow(object):

    def setupUi(self, MainWindow, Table):       #tableWidgetを追加
        MainWindow.setObjectName(_fromUtf8("MainWindow"))
        MainWindow.resize(800, 600)
        iconDir = os.getenv("TreeFoamPath") + "/icons"
        self.centralwidget = QWidget(MainWindow)
        self.centralwidget.setObjectName(_fromUtf8("centralwidget"))
        
        #splitterとそれを配置するboxを定義
        self.hbox = QHBoxLayout(self.centralwidget)
        ## self.splitter = QSplitter(Qt.Horizontal)
        self.splitter = QSplitter(Qt.Orientation.Horizontal)
        #splitterの左側widgetを定義
        self.frame = QFrame(self.centralwidget)
        ## self.frame.setFrameShape(QFrame.StyledPanel)
        self.frame.setFrameShape(QFrame.Shape.StyledPanel)
        ## self.frame.setFrameShadow(QFrame.Raised)
        self.frame.setFrameShadow(QFrame.Shadow.Raised)
        self.verticalLayoutLeft = QVBoxLayout(self.frame)
        #  viewer title
        self.label = QLabel(self.frame)
        ## self.label.setAlignment(Qt.AlignCenter)
        self.label.setAlignment(Qt.AlignmentFlag.AlignCenter)
        self.label.setText(_("Patch Viewer"))
        self.verticalLayoutLeft.addWidget(self.label)
        #  checkButtons
        self.gridLayout = QGridLayout()
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        self.check_showEdge = QCheckBox(self.frame)
        self.check_showEdge.setObjectName("check_showEdge")
        self.check_showEdge.setText(_("edge表示"))
        self.check_showEdge.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.check_showEdge, 0, 0, 1, 1)
        self.check_opacity = QCheckBox(self.frame)
        self.check_opacity.setObjectName("check_opacity")
        self.check_opacity.setSizePolicy(sizePolicy)
        self.check_opacity.setText(_("透明化"))
        self.gridLayout.addWidget(self.check_opacity, 1, 0, 1, 1)

        #  buttons
        #   resetCamera button
        self.button_reset = QPushButton(self.frame)
        self.button_reset.setObjectName("button_reset")
        icon_reset = QIcon()
        ## icon_reset.addPixmap(QPixmap(iconDir + "/resetCamera.png"), QIcon.Normal, QIcon.Off)
        icon_reset.addPixmap(QPixmap(iconDir + "/resetCamera.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_reset.setIcon(icon_reset)
        self.button_reset.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_reset.sizePolicy().hasHeightForWidth())
        self.button_reset.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_reset, 0, 1, 1, 1)

        #   setXaxis button
        self.button_Xaxis = QPushButton(self.frame)
        self.button_Xaxis.setObjectName("button_Xaxis")
        icon_Xaxis = QIcon()
        ## icon_Xaxis.addPixmap(QPixmap(iconDir + "/setXaxis.png"), QIcon.Normal, QIcon.Off)
        icon_Xaxis.addPixmap(QPixmap(iconDir + "/setXaxis.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_Xaxis.setIcon(icon_Xaxis)
        self.button_Xaxis.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_Xaxis.sizePolicy().hasHeightForWidth())
        self.button_Xaxis.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_Xaxis, 0, 2, 1, 1)

        #   setYaxis button
        self.button_Yaxis = QPushButton(self.frame)
        self.button_Yaxis.setObjectName("button_Yaxis")
        icon_Yaxis = QIcon()
        ## icon_Yaxis.addPixmap(QPixmap(iconDir + "/setYaxis.png"), QIcon.Normal, QIcon.Off)
        icon_Yaxis.addPixmap(QPixmap(iconDir + "/setYaxis.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_Yaxis.setIcon(icon_Yaxis)
        self.button_Yaxis.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_Yaxis.sizePolicy().hasHeightForWidth())
        self.button_Yaxis.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_Yaxis, 0, 3, 1, 1)

        #   setZaxis button
        self.button_Zaxis = QPushButton(self.frame)
        self.button_Zaxis.setObjectName("button_Zaxis")
        icon_Zaxis = QIcon()
        ## icon_Zaxis.addPixmap(QPixmap(iconDir + "/setZaxis.png"), QIcon.Normal, QIcon.Off)
        icon_Zaxis.addPixmap(QPixmap(iconDir + "/setZaxis.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_Zaxis.setIcon(icon_Zaxis)
        self.button_Zaxis.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_Zaxis.sizePolicy().hasHeightForWidth())
        self.button_Zaxis.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_Zaxis, 0, 4, 1, 1)

        #   reloadVtk button
        self.button_reloadVtk = QPushButton(self.frame)
        self.button_reloadVtk.setObjectName("button_reloadVtk")
        icon_reloadVtk = QIcon()
        ## icon_reloadVtk.addPixmap(QPixmap(iconDir + "/reload.png"), QIcon.Normal, QIcon.Off)
        icon_reloadVtk.addPixmap(QPixmap(iconDir + "/reload.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_reloadVtk.setIcon(icon_reloadVtk)
        self.button_reloadVtk.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_reloadVtk.sizePolicy().hasHeightForWidth())
        self.button_reloadVtk.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_reloadVtk, 0, 5, 1, 1)

        #   rightToLeft button
        self.button_rightToLeft = QPushButton(self.frame)
        self.button_rightToLeft.setObjectName("button_rightToLeft")
        icon_rightToLeft = QIcon()
        ## icon_rightToLeft.addPixmap(QPixmap(iconDir + "/rightToLeft.png"), QIcon.Normal, QIcon.Off)
        icon_rightToLeft.addPixmap(QPixmap(iconDir + "/rightToLeft.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_rightToLeft.setIcon(icon_rightToLeft)
        self.button_rightToLeft.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_rightToLeft.sizePolicy().hasHeightForWidth())
        self.button_rightToLeft.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_rightToLeft, 1, 1, 1, 1)

        #   rolling90 button
        self.button_rolling90 = QPushButton(self.frame)
        self.button_rolling90.setObjectName("button_rolling90")
        icon_rolling90 = QIcon()
        ## icon_rolling90.addPixmap(QPixmap(iconDir + "/rolling90.png"), QIcon.Normal, QIcon.Off)
        icon_rolling90.addPixmap(QPixmap(iconDir + "/rolling90.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_rolling90.setIcon(icon_rolling90)
        self.button_rolling90.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_rolling90.sizePolicy().hasHeightForWidth())
        self.button_rolling90.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_rolling90, 1, 2, 1, 1)

        #   showAllPatches button
        self.button_showAllPatches = QPushButton(self.frame)
        self.button_showAllPatches.setObjectName("button_showAllPatches")
        icon_allPatches = QIcon()
        ## icon_allPatches.addPixmap(QPixmap(iconDir + "/allPatches.png"), QIcon.Normal, QIcon.Off)
        icon_allPatches.addPixmap(QPixmap(iconDir + "/allPatches.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_showAllPatches.setIcon(icon_allPatches)
        self.button_showAllPatches.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_showAllPatches.sizePolicy().hasHeightForWidth())
        self.button_showAllPatches.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_showAllPatches, 1, 3, 1, 1)

        #   hidePatch button
        self.button_hidePatch = QPushButton(self.frame)
        self.button_hidePatch.setObjectName("button_hidePatch")
        icon_hidePatch = QIcon()
        ## icon_hidePatch.addPixmap(QPixmap(iconDir + "/hidePatches.png"), QIcon.Normal, QIcon.Off)
        icon_hidePatch.addPixmap(QPixmap(iconDir + "/hidePatches.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_hidePatch.setIcon(icon_hidePatch)
        self.button_hidePatch.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_hidePatch.sizePolicy().hasHeightForWidth())
        self.button_hidePatch.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_hidePatch, 1, 4, 1, 1)

        #   boundary button
        self.button_boundary = QPushButton(self.frame)
        self.button_boundary.setObjectName("button_boundary")
        icon_boundary = QIcon()
        ## icon_boundary.addPixmap(QPixmap(iconDir + "/boundary.png"), QIcon.Normal, QIcon.Off)
        icon_boundary.addPixmap(QPixmap(iconDir + "/boundary.png"), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.button_boundary.setIcon(icon_boundary)
        self.button_boundary.setIconSize(QSize(24, 24))
        ## sizePolicy = QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Fixed, QSizePolicy.Policy.Fixed)
        sizePolicy.setHeightForWidth(self.button_boundary.sizePolicy().hasHeightForWidth())
        self.button_boundary.setSizePolicy(sizePolicy)
        self.gridLayout.addWidget(self.button_boundary, 1, 5, 1, 1)

        #スペーサを入力
        ## spacerItem = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        spacerItem = QSpacerItem(40, 20, QSizePolicy.Policy.Expanding, QSizePolicy.Policy.Minimum)
        self.gridLayout.addItem(spacerItem, 0, 5, 1, 1)
        self.verticalLayoutLeft.addLayout(self.gridLayout)
        
        #  vtkWidget
        if VtkFlag != None:
            self.vtkWidget = QtVtk.vtkQWidget(self.frame)
            self.verticalLayoutLeft.addWidget(self.vtkWidget)

        #  vtkClose button
        self.horizontalLayout1 = QHBoxLayout()
        ## spacerItem1 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        spacerItem1 = QSpacerItem(40, 20, QSizePolicy.Policy.Expanding, QSizePolicy.Policy.Minimum)
        self.horizontalLayout1.addItem(spacerItem1)
        self.button_vtkClose = QPushButton(self.frame)
        self.button_vtkClose.setObjectName("button_vtkClose")
        self.button_vtkClose.setText(_("patchViewer閉じる"))
        self.horizontalLayout1.addWidget(self.button_vtkClose)
        self.verticalLayoutLeft.addLayout(self.horizontalLayout1)

        #  左splitterをframeに追加
        self.splitter.addWidget(self.frame)

        #splitterの右側にtableWidget追加
        self.frameTable = QFrame(self.centralwidget)
        ## self.frameTable.setFrameShape(QFrame.StyledPanel)
        self.frameTable.setFrameShape(QFrame.Shape.StyledPanel)
        ## self.frameTable.setFrameShadow(QFrame.Raised)
        self.frameTable.setFrameShadow(QFrame.Shadow.Raised)
        self.verticalLayout = QVBoxLayout(self.frameTable)
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        self.tableWidget = Table
        self.tableWidget.setRowCount(3)
        self.tableWidget.setColumnCount(3)
        self.tableWidget.setObjectName(_fromUtf8("tableWidget"))
        self.verticalLayout.addWidget(self.tableWidget)
        self.splitter.addWidget(self.frameTable)

        #splitterを設定
        self.hbox.addWidget(self.splitter)
        self.splitter.setSizes([100, 800])        

        MainWindow.setCentralWidget(self.centralwidget)
        self.menubar = QMenuBar(MainWindow)
        self.menubar.setGeometry(QRect(0, 0, 800, 37))
        self.menubar.setObjectName(_fromUtf8("menubar"))
        self.menu = QMenu(self.menubar)
        self.menu.setObjectName(_fromUtf8("menu"))
        self.menu_E = QMenu(self.menubar)
        self.menu_E.setObjectName(_fromUtf8("menu_E"))
        self.menu_V = QMenu(self.menubar)
        self.menu_V.setObjectName(_fromUtf8("menu_V"))
        MainWindow.setMenuBar(self.menubar)
        self.statusbar = QStatusBar(MainWindow)
        self.statusbar.setObjectName(_fromUtf8("statusbar"))
        MainWindow.setStatusBar(self.statusbar)
        self.toolBar = QToolBar(MainWindow)
        self.toolBar.setObjectName(_fromUtf8("toolBar"))
        ## MainWindow.addToolBar(Qt.TopToolBarArea, self.toolBar)
        MainWindow.addToolBar(self.toolBar)
        self.toolBar_2 = QToolBar(MainWindow)
        self.toolBar_2.setObjectName(_fromUtf8("toolBar_2"))
        ## MainWindow.addToolBar(Qt.TopToolBarArea, self.toolBar_2)
        MainWindow.addToolBar(self.toolBar_2)
        self.toolBar_3 = QToolBar(MainWindow)
        self.toolBar_3.setObjectName(_fromUtf8("toolBar_3"))
        ## MainWindow.addToolBar(Qt.TopToolBarArea, self.toolBar_3)
        MainWindow.addToolBar(self.toolBar_3)

        self.actionOpen = QAction(MainWindow)
        icon = QIcon()
        ## icon.addPixmap(QPixmap(_fromUtf8(iconDir + "/fileopen.png")), QIcon.Normal, QIcon.Off)
        icon.addPixmap(QPixmap(_fromUtf8(iconDir + "/fileopen.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionOpen.setIcon(icon)
        self.actionOpen.setObjectName(_fromUtf8("actionOpen"))
        self.actionSave = QAction(MainWindow)
        icon1 = QIcon()
        ## icon1.addPixmap(QPixmap(_fromUtf8(iconDir + "/save.png")), QIcon.Normal, QIcon.Off)
        icon1.addPixmap(QPixmap(_fromUtf8(iconDir + "/save.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionSave.setIcon(icon1)
        self.actionSave.setObjectName(_fromUtf8("actionSave"))
        self.actionCSV = QAction(MainWindow)
        icon2 = QIcon()
        ## icon2.addPixmap(QPixmap(_fromUtf8(iconDir + "/document-revert.png")), QIcon.Normal, QIcon.Off)
        icon2.addPixmap(QPixmap(_fromUtf8(iconDir + "/document-revert.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionCSV.setIcon(icon2)
        self.actionCSV.setObjectName(_fromUtf8("actionCSV"))
        self.actionReload = QAction(MainWindow)
        icon3 = QIcon()
        ## icon3.addPixmap(QPixmap(_fromUtf8(iconDir + "/reload.png")), QIcon.Normal, QIcon.Off)
        icon3.addPixmap(QPixmap(_fromUtf8(iconDir + "/reload.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionReload.setIcon(icon3)
        self.actionReload.setObjectName(_fromUtf8("actionReload"))
        self.actionClose = QAction(MainWindow)
        icon4 = QIcon()
        ## icon4.addPixmap(QPixmap(_fromUtf8(iconDir + "/exit.png")), QIcon.Normal, QIcon.Off)
        icon4.addPixmap(QPixmap(_fromUtf8(iconDir + "/exit.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionClose.setIcon(icon4)
        self.actionClose.setObjectName(_fromUtf8("actionClose"))
        self.actionCopy = QAction(MainWindow)
        icon5 = QIcon()
        ## icon5.addPixmap(QPixmap(_fromUtf8(iconDir + "/copy.png")), QIcon.Normal, QIcon.Off)
        icon5.addPixmap(QPixmap(_fromUtf8(iconDir + "/copy.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionCopy.setIcon(icon5)
        self.actionCopy.setObjectName(_fromUtf8("actionCopy"))
        self.actionPaste = QAction(MainWindow)
        icon6 = QIcon()
        ## icon6.addPixmap(QPixmap(_fromUtf8(iconDir + "/paste.png")), QIcon.Normal, QIcon.Off)
        icon6.addPixmap(QPixmap(_fromUtf8(iconDir + "/paste.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionPaste.setIcon(icon6)
        self.actionPaste.setObjectName(_fromUtf8("actionPaste"))
        self.actionClearZeroGrad = QAction(MainWindow)
        icon7 = QIcon()
        ## icon7.addPixmap(QPixmap(_fromUtf8(iconDir + "/clearZeroGradient.png")), QIcon.Normal, QIcon.Off)
        icon7.addPixmap(QPixmap(_fromUtf8(iconDir + "/clearZeroGradient.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionClearZeroGrad.setIcon(icon7)
        self.actionClearZeroGrad.setObjectName(_fromUtf8("actionClearZeroGrad"))
        self.actionClearUniform = QAction(MainWindow)
        icon8 = QIcon()
        ## icon8.addPixmap(QPixmap(_fromUtf8(iconDir + "/clearUniform.png")), QIcon.Normal, QIcon.Off)
        icon8.addPixmap(QPixmap(_fromUtf8(iconDir + "/clearUniform.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionClearUniform.setIcon(icon8)
        self.actionClearUniform.setObjectName(_fromUtf8("actionClearUniform"))
        self.actionShowVtk = QAction(MainWindow)
        icon9 = QIcon()
        ## icon9.addPixmap(QPixmap(_fromUtf8(iconDir + "/patchViewer.png")), QIcon.Normal, QIcon.Off)
        icon9.addPixmap(QPixmap(_fromUtf8(iconDir + "/patchViewer.png")), mode=QIcon.Mode.Normal, state=QIcon.State.Off)
        self.actionShowVtk.setIcon(icon9)
        self.actionShowVtk.setObjectName(_fromUtf8("actionShowVtk"))

        self.actionOpen_2 = QAction(MainWindow)
        self.actionOpen_2.setIcon(icon)
        self.actionOpen_2.setObjectName(_fromUtf8("actionOpen_2"))
        self.actionSave_2 = QAction(MainWindow)
        self.actionSave_2.setIcon(icon1)
        self.actionSave_2.setObjectName(_fromUtf8("actionSave_2"))
        self.actionCSV_2 = QAction(MainWindow)
        self.actionCSV_2.setIcon(icon2)
        self.actionCSV_2.setObjectName(_fromUtf8("actionCSV_2"))
        self.actionReload_2 = QAction(MainWindow)
        self.actionReload_2.setIcon(icon3)
        self.actionReload_2.setObjectName(_fromUtf8("actionReload_2"))
        self.actionClose_2 = QAction(MainWindow)
        self.actionClose_2.setIcon(icon4)
        self.actionClose_2.setObjectName(_fromUtf8("actionClose_2"))
        self.actionRenamePatch = QAction(MainWindow)
        self.actionRenamePatch.setObjectName(_fromUtf8("actionRenamePatch"))
        self.actionDeletePatch = QAction(MainWindow)
        self.actionDeletePatch.setObjectName(_fromUtf8("actionDeletePatch"))
        self.actionCopy_2 = QAction(MainWindow)
        self.actionCopy_2.setIcon(icon5)
        self.actionCopy_2.setObjectName(_fromUtf8("actionCopy_2"))
        self.actionPaste_2 = QAction(MainWindow)
        self.actionPaste_2.setIcon(icon6)
        self.actionPaste_2.setObjectName(_fromUtf8("actionPaste_2"))
        self.actionEditor = QAction(MainWindow)
        self.actionEditor.setObjectName(_fromUtf8("actionEditor"))
        self.actionChangeView = QAction(MainWindow)
        self.actionChangeView.setObjectName(_fromUtf8("actionChangeView"))
        self.actionHideFields = QAction(MainWindow)
        self.actionHideFields.setObjectName(_fromUtf8("actionHideFields"))
        self.actionChangeOrder = QAction(MainWindow)
        self.actionChangeOrder.setObjectName(_fromUtf8("actionChangeOrder"))
        self.actionChangeViewLines = QAction(MainWindow)
        self.actionChangeViewLines.setObjectName(_fromUtf8("actionChangeViewLines"))
        self.menu.addAction(self.actionOpen_2)
        self.menu.addAction(self.actionSave_2)
        self.menu.addAction(self.actionCSV_2)
        self.menu.addAction(self.actionReload_2)
        self.menu.addAction(self.actionClose_2)
        self.menu_E.addAction(self.actionRenamePatch)
        self.menu_E.addAction(self.actionDeletePatch)
        self.menu_E.addAction(self.actionCopy_2)
        self.menu_E.addAction(self.actionPaste_2)
        self.menu_E.addAction(self.actionEditor)
        self.menu_V.addAction(self.actionChangeView)
        self.menu_V.addAction(self.actionHideFields)
        self.menu_V.addAction(self.actionChangeOrder)
        self.menu_V.addAction(self.actionChangeViewLines)
        self.menubar.addAction(self.menu.menuAction())
        self.menubar.addAction(self.menu_E.menuAction())
        self.menubar.addAction(self.menu_V.menuAction())
        self.toolBar.addAction(self.actionOpen)
        self.toolBar.addAction(self.actionSave)
        self.toolBar.addAction(self.actionCSV)
        self.toolBar.addAction(self.actionReload)
        self.toolBar.addAction(self.actionClose)
        self.toolBar_2.addAction(self.actionCopy)
        self.toolBar_2.addAction(self.actionPaste)
        self.toolBar_2.addAction(self.actionClearZeroGrad)
        self.toolBar_2.addAction(self.actionClearUniform)
        self.toolBar_3.addAction(self.actionShowVtk)

        self.retranslateUi(MainWindow)
        QMetaObject.connectSlotsByName(MainWindow)

    def retranslateUi(self, MainWindow):
        MainWindow.setWindowTitle(_translate("MainWindow", "MainWindow", None))
        self.menu.setTitle(_translate("MainWindow", _("ファイル(F)"), None))
        self.menu_E.setTitle(_translate("MainWindow", _("編集(E)"), None))
        self.menu_V.setTitle(_translate("MainWindow", _("表示(V)"), None))
        self.toolBar.setWindowTitle(_translate("MainWindow", "toolBar", None))
        self.toolBar_2.setWindowTitle(_translate("MainWindow", "toolBar_2", None))
        self.actionOpen.setText(_translate("MainWindow", _("開く"), None))
        self.actionSave.setText(_translate("MainWindow", _("保存"), None))
        self.actionCSV.setText(_translate("MainWindow", _("CSV保存"), None))
        self.actionReload.setText(_translate("MainWindow", _("再読み込み"), None))
        self.actionClose.setText(_translate("MainWindow", _("閉じる"), None))
        self.actionCopy.setText(_translate("MainWindow", _("cell内容コピー"), None))
        self.actionPaste.setText(_translate("MainWindow", _("cell貼り付け"), None))
        self.actionClearZeroGrad.setText(_translate("MainWindow", _("空白cellをzeroGradientで埋める"), None))
        self.actionClearUniform.setText(_translate("MainWindow", _("internalField内のnonuniformをuniformに変更"), None))
        self.actionShowVtk.setText(_translate("MainWindow", _("patchViewerを表示"), None))
        self.actionOpen_2.setText(_translate("MainWindow", _("開く"), None))
        self.actionSave_2.setText(_translate("MainWindow", _("保存"), None))
        self.actionCSV_2.setText(_translate("MainWindow", _("CSV保存"), None))
        self.actionReload_2.setText(_translate("MainWindow", _("再読み込み"), None))
        self.actionClose_2.setText(_translate("MainWindow", _("閉じる"), None))
        self.actionRenamePatch.setText(_translate("MainWindow", _("patch名変更"), None))
        self.actionDeletePatch.setText(_translate("MainWindow", _("空patch削除"), None))
        self.actionCopy_2.setText(_translate("MainWindow", _("cellコピー"), None))
        self.actionPaste_2.setText(_translate("MainWindow", _("cell貼り付け"), None))
        self.actionEditor.setText(_translate("MainWindow", _("cell内容をEditorで編集"), None))
        self.actionChangeView.setText(_translate("MainWindow", _("全表示/非表示fieldの切替え"), None))
        self.actionHideFields.setText(_translate("MainWindow", _("選択したfieldを非表示"), None))
        self.actionChangeOrder.setText(_translate("MainWindow", _("fieldの再表示、表示順変更"), None))
        self.actionChangeViewLines.setText(_translate("MainWindow", _("cell内の表示行数・データ数変更"), None))

if __name__ == "__main__":
    import gettext
    #localeDir = os.getenv("TreeFoamPath") + "/data/locale"
    #gettext.install("treefoam", localeDir)
    gettext.install("app")
    #_ = gettext.gettext
    import sys
    app = QApplication(sys.argv)
    MainWindow = QMainWindow()
    ui = Ui_MainWindow()
    tableWidget = QTableWidget()
    ui.setupUi(MainWindow, tableWidget)
    MainWindow.show()
    ## sys.exit(app.exec_())
    sys.exit(app.exec())

