#!/usr/bin/python3
#  coding: utf-8
#
#       getPyQtModule.py
#
#       PyQtのmoduleのimport状況を確認する。
#       確認結果が、PyQtModule変数に入る。
#
#   20/05/23    新規作成
#      06/11    バグ修正 (33行目 import PySide → import PySide2)
#   24/08/26    PyQt6, PySide6を追加。
#      08/24    UiCodeでグループ分け（UiCode="Qt4","Qt6")
#

import sys

PyQtModule = None
UiCode = None

QtModules = ["PyQt6", "PySide6", "PyQt5", "PySide2", "PyQt4", "PySide"]

#既にimportされているか確認
for module in QtModules:
    if module in sys.modules.keys():
        PyQtModule = module
        break
    
#importされていない場合は、importできるものを探す。
if PyQtModule == None:
    #  PyQtを確認
    try:
        import PyQt6
        PyQtModule = "PyQt6"
    except ImportError:
        try:
            import PySide6
            PyQtModule = "PySide6"
        except ImportError:
            try:
                import PyQt5
                PyQtModule = "PyQt5"
            except ImportError:
                try:
                    import PySide2
                    PyQtModule = "PySide2"
                except:
                    try:
                        import PyQt4
                        PyQtModule = "PyQt4"
                    except:
                        try:
                            import PySide
                            PyQtModule = "PySide"
                        except:
                            raise ImportError("Cannot load either PyQt or PySide")
    print("import " + PyQtModule + "...")

#uiCodeのグループ分け
#  Qt4系？
if PyQtModule in ["PyQt5", "PyQt4", "PySide2", "PySide"]:
    UiCode = "Qt4"      #Qt4系
#  Qt6系？
elif PyQtModule in ["PyQt6", "PySide6"]:
    UiCode = "Qt6"      #Qt6系

