#
# coding: utf-8
#
#   focus_clearJobList.py
#
#       jobListの内容を実際の結果に合わせる
#
#   19/11/09    新規作成
#   21/07/02    printJobCont:list中にdirNameを追加
#

import os, sys
import datetime
import subprocess
import glob

jobListFile = os.getenv("HOME") + "/.jobList"


#
#  getCurrentJobNos
def getCurrentJobNos():
    results = []
    comm = "squeue"
    proc = subprocess.Popen(
        comm,
        shell=True,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE )
    #結果をreadTimeで取得し、出力
    for line in iter(proc.stdout.readline, b""):
        resLine = line.rstrip().decode("utf-8")
        results.append(resLine)
        #print(resLine)
    #jobNoを取得
    jobNos = []
    for i in range(1, len(results)):
        line = results[i]
        words = line.split()
        if len(words) > 0:
            jobNos.append(words[0])
    return jobNos, results

#
#  readJoblist
def readJobList():
    """ ファイルからjobListを読み込む"""
    fileName = jobListFile
    if len(glob.glob(fileName)) == 0:
        return []
    else:
        f = open(fileName); jobLines = f.readlines(); f.close()
    return jobLines

#
#  getJobSeconds
def getJobSeconds(line):
    """ job実行時から現在までの秒数を取得"""
    words = line.split()
    if len(words) > 0:
        job = list(map(int, words[1].split("-")))
        jobTime = datetime.datetime(job[0], job[1], job[2], job[3], job[4], job[5])
        seconds = (datetime.datetime.now() - jobTime).seconds
        return float(seconds)
    else:
        return 1e5

#
#  deleteJoblist
def deleteJobList(currJobs, jobLines):
    newLines = []
    for line in jobLines:
        words = line.split()
        if len(words) > 1:
            if words[0] in currJobs:
                newLines.append(line)
            else:
                seconds = getJobSeconds(line)
                if seconds < 3600.0:
                    newLines.append(line)
    return newLines

#
#  writeJobContToFile
def writeJobContToFile(jobLines):
    """ job内容をファイルに書き込み"""
    fileName = jobListFile
    f = open(fileName, "w")
    for line in jobLines:
        f.write(line)
    f.close()

#
#  printJobCont
#---------------
def printJobCont(results, jobLines):
    """ resultsの後に、dir名を追加してprintする"""
    for resLine in results:
        resJob = resLine.split()[0]
        dirName = ""
        for jobLine in jobLines:
            words = jobLine.split()
            jobNo = words[0]
            if resJob == jobNo:
                dirName = os.path.basename(words[-1])
                resLine += "  -> " + dirName        
                break
        print(resLine)

#
#  clearJobList
#  ------------
def clearJobList():
    currJobs, results = getCurrentJobNos()
    jobLines = readJobList()
    jobLines = deleteJobList(currJobs, jobLines)
    writeJobContToFile(jobLines)
    printJobCont(results, jobLines)


if __name__ == "__main__":
    clearJobList()
