#!/usr/bin/python3
#  coding: utf-8
#
#           createNewRegionCaseDDialog.py
#
#       multiRegionCaseを新規に作成する。
#
#   25/07/03    新規作成
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk
import os, sys

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

#-------------------
#  dialogApp class
#-------------------
class dialogApp:

    def __init__(self, entryText, funcOk=[], parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "createNewRegionCaseDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.entryText = entryText
        self.funcOk = funcOk
        #初期化
        self.dialog.set_title(_("メッシュの領域分割"))
        self.entry_newName.set_text(entryText)

    #
    #  show
    #-------
    def show(self):
        self.dialog.show()

    def close(self, *args):
        self.dialog.destroy()

    def onOk(self, event):
        getText = self.entry_newName.get_text()
        self.close()
        #取得したtextをfuncで処理する
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = [getText] + self.funcOk[1:]
            funcName(*args)

    #
    #  setGtkObject
    #------------
    def setGtkObject(self):
        self.entry_newName = self.builder.get_object("entry_newName")
        self.button_ok = self.builder.get_object("button_ok")
