#!/usr/bin/python3
#
#       contRun_altnSource_chtChtss.py
#
#       OpenFOAMが出力した熱流束から、FrontISTRを実行して、
#       温度、熱ひずみを出力する。
#       contRun_altnSource_chtChtss.pyを交互計算用に修正。
#
#   23/10/23    saveMappingTemp:交互計算に対応させる為、
#               tempのfile名のstep数をendStepからtimeIndexに変更。
#               addTempRenameRes,setDeltaTInCnt_cht,deleteResSetRestartFileCht:
#               大幅修正。
#               createCommTimeArea:新規追加。（前回のcouplingTime取得の為）
#               runFistr:Fistr起動前に、Fistrが停止している事を確認後、Fistrを起動
#               runCoupling.pyから起動された場合、直ぐに戻る用に修正。
#      11/09    chtCommonAlternate,fsiCommonAlternateモジュールの使用に変更
#               chtssCommonAlternateモジュール使用に変更
#      11/16    allCommonConcAltnモジュール使用に変更
#      11/20    waitUntilPressSaveCouplingTime:OpenFoam側が並列処理の時、各process
#               のタイミングが合わず、エラー発生のため、timingを合わせる関数を追加
#

import sys, os
import shutil
import glob
import time
import pyCoupling
import chtCommonAlternate as chtComm
import chtssCommonAlternate as chtssComm
import allCommonConcAltn as allComm


waitCount = 5000
waitTime = 0.01


#---------------------
#  coupling_chtChtss
#---------------------
def coupling_chtChtss():
    """ OpenFOAMが出力した熱流束から、FrontISTRが温度を計算する。"""
    solidCaseDir = couplingDict["solidCaseDir"]
    fluidCaseDir = couplingDict["fluidCaseDir"]
    patchName = couplingDict["mappingPatch"]
    timeName = couplingDict["timeName"]
    procNo = couplingDict["procNo"]
    dataDir = fluidCaseDir + "/coupling_FrontISTR/data"
    #---- heatFluxをmapping ---------
    #heatFluxの点群ファイル作成
    htFile = dataDir + "/" + patchName + "_faceHeatFlux_" + timeName + "_" + procNo + "tm"
    chtComm.createHeatFluxPtcFile(couplingDict, htFile)
    if int(procNo) == 0:
        #heatFluxをmappingしてcntファイルに反映
        chtComm.createMappingHeatFlux(couplingDict)
        #---- fistr実行（温度計算） --------------
        #cht計算前の設定
        setFsiChtCntFile("cht")
        bfrStep, bfrTime = mmCommTempArea.getBeforeCouplingTime()
        endStep, endTime = chtComm.setDeltaTInCnt_cht(couplingDict, bfrStep, bfrTime)
        #Fistr起動
        runFistr("cht", endStep, endTime)
        #--- 温度を取得 ---------
        #温度のptcデータを作成
        print("(py) --- creating temperature PTC ...", flush=True)
        np = pyCoupling.getNumProcsFistrFromDat(solidCaseDir)
        tempDict = chtComm.getTempDictFromResFile(couplingDict, endStep, np)
        tempPtc = chtComm.createTempPtc(couplingDict, tempDict)
        #温度をmappingしたfileを作成
        print("(OF) --- temperature value is mapping to patch '" + patchName + "' ...", flush=True)
        chtComm.createMappingTempFile(couplingDict, tempPtc, endStep)
        #---- fistr実行（熱ひずみ計算）----------
        #chtss計算前の設定(cnt,mshファイルを設定)
        setFsiChtCntFile("chtss")
        #温度の計算結果をcntファイルに設定
        chtssComm.remakeFistrCntFileForTemperature(couplingDict, tempDict)
        #Fistr起動(endStep, endTimeはdummy)
        runFistr("chtss", endStep, endTime)
        #---- 変位を取得 -----------------------
        #変位の点群データ作成
        print("(py) --- creating displacement PTC ...", flush=True)
        npSs = pyCoupling.getNumProcsFistrFromDat(solidCaseDir)
        chtssDispDict = chtssComm.getDispDictFromResFile(couplingDict, endStep, npSs)
        chtssDispPtc = chtssComm.createDispPtc(couplingDict, chtssDispDict)
        #変位のmappingFileを作成
        print("(py) --- displacement value is mapping to patch '" + patchName + "' ...", flush=True)
        chtssComm.createMappingDispFile(couplingDict, chtssDispPtc, endStep)
        #--- 結果file整理（file削除、restart設定）----
        chtComm.deleteResSetRestartFileCht(couplingDict, bfrStep, bfrTime, np)
    return ""

#
#  setFsiChtCntFile
def setFsiChtCntFile(sect):
    """ sectに応じたdatファイルに修正"""
    solidCaseDir = couplingDict["solidCaseDir"]
    pasteDatFile = solidCaseDir + os.sep + "hecmw_ctrl.dat"
    if sect == "fsi":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_fsi.dat"
    elif sect == "cht":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_cht.dat"
    elif sect == "chtss":
        datFile = solidCaseDir + os.sep + "hecmw_ctrl_chtss.dat"
    shutil.copy(datFile, pasteDatFile)

#
#  runFistr
#----------
def runFistr(sect, endStep, endTime):
    """ FrontISTRを起動"""
    allComm.runFistr(couplingDict, mmCommArea, sect, endStep, endTime)
    return

#------------------
#  createNextDisp
#------------------
def createNextDisp():
    """ OpenFOAMが読み込む変位のfileをコピーして作成する"""
    startTime = couplingDict["startTime"]
    timeName = couplingDict["timeName"]
    beforeTime = couplingDict["beforeTime"]
    timeIndex = couplingDict["timeIndex"]   #endStep
    nStepsOF = couplingDict["nStepsOF"]     #変位のstep数
    nSteps = couplingDict["nSteps"]         #温度のstep数
    procNo = couplingDict["procNo"]
    startStep = int(timeIndex) - int(nStepsOF)
    patchName = couplingDict["mappingPatch"]
    fluidCaseDir = couplingDict["fluidCaseDir"]
    solidCaseDir = couplingDict["solidCaseDir"]
    dataDir = fluidCaseDir + "/coupling_FrontISTR/data"
    #前回の温度coupling時のstepを取得
    bfStep, bfTime = mmCommPressArea.getBeforeCouplingTime()
    if int(bfStep) < 0:
        bfTime = startTime
        if float(bfTime) == 0.0:
            bfStep = "0"
        else:
            #restart開始時のsStep数をrestartFileから取得
            restartHeader = "FistrModel_cht.restart"
            ssTime = pyCoupling.time2str(float(bfTime))
            name = restartHeader + "_" + ssTime + "_*"
            pattern = solidCaseDir + "/" + name
            files = glob.glob(pattern)
            restartFile = files[0]
            restFile = ".".join(restartFile.split(".")[:-1])
            runStep = (restFile.split("_")[-1])
            bfStep = runStep
    #温度のcoupling時に作成した変位file
    name = patchName + "_disp_" + bfStep + "_" + procNo + "tm"
    oldDispFile = dataDir + "/" + name
    #OpenFOAMが読み込むfileを作成
    calcEndStep = int(timeIndex)
    if calcEndStep % int(nSteps) != 0:
        name = patchName + "_disp_" + str(calcEndStep) + "_" + procNo + "tm"
        newDispFile = dataDir + "/" + name
        shutil.copy(oldDispFile, newDispFile)
    #不要なfileを削除--------------
    deltaT = str(float(timeName) - float(beforeTime))
    writeInterval = couplingDict["writeInterval"]
    name = patchName + "_disp_" + bfStep + "_" + procNo + "tm"
    orgFile = dataDir + "/" + name
    #writeInterval？
    if pyCoupling.isWriteInterval(bfTime, writeInterval, deltaT) == True:
        #orgFileをrenameする
        newFile = orgFile[:-2]
        if os.path.exists(orgFile) == True:
            shutil.move(orgFile, newFile)
    else:
        #削除する
        if os.path.exists(orgFile) == True:
            os.remove(orgFile)

#
#  waitUntilSaveCouplingTime
#----------------------------
def waitUntilPressSaveCouplingTime():
    """ 全procsのタイミングを合わせる。
    commonArea内に現在のtimeIndexが書き込まれるまで待つ"""
    timeIndex = couplingDict["timeIndex"]
    count = waitCount
    sleepTime = waitTime
    while True:
        cont = mmCommPressArea.readCommonArea()
        if cont != "":
            lines = cont.split("\n")
            words = lines[-2].split()
            if int(words[1]) == int(timeIndex):
                break
        time.sleep(sleepTime)
        count -= 1
        if count < 0:
            break


if __name__ == "__main__":
    import gettext
    gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext

    currTime = sys.argv[1]      #currTime
    beforeTime = sys.argv[2]    #前回のtime
    procNo = sys.argv[3]        #procNo
    nProcs = sys.argv[4]        #nProcs
    timeIndex = sys.argv[5]     #timeIndex
    fluidCaseDir = os.getcwd()
    couplingData = pyCoupling.couplingData(fluidCaseDir)
    couplingDict = couplingData.read()
    couplingDict["fluidCaseDir"] = fluidCaseDir
    couplingDict["timeName"] = currTime
    couplingDict["beforeTime"] = beforeTime
    couplingDict["procNo"] = procNo
    couplingDict["nProcs"] = nProcs
    couplingDict["timeIndex"] = timeIndex
    waitCount = int(couplingDict["maxWaitTime"])
    #共有メモリの設定
    mmCommFile = allComm.createCommonArea(couplingDict)
    mmCommArea = allComm.mmCommonArea(couplingDict, mmCommFile)
    mmCommPressFile = allComm.createCommTimePressArea(couplingDict)
    mmCommPressArea = allComm.mmCommonArea(couplingDict, mmCommPressFile)
    mmCommTempFile = allComm.createCommTimeTempArea(couplingDict)
    mmCommTempArea = allComm.mmCommonArea(couplingDict, mmCommTempFile)
    #現在時間が終了時間？
    if float(couplingDict["timeName"]) > float(couplingDict["endTime"]):
        exit()
    #beforeTimeが計算開始時間よりも前 or 現時点がbeforeTime？
    if (float(beforeTime) <  float(couplingDict["startTime"]) or    #restart初回
        float(beforeTime) == float(currTime)):                      #計算初回
        #共有メモリにcouplingTimeを保存して終了
        mmCommTempArea.saveCouplingTime()
        mmCommPressArea.saveCouplingTime()
        exit() 
    #温度のcoupling？
    if pyCoupling.isTempCoupling(couplingDict) == True:
        #couplingTimeを共有メモリに保存
        mmCommTempArea.saveCouplingTime()
        #mainへ
        stat = coupling_chtChtss()
        if stat != "":
            raise NameError(stat)
    #変位のcoupling？
    if pyCoupling.isDispCoupling(couplingDict) == True:
        #couplingTimeを共有メモリに保存
        mmCommPressArea.saveCouplingTime()
        #各processのタイミングを合わせる
        if int(procNo) > 0:
            waitUntilPressSaveCouplingTime()
        #cht時に計算したdispFileを作成
        createNextDisp()
        

