#!/usr/bin/python3
#
#           chtssCommonAlternate.py
#
#       交互計算用のchtss連成の共通関数群
#
#   23/11/09    新規作成
#

import os
import pickle
import time
import pyFistr_ptc as pyFistr
import fsiCommonAlternate as fsiComm

couplingDict = {}
waitCount = 5000
waitTime = 0.01
 
FistrModel_cnt = "FistrModel_chtss.cnt"
resHeaderName = "FistrModel.res"
hecmwCtrlFile = "hecmw_ctrl_chtss.dat"

#
#  waitUntilExistingFile
#------------------------
def waitUntilExistingFile(fileName):
    """ fileが出来上がるまで待つ"""
    count = int(couplingDict["maxWaitTime"])
    sleepTime = waitTime
    while True:
        if os.path.exists(fileName) == True:
            #time.sleep(sleepTime)
            break
        count -= 1
        if count < 0:
            break
        time.sleep(sleepTime)
    return

#-----------------------------------
#  remakeFistrCntFileForTemperature
#-----------------------------------
#def remakeFistrCntFileForTemperature(dataDict, tempLines):
def remakeFistrCntFileForTemperature(dataDict, tempDict):
    """ temperatureの計算結果をcntファイルに反映"""
    global couplingDict
    couplingDict = dataDict
    solidCaseDir = couplingDict["solidCaseDir"]
    #cntFileを修正
    FistrModelDict = pyFistr.getCntMshFileNameDict(solidCaseDir, datFile=hecmwCtrlFile)
    cntFile = solidCaseDir + os.sep + FistrModelDict["cnt"]
    #cntFile = solidCaseDir + os.sep + "FistrModel_chtss.cnt"
    f = open(cntFile); lines = f.readlines(); f.close()
    #挿入場所は、!TEMPERATUREのALLに、'otherData=yes'を追加して挿入。
    si = 0
    i = 0
    while i < len(lines):
        i = pyFistr.getNextHeaderName(lines, i, "!TEMPERATURE", "")
        i += 1
        if i >= len(lines):
            break
        words = pyFistr.deleteSp(lines[i]).split(",")
        if words[0] == "ALL":
            #!TEMPERATUREの行に'otherData=yes'を追加
            lines[i-1] = pyFistr.setValName(lines[i-1], "otherData=yes")
            si = i + 1
            ei = pyFistr.skipNextHeader(lines, i)
            break
    if si == 0:
        print("error: could not find !TEMPERATURE card!")
        return
    #tempLinesを作成
    nodeNos = list(tempDict.keys())
    nodeNos.sort()
    tempLines = []
    for nodeNo in nodeNos:
        line = str(nodeNo) + ", " + str(tempDict[nodeNo]) + "\n"
        tempLines.append(line)
    #tempLinesを追加
    lines = lines[:si] + tempLines + lines[ei:]
    f = open(cntFile, "w"); f.writelines(lines); f.close()

#---------------------
#  createChtssDispPtc
#---------------------
def createChtssDispPtc(dataDict):
    """ chtss変位の点群データ取得"""
    global couplingDict
    couplingDict = dataDict
    solidCaseDir = couplingDict["solidCaseDir"]
    nodeDictName = solidCaseDir + "/nodeDict.bin"
    f = open(nodeDictName, "rb")
    nodeDict = pickle.load(f)
    f.close()
    #resFile名を取得、読み込み
    #resFile = solidCaseDir + "/FistrModel.res.0.1"
    resFile = solidCaseDir + os.sep + resHeaderName + ".0.1"
    #dispDict = readDispFromResFile(resFile)
    fsiComm.couplingDict = dataDict
    dispDict = fsiComm.readDispFromResFile(resFile)
    #点群作成
    dispPtc = []
    for nodeNo in nodeDict.keys():
        disp = dispDict[nodeNo]
        loc = nodeDict[nodeNo]
        dispPtc.append([loc, disp])
    return dispPtc

#--------------------------
#  getDispDictFromResFile
#--------------------------
def getDispDictFromResFile(dataDict, endStep, np):
    """ FrontISTRの変位計算結果を辞書形式で返す。
    dispDict={<nodeNo>: [x,y,z]}"""
    global couplingDict, resHeaderName
    couplingDict = dataDict
    #resFile名を取得
    solidCaseDir = couplingDict["solidCaseDir"]
    resHeader = resHeaderName
    dispDict = {}
    fsiComm.couplingDict = dataDict
    for n in range(np):
        resFile = solidCaseDir + "/" + resHeader + "." + str(n) + "." + str(1)
        waitUntilExistingFile(resFile)
        addDict = fsiComm.readDispFromResFile(resFile)
        dispDict.update(addDict)
    return dispDict

#----------------
#  createDispPtc
#----------------
def createDispPtc(couplingDict, chtssDispDict):
    """ 辞書からptcを作成して返す"""
    chtssDispPtc = fsiComm.createDispPtc(couplingDict, chtssDispDict)
    return chtssDispPtc

#------------------------
#  createMappingDispFile
#------------------------
def createMappingDispFile(couplingDict, chtssDispPtc, endStep):
    """ 変位をpatchにmappingしたfileを作成する"""
    fsiComm.createMappingDispFile(couplingDict, chtssDispPtc, endStep)
    return
